/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.apache.druid.indexing.seekablestream.SeekableStreamStartSequenceNumbers;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Test;

public class SeekableStreamStartSequenceNumbersTest {
    private static final ObjectMapper OBJECT_MAPPER = TestHelper.makeJsonMapper();

    @Test
    public void testSerde() throws Exception {
        String stream = "theStream";
        ImmutableMap offsetMap = ImmutableMap.of((Object)1, (Object)2L, (Object)3, (Object)4L);
        SeekableStreamStartSequenceNumbers partitions = new SeekableStreamStartSequenceNumbers("theStream", (Map)offsetMap, (Set)ImmutableSet.of((Object)6));
        String serializedString = OBJECT_MAPPER.writeValueAsString((Object)partitions);
        SeekableStreamStartSequenceNumbers partitions2 = (SeekableStreamStartSequenceNumbers)OBJECT_MAPPER.readValue(serializedString, (TypeReference)new TypeReference<SeekableStreamStartSequenceNumbers<Integer, Long>>(){});
        Assert.assertEquals((String)"Round trip", (Object)partitions, (Object)partitions2);
        Map asMap = (Map)OBJECT_MAPPER.readValue(serializedString, JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        Assert.assertEquals((Object)"theStream", asMap.get("stream"));
        Assert.assertEquals((Object)"theStream", asMap.get("topic"));
        Assert.assertEquals((Object)offsetMap, (Object)OBJECT_MAPPER.convertValue(asMap.get("partitionSequenceNumberMap"), (TypeReference)new TypeReference<Map<Integer, Long>>(){}));
        Assert.assertEquals((Object)offsetMap, (Object)OBJECT_MAPPER.convertValue(asMap.get("partitionOffsetMap"), (TypeReference)new TypeReference<Map<Integer, Long>>(){}));
    }
}

