/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.seekablestream.SeekableStreamEndSequenceNumbers;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskRunner;
import org.apache.druid.indexing.seekablestream.SequenceMetadata;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.segment.realtime.appenderator.TransactionalSegmentPublisher;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SequenceMetadataTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock
    private SeekableStreamIndexTaskRunner mockSeekableStreamIndexTaskRunner;
    @Mock
    private SeekableStreamEndSequenceNumbers mockSeekableStreamEndSequenceNumbers;
    @Mock
    private TaskActionClient mockTaskActionClient;
    @Mock
    private TaskToolbox mockTaskToolbox;

    @Test
    public void testPublishAnnotatedSegmentsThrowExceptionIfOverwriteSegmentsNotNullAndNotEmpty() throws Exception {
        DataSegment dataSegment = DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2001/P1D")).shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(1))).version("b").size(0L).build();
        ImmutableSet notNullNotEmptySegment = ImmutableSet.of((Object)dataSegment);
        SequenceMetadata sequenceMetadata = new SequenceMetadata(1, "test", (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), true, (Set)ImmutableSet.of());
        TransactionalSegmentPublisher transactionalSegmentPublisher = sequenceMetadata.createPublisher(this.mockSeekableStreamIndexTaskRunner, this.mockTaskToolbox, true);
        this.expectedException.expect(ISE.class);
        this.expectedException.expectMessage("Stream ingestion task unexpectedly attempted to overwrite segments: " + SegmentUtils.commaSeparatedIdentifiers((Collection)notNullNotEmptySegment));
        transactionalSegmentPublisher.publishAnnotatedSegments((Set)notNullNotEmptySegment, null, (Set)ImmutableSet.of(), null);
    }

    @Test
    public void testPublishAnnotatedSegmentsThrowExceptionIfDropSegmentsNotNullAndNotEmpty() throws Exception {
        DataSegment dataSegment = DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2001/P1D")).shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(1))).version("b").size(0L).build();
        ImmutableSet notNullNotEmptySegment = ImmutableSet.of((Object)dataSegment);
        SequenceMetadata sequenceMetadata = new SequenceMetadata(1, "test", (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), true, (Set)ImmutableSet.of());
        TransactionalSegmentPublisher transactionalSegmentPublisher = sequenceMetadata.createPublisher(this.mockSeekableStreamIndexTaskRunner, this.mockTaskToolbox, true);
        this.expectedException.expect(ISE.class);
        this.expectedException.expectMessage("Stream ingestion task unexpectedly attempted to drop segments: " + SegmentUtils.commaSeparatedIdentifiers((Collection)notNullNotEmptySegment));
        transactionalSegmentPublisher.publishAnnotatedSegments(null, (Set)notNullNotEmptySegment, (Set)ImmutableSet.of(), null);
    }

    @Test
    public void testPublishAnnotatedSegmentsSucceedIfDropSegmentsAndOverwriteSegmentsNullAndEmpty() throws Exception {
        Mockito.when((Object)this.mockSeekableStreamIndexTaskRunner.deserializePartitionsFromMetadata((ObjectMapper)ArgumentMatchers.any(), ArgumentMatchers.any())).thenReturn((Object)this.mockSeekableStreamEndSequenceNumbers);
        Mockito.when((Object)this.mockSeekableStreamEndSequenceNumbers.getPartitionSequenceNumberMap()).thenReturn((Object)ImmutableMap.of());
        Mockito.when((Object)this.mockTaskToolbox.getTaskActionClient()).thenReturn((Object)this.mockTaskActionClient);
        DataSegment dataSegment = DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2001/P1D")).shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(1))).version("b").size(0L).build();
        ImmutableSet notNullNotEmptySegment = ImmutableSet.of((Object)dataSegment);
        SequenceMetadata sequenceMetadata = new SequenceMetadata(1, "test", (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), true, (Set)ImmutableSet.of());
        TransactionalSegmentPublisher transactionalSegmentPublisher = sequenceMetadata.createPublisher(this.mockSeekableStreamIndexTaskRunner, this.mockTaskToolbox, false);
        transactionalSegmentPublisher.publishAnnotatedSegments(null, null, (Set)notNullNotEmptySegment, (Object)ImmutableMap.of());
    }
}

