/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.test;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.indexing.overlord.DataSourceMetadata;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.SegmentPublishResult;
import org.apache.druid.indexing.overlord.Segments;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.PartialShardSpec;
import org.joda.time.Interval;

public class TestIndexerMetadataStorageCoordinator
implements IndexerMetadataStorageCoordinator {
    private final ObjectMapper objectMapper = new DefaultObjectMapper();
    private final Set<DataSegment> published = Sets.newConcurrentHashSet();
    private final Set<DataSegment> nuked = Sets.newConcurrentHashSet();
    private final List<DataSegment> unusedSegments = new ArrayList<DataSegment>();

    public DataSourceMetadata retrieveDataSourceMetadata(String dataSource) {
        throw new UnsupportedOperationException();
    }

    public boolean deleteDataSourceMetadata(String dataSource) {
        throw new UnsupportedOperationException();
    }

    public boolean resetDataSourceMetadata(String dataSource, DataSourceMetadata dataSourceMetadata) {
        return false;
    }

    public boolean insertDataSourceMetadata(String dataSource, DataSourceMetadata dataSourceMetadata) {
        return false;
    }

    public List<DataSegment> retrieveAllUsedSegments(String dataSource, Segments visibility) {
        return ImmutableList.of();
    }

    public List<Pair<DataSegment, String>> retrieveUsedSegmentsAndCreatedDates(String dataSource) {
        return ImmutableList.of();
    }

    public List<DataSegment> retrieveUsedSegmentsForIntervals(String dataSource, List<Interval> intervals, Segments visibility) {
        return ImmutableList.of();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataSegment> retrieveUnusedSegmentsForInterval(String dataSource, Interval interval) {
        List<DataSegment> list = this.unusedSegments;
        synchronized (list) {
            return ImmutableList.copyOf(this.unusedSegments);
        }
    }

    public int markSegmentsAsUnusedWithinInterval(String dataSource, Interval interval) {
        return 0;
    }

    public Set<DataSegment> announceHistoricalSegments(Set<DataSegment> segments) {
        HashSet<DataSegment> added = new HashSet<DataSegment>();
        for (DataSegment segment : segments) {
            if (!this.published.add(segment)) continue;
            added.add(segment);
        }
        return ImmutableSet.copyOf(added);
    }

    public SegmentPublishResult announceHistoricalSegments(Set<DataSegment> segments, Set<DataSegment> segmentsToDrop, DataSourceMetadata oldCommitMetadata, DataSourceMetadata newCommitMetadata) {
        return SegmentPublishResult.ok(this.announceHistoricalSegments(segments));
    }

    public SegmentPublishResult commitMetadataOnly(String dataSource, DataSourceMetadata startMetadata, DataSourceMetadata endMetadata) {
        throw new UnsupportedOperationException("Not implemented, no test uses this currently.");
    }

    public int removeDataSourceMetadataOlderThan(long timestamp, @Nullable Set<String> excludeDatasources) {
        throw new UnsupportedOperationException("Not implemented, no test uses this currently.");
    }

    public SegmentIdWithShardSpec allocatePendingSegment(String dataSource, String sequenceName, String previousSegmentId, Interval interval, PartialShardSpec partialShardSpec, String maxVersion, boolean skipSegmentLineageCheck) {
        return new SegmentIdWithShardSpec(dataSource, interval, maxVersion, partialShardSpec.complete(this.objectMapper, 0, 0));
    }

    public int deletePendingSegmentsCreatedInInterval(String dataSource, Interval deleteInterval) {
        throw new UnsupportedOperationException();
    }

    public int deletePendingSegments(String dataSource) {
        throw new UnsupportedOperationException();
    }

    public void deleteSegments(Set<DataSegment> segments) {
        this.nuked.addAll(segments);
    }

    public void updateSegmentMetadata(Set<DataSegment> segments) {
        throw new UnsupportedOperationException();
    }

    public Set<DataSegment> getPublished() {
        return ImmutableSet.copyOf(this.published);
    }

    public Set<DataSegment> getNuked() {
        return ImmutableSet.copyOf(this.nuked);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUnusedSegments(List<DataSegment> newUnusedSegments) {
        List<DataSegment> list = this.unusedSegments;
        synchronized (list) {
            this.unusedSegments.clear();
            this.unusedSegments.addAll(newUnusedSegments);
        }
    }
}

