/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.worker.shuffle;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.druid.client.indexing.NoopIndexingServiceClient;
import org.apache.druid.client.indexing.TaskStatus;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.worker.config.WorkerConfig;
import org.apache.druid.indexing.worker.shuffle.LocalIntermediaryDataManager;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.segment.loading.StorageLocationConfig;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.BucketNumberedShardSpec;
import org.apache.druid.timeline.partition.BuildingShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.ShardSpecLookup;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class LocalIntermediaryDataManagerAutoCleanupTest {
    @Rule
    public TemporaryFolder tempDir = new TemporaryFolder();
    private LocalIntermediaryDataManager intermediaryDataManager;

    @Before
    public void setup() throws IOException {
        WorkerConfig workerConfig = new WorkerConfig(){

            public long getIntermediaryPartitionDiscoveryPeriodSec() {
                return 1L;
            }

            public long getIntermediaryPartitionCleanupPeriodSec() {
                return 2L;
            }

            public Period getIntermediaryPartitionTimeout() {
                return new Period((Object)"PT2S");
            }
        };
        TaskConfig taskConfig = new TaskConfig(null, null, null, null, null, false, null, null, (List)ImmutableList.of((Object)new StorageLocationConfig(this.tempDir.newFolder(), null, null)), false, false, TaskConfig.BATCH_PROCESSING_MODE_DEFAULT.name(), null);
        NoopIndexingServiceClient indexingServiceClient = new NoopIndexingServiceClient(){

            public Map<String, TaskStatus> getTaskStatuses(Set<String> taskIds) {
                HashMap<String, TaskStatus> result = new HashMap<String, TaskStatus>();
                for (String taskId : taskIds) {
                    result.put(taskId, new TaskStatus(taskId, TaskState.SUCCESS, 10L));
                }
                return result;
            }
        };
        this.intermediaryDataManager = new LocalIntermediaryDataManager(workerConfig, taskConfig, (IndexingServiceClient)indexingServiceClient);
        this.intermediaryDataManager.start();
    }

    @After
    public void teardown() {
        this.intermediaryDataManager.stop();
    }

    @Test
    public void testCleanup() throws IOException, InterruptedException {
        String supervisorTaskId = "supervisorTaskId";
        String subTaskId = "subTaskId";
        Interval interval = Intervals.of((String)"2018/2019");
        File segmentFile = this.generateSegmentDir("test");
        DataSegment segment = this.newSegment(interval);
        this.intermediaryDataManager.addSegment("supervisorTaskId", "subTaskId", segment, segmentFile);
        Thread.sleep(3000L);
        Assert.assertFalse((boolean)this.intermediaryDataManager.findPartitionFile("supervisorTaskId", "subTaskId", interval, 0).isPresent());
    }

    private File generateSegmentDir(String fileName) throws IOException {
        File segmentDir = this.tempDir.newFolder();
        FileUtils.write((File)new File(segmentDir, fileName), (CharSequence)"test data.", (Charset)StandardCharsets.UTF_8);
        FileUtils.writeByteArrayToFile((File)new File(segmentDir, "version.bin"), (byte[])Ints.toByteArray((int)9));
        return segmentDir;
    }

    private DataSegment newSegment(Interval interval) {
        return new DataSegment("dataSource", interval, "version", null, null, null, (ShardSpec)new TestShardSpec(), Integer.valueOf(9), 10L);
    }

    private static class TestShardSpec
    implements BucketNumberedShardSpec<BuildingShardSpec<ShardSpec>> {
        private TestShardSpec() {
        }

        public int getBucketId() {
            return 0;
        }

        public BuildingShardSpec<ShardSpec> convert(int partitionId) {
            throw new UnsupportedOperationException();
        }

        public ShardSpecLookup getLookup(List<? extends ShardSpec> shardSpecs) {
            throw new UnsupportedOperationException();
        }
    }
}

