/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.worker.shuffle;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.druid.client.indexing.NoopIndexingServiceClient;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.worker.config.WorkerConfig;
import org.apache.druid.indexing.worker.shuffle.LocalIntermediaryDataManager;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.loading.StorageLocationConfig;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.BucketNumberedShardSpec;
import org.apache.druid.timeline.partition.BuildingShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.ShardSpecLookup;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class LocalIntermediaryDataManagerManualAddAndDeleteTest {
    @Rule
    public TemporaryFolder tempDir = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private LocalIntermediaryDataManager intermediaryDataManager;
    private File intermediarySegmentsLocation;
    private File siblingLocation;

    @Before
    public void setup() throws IOException {
        WorkerConfig workerConfig = new WorkerConfig();
        this.intermediarySegmentsLocation = this.tempDir.newFolder();
        this.siblingLocation = this.tempDir.newFolder();
        TaskConfig taskConfig = new TaskConfig(null, null, null, null, null, false, null, null, (List)ImmutableList.of((Object)new StorageLocationConfig(this.intermediarySegmentsLocation, 1200L, null)), false, false, TaskConfig.BATCH_PROCESSING_MODE_DEFAULT.name(), null);
        NoopIndexingServiceClient indexingServiceClient = new NoopIndexingServiceClient();
        this.intermediaryDataManager = new LocalIntermediaryDataManager(workerConfig, taskConfig, (IndexingServiceClient)indexingServiceClient);
        this.intermediaryDataManager.start();
    }

    @After
    public void teardown() {
        this.intermediaryDataManager.stop();
    }

    @Test
    public void testAddSegmentFailure() throws IOException {
        DataSegment segment;
        File segmentFile;
        int i;
        for (i = 0; i < 4; ++i) {
            segmentFile = this.generateSegmentDir("file_" + i);
            segment = this.newSegment(Intervals.of((String)"2018/2019"), i);
            this.intermediaryDataManager.addSegment("supervisorTaskId", "subTaskId", segment, segmentFile);
        }
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Can't find location to handle segment");
        segmentFile = this.generateSegmentDir("file_" + i);
        segment = this.newSegment(Intervals.of((String)"2018/2019"), 4);
        this.intermediaryDataManager.addSegment("supervisorTaskId", "subTaskId", segment, segmentFile);
    }

    @Test
    public void testFindPartitionFiles() throws IOException {
        int i;
        String supervisorTaskId = "supervisorTaskId";
        Interval interval = Intervals.of((String)"2018/2019");
        boolean partitionId = false;
        for (i = 0; i < 4; ++i) {
            File segmentFile = this.generateSegmentDir("file_" + i);
            DataSegment segment = this.newSegment(interval, 0);
            this.intermediaryDataManager.addSegment("supervisorTaskId", "subTaskId_" + i, segment, segmentFile);
        }
        for (i = 0; i < 4; ++i) {
            Optional file = this.intermediaryDataManager.findPartitionFile("supervisorTaskId", "subTaskId_" + i, interval, 0);
            Assert.assertTrue((boolean)file.isPresent());
        }
    }

    @Test
    public void deletePartitions() throws IOException {
        int subTaskId;
        int partitionId;
        String supervisorTaskId = "supervisorTaskId";
        Interval interval = Intervals.of((String)"2018/2019");
        for (partitionId = 0; partitionId < 2; ++partitionId) {
            for (subTaskId = 0; subTaskId < 2; ++subTaskId) {
                File segmentFile = this.generateSegmentDir("file_" + partitionId + "_" + subTaskId);
                DataSegment segment = this.newSegment(interval, partitionId);
                this.intermediaryDataManager.addSegment("supervisorTaskId", "subTaskId_" + subTaskId, segment, segmentFile);
            }
        }
        this.intermediaryDataManager.deletePartitions("supervisorTaskId");
        for (partitionId = 0; partitionId < 2; ++partitionId) {
            for (subTaskId = 0; subTaskId < 2; ++subTaskId) {
                Assert.assertFalse((boolean)this.intermediaryDataManager.findPartitionFile("supervisorTaskId", "subTaskId_" + subTaskId, interval, partitionId).isPresent());
            }
        }
    }

    @Test
    public void testAddRemoveAdd() throws IOException {
        DataSegment segment;
        File segmentFile;
        int i;
        String supervisorTaskId = "supervisorTaskId";
        Interval interval = Intervals.of((String)"2018/2019");
        for (i = 0; i < 4; ++i) {
            segmentFile = this.generateSegmentDir("file_" + i);
            segment = this.newSegment(interval, i);
            this.intermediaryDataManager.addSegment("supervisorTaskId", "subTaskId", segment, segmentFile);
        }
        this.intermediaryDataManager.deletePartitions("supervisorTaskId");
        segmentFile = this.generateSegmentDir("file_" + i);
        segment = this.newSegment(interval, i);
        this.intermediaryDataManager.addSegment("supervisorTaskId", "subTaskId", segment, segmentFile);
    }

    @Test
    public void testFailsWithCraftyFabricatedNamesForDelete() throws IOException {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("supervisorTaskId cannot start with the '.' character.");
        String supervisorTaskId = "../" + this.siblingLocation.getName();
        String someFile = "sneaky-snake.txt";
        File dataFile = new File(this.siblingLocation, "sneaky-snake.txt");
        FileUtils.write((File)dataFile, (CharSequence)"test data", (Charset)StandardCharsets.UTF_8);
        Assert.assertTrue((boolean)new File(this.intermediarySegmentsLocation, supervisorTaskId).exists());
        Assert.assertTrue((boolean)dataFile.exists());
        this.intermediaryDataManager.deletePartitions(supervisorTaskId);
        Assert.assertTrue((boolean)new File(this.intermediarySegmentsLocation, supervisorTaskId).exists());
        Assert.assertTrue((boolean)dataFile.exists());
    }

    @Test
    public void testFailsWithCraftyFabricatedNamesForFind() throws IOException {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("supervisorTaskId cannot start with the '.' character.");
        String supervisorTaskId = "../" + this.siblingLocation.getName();
        Interval interval = Intervals.of((String)"2018/2019");
        boolean partitionId = false;
        String intervalAndPart = StringUtils.format((String)"%s/%s/%s", (Object[])new Object[]{interval.getStart().toString(), interval.getEnd().toString(), 0});
        String someFile = "sneaky-snake.txt";
        String someFilePath = intervalAndPart + "/" + "sneaky-snake.txt";
        File dataFile = new File(this.siblingLocation, someFilePath);
        FileUtils.write((File)dataFile, (CharSequence)"test data", (Charset)StandardCharsets.UTF_8);
        Assert.assertTrue((boolean)new File(this.intermediarySegmentsLocation, supervisorTaskId).exists());
        Assert.assertTrue((boolean)new File(this.intermediarySegmentsLocation, supervisorTaskId + "/" + someFilePath).exists());
        Optional foundFile1 = this.intermediaryDataManager.findPartitionFile(supervisorTaskId, "sneaky-snake.txt", interval, 0);
        Assert.assertFalse((boolean)foundFile1.isPresent());
    }

    private File generateSegmentDir(String fileName) throws IOException {
        File segmentDir = this.tempDir.newFolder();
        FileUtils.write((File)new File(segmentDir, fileName), (CharSequence)"test data.", (Charset)StandardCharsets.UTF_8);
        FileUtils.writeByteArrayToFile((File)new File(segmentDir, "version.bin"), (byte[])Ints.toByteArray((int)9));
        return segmentDir;
    }

    private DataSegment newSegment(Interval interval, int bucketId) {
        return new DataSegment("dataSource", interval, "version", null, null, null, (ShardSpec)new TestShardSpec(bucketId), Integer.valueOf(9), 10L);
    }

    private static class TestShardSpec
    implements BucketNumberedShardSpec<BuildingShardSpec<ShardSpec>> {
        private final int bucketId;

        private TestShardSpec(int bucketId) {
            this.bucketId = bucketId;
        }

        public int getBucketId() {
            return this.bucketId;
        }

        public BuildingShardSpec<ShardSpec> convert(int partitionId) {
            throw new UnsupportedOperationException();
        }

        public ShardSpecLookup getLookup(List<? extends ShardSpec> shardSpecs) {
            throw new UnsupportedOperationException();
        }
    }
}

