/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.worker.shuffle;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import org.apache.druid.indexing.worker.shuffle.ShuffleMetrics;
import org.apache.druid.indexing.worker.shuffle.ShuffleMonitor;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ShuffleMonitorTest {
    @Test
    public void testDoMonitor() {
        ShuffleMetrics shuffleMetrics = (ShuffleMetrics)Mockito.mock(ShuffleMetrics.class);
        ShuffleMetrics.PerDatasourceShuffleMetrics perDatasourceShuffleMetrics = new ShuffleMetrics.PerDatasourceShuffleMetrics();
        perDatasourceShuffleMetrics.accumulate(100L);
        perDatasourceShuffleMetrics.accumulate(200L);
        perDatasourceShuffleMetrics.accumulate(10L);
        Mockito.when((Object)shuffleMetrics.snapshotAndReset()).thenReturn((Object)ImmutableMap.of((Object)"supervisor", (Object)perDatasourceShuffleMetrics));
        StubServiceEmitter emitter = new StubServiceEmitter("service", "host");
        ShuffleMonitor monitor = new ShuffleMonitor();
        monitor.setShuffleMetrics(shuffleMetrics);
        Assert.assertTrue((boolean)monitor.doMonitor((ServiceEmitter)emitter));
        List events = emitter.getEvents();
        Assert.assertEquals((long)2L, (long)events.size());
        Assert.assertSame(ServiceMetricEvent.class, ((Event)events.get(0)).getClass());
        ServiceMetricEvent event = (ServiceMetricEvent)events.get(0);
        Assert.assertEquals((Object)"ingest/shuffle/bytes", (Object)event.getMetric());
        Assert.assertEquals((Object)310L, (Object)event.getValue());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"supervisorTaskId", (Object)"supervisor"), (Object)event.getUserDims());
        Assert.assertSame(ServiceMetricEvent.class, ((Event)events.get(1)).getClass());
        event = (ServiceMetricEvent)events.get(1);
        Assert.assertEquals((Object)"ingest/shuffle/requests", (Object)event.getMetric());
        Assert.assertEquals((Object)3, (Object)event.getValue());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"supervisorTaskId", (Object)"supervisor"), (Object)event.getUserDims());
    }
}

