/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.RetryPolicy;
import org.apache.druid.indexing.common.RetryPolicyConfig;
import org.apache.druid.indexing.common.RetryPolicyFactory;
import org.apache.druid.indexing.common.TaskInfoProvider;
import org.apache.druid.java.util.common.Either;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.IOE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.ObjectOrErrorResponseHandler;
import org.apache.druid.java.util.http.client.response.StringFullResponseHandler;
import org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.joda.time.Duration;
import org.joda.time.Period;

public abstract class IndexTaskClient
implements AutoCloseable {
    public static final int MAX_RETRY_WAIT_SECONDS = 10;
    private static final EmittingLogger log = new EmittingLogger(IndexTaskClient.class);
    private static final String BASE_PATH = "/druid/worker/v1/chat";
    private static final int MIN_RETRY_WAIT_SECONDS = 2;
    private static final int TASK_MISMATCH_RETRY_DELAY_SECONDS = 5;
    private final HttpClient httpClient;
    private final ObjectMapper objectMapper;
    private final TaskInfoProvider taskInfoProvider;
    private final Duration httpTimeout;
    private final RetryPolicyFactory retryPolicyFactory;
    private final ListeningExecutorService executorService;

    public IndexTaskClient(HttpClient httpClient, ObjectMapper objectMapper, TaskInfoProvider taskInfoProvider, Duration httpTimeout, String callerId, int numThreads, long numRetries) {
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
        this.taskInfoProvider = taskInfoProvider;
        this.httpTimeout = httpTimeout;
        this.retryPolicyFactory = IndexTaskClient.initializeRetryPolicyFactory(numRetries);
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Execs.multiThreaded((int)numThreads, (String)StringUtils.format((String)"IndexTaskClient-%s-%%d", (Object[])new Object[]{StringUtils.encodeForFormat((String)callerId)})));
    }

    private static RetryPolicyFactory initializeRetryPolicyFactory(long numRetries) {
        return new RetryPolicyFactory(new RetryPolicyConfig().setMinWait(Period.seconds((int)2)).setMaxWait(Period.seconds((int)10)).setMaxRetryCount(numRetries));
    }

    protected HttpClient getHttpClient() {
        return this.httpClient;
    }

    protected RetryPolicy newRetryPolicy() {
        return this.retryPolicyFactory.makeRetryPolicy();
    }

    protected <T> T deserialize(String content, JavaType type) throws IOException {
        return (T)this.objectMapper.readValue(content, type);
    }

    protected <T> T deserialize(String content, TypeReference<T> typeReference) throws IOException {
        return (T)this.objectMapper.readValue(content, typeReference);
    }

    protected <T> T deserialize(String content, Class<T> typeReference) throws IOException {
        return (T)this.objectMapper.readValue(content, typeReference);
    }

    protected <T> T deserializeMap(String content, Class<? extends Map> mapClass, Class<?> keyClass, Class<?> valueClass) throws IOException {
        return this.deserialize(content, (JavaType)this.objectMapper.getTypeFactory().constructMapType(mapClass, keyClass, valueClass));
    }

    protected <T> T deserializeNestedValueMap(String content, Class<? extends Map> mapClass, Class<?> keyClass, Class<? extends Map> valueMapClass, Class<?> valueMapClassKey, Class<?> valueMapClassValue) throws IOException {
        TypeFactory factory = this.objectMapper.getTypeFactory();
        return this.deserialize(content, (JavaType)factory.constructMapType(mapClass, factory.constructType(keyClass), (JavaType)factory.constructMapType(valueMapClass, valueMapClassKey, valueMapClassValue)));
    }

    protected byte[] serialize(Object value) throws JsonProcessingException {
        return this.objectMapper.writeValueAsBytes(value);
    }

    protected <T> ListenableFuture<T> doAsync(Callable<T> callable) {
        return this.executorService.submit(callable);
    }

    protected boolean isSuccess(StringFullResponseHolder responseHolder) {
        return responseHolder.getStatus().getCode() / 100 == 2;
    }

    @VisibleForTesting
    protected void checkConnection(String host, int port) throws IOException {
        new Socket(host, port).close();
    }

    protected StringFullResponseHolder submitRequestWithEmptyContent(String taskId, HttpMethod method, String encodedPathSuffix, @Nullable String encodedQueryString, boolean retry) throws IOException, ChannelException, NoTaskLocationException {
        return (StringFullResponseHolder)this.submitRequest(taskId, null, method, encodedPathSuffix, encodedQueryString, new byte[0], (HttpResponseHandler)new StringFullResponseHandler(StandardCharsets.UTF_8), retry);
    }

    protected StringFullResponseHolder submitJsonRequest(String taskId, HttpMethod method, String encodedPathSuffix, @Nullable String encodedQueryString, byte[] content, boolean retry) throws IOException, ChannelException, NoTaskLocationException {
        return (StringFullResponseHolder)this.submitRequest(taskId, "application/json", method, encodedPathSuffix, encodedQueryString, content, (HttpResponseHandler)new StringFullResponseHandler(StandardCharsets.UTF_8), retry);
    }

    protected StringFullResponseHolder submitSmileRequest(String taskId, HttpMethod method, String encodedPathSuffix, @Nullable String encodedQueryString, byte[] content, boolean retry) throws IOException, ChannelException, NoTaskLocationException {
        return (StringFullResponseHolder)this.submitRequest(taskId, "application/x-jackson-smile", method, encodedPathSuffix, encodedQueryString, content, (HttpResponseHandler)new StringFullResponseHandler(StandardCharsets.UTF_8), retry);
    }

    private Request createRequest(String taskId, TaskLocation location, String path, @Nullable String encodedQueryString, HttpMethod method, @Nullable String mediaType, byte[] content) throws MalformedURLException {
        URL serviceUrl = location.makeURL(encodedQueryString == null ? path : StringUtils.format((String)"%s?%s", (Object[])new Object[]{path, encodedQueryString}));
        Request request = new Request(method, serviceUrl);
        request.addHeader("X-Druid-Task-Id", StringUtils.urlEncode((String)taskId));
        if (content.length > 0) {
            request.setContent((String)Preconditions.checkNotNull((Object)mediaType, (Object)"mediaType"), content);
        }
        return request;
    }

    /*
     * Unable to fully structure code
     */
    protected <IntermediateType, FinalType> FinalType submitRequest(String taskId, @Nullable String mediaType, HttpMethod method, String encodedPathSuffix, @Nullable String encodedQueryString, byte[] content, HttpResponseHandler<IntermediateType, FinalType> responseHandler, boolean retry) throws IOException, ChannelException, NoTaskLocationException {
        retryPolicy = this.retryPolicyFactory.makeRetryPolicy();
        while (true) lbl-1000:
        // 2 sources

        {
            path = StringUtils.format((String)"%s/%s/%s", (Object[])new Object[]{"/druid/worker/v1/chat", StringUtils.urlEncode((String)taskId), encodedPathSuffix});
            status = this.taskInfoProvider.getTaskStatus(taskId);
            if (!status.isPresent() || !((TaskStatus)status.get()).isRunnable()) {
                throw new TaskNotRunnableException(StringUtils.format((String)"Aborting request because task [%s] is not runnable", (Object[])new Object[]{taskId}));
            }
            location = this.taskInfoProvider.getTaskLocation(taskId);
            if (location.equals((Object)TaskLocation.unknown())) {
                throw new NoTaskLocationException(StringUtils.format((String)"No TaskLocation available for task [%s]", (Object[])new Object[]{taskId}));
            }
            request = this.createRequest(taskId, location, path, encodedQueryString, method, mediaType, content);
            response = null;
            try {
                this.checkConnection(request.getUrl().getHost(), request.getUrl().getPort());
                response = this.submitRequest(request, responseHandler);
                if (response.isValue()) {
                    return (FinalType)response.valueOrThrow();
                }
                exceptionMessage = new StringBuilder();
                httpResponseStatus = ((StringFullResponseHolder)response.error()).getStatus();
                httpResponseContent = ((StringFullResponseHolder)response.error()).getContent();
                exceptionMessage.append("Received server error with status [").append(httpResponseStatus).append("]");
                if (!Strings.isNullOrEmpty((String)httpResponseContent)) {
                    choppedMessage = StringUtils.chop((String)StringUtils.nullToEmptyNonDruidDataString((String)httpResponseContent), (int)1000);
                    exceptionMessage.append("; first 1KB of body: ").append(choppedMessage);
                }
                if (httpResponseStatus.getCode() == 400) {
                    throw new IAE(exceptionMessage.toString(), new Object[0]);
                }
                throw new IOE(exceptionMessage.toString(), new Object[0]);
            }
            catch (IOException | ChannelException e) {
                if (response != null && !response.isValue() && ((StringFullResponseHolder)response.error()).getStatus().equals((Object)HttpResponseStatus.NOT_FOUND)) {
                    headerId = StringUtils.urlDecode((String)((StringFullResponseHolder)response.error()).getResponse().headers().get("X-Druid-Task-Id"));
                    if (headerId != null && !headerId.equals(taskId)) {
                        IndexTaskClient.log.warn("Expected worker to have taskId [%s] but has taskId [%s], will retry in [%d]s", new Object[]{taskId, headerId, 5});
                        delay = Duration.standardSeconds((long)5L);
                    } else {
                        delay = retryPolicy.getAndIncrementRetryDelay();
                    }
                } else {
                    delay = retryPolicy.getAndIncrementRetryDelay();
                }
                urlForLog = request.getUrl().toString();
                if (!retry) {
                    IndexTaskClient.log.noStackTrace().info(e, "submitRequest failed for [%s]", new Object[]{urlForLog});
                    throw e;
                }
                if (delay == null) {
                    IndexTaskClient.log.warn(e, "submitRequest failed for [%s]", new Object[]{urlForLog});
                    throw e;
                }
                try {
                    sleepTime = delay.getMillis();
                    IndexTaskClient.log.noStackTrace().info(e, "submitRequest failed for [%s]; will try again in [%s]", new Object[]{urlForLog, new Duration(sleepTime).toString()});
                    Thread.sleep(sleepTime);
                    continue;
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    e.addSuppressed(e2);
                    throw new RuntimeException(e);
                }
            }
            ** while (true)
            catch (NoTaskLocationException e) {
                IndexTaskClient.log.info("No TaskLocation available for task [%s], this task may not have been assigned to a worker yet or may have already completed", new Object[]{taskId});
                throw e;
            }
            catch (Exception e) {
                IndexTaskClient.log.warn((Throwable)e, "Exception while sending request", new Object[0]);
                throw e;
            }
            break;
        }
    }

    private <IntermediateType, FinalType> Either<StringFullResponseHolder, FinalType> submitRequest(Request request, HttpResponseHandler<IntermediateType, FinalType> responseHandler) throws IOException, ChannelException {
        ObjectOrErrorResponseHandler wrappedHandler = new ObjectOrErrorResponseHandler(responseHandler);
        try {
            log.debug("HTTP %s: %s", new Object[]{request.getMethod().getName(), request.getUrl().toString()});
            return (Either)this.httpClient.go(request, (HttpResponseHandler)wrappedHandler, this.httpTimeout).get();
        }
        catch (Exception e) {
            throw this.throwIfPossible(e);
        }
    }

    private RuntimeException throwIfPossible(Throwable t) throws IOException, ChannelException {
        Preconditions.checkNotNull((Object)t, (Object)"Throwable shoulnd't null");
        if (t instanceof ExecutionException) {
            if (t.getCause() != null) {
                return this.throwIfPossible(t.getCause());
            }
            return new RuntimeException(t);
        }
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof ChannelException) {
            throw (ChannelException)t;
        }
        if (t instanceof InterruptedException) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(t);
        }
        Throwables.propagateIfPossible((Throwable)t);
        return new RuntimeException(t);
    }

    @Override
    public void close() {
        this.executorService.shutdownNow();
    }

    public static class TaskNotRunnableException
    extends RuntimeException {
        public TaskNotRunnableException(String message) {
            super(message);
        }
    }

    public static class NoTaskLocationException
    extends RuntimeException {
        public NoTaskLocationException(String message) {
            super(message);
        }
    }
}

