/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.druid.discovery.DataNodeService;
import org.apache.druid.discovery.DruidNodeAnnouncer;
import org.apache.druid.discovery.LookupNodeService;
import org.apache.druid.indexing.common.TaskReportFileWriter;
import org.apache.druid.indexing.common.actions.SegmentInsertAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.IndexTaskClientFactory;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTaskClient;
import org.apache.druid.indexing.common.task.batch.parallel.ShuffleClient;
import org.apache.druid.indexing.worker.shuffle.IntermediaryDataManager;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.Monitor;
import org.apache.druid.java.util.metrics.MonitorScheduler;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.handoff.SegmentHandoffNotifierFactory;
import org.apache.druid.segment.incremental.RowIngestionMetersFactory;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.loading.DataSegmentArchiver;
import org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.druid.segment.loading.DataSegmentMover;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.segment.realtime.appenderator.AppenderatorsManager;
import org.apache.druid.segment.realtime.firehose.ChatHandlerProvider;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.druid.server.coordination.DataSegmentServerAnnouncer;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class TaskToolbox {
    private final TaskConfig config;
    private final DruidNode taskExecutorNode;
    private final TaskActionClient taskActionClient;
    private final ServiceEmitter emitter;
    private final DataSegmentPusher segmentPusher;
    private final DataSegmentKiller dataSegmentKiller;
    private final DataSegmentArchiver dataSegmentArchiver;
    private final DataSegmentMover dataSegmentMover;
    private final DataSegmentAnnouncer segmentAnnouncer;
    private final DataSegmentServerAnnouncer serverAnnouncer;
    private final SegmentHandoffNotifierFactory handoffNotifierFactory;
    private final Provider<QueryRunnerFactoryConglomerate> queryRunnerFactoryConglomerateProvider;
    @Nullable
    private final Provider<MonitorScheduler> monitorSchedulerProvider;
    private final QueryProcessingPool queryProcessingPool;
    private final JoinableFactory joinableFactory;
    private final SegmentCacheManager segmentCacheManager;
    private final ObjectMapper jsonMapper;
    private final File taskWorkDir;
    private final IndexIO indexIO;
    private final Cache cache;
    private final CacheConfig cacheConfig;
    private final CachePopulatorStats cachePopulatorStats;
    private final IndexMergerV9 indexMergerV9;
    private final TaskReportFileWriter taskReportFileWriter;
    private final DruidNodeAnnouncer druidNodeAnnouncer;
    private final DruidNode druidNode;
    private final LookupNodeService lookupNodeService;
    private final DataNodeService dataNodeService;
    private final AuthorizerMapper authorizerMapper;
    private final ChatHandlerProvider chatHandlerProvider;
    private final RowIngestionMetersFactory rowIngestionMetersFactory;
    private final AppenderatorsManager appenderatorsManager;
    private final IndexingServiceClient indexingServiceClient;
    private final CoordinatorClient coordinatorClient;
    private final IntermediaryDataManager intermediaryDataManager;
    private final IndexTaskClientFactory<ParallelIndexSupervisorTaskClient> supervisorTaskClientFactory;
    private final ShuffleClient shuffleClient;

    public TaskToolbox(TaskConfig config, DruidNode taskExecutorNode, TaskActionClient taskActionClient, ServiceEmitter emitter, DataSegmentPusher segmentPusher, DataSegmentKiller dataSegmentKiller, DataSegmentMover dataSegmentMover, DataSegmentArchiver dataSegmentArchiver, DataSegmentAnnouncer segmentAnnouncer, DataSegmentServerAnnouncer serverAnnouncer, SegmentHandoffNotifierFactory handoffNotifierFactory, Provider<QueryRunnerFactoryConglomerate> queryRunnerFactoryConglomerateProvider, QueryProcessingPool queryProcessingPool, JoinableFactory joinableFactory, @Nullable Provider<MonitorScheduler> monitorSchedulerProvider, SegmentCacheManager segmentCacheManager, ObjectMapper jsonMapper, File taskWorkDir, IndexIO indexIO, Cache cache, CacheConfig cacheConfig, CachePopulatorStats cachePopulatorStats, IndexMergerV9 indexMergerV9, DruidNodeAnnouncer druidNodeAnnouncer, DruidNode druidNode, LookupNodeService lookupNodeService, DataNodeService dataNodeService, TaskReportFileWriter taskReportFileWriter, IntermediaryDataManager intermediaryDataManager, AuthorizerMapper authorizerMapper, ChatHandlerProvider chatHandlerProvider, RowIngestionMetersFactory rowIngestionMetersFactory, AppenderatorsManager appenderatorsManager, IndexingServiceClient indexingServiceClient, CoordinatorClient coordinatorClient, IndexTaskClientFactory<ParallelIndexSupervisorTaskClient> supervisorTaskClientFactory, ShuffleClient shuffleClient) {
        this.config = config;
        this.taskExecutorNode = taskExecutorNode;
        this.taskActionClient = taskActionClient;
        this.emitter = emitter;
        this.segmentPusher = segmentPusher;
        this.dataSegmentKiller = dataSegmentKiller;
        this.dataSegmentMover = dataSegmentMover;
        this.dataSegmentArchiver = dataSegmentArchiver;
        this.segmentAnnouncer = segmentAnnouncer;
        this.serverAnnouncer = serverAnnouncer;
        this.handoffNotifierFactory = handoffNotifierFactory;
        this.queryRunnerFactoryConglomerateProvider = queryRunnerFactoryConglomerateProvider;
        this.queryProcessingPool = queryProcessingPool;
        this.joinableFactory = joinableFactory;
        this.monitorSchedulerProvider = monitorSchedulerProvider;
        this.segmentCacheManager = segmentCacheManager;
        this.jsonMapper = jsonMapper;
        this.taskWorkDir = taskWorkDir;
        this.indexIO = (IndexIO)Preconditions.checkNotNull((Object)indexIO, (Object)"Null IndexIO");
        this.cache = cache;
        this.cacheConfig = cacheConfig;
        this.cachePopulatorStats = cachePopulatorStats;
        this.indexMergerV9 = (IndexMergerV9)Preconditions.checkNotNull((Object)indexMergerV9, (Object)"Null IndexMergerV9");
        this.druidNodeAnnouncer = druidNodeAnnouncer;
        this.druidNode = druidNode;
        this.lookupNodeService = lookupNodeService;
        this.dataNodeService = dataNodeService;
        this.taskReportFileWriter = taskReportFileWriter;
        this.taskReportFileWriter.setObjectMapper(this.jsonMapper);
        this.intermediaryDataManager = intermediaryDataManager;
        this.authorizerMapper = authorizerMapper;
        this.chatHandlerProvider = chatHandlerProvider;
        this.rowIngestionMetersFactory = rowIngestionMetersFactory;
        this.appenderatorsManager = appenderatorsManager;
        this.indexingServiceClient = indexingServiceClient;
        this.coordinatorClient = coordinatorClient;
        this.supervisorTaskClientFactory = supervisorTaskClientFactory;
        this.shuffleClient = shuffleClient;
    }

    public TaskConfig getConfig() {
        return this.config;
    }

    public DruidNode getTaskExecutorNode() {
        return this.taskExecutorNode;
    }

    public TaskActionClient getTaskActionClient() {
        return this.taskActionClient;
    }

    public ServiceEmitter getEmitter() {
        return this.emitter;
    }

    public DataSegmentPusher getSegmentPusher() {
        return this.segmentPusher;
    }

    public DataSegmentKiller getDataSegmentKiller() {
        return this.dataSegmentKiller;
    }

    public DataSegmentMover getDataSegmentMover() {
        return this.dataSegmentMover;
    }

    public DataSegmentArchiver getDataSegmentArchiver() {
        return this.dataSegmentArchiver;
    }

    public DataSegmentAnnouncer getSegmentAnnouncer() {
        return this.segmentAnnouncer;
    }

    public DataSegmentServerAnnouncer getDataSegmentServerAnnouncer() {
        return this.serverAnnouncer;
    }

    public SegmentHandoffNotifierFactory getSegmentHandoffNotifierFactory() {
        return this.handoffNotifierFactory;
    }

    public QueryRunnerFactoryConglomerate getQueryRunnerFactoryConglomerate() {
        return (QueryRunnerFactoryConglomerate)this.queryRunnerFactoryConglomerateProvider.get();
    }

    public QueryProcessingPool getQueryProcessingPool() {
        return this.queryProcessingPool;
    }

    public JoinableFactory getJoinableFactory() {
        return this.joinableFactory;
    }

    @Nullable
    public MonitorScheduler getMonitorScheduler() {
        return this.monitorSchedulerProvider == null ? null : (MonitorScheduler)this.monitorSchedulerProvider.get();
    }

    public void addMonitor(Monitor monitor) {
        MonitorScheduler scheduler = this.getMonitorScheduler();
        if (scheduler != null) {
            scheduler.addMonitor(monitor);
        }
    }

    public void removeMonitor(Monitor monitor) {
        MonitorScheduler scheduler = this.getMonitorScheduler();
        if (scheduler != null) {
            scheduler.removeMonitor(monitor);
        }
    }

    public ObjectMapper getJsonMapper() {
        return this.jsonMapper;
    }

    public Map<DataSegment, File> fetchSegments(List<DataSegment> segments) throws SegmentLoadingException {
        LinkedHashMap retVal = Maps.newLinkedHashMap();
        for (DataSegment segment : segments) {
            retVal.put(segment, this.segmentCacheManager.getSegmentFiles(segment));
        }
        return retVal;
    }

    public void publishSegments(Iterable<DataSegment> segments) throws IOException {
        ImmutableListMultimap segmentMultimap = Multimaps.index(segments, (Function)new Function<DataSegment, Interval>(){

            public Interval apply(DataSegment segment) {
                return segment.getInterval();
            }
        });
        for (Collection segmentCollection : segmentMultimap.asMap().values()) {
            this.getTaskActionClient().submit(new SegmentInsertAction((Set<DataSegment>)ImmutableSet.copyOf((Collection)segmentCollection)));
        }
    }

    public IndexIO getIndexIO() {
        return this.indexIO;
    }

    public Cache getCache() {
        return this.cache;
    }

    public CacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    public CachePopulatorStats getCachePopulatorStats() {
        return this.cachePopulatorStats;
    }

    public IndexMergerV9 getIndexMergerV9() {
        return this.indexMergerV9;
    }

    public File getIndexingTmpDir() {
        File tmpDir = new File(this.taskWorkDir, "indexing-tmp");
        try {
            FileUtils.mkdirp((File)tmpDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return tmpDir;
    }

    public File getMergeDir() {
        return new File(this.taskWorkDir, "merge");
    }

    public File getPersistDir() {
        return new File(this.taskWorkDir, "persist");
    }

    public DruidNodeAnnouncer getDruidNodeAnnouncer() {
        return this.druidNodeAnnouncer;
    }

    public LookupNodeService getLookupNodeService() {
        return this.lookupNodeService;
    }

    public DataNodeService getDataNodeService() {
        return this.dataNodeService;
    }

    public DruidNode getDruidNode() {
        return this.druidNode;
    }

    public TaskReportFileWriter getTaskReportFileWriter() {
        return this.taskReportFileWriter;
    }

    public IntermediaryDataManager getIntermediaryDataManager() {
        return this.intermediaryDataManager;
    }

    public AuthorizerMapper getAuthorizerMapper() {
        return this.authorizerMapper;
    }

    public ChatHandlerProvider getChatHandlerProvider() {
        return this.chatHandlerProvider;
    }

    public RowIngestionMetersFactory getRowIngestionMetersFactory() {
        return this.rowIngestionMetersFactory;
    }

    public AppenderatorsManager getAppenderatorsManager() {
        return this.appenderatorsManager;
    }

    public IndexingServiceClient getIndexingServiceClient() {
        return this.indexingServiceClient;
    }

    public CoordinatorClient getCoordinatorClient() {
        return this.coordinatorClient;
    }

    public IndexTaskClientFactory<ParallelIndexSupervisorTaskClient> getSupervisorTaskClientFactory() {
        return this.supervisorTaskClientFactory;
    }

    public ShuffleClient getShuffleClient() {
        return this.shuffleClient;
    }
}

