/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.data.input.FiniteFirehoseFactory;
import org.apache.druid.data.input.FirehoseFactory;
import org.apache.druid.data.input.FirehoseFactoryToInputSourceAdaptor;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.Rows;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.indexer.Checks;
import org.apache.druid.indexer.IngestionState;
import org.apache.druid.indexer.Property;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexer.partitions.SecondaryPartitionType;
import org.apache.druid.indexing.common.IngestionStatsAndErrorsTaskReport;
import org.apache.druid.indexing.common.IngestionStatsAndErrorsTaskReportData;
import org.apache.druid.indexing.common.TaskReport;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.SegmentTransactionalInsertAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.task.AbstractBatchIndexTask;
import org.apache.druid.indexing.common.task.FilteringCloseableInputRowIterator;
import org.apache.druid.indexing.common.task.IndexTaskUtils;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.common.task.batch.parallel.PartialHashSegmentGenerateTask;
import org.apache.druid.indexing.common.task.batch.partition.HashPartitionAnalysis;
import org.apache.druid.indexing.common.task.batch.partition.LinearPartitionAnalysis;
import org.apache.druid.indexing.common.task.batch.partition.PartitionAnalysis;
import org.apache.druid.indexing.overlord.SegmentPublishResult;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.incremental.AppendableIndexSpec;
import org.apache.druid.segment.incremental.ParseExceptionHandler;
import org.apache.druid.segment.incremental.ParseExceptionReport;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.incremental.RowIngestionMetersTotals;
import org.apache.druid.segment.indexing.BatchIOConfig;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.IOConfig;
import org.apache.druid.segment.indexing.IngestionSpec;
import org.apache.druid.segment.indexing.TuningConfig;
import org.apache.druid.segment.indexing.granularity.ArbitraryGranularitySpec;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.realtime.appenderator.AppenderatorConfig;
import org.apache.druid.segment.realtime.appenderator.SegmentsAndCommitMetadata;
import org.apache.druid.segment.realtime.firehose.ChatHandler;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.utils.CircularBuffer;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.joda.time.Interval;
import org.joda.time.Period;

public class IndexTask
extends AbstractBatchIndexTask
implements ChatHandler {
    public static final HashFunction HASH_FUNCTION = Hashing.murmur3_128();
    private static final Logger log = new Logger(IndexTask.class);
    private static final String TYPE = "index";
    private final String baseSequenceName;
    private final IndexIngestionSpec ingestionSchema;
    private IngestionState ingestionState;
    private @MonotonicNonNull ParseExceptionHandler determinePartitionsParseExceptionHandler;
    private @MonotonicNonNull ParseExceptionHandler buildSegmentsParseExceptionHandler;
    private @MonotonicNonNull AuthorizerMapper authorizerMapper;
    private @MonotonicNonNull RowIngestionMeters determinePartitionsMeters;
    private @MonotonicNonNull RowIngestionMeters buildSegmentsMeters;
    @Nullable
    private String errorMsg;

    private static String makeGroupId(IndexIngestionSpec ingestionSchema) {
        return IndexTask.makeGroupId(ingestionSchema.ioConfig.appendToExisting, ingestionSchema.dataSchema.getDataSource());
    }

    private static String makeGroupId(boolean isAppendToExisting, String dataSource) {
        if (isAppendToExisting) {
            return StringUtils.format((String)"%s_append_%s", (Object[])new Object[]{TYPE, dataSource});
        }
        return null;
    }

    @JsonCreator
    public IndexTask(@JsonProperty(value="id") String id, @JsonProperty(value="resource") TaskResource taskResource, @JsonProperty(value="spec") IndexIngestionSpec ingestionSchema, @JsonProperty(value="context") Map<String, Object> context) {
        this(id, IndexTask.makeGroupId(ingestionSchema), taskResource, ingestionSchema.dataSchema.getDataSource(), null, ingestionSchema, context, -1);
    }

    public IndexTask(String id, String groupId, TaskResource resource, String dataSource, @Nullable String baseSequenceName, IndexIngestionSpec ingestionSchema, Map<String, Object> context, int maxAllowedLockCount) {
        super(IndexTask.getOrMakeId(id, TYPE, dataSource), groupId, resource, dataSource, context, maxAllowedLockCount);
        this.baseSequenceName = baseSequenceName == null ? this.getId() : baseSequenceName;
        this.ingestionSchema = ingestionSchema;
        this.ingestionState = IngestionState.NOT_STARTED;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) throws Exception {
        IndexTuningConfig tuningConfig = this.getIngestionSchema().getTuningConfig();
        if (tuningConfig != null && tuningConfig.getPartitionsSpec() != null && tuningConfig.getPartitionsSpec().getType() != SecondaryPartitionType.LINEAR && tuningConfig.getPartitionsSpec().getType() != SecondaryPartitionType.HASH) {
            throw new UOE("partitionsSpec[%s] is not supported", new Object[]{tuningConfig.getPartitionsSpec().getClass().getName()});
        }
        return this.determineLockGranularityAndTryLock(taskActionClient, this.ingestionSchema.dataSchema.getGranularitySpec().inputIntervals(), this.ingestionSchema.getIOConfig());
    }

    @Override
    public boolean requireLockExistingSegments() {
        return IndexTask.isGuaranteedRollup(this.ingestionSchema.ioConfig, this.ingestionSchema.tuningConfig) || !this.ingestionSchema.ioConfig.isAppendToExisting();
    }

    @Override
    public List<DataSegment> findSegmentsToLock(TaskActionClient taskActionClient, List<Interval> intervals) throws IOException {
        return IndexTask.findInputSegments(this.getDataSource(), taskActionClient, intervals, this.ingestionSchema.ioConfig.firehoseFactory);
    }

    @Override
    public boolean isPerfectRollup() {
        return IndexTask.isGuaranteedRollup(this.ingestionSchema.ioConfig, this.ingestionSchema.tuningConfig);
    }

    @Override
    @Nullable
    public Granularity getSegmentGranularity() {
        GranularitySpec granularitySpec = this.ingestionSchema.getDataSchema().getGranularitySpec();
        if (granularitySpec instanceof ArbitraryGranularitySpec) {
            return null;
        }
        return granularitySpec.getSegmentGranularity();
    }

    @GET
    @Path(value="/unparseableEvents")
    @Produces(value={"application/json"})
    public Response getUnparseableEvents(@Context HttpServletRequest req, @QueryParam(value="full") String full) {
        IndexTaskUtils.datasourceAuthorizationCheck(req, Action.READ, this.getDataSource(), this.authorizerMapper);
        return Response.ok(this.doGetUnparseableEvents(full)).build();
    }

    public Map<String, Object> doGetUnparseableEvents(String full) {
        HashMap<String, Object> events = new HashMap<String, Object>();
        boolean needsDeterminePartitions = false;
        boolean needsBuildSegments = false;
        if (full != null) {
            needsDeterminePartitions = true;
            needsBuildSegments = true;
        } else {
            switch (this.ingestionState) {
                case DETERMINE_PARTITIONS: {
                    needsDeterminePartitions = true;
                    break;
                }
                case BUILD_SEGMENTS: 
                case COMPLETED: {
                    needsBuildSegments = true;
                    break;
                }
            }
        }
        if (needsDeterminePartitions) {
            events.put("determinePartitions", IndexTaskUtils.getReportListFromSavedParseExceptions((CircularBuffer<ParseExceptionReport>)this.determinePartitionsParseExceptionHandler.getSavedParseExceptionReports()));
        }
        if (needsBuildSegments) {
            events.put("buildSegments", IndexTaskUtils.getReportListFromSavedParseExceptions((CircularBuffer<ParseExceptionReport>)this.buildSegmentsParseExceptionHandler.getSavedParseExceptionReports()));
        }
        return events;
    }

    public Map<String, Object> doGetRowStats(String full) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        HashMap<String, RowIngestionMetersTotals> totalsMap = new HashMap<String, RowIngestionMetersTotals>();
        HashMap<String, Map> averagesMap = new HashMap<String, Map>();
        boolean needsDeterminePartitions = false;
        boolean needsBuildSegments = false;
        if (full != null) {
            needsDeterminePartitions = true;
            needsBuildSegments = true;
        } else {
            switch (this.ingestionState) {
                case DETERMINE_PARTITIONS: {
                    needsDeterminePartitions = true;
                    break;
                }
                case BUILD_SEGMENTS: 
                case COMPLETED: {
                    needsBuildSegments = true;
                    break;
                }
            }
        }
        if (needsDeterminePartitions) {
            totalsMap.put("determinePartitions", this.determinePartitionsMeters.getTotals());
            averagesMap.put("determinePartitions", this.determinePartitionsMeters.getMovingAverages());
        }
        if (needsBuildSegments) {
            totalsMap.put("buildSegments", this.buildSegmentsMeters.getTotals());
            averagesMap.put("buildSegments", this.buildSegmentsMeters.getMovingAverages());
        }
        returnMap.put("totals", totalsMap);
        returnMap.put("movingAverages", averagesMap);
        return returnMap;
    }

    @GET
    @Path(value="/rowStats")
    @Produces(value={"application/json"})
    public Response getRowStats(@Context HttpServletRequest req, @QueryParam(value="full") String full) {
        IndexTaskUtils.datasourceAuthorizationCheck(req, Action.READ, this.getDataSource(), this.authorizerMapper);
        return Response.ok(this.doGetRowStats(full)).build();
    }

    @GET
    @Path(value="/liveReports")
    @Produces(value={"application/json"})
    public Response getLiveReports(@Context HttpServletRequest req, @QueryParam(value="full") String full) {
        IndexTaskUtils.datasourceAuthorizationCheck(req, Action.READ, this.getDataSource(), this.authorizerMapper);
        HashMap returnMap = new HashMap();
        HashMap<String, Object> ingestionStatsAndErrors = new HashMap<String, Object>();
        HashMap<String, Object> payload = new HashMap<String, Object>();
        Map<String, Object> events = this.getTaskCompletionUnparseableEvents();
        payload.put("ingestionState", this.ingestionState);
        payload.put("unparseableEvents", events);
        payload.put("rowStats", this.doGetRowStats(full));
        ingestionStatsAndErrors.put("taskId", this.getId());
        ingestionStatsAndErrors.put("payload", payload);
        ingestionStatsAndErrors.put("type", "ingestionStatsAndErrors");
        returnMap.put("ingestionStatsAndErrors", ingestionStatsAndErrors);
        return Response.ok(returnMap).build();
    }

    @JsonProperty(value="spec")
    public IndexIngestionSpec getIngestionSchema() {
        return this.ingestionSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskStatus runTask(TaskToolbox toolbox) {
        try {
            DataSchema dataSchema;
            log.debug("Found chat handler of class[%s]", new Object[]{toolbox.getChatHandlerProvider().getClass().getName()});
            if (toolbox.getChatHandlerProvider().get(this.getId()).isPresent()) {
                log.warn("Chat handler is already registered. Skipping chat handler registration.", new Object[0]);
            } else {
                toolbox.getChatHandlerProvider().register(this.getId(), (ChatHandler)this, false);
            }
            this.authorizerMapper = toolbox.getAuthorizerMapper();
            this.determinePartitionsMeters = toolbox.getRowIngestionMetersFactory().createRowIngestionMeters();
            this.buildSegmentsMeters = toolbox.getRowIngestionMetersFactory().createRowIngestionMeters();
            this.determinePartitionsParseExceptionHandler = new ParseExceptionHandler(this.determinePartitionsMeters, this.ingestionSchema.getTuningConfig().isLogParseExceptions(), this.ingestionSchema.getTuningConfig().getMaxParseExceptions(), this.ingestionSchema.getTuningConfig().getMaxSavedParseExceptions());
            this.buildSegmentsParseExceptionHandler = new ParseExceptionHandler(this.buildSegmentsMeters, this.ingestionSchema.getTuningConfig().isLogParseExceptions(), this.ingestionSchema.getTuningConfig().getMaxParseExceptions(), this.ingestionSchema.getTuningConfig().getMaxSavedParseExceptions());
            boolean determineIntervals = this.ingestionSchema.getDataSchema().getGranularitySpec().inputIntervals().isEmpty();
            InputSource inputSource = this.ingestionSchema.getIOConfig().getNonNullInputSource(this.ingestionSchema.getDataSchema().getParser());
            File tmpDir = toolbox.getIndexingTmpDir();
            this.ingestionState = IngestionState.DETERMINE_PARTITIONS;
            IndexTuningConfig tuningConfig = this.ingestionSchema.tuningConfig;
            PartitionsSpec partitionsSpec = tuningConfig.getGivenOrDefaultPartitionsSpec();
            PartitionAnalysis partitionAnalysis = this.determineShardSpecs(toolbox, inputSource, tmpDir, partitionsSpec);
            ArrayList<Interval> allocateIntervals = new ArrayList<Interval>(partitionAnalysis.getAllIntervalsToIndex());
            if (determineIntervals) {
                boolean gotLocks = this.determineLockGranularityAndTryLock(toolbox.getTaskActionClient(), allocateIntervals, this.ingestionSchema.getIOConfig());
                if (!gotLocks) {
                    throw new ISE("Failed to get locks for intervals[%s]", new Object[]{allocateIntervals});
                }
                dataSchema = this.ingestionSchema.getDataSchema().withGranularitySpec(this.ingestionSchema.getDataSchema().getGranularitySpec().withIntervals(JodaUtils.condenseIntervals(allocateIntervals)));
            } else {
                dataSchema = this.ingestionSchema.getDataSchema();
            }
            this.ingestionState = IngestionState.BUILD_SEGMENTS;
            TaskStatus taskStatus = this.generateAndPublishSegments(toolbox, dataSchema, inputSource, tmpDir, partitionAnalysis);
            return taskStatus;
        }
        catch (Exception e) {
            log.error((Throwable)e, "Encountered exception in %s.", new Object[]{this.ingestionState});
            this.errorMsg = Throwables.getStackTraceAsString((Throwable)e);
            toolbox.getTaskReportFileWriter().write(this.getId(), this.getTaskCompletionReports());
            TaskStatus taskStatus = TaskStatus.failure((String)this.getId(), (String)this.errorMsg);
            return taskStatus;
        }
        finally {
            toolbox.getChatHandlerProvider().unregister(this.getId());
        }
    }

    private Map<String, TaskReport> getTaskCompletionReports() {
        return TaskReport.buildTaskReports(new IngestionStatsAndErrorsTaskReport(this.getId(), new IngestionStatsAndErrorsTaskReportData(this.ingestionState, this.getTaskCompletionUnparseableEvents(), this.getTaskCompletionRowStats(), this.errorMsg, this.segmentAvailabilityConfirmationCompleted, this.segmentAvailabilityWaitTimeMs)));
    }

    private Map<String, Object> getTaskCompletionUnparseableEvents() {
        HashMap<String, Object> unparseableEventsMap = new HashMap<String, Object>();
        CircularBuffer determinePartitionsParseExceptionReports = this.determinePartitionsParseExceptionHandler.getSavedParseExceptionReports();
        CircularBuffer buildSegmentsParseExceptionReports = this.buildSegmentsParseExceptionHandler.getSavedParseExceptionReports();
        if (determinePartitionsParseExceptionReports != null || buildSegmentsParseExceptionReports != null) {
            unparseableEventsMap.put("determinePartitions", IndexTaskUtils.getReportListFromSavedParseExceptions((CircularBuffer<ParseExceptionReport>)determinePartitionsParseExceptionReports));
            unparseableEventsMap.put("buildSegments", IndexTaskUtils.getReportListFromSavedParseExceptions((CircularBuffer<ParseExceptionReport>)buildSegmentsParseExceptionReports));
        }
        return unparseableEventsMap;
    }

    private Map<String, Object> getTaskCompletionRowStats() {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        metrics.put("determinePartitions", this.determinePartitionsMeters.getTotals());
        metrics.put("buildSegments", this.buildSegmentsMeters.getTotals());
        return metrics;
    }

    private PartitionAnalysis determineShardSpecs(TaskToolbox toolbox, InputSource inputSource, File tmpDir, @Nonnull PartitionsSpec partitionsSpec) throws IOException {
        ObjectMapper jsonMapper = toolbox.getJsonMapper();
        GranularitySpec granularitySpec = this.ingestionSchema.getDataSchema().getGranularitySpec();
        boolean determineIntervals = granularitySpec.inputIntervals().isEmpty();
        boolean determineNumPartitions = partitionsSpec.needsDeterminePartitions(false);
        if (!determineNumPartitions && !determineIntervals) {
            log.info("Skipping determine partition scan", new Object[0]);
            if (partitionsSpec.getType() == SecondaryPartitionType.HASH) {
                return PartialHashSegmentGenerateTask.createHashPartitionAnalysisFromPartitionsSpec(granularitySpec, (HashedPartitionsSpec)partitionsSpec, null);
            }
            if (partitionsSpec.getType() == SecondaryPartitionType.LINEAR) {
                return IndexTask.createLinearPartitionAnalysis(granularitySpec, (DynamicPartitionsSpec)partitionsSpec);
            }
            throw new UOE("%s", new Object[]{partitionsSpec.getClass().getName()});
        }
        log.info("Determining intervals and shardSpecs", new Object[0]);
        return this.createShardSpecsFromInput(jsonMapper, this.ingestionSchema, inputSource, tmpDir, granularitySpec, partitionsSpec, determineIntervals);
    }

    private static LinearPartitionAnalysis createLinearPartitionAnalysis(GranularitySpec granularitySpec, @Nonnull DynamicPartitionsSpec partitionsSpec) {
        Iterable intervals = granularitySpec.sortedBucketIntervals();
        boolean numBucketsPerInterval = true;
        LinearPartitionAnalysis partitionAnalysis = new LinearPartitionAnalysis(partitionsSpec);
        intervals.forEach(interval -> partitionAnalysis.updateBucket((Interval)interval, 1));
        return partitionAnalysis;
    }

    private PartitionAnalysis createShardSpecsFromInput(ObjectMapper jsonMapper, IndexIngestionSpec ingestionSchema, InputSource inputSource, File tmpDir, GranularitySpec granularitySpec, @Nonnull PartitionsSpec partitionsSpec, boolean determineIntervals) throws IOException {
        PartitionAnalysis<Integer, DynamicPartitionsSpec> partitionAnalysis;
        assert (partitionsSpec.getType() != SecondaryPartitionType.RANGE);
        long determineShardSpecsStartMillis = System.currentTimeMillis();
        Map<Interval, Optional<HyperLogLogCollector>> hllCollectors = this.collectIntervalsAndShardSpecs(jsonMapper, ingestionSchema, inputSource, tmpDir, granularitySpec, partitionsSpec, determineIntervals);
        if (partitionsSpec.getType() == SecondaryPartitionType.LINEAR) {
            partitionAnalysis = new LinearPartitionAnalysis((DynamicPartitionsSpec)partitionsSpec);
        } else if (partitionsSpec.getType() == SecondaryPartitionType.HASH) {
            partitionAnalysis = new HashPartitionAnalysis((HashedPartitionsSpec)partitionsSpec);
        } else {
            throw new UOE("%s", new Object[]{partitionsSpec.getClass().getName()});
        }
        for (Map.Entry<Interval, Optional<HyperLogLogCollector>> entry : hllCollectors.entrySet()) {
            int numBucketsPerInterval;
            Interval interval = entry.getKey();
            if (partitionsSpec.getType() == SecondaryPartitionType.HASH) {
                HashedPartitionsSpec hashedPartitionsSpec = (HashedPartitionsSpec)partitionsSpec;
                HyperLogLogCollector collector = (HyperLogLogCollector)entry.getValue().orNull();
                if (partitionsSpec.needsDeterminePartitions(false)) {
                    long numRows = ((HyperLogLogCollector)Preconditions.checkNotNull((Object)collector, (Object)"HLL collector")).estimateCardinalityRound();
                    int nonNullMaxRowsPerSegment = partitionsSpec.getMaxRowsPerSegment() == null ? 5000000 : partitionsSpec.getMaxRowsPerSegment();
                    numBucketsPerInterval = (int)Math.ceil((double)numRows / (double)nonNullMaxRowsPerSegment);
                    log.info("Estimated [%,d] rows of data for interval [%s], creating [%,d] shards", new Object[]{numRows, interval, numBucketsPerInterval});
                } else {
                    numBucketsPerInterval = hashedPartitionsSpec.getNumShards() == null ? 1 : hashedPartitionsSpec.getNumShards();
                    log.info("Creating [%,d] buckets for interval [%s]", new Object[]{numBucketsPerInterval, interval});
                }
            } else {
                numBucketsPerInterval = 1;
            }
            partitionAnalysis.updateBucket(interval, numBucketsPerInterval);
        }
        log.info("Found intervals and shardSpecs in %,dms", new Object[]{System.currentTimeMillis() - determineShardSpecsStartMillis});
        return partitionAnalysis;
    }

    private Map<Interval, Optional<HyperLogLogCollector>> collectIntervalsAndShardSpecs(ObjectMapper jsonMapper, IndexIngestionSpec ingestionSchema, InputSource inputSource, File tmpDir, GranularitySpec granularitySpec, @Nonnull PartitionsSpec partitionsSpec, boolean determineIntervals) throws IOException {
        TreeMap<Interval, Optional<HyperLogLogCollector>> hllCollectors = new TreeMap<Interval, Optional<HyperLogLogCollector>>(Comparators.intervalsByStartThenEnd());
        Granularity queryGranularity = granularitySpec.getQueryGranularity();
        Predicate<InputRow> rowFilter = inputRow -> {
            if (inputRow == null) {
                return false;
            }
            if (determineIntervals) {
                return true;
            }
            Optional optInterval = granularitySpec.bucketInterval(inputRow.getTimestamp());
            return optInterval.isPresent();
        };
        try (FilteringCloseableInputRowIterator inputRowIterator = AbstractBatchIndexTask.inputSourceReader(tmpDir, ingestionSchema.getDataSchema(), inputSource, inputSource.needsFormat() ? IndexTask.getInputFormat(ingestionSchema) : null, rowFilter, this.determinePartitionsMeters, this.determinePartitionsParseExceptionHandler);){
            while (inputRowIterator.hasNext()) {
                Interval interval;
                InputRow inputRow2 = (InputRow)inputRowIterator.next();
                if (determineIntervals) {
                    interval = granularitySpec.getSegmentGranularity().bucket(inputRow2.getTimestamp());
                } else {
                    Optional optInterval = granularitySpec.bucketInterval(inputRow2.getTimestamp());
                    assert (optInterval.isPresent());
                    interval = (Interval)optInterval.get();
                }
                if (partitionsSpec.needsDeterminePartitions(false)) {
                    hllCollectors.computeIfAbsent(interval, intv -> Optional.of((Object)HyperLogLogCollector.makeLatestCollector()));
                    List groupKey = Rows.toGroupKey((long)queryGranularity.bucketStart(inputRow2.getTimestampFromEpoch()), (InputRow)inputRow2);
                    ((HyperLogLogCollector)((Optional)hllCollectors.get(interval)).get()).add(HASH_FUNCTION.hashBytes(jsonMapper.writeValueAsBytes((Object)groupKey)).asBytes());
                } else {
                    hllCollectors.putIfAbsent(interval, (Optional<HyperLogLogCollector>)Optional.absent());
                }
                this.determinePartitionsMeters.incrementProcessed();
            }
        }
        if (this.determinePartitionsMeters.getThrownAway() > 0L) {
            log.warn("Unable to find a matching interval for [%,d] events", new Object[]{this.determinePartitionsMeters.getThrownAway()});
        }
        if (this.determinePartitionsMeters.getUnparseable() > 0L) {
            log.warn("Unable to parse [%,d] events", new Object[]{this.determinePartitionsMeters.getUnparseable()});
        }
        return hllCollectors;
    }

    public IngestionState getIngestionState() {
        return this.ingestionState;
    }

    /*
     * Exception decompiling
     */
    private TaskStatus generateAndPublishSegments(TaskToolbox toolbox, DataSchema dataSchema, InputSource inputSource, File tmpDir, PartitionAnalysis partitionAnalysis) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static SegmentsAndCommitMetadata awaitPublish(ListenableFuture<SegmentsAndCommitMetadata> publishFuture, long publishTimeout) throws ExecutionException, InterruptedException, TimeoutException {
        if (publishTimeout == 0L) {
            return (SegmentsAndCommitMetadata)publishFuture.get();
        }
        return (SegmentsAndCommitMetadata)publishFuture.get(publishTimeout, TimeUnit.MILLISECONDS);
    }

    private static InputFormat getInputFormat(IndexIngestionSpec ingestionSchema) {
        return ingestionSchema.getIOConfig().getNonNullInputFormat();
    }

    private static /* synthetic */ SegmentPublishResult lambda$generateAndPublishSegments$3(TaskToolbox toolbox, Set segmentsToBeOverwritten, Set segmentsToDrop, Set segmentsToPublish, Object commitMetadata) throws IOException {
        return toolbox.getTaskActionClient().submit(SegmentTransactionalInsertAction.overwriteAction(segmentsToBeOverwritten, segmentsToDrop, segmentsToPublish));
    }

    public static class IndexTuningConfig
    implements AppenderatorConfig {
        private static final IndexSpec DEFAULT_INDEX_SPEC = new IndexSpec();
        private static final int DEFAULT_MAX_PENDING_PERSISTS = 0;
        private static final boolean DEFAULT_GUARANTEE_ROLLUP = false;
        private static final boolean DEFAULT_REPORT_PARSE_EXCEPTIONS = false;
        private static final long DEFAULT_PUSH_TIMEOUT = 0L;
        private final AppendableIndexSpec appendableIndexSpec;
        private final int maxRowsInMemory;
        private final long maxBytesInMemory;
        private final boolean skipBytesInMemoryOverheadCheck;
        private final int maxColumnsToMerge;
        @Nullable
        private final PartitionsSpec partitionsSpec;
        private final IndexSpec indexSpec;
        private final IndexSpec indexSpecForIntermediatePersists;
        private final File basePersistDirectory;
        private final int maxPendingPersists;
        private final boolean forceGuaranteedRollup;
        private final boolean reportParseExceptions;
        private final long pushTimeout;
        private final boolean logParseExceptions;
        private final int maxParseExceptions;
        private final int maxSavedParseExceptions;
        private final long awaitSegmentAvailabilityTimeoutMillis;
        @Nullable
        private final SegmentWriteOutMediumFactory segmentWriteOutMediumFactory;

        @Nullable
        private static PartitionsSpec getPartitionsSpec(boolean forceGuaranteedRollup, @Nullable PartitionsSpec partitionsSpec, @Nullable Integer maxRowsPerSegment, @Nullable Long maxTotalRows, @Nullable Integer numShards, @Nullable List<String> partitionDimensions) {
            if (partitionsSpec == null) {
                if (forceGuaranteedRollup) {
                    if (maxRowsPerSegment != null || numShards != null || partitionDimensions != null && !partitionDimensions.isEmpty()) {
                        return new HashedPartitionsSpec(maxRowsPerSegment, numShards, partitionDimensions);
                    }
                    return null;
                }
                if (maxRowsPerSegment != null || maxTotalRows != null) {
                    return new DynamicPartitionsSpec(maxRowsPerSegment, maxTotalRows);
                }
                return null;
            }
            if (forceGuaranteedRollup) {
                if (!partitionsSpec.isForceGuaranteedRollupCompatibleType()) {
                    throw new IAE(partitionsSpec.getClass().getSimpleName() + " cannot be used for perfect rollup", new Object[0]);
                }
            } else if (!(partitionsSpec instanceof DynamicPartitionsSpec)) {
                throw new IAE("DynamicPartitionsSpec must be used for best-effort rollup", new Object[0]);
            }
            return partitionsSpec;
        }

        @JsonCreator
        public IndexTuningConfig(@JsonProperty(value="targetPartitionSize") @Deprecated @Nullable Integer targetPartitionSize, @JsonProperty(value="maxRowsPerSegment") @Deprecated @Nullable Integer maxRowsPerSegment, @JsonProperty(value="appendableIndexSpec") @Nullable AppendableIndexSpec appendableIndexSpec, @JsonProperty(value="maxRowsInMemory") @Nullable Integer maxRowsInMemory, @JsonProperty(value="maxBytesInMemory") @Nullable Long maxBytesInMemory, @JsonProperty(value="skipBytesInMemoryOverheadCheck") @Nullable Boolean skipBytesInMemoryOverheadCheck, @JsonProperty(value="maxTotalRows") @Deprecated @Nullable Long maxTotalRows, @JsonProperty(value="rowFlushBoundary") @Deprecated @Nullable Integer rowFlushBoundary_forBackCompatibility, @JsonProperty(value="numShards") @Deprecated @Nullable Integer numShards, @JsonProperty(value="partitionDimensions") @Deprecated @Nullable List<String> partitionDimensions, @JsonProperty(value="partitionsSpec") @Nullable PartitionsSpec partitionsSpec, @JsonProperty(value="indexSpec") @Nullable IndexSpec indexSpec, @JsonProperty(value="indexSpecForIntermediatePersists") @Nullable IndexSpec indexSpecForIntermediatePersists, @JsonProperty(value="maxPendingPersists") @Nullable Integer maxPendingPersists, @JsonProperty(value="forceGuaranteedRollup") @Nullable Boolean forceGuaranteedRollup, @JsonProperty(value="reportParseExceptions") @Deprecated @Nullable Boolean reportParseExceptions, @JsonProperty(value="publishTimeout") @Deprecated @Nullable Long publishTimeout, @JsonProperty(value="pushTimeout") @Nullable Long pushTimeout, @JsonProperty(value="segmentWriteOutMediumFactory") @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, @JsonProperty(value="logParseExceptions") @Nullable Boolean logParseExceptions, @JsonProperty(value="maxParseExceptions") @Nullable Integer maxParseExceptions, @JsonProperty(value="maxSavedParseExceptions") @Nullable Integer maxSavedParseExceptions, @JsonProperty(value="maxColumnsToMerge") @Nullable Integer maxColumnsToMerge, @JsonProperty(value="awaitSegmentAvailabilityTimeoutMillis") @Nullable Long awaitSegmentAvailabilityTimeoutMillis) {
            this(appendableIndexSpec, maxRowsInMemory != null ? maxRowsInMemory : rowFlushBoundary_forBackCompatibility, maxBytesInMemory != null ? maxBytesInMemory : 0L, skipBytesInMemoryOverheadCheck != null ? skipBytesInMemoryOverheadCheck : false, IndexTuningConfig.getPartitionsSpec(forceGuaranteedRollup == null ? false : forceGuaranteedRollup, partitionsSpec, maxRowsPerSegment == null ? targetPartitionSize : maxRowsPerSegment, maxTotalRows, numShards, partitionDimensions), indexSpec, indexSpecForIntermediatePersists, maxPendingPersists, forceGuaranteedRollup, reportParseExceptions, pushTimeout != null ? pushTimeout : publishTimeout, null, segmentWriteOutMediumFactory, logParseExceptions, maxParseExceptions, maxSavedParseExceptions, maxColumnsToMerge, awaitSegmentAvailabilityTimeoutMillis);
            Preconditions.checkArgument((targetPartitionSize == null || maxRowsPerSegment == null ? 1 : 0) != 0, (Object)"Can't use targetPartitionSize and maxRowsPerSegment together");
        }

        private IndexTuningConfig() {
            this(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }

        private IndexTuningConfig(@Nullable AppendableIndexSpec appendableIndexSpec, @Nullable Integer maxRowsInMemory, @Nullable Long maxBytesInMemory, @Nullable Boolean skipBytesInMemoryOverheadCheck, @Nullable PartitionsSpec partitionsSpec, @Nullable IndexSpec indexSpec, @Nullable IndexSpec indexSpecForIntermediatePersists, @Nullable Integer maxPendingPersists, @Nullable Boolean forceGuaranteedRollup, @Nullable Boolean reportParseExceptions, @Nullable Long pushTimeout, @Nullable File basePersistDirectory, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, @Nullable Boolean logParseExceptions, @Nullable Integer maxParseExceptions, @Nullable Integer maxSavedParseExceptions, @Nullable Integer maxColumnsToMerge, @Nullable Long awaitSegmentAvailabilityTimeoutMillis) {
            this.appendableIndexSpec = appendableIndexSpec == null ? DEFAULT_APPENDABLE_INDEX : appendableIndexSpec;
            this.maxRowsInMemory = maxRowsInMemory == null ? 1000000 : maxRowsInMemory;
            this.maxBytesInMemory = maxBytesInMemory == null ? 0L : maxBytesInMemory;
            this.skipBytesInMemoryOverheadCheck = skipBytesInMemoryOverheadCheck == null ? false : skipBytesInMemoryOverheadCheck;
            this.maxColumnsToMerge = maxColumnsToMerge == null ? -1 : maxColumnsToMerge;
            this.partitionsSpec = partitionsSpec;
            this.indexSpec = indexSpec == null ? DEFAULT_INDEX_SPEC : indexSpec;
            this.indexSpecForIntermediatePersists = indexSpecForIntermediatePersists == null ? this.indexSpec : indexSpecForIntermediatePersists;
            this.maxPendingPersists = maxPendingPersists == null ? 0 : maxPendingPersists;
            this.forceGuaranteedRollup = forceGuaranteedRollup == null ? false : forceGuaranteedRollup;
            this.reportParseExceptions = reportParseExceptions == null ? false : reportParseExceptions;
            this.pushTimeout = pushTimeout == null ? 0L : pushTimeout;
            this.basePersistDirectory = basePersistDirectory;
            this.segmentWriteOutMediumFactory = segmentWriteOutMediumFactory;
            if (this.reportParseExceptions) {
                this.maxParseExceptions = 0;
                this.maxSavedParseExceptions = maxSavedParseExceptions == null ? 0 : Math.min(1, maxSavedParseExceptions);
            } else {
                this.maxParseExceptions = maxParseExceptions == null ? Integer.MAX_VALUE : maxParseExceptions;
                this.maxSavedParseExceptions = maxSavedParseExceptions == null ? 0 : maxSavedParseExceptions;
            }
            this.logParseExceptions = logParseExceptions == null ? false : logParseExceptions;
            this.awaitSegmentAvailabilityTimeoutMillis = awaitSegmentAvailabilityTimeoutMillis == null || awaitSegmentAvailabilityTimeoutMillis < 0L ? 0L : awaitSegmentAvailabilityTimeoutMillis;
        }

        public IndexTuningConfig withBasePersistDirectory(File dir) {
            return new IndexTuningConfig(this.appendableIndexSpec, this.maxRowsInMemory, this.maxBytesInMemory, this.skipBytesInMemoryOverheadCheck, this.partitionsSpec, this.indexSpec, this.indexSpecForIntermediatePersists, this.maxPendingPersists, this.forceGuaranteedRollup, this.reportParseExceptions, this.pushTimeout, dir, this.segmentWriteOutMediumFactory, this.logParseExceptions, this.maxParseExceptions, this.maxSavedParseExceptions, this.maxColumnsToMerge, this.awaitSegmentAvailabilityTimeoutMillis);
        }

        public IndexTuningConfig withPartitionsSpec(PartitionsSpec partitionsSpec) {
            return new IndexTuningConfig(this.appendableIndexSpec, this.maxRowsInMemory, this.maxBytesInMemory, this.skipBytesInMemoryOverheadCheck, partitionsSpec, this.indexSpec, this.indexSpecForIntermediatePersists, this.maxPendingPersists, this.forceGuaranteedRollup, this.reportParseExceptions, this.pushTimeout, this.basePersistDirectory, this.segmentWriteOutMediumFactory, this.logParseExceptions, this.maxParseExceptions, this.maxSavedParseExceptions, this.maxColumnsToMerge, this.awaitSegmentAvailabilityTimeoutMillis);
        }

        @JsonProperty
        public AppendableIndexSpec getAppendableIndexSpec() {
            return this.appendableIndexSpec;
        }

        @JsonProperty
        public int getMaxRowsInMemory() {
            return this.maxRowsInMemory;
        }

        @JsonProperty
        public long getMaxBytesInMemory() {
            return this.maxBytesInMemory;
        }

        @JsonProperty
        public boolean isSkipBytesInMemoryOverheadCheck() {
            return this.skipBytesInMemoryOverheadCheck;
        }

        @JsonProperty
        @Nullable
        public PartitionsSpec getPartitionsSpec() {
            return this.partitionsSpec;
        }

        public PartitionsSpec getGivenOrDefaultPartitionsSpec() {
            if (this.partitionsSpec != null) {
                return this.partitionsSpec;
            }
            return this.forceGuaranteedRollup ? new HashedPartitionsSpec(null, null, null) : new DynamicPartitionsSpec(null, null);
        }

        @JsonProperty
        public IndexSpec getIndexSpec() {
            return this.indexSpec;
        }

        @JsonProperty
        public IndexSpec getIndexSpecForIntermediatePersists() {
            return this.indexSpecForIntermediatePersists;
        }

        @JsonProperty
        public int getMaxPendingPersists() {
            return this.maxPendingPersists;
        }

        @JsonProperty
        public boolean isForceGuaranteedRollup() {
            return this.forceGuaranteedRollup;
        }

        @JsonProperty
        public boolean isReportParseExceptions() {
            return this.reportParseExceptions;
        }

        @JsonProperty
        public long getPushTimeout() {
            return this.pushTimeout;
        }

        @Nullable
        @JsonProperty
        public SegmentWriteOutMediumFactory getSegmentWriteOutMediumFactory() {
            return this.segmentWriteOutMediumFactory;
        }

        @JsonProperty
        public int getMaxColumnsToMerge() {
            return this.maxColumnsToMerge;
        }

        @JsonProperty
        public boolean isLogParseExceptions() {
            return this.logParseExceptions;
        }

        @JsonProperty
        public int getMaxParseExceptions() {
            return this.maxParseExceptions;
        }

        @JsonProperty
        public int getMaxSavedParseExceptions() {
            return this.maxSavedParseExceptions;
        }

        @Nullable
        @Deprecated
        @JsonProperty
        public Integer getMaxRowsPerSegment() {
            return this.partitionsSpec == null ? null : this.partitionsSpec.getMaxRowsPerSegment();
        }

        @Nullable
        @Deprecated
        @JsonProperty
        public Long getMaxTotalRows() {
            return this.partitionsSpec instanceof DynamicPartitionsSpec ? ((DynamicPartitionsSpec)this.partitionsSpec).getMaxTotalRows() : null;
        }

        @Deprecated
        @Nullable
        @JsonProperty
        public Integer getNumShards() {
            return this.partitionsSpec instanceof HashedPartitionsSpec ? ((HashedPartitionsSpec)this.partitionsSpec).getNumShards() : null;
        }

        @Deprecated
        @JsonProperty
        public List<String> getPartitionDimensions() {
            return this.partitionsSpec instanceof HashedPartitionsSpec ? ((HashedPartitionsSpec)this.partitionsSpec).getPartitionDimensions() : Collections.emptyList();
        }

        public File getBasePersistDirectory() {
            return this.basePersistDirectory;
        }

        public Period getIntermediatePersistPeriod() {
            return new Period(Integer.MAX_VALUE);
        }

        @JsonProperty
        public long getAwaitSegmentAvailabilityTimeoutMillis() {
            return this.awaitSegmentAvailabilityTimeoutMillis;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexTuningConfig that = (IndexTuningConfig)o;
            return Objects.equals(this.appendableIndexSpec, that.appendableIndexSpec) && this.maxRowsInMemory == that.maxRowsInMemory && this.maxBytesInMemory == that.maxBytesInMemory && this.skipBytesInMemoryOverheadCheck == that.skipBytesInMemoryOverheadCheck && this.maxColumnsToMerge == that.maxColumnsToMerge && this.maxPendingPersists == that.maxPendingPersists && this.forceGuaranteedRollup == that.forceGuaranteedRollup && this.reportParseExceptions == that.reportParseExceptions && this.pushTimeout == that.pushTimeout && this.logParseExceptions == that.logParseExceptions && this.maxParseExceptions == that.maxParseExceptions && this.maxSavedParseExceptions == that.maxSavedParseExceptions && Objects.equals(this.partitionsSpec, that.partitionsSpec) && Objects.equals(this.indexSpec, that.indexSpec) && Objects.equals(this.indexSpecForIntermediatePersists, that.indexSpecForIntermediatePersists) && Objects.equals(this.basePersistDirectory, that.basePersistDirectory) && Objects.equals(this.segmentWriteOutMediumFactory, that.segmentWriteOutMediumFactory) && Objects.equals(this.awaitSegmentAvailabilityTimeoutMillis, that.awaitSegmentAvailabilityTimeoutMillis);
        }

        public int hashCode() {
            return Objects.hash(this.appendableIndexSpec, this.maxRowsInMemory, this.maxBytesInMemory, this.skipBytesInMemoryOverheadCheck, this.maxColumnsToMerge, this.partitionsSpec, this.indexSpec, this.indexSpecForIntermediatePersists, this.basePersistDirectory, this.maxPendingPersists, this.forceGuaranteedRollup, this.reportParseExceptions, this.pushTimeout, this.logParseExceptions, this.maxParseExceptions, this.maxSavedParseExceptions, this.segmentWriteOutMediumFactory, this.awaitSegmentAvailabilityTimeoutMillis);
        }

        public String toString() {
            return "IndexTuningConfig{maxRowsInMemory=" + this.maxRowsInMemory + ", maxBytesInMemory=" + this.maxBytesInMemory + ", skipBytesInMemoryOverheadCheck=" + this.skipBytesInMemoryOverheadCheck + ", maxColumnsToMerge=" + this.maxColumnsToMerge + ", partitionsSpec=" + this.partitionsSpec + ", indexSpec=" + this.indexSpec + ", indexSpecForIntermediatePersists=" + this.indexSpecForIntermediatePersists + ", basePersistDirectory=" + this.basePersistDirectory + ", maxPendingPersists=" + this.maxPendingPersists + ", forceGuaranteedRollup=" + this.forceGuaranteedRollup + ", reportParseExceptions=" + this.reportParseExceptions + ", pushTimeout=" + this.pushTimeout + ", logParseExceptions=" + this.logParseExceptions + ", maxParseExceptions=" + this.maxParseExceptions + ", maxSavedParseExceptions=" + this.maxSavedParseExceptions + ", segmentWriteOutMediumFactory=" + this.segmentWriteOutMediumFactory + ", awaitSegmentAvailabilityTimeoutMillis=" + this.awaitSegmentAvailabilityTimeoutMillis + '}';
        }
    }

    @JsonTypeName(value="index")
    public static class IndexIOConfig
    implements BatchIOConfig {
        private static final boolean DEFAULT_APPEND_TO_EXISTING = false;
        private final FirehoseFactory firehoseFactory;
        private final InputSource inputSource;
        private final InputFormat inputFormat;
        private final boolean appendToExisting;
        private final boolean dropExisting;

        @JsonCreator
        public IndexIOConfig(@Deprecated @JsonProperty(value="firehose") @Nullable FirehoseFactory firehoseFactory, @JsonProperty(value="inputSource") @Nullable InputSource inputSource, @JsonProperty(value="inputFormat") @Nullable InputFormat inputFormat, @JsonProperty(value="appendToExisting") @Nullable Boolean appendToExisting, @JsonProperty(value="dropExisting") @Nullable Boolean dropExisting) {
            Checks.checkOneNotNullOrEmpty((List)ImmutableList.of((Object)new Property("firehose", (Object)firehoseFactory), (Object)new Property("inputSource", (Object)inputSource)));
            if (firehoseFactory != null && inputFormat != null) {
                throw new IAE("Cannot use firehose and inputFormat together. Try using inputSource instead of firehose.", new Object[0]);
            }
            this.firehoseFactory = firehoseFactory;
            this.inputSource = inputSource;
            this.inputFormat = inputFormat;
            this.appendToExisting = appendToExisting == null ? false : appendToExisting;
            boolean bl = this.dropExisting = dropExisting == null ? false : dropExisting;
            if (this.dropExisting && this.appendToExisting) {
                throw new IAE("Cannot both drop existing segments and append to existing segments. Either dropExisting or appendToExisting should be set to false", new Object[0]);
            }
        }

        @Deprecated
        public IndexIOConfig(FirehoseFactory firehoseFactory, @Nullable Boolean appendToExisting, @Nullable Boolean dropExisting) {
            this(firehoseFactory, null, null, appendToExisting, dropExisting);
        }

        @Nullable
        @JsonProperty(value="firehose")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Deprecated
        public FirehoseFactory getFirehoseFactory() {
            return this.firehoseFactory;
        }

        @Nullable
        @JsonProperty
        public InputSource getInputSource() {
            return this.inputSource;
        }

        @Nullable
        @JsonProperty
        public InputFormat getInputFormat() {
            return this.inputFormat;
        }

        public InputSource getNonNullInputSource(@Nullable InputRowParser inputRowParser) {
            if (this.inputSource == null) {
                return new FirehoseFactoryToInputSourceAdaptor((FiniteFirehoseFactory)this.firehoseFactory, inputRowParser);
            }
            return this.inputSource;
        }

        public InputFormat getNonNullInputFormat() {
            return (InputFormat)Preconditions.checkNotNull((Object)this.inputFormat, (Object)"inputFormat");
        }

        @JsonProperty
        public boolean isAppendToExisting() {
            return this.appendToExisting;
        }

        @JsonProperty
        public boolean isDropExisting() {
            return this.dropExisting;
        }
    }

    public static class IndexIngestionSpec
    extends IngestionSpec<IndexIOConfig, IndexTuningConfig> {
        private final DataSchema dataSchema;
        private final IndexIOConfig ioConfig;
        private final IndexTuningConfig tuningConfig;

        @JsonCreator
        public IndexIngestionSpec(@JsonProperty(value="dataSchema") DataSchema dataSchema, @JsonProperty(value="ioConfig") IndexIOConfig ioConfig, @JsonProperty(value="tuningConfig") IndexTuningConfig tuningConfig) {
            super(dataSchema, (IOConfig)ioConfig, (TuningConfig)tuningConfig);
            if (dataSchema.getParserMap() != null && ioConfig.getInputSource() != null) {
                throw new IAE("Cannot use parser and inputSource together. Try using inputFormat instead of parser.", new Object[0]);
            }
            if (ioConfig.isDropExisting() && dataSchema.getGranularitySpec().inputIntervals().isEmpty()) {
                throw new IAE("GranularitySpec's intervals cannot be empty when setting dropExisting to true.", new Object[0]);
            }
            if (ioConfig.getInputSource() != null && ioConfig.getInputSource().needsFormat()) {
                Checks.checkOneNotNullOrEmpty((List)ImmutableList.of((Object)new Property("parser", (Object)dataSchema.getParserMap()), (Object)new Property("inputFormat", (Object)ioConfig.getInputFormat())));
            }
            this.dataSchema = dataSchema;
            this.ioConfig = ioConfig;
            this.tuningConfig = tuningConfig == null ? new IndexTuningConfig() : tuningConfig;
        }

        @JsonProperty(value="dataSchema")
        public DataSchema getDataSchema() {
            return this.dataSchema;
        }

        @JsonProperty(value="ioConfig")
        public IndexIOConfig getIOConfig() {
            return this.ioConfig;
        }

        @JsonProperty(value="tuningConfig")
        public IndexTuningConfig getTuningConfig() {
            return this.tuningConfig;
        }
    }
}

