/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.druid.indexer.TaskInfo;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.config.TaskStorageConfig;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.EntryExistsException;
import org.apache.druid.metadata.TaskLookup;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class HeapMemoryTaskStorage
implements TaskStorage {
    private final TaskStorageConfig config;
    private final ConcurrentHashMap<String, TaskStuff> tasks = new ConcurrentHashMap();
    @GuardedBy(value="itself")
    private final Multimap<String, TaskLock> taskLocks = HashMultimap.create();
    @GuardedBy(value="itself")
    private final Multimap<String, TaskAction> taskActions = ArrayListMultimap.create();
    private static final Logger log = new Logger(HeapMemoryTaskStorage.class);

    @Inject
    public HeapMemoryTaskStorage(TaskStorageConfig config) {
        this.config = config;
    }

    @Override
    public void insert(Task task, TaskStatus status) throws EntryExistsException {
        Preconditions.checkNotNull((Object)task, (Object)"task");
        Preconditions.checkNotNull((Object)status, (Object)"status");
        Preconditions.checkArgument((boolean)task.getId().equals(status.getId()), (String)"Task/Status ID mismatch[%s/%s]", (Object[])new Object[]{task.getId(), status.getId()});
        TaskStuff newTaskStuff = new TaskStuff(task, status, DateTimes.nowUtc(), task.getDataSource());
        TaskStuff alreadyExisted = this.tasks.putIfAbsent(task.getId(), newTaskStuff);
        if (alreadyExisted != null) {
            throw new EntryExistsException(task.getId());
        }
        log.info("Inserted task %s with status: %s", new Object[]{task.getId(), status});
    }

    @Override
    public Optional<Task> getTask(String taskid) {
        Preconditions.checkNotNull((Object)taskid, (Object)"taskid");
        TaskStuff taskStuff = this.tasks.get(taskid);
        if (taskStuff != null) {
            return Optional.of((Object)taskStuff.getTask());
        }
        return Optional.absent();
    }

    @Override
    public void setStatus(TaskStatus status) {
        Preconditions.checkNotNull((Object)status, (Object)"status");
        String taskid = status.getId();
        log.info("Updating task %s to status: %s", new Object[]{taskid, status});
        TaskStuff updated = this.tasks.computeIfPresent(taskid, (tid, taskStuff) -> {
            Preconditions.checkState((boolean)taskStuff.getStatus().isRunnable(), (String)"Task must be runnable: %s", (Object[])new Object[]{taskid});
            return ((TaskStuff)taskStuff).withStatus(status);
        });
        Preconditions.checkNotNull((Object)updated, (String)"Task ID must already be present: %s", (Object[])new Object[]{taskid});
    }

    @Override
    public Optional<TaskStatus> getStatus(String taskid) {
        Preconditions.checkNotNull((Object)taskid, (Object)"taskid");
        TaskStuff existing = this.tasks.get(taskid);
        if (existing != null) {
            return Optional.of((Object)existing.getStatus());
        }
        return Optional.absent();
    }

    @Override
    @Nullable
    public TaskInfo<Task, TaskStatus> getTaskInfo(String taskId) {
        Preconditions.checkNotNull((Object)taskId, (Object)"taskId");
        TaskStuff taskStuff = this.tasks.get(taskId);
        if (taskStuff != null) {
            return TaskStuff.toTaskInfo(taskStuff);
        }
        return null;
    }

    @Override
    public List<Task> getActiveTasks() {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (TaskStuff taskStuff : this.tasks.values()) {
            if (!taskStuff.getStatus().isRunnable()) continue;
            listBuilder.add((Object)taskStuff.getTask());
        }
        return listBuilder.build();
    }

    @Override
    public List<Task> getActiveTasksByDatasource(String datasource) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (Map.Entry<String, TaskStuff> entry : this.tasks.entrySet()) {
            if (!entry.getValue().getStatus().isRunnable() || !entry.getValue().getDataSource().equals(datasource)) continue;
            listBuilder.add((Object)entry.getValue().getTask());
        }
        return listBuilder.build();
    }

    public List<TaskInfo<Task, TaskStatus>> getActiveTaskInfo(@Nullable String dataSource) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (TaskStuff taskStuff : this.tasks.values()) {
            if (!taskStuff.getStatus().isRunnable() || dataSource != null && !dataSource.equals(taskStuff.getDataSource())) continue;
            listBuilder.add(TaskStuff.toTaskInfo(taskStuff));
        }
        return listBuilder.build();
    }

    public List<TaskInfo<Task, TaskStatus>> getRecentlyCreatedAlreadyFinishedTaskInfo(TaskLookup.CompleteTaskLookup taskLookup, @Nullable String datasource) {
        Ordering createdDateDesc = new Ordering<TaskStuff>(){

            public int compare(TaskStuff a, TaskStuff b) {
                return a.getCreatedDate().compareTo((ReadableInstant)b.getCreatedDate());
            }
        }.reverse();
        return this.getRecentlyCreatedAlreadyFinishedTaskInfoSince(taskLookup.getTasksCreatedPriorTo(), taskLookup.getMaxTaskStatuses(), (Ordering<TaskStuff>)createdDateDesc);
    }

    @Override
    public List<TaskInfo<Task, TaskStatus>> getTaskInfos(Map<TaskLookup.TaskLookupType, TaskLookup> taskLookups, @Nullable String datasource) {
        ArrayList<TaskInfo<Task, TaskStatus>> tasks = new ArrayList<TaskInfo<Task, TaskStatus>>();
        taskLookups.forEach((type, lookup) -> {
            if (type == TaskLookup.TaskLookupType.COMPLETE) {
                TaskLookup.CompleteTaskLookup completeTaskLookup = (TaskLookup.CompleteTaskLookup)lookup;
                tasks.addAll(this.getRecentlyCreatedAlreadyFinishedTaskInfo(completeTaskLookup.hasTaskCreatedTimeFilter() ? completeTaskLookup : completeTaskLookup.withDurationBeforeNow(this.config.getRecentlyFinishedThreshold()), datasource));
            } else {
                tasks.addAll(this.getActiveTaskInfo(datasource));
            }
        });
        return tasks;
    }

    private List<TaskInfo<Task, TaskStatus>> getRecentlyCreatedAlreadyFinishedTaskInfoSince(DateTime start, @Nullable Integer n, Ordering<TaskStuff> createdDateDesc) {
        Stream<TaskStuff> stream = this.tasks.values().stream().filter(taskStuff -> taskStuff.getStatus().isComplete() && taskStuff.getCreatedDate().isAfter((ReadableInstant)start)).sorted((Comparator<TaskStuff>)createdDateDesc);
        if (n != null) {
            stream = stream.limit(n.intValue());
        }
        List list = stream.map(TaskStuff::toTaskInfo).collect(Collectors.toList());
        return Collections.unmodifiableList(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLock(String taskid, TaskLock taskLock) {
        Preconditions.checkNotNull((Object)taskid, (Object)"taskid");
        Preconditions.checkNotNull((Object)taskLock, (Object)"taskLock");
        Multimap<String, TaskLock> multimap = this.taskLocks;
        synchronized (multimap) {
            this.taskLocks.put((Object)taskid, (Object)taskLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceLock(String taskid, TaskLock oldLock, TaskLock newLock) {
        Preconditions.checkNotNull((Object)taskid, (Object)"taskid");
        Preconditions.checkNotNull((Object)oldLock, (Object)"oldLock");
        Preconditions.checkNotNull((Object)newLock, (Object)"newLock");
        Multimap<String, TaskLock> multimap = this.taskLocks;
        synchronized (multimap) {
            if (!this.taskLocks.remove((Object)taskid, (Object)oldLock)) {
                log.warn("taskLock[%s] for replacement is not found for task[%s]", new Object[]{oldLock, taskid});
            }
            this.taskLocks.put((Object)taskid, (Object)newLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLock(String taskid, TaskLock taskLock) {
        Preconditions.checkNotNull((Object)taskLock, (Object)"taskLock");
        Multimap<String, TaskLock> multimap = this.taskLocks;
        synchronized (multimap) {
            this.taskLocks.remove((Object)taskid, (Object)taskLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TaskLock> getLocks(String taskid) {
        Multimap<String, TaskLock> multimap = this.taskLocks;
        synchronized (multimap) {
            return ImmutableList.copyOf((Collection)this.taskLocks.get((Object)taskid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTasksOlderThan(long timestamp) {
        List<String> taskIds = this.tasks.entrySet().stream().filter(entry -> ((TaskStuff)entry.getValue()).getStatus().isComplete() && ((TaskStuff)entry.getValue()).getCreatedDate().isBefore(timestamp)).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
        taskIds.forEach(this.tasks::remove);
        Multimap<String, TaskAction> multimap = this.taskActions;
        synchronized (multimap) {
            taskIds.forEach(arg_0 -> this.taskActions.removeAll(arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public <T> void addAuditLog(Task task, TaskAction<T> taskAction) {
        Multimap<String, TaskAction> multimap = this.taskActions;
        synchronized (multimap) {
            this.taskActions.put((Object)task.getId(), taskAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public List<TaskAction> getAuditLogs(String taskid) {
        Multimap<String, TaskAction> multimap = this.taskActions;
        synchronized (multimap) {
            return ImmutableList.copyOf((Collection)this.taskActions.get((Object)taskid));
        }
    }

    private static class TaskStuff {
        final Task task;
        final TaskStatus status;
        final DateTime createdDate;
        final String dataSource;

        private TaskStuff(Task task, TaskStatus status, DateTime createdDate, String dataSource) {
            Preconditions.checkArgument((boolean)task.getId().equals(status.getId()));
            this.task = (Task)Preconditions.checkNotNull((Object)task, (Object)"task");
            this.status = (TaskStatus)Preconditions.checkNotNull((Object)status, (Object)"status");
            this.createdDate = (DateTime)Preconditions.checkNotNull((Object)createdDate, (Object)"createdDate");
            this.dataSource = (String)Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        }

        public Task getTask() {
            return this.task;
        }

        public TaskStatus getStatus() {
            return this.status;
        }

        public DateTime getCreatedDate() {
            return this.createdDate;
        }

        public String getDataSource() {
            return this.dataSource;
        }

        private TaskStuff withStatus(TaskStatus _status) {
            return new TaskStuff(this.task, _status, this.createdDate, this.dataSource);
        }

        static TaskInfo<Task, TaskStatus> toTaskInfo(TaskStuff taskStuff) {
            return new TaskInfo(taskStuff.getTask().getId(), taskStuff.getCreatedDate(), (Object)taskStuff.getStatus(), taskStuff.getDataSource(), (Object)taskStuff.getTask());
        }
    }
}

