/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.indexer.TaskInfo;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.config.TaskStorageConfig;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.metadata.EntryExistsException;
import org.apache.druid.metadata.MetadataStorageActionHandler;
import org.apache.druid.metadata.MetadataStorageActionHandlerFactory;
import org.apache.druid.metadata.MetadataStorageActionHandlerTypes;
import org.apache.druid.metadata.MetadataStorageConnector;
import org.apache.druid.metadata.TaskLookup;

public class MetadataTaskStorage
implements TaskStorage {
    private static final MetadataStorageActionHandlerTypes<Task, TaskStatus, TaskAction, TaskLock> TASK_TYPES = new MetadataStorageActionHandlerTypes<Task, TaskStatus, TaskAction, TaskLock>(){

        public TypeReference<Task> getEntryType() {
            return new TypeReference<Task>(){};
        }

        public TypeReference<TaskStatus> getStatusType() {
            return new TypeReference<TaskStatus>(){};
        }

        public TypeReference<TaskAction> getLogType() {
            return new TypeReference<TaskAction>(){};
        }

        public TypeReference<TaskLock> getLockType() {
            return new TypeReference<TaskLock>(){};
        }
    };
    private final MetadataStorageConnector metadataStorageConnector;
    private final TaskStorageConfig config;
    private final MetadataStorageActionHandler<Task, TaskStatus, TaskAction, TaskLock> handler;
    private static final EmittingLogger log = new EmittingLogger(MetadataTaskStorage.class);

    @Inject
    public MetadataTaskStorage(MetadataStorageConnector metadataStorageConnector, TaskStorageConfig config, MetadataStorageActionHandlerFactory factory) {
        this.metadataStorageConnector = metadataStorageConnector;
        this.config = config;
        this.handler = factory.create("task", TASK_TYPES);
    }

    @LifecycleStart
    public void start() {
        this.metadataStorageConnector.createTaskTables();
    }

    @LifecycleStop
    public void stop() {
    }

    @Override
    public void insert(Task task, TaskStatus status) throws EntryExistsException {
        Preconditions.checkNotNull((Object)task, (Object)"task");
        Preconditions.checkNotNull((Object)status, (Object)"status");
        Preconditions.checkArgument((boolean)task.getId().equals(status.getId()), (String)"Task/Status ID mismatch[%s/%s]", (Object[])new Object[]{task.getId(), status.getId()});
        log.info("Inserting task %s with status: %s", new Object[]{task.getId(), status});
        try {
            this.handler.insert(task.getId(), DateTimes.nowUtc(), task.getDataSource(), (Object)task, status.isRunnable(), (Object)status);
        }
        catch (Exception e) {
            if (e instanceof EntryExistsException) {
                throw (EntryExistsException)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setStatus(TaskStatus status) {
        Preconditions.checkNotNull((Object)status, (Object)"status");
        log.info("Updating task %s to status: %s", new Object[]{status.getId(), status});
        boolean set = this.handler.setStatus(status.getId(), status.isRunnable(), (Object)status);
        if (!set) {
            throw new ISE("Active task not found: %s", new Object[]{status.getId()});
        }
    }

    @Override
    public Optional<Task> getTask(String taskId) {
        return this.handler.getEntry(taskId);
    }

    @Override
    public Optional<TaskStatus> getStatus(String taskId) {
        return this.handler.getStatus(taskId);
    }

    @Override
    @Nullable
    public TaskInfo<Task, TaskStatus> getTaskInfo(String taskId) {
        return this.handler.getTaskInfo(taskId);
    }

    @Override
    public List<Task> getActiveTasks() {
        return this.handler.getTaskInfos(Collections.singletonMap(TaskLookup.TaskLookupType.ACTIVE, TaskLookup.ActiveTaskLookup.getInstance()), null).stream().filter(taskInfo -> ((TaskStatus)taskInfo.getStatus()).isRunnable() && taskInfo.getTask() != null).map(TaskInfo::getTask).collect(Collectors.toList());
    }

    @Override
    public List<Task> getActiveTasksByDatasource(String datasource) {
        List activeTaskInfos = this.handler.getTaskInfos(Collections.singletonMap(TaskLookup.TaskLookupType.ACTIVE, TaskLookup.ActiveTaskLookup.getInstance()), datasource);
        ImmutableList.Builder tasksBuilder = ImmutableList.builder();
        for (TaskInfo taskInfo : activeTaskInfos) {
            if (!((TaskStatus)taskInfo.getStatus()).isRunnable() || taskInfo.getTask() == null) continue;
            tasksBuilder.add(taskInfo.getTask());
        }
        return tasksBuilder.build();
    }

    @Override
    public List<TaskInfo<Task, TaskStatus>> getTaskInfos(Map<TaskLookup.TaskLookupType, TaskLookup> taskLookups, @Nullable String datasource) {
        HashMap theTaskLookups = Maps.newHashMapWithExpectedSize((int)taskLookups.size());
        for (Map.Entry<TaskLookup.TaskLookupType, TaskLookup> entry : taskLookups.entrySet()) {
            if (entry.getKey() == TaskLookup.TaskLookupType.COMPLETE) {
                TaskLookup.CompleteTaskLookup completeTaskLookup = (TaskLookup.CompleteTaskLookup)entry.getValue();
                theTaskLookups.put(entry.getKey(), completeTaskLookup.hasTaskCreatedTimeFilter() ? completeTaskLookup : completeTaskLookup.withDurationBeforeNow(this.config.getRecentlyFinishedThreshold()));
                continue;
            }
            theTaskLookups.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableList(this.handler.getTaskInfos((Map)theTaskLookups, datasource));
    }

    @Override
    public void addLock(String taskid, TaskLock taskLock) {
        Preconditions.checkNotNull((Object)taskid, (Object)"taskid");
        Preconditions.checkNotNull((Object)taskLock, (Object)"taskLock");
        log.info("Adding lock on interval[%s] version[%s] for task: %s", new Object[]{taskLock.getInterval(), taskLock.getVersion(), taskid});
        this.handler.addLock(taskid, (Object)taskLock);
    }

    @Override
    public void replaceLock(String taskid, TaskLock oldLock, TaskLock newLock) {
        Preconditions.checkNotNull((Object)taskid, (Object)"taskid");
        Preconditions.checkNotNull((Object)oldLock, (Object)"oldLock");
        Preconditions.checkNotNull((Object)newLock, (Object)"newLock");
        log.info("Replacing an existing lock[%s] with a new lock[%s] for task: %s", new Object[]{oldLock, newLock, taskid});
        Long oldLockId = this.handler.getLockId(taskid, (Object)oldLock);
        if (oldLockId == null) {
            throw new ISE("Cannot find an existing lock[%s]", new Object[]{oldLock});
        }
        this.handler.replaceLock(taskid, oldLockId.longValue(), (Object)newLock);
    }

    @Override
    public void removeLock(String taskid, TaskLock taskLockToRemove) {
        Preconditions.checkNotNull((Object)taskid, (Object)"taskid");
        Preconditions.checkNotNull((Object)taskLockToRemove, (Object)"taskLockToRemove");
        Long lockId = this.handler.getLockId(taskid, (Object)taskLockToRemove);
        if (lockId == null) {
            log.warn("Cannot find lock[%s]", new Object[]{taskLockToRemove});
        } else {
            log.info("Deleting TaskLock with id[%d]: %s", new Object[]{lockId, taskLockToRemove});
            this.handler.removeLock(lockId.longValue());
        }
    }

    @Override
    public void removeTasksOlderThan(long timestamp) {
        this.handler.removeTasksOlderThan(timestamp);
    }

    @Override
    public List<TaskLock> getLocks(String taskid) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(this.getLocksWithIds(taskid).entrySet(), (Function)new Function<Map.Entry<Long, TaskLock>, TaskLock>(){

            public TaskLock apply(Map.Entry<Long, TaskLock> e) {
                return e.getValue();
            }
        }));
    }

    @Override
    @Deprecated
    public <T> void addAuditLog(Task task, TaskAction<T> taskAction) {
        Preconditions.checkNotNull(taskAction, (Object)"taskAction");
        log.info("Logging action for task[%s]: %s", new Object[]{task.getId(), taskAction});
        this.handler.addLog(task.getId(), taskAction);
    }

    @Override
    @Deprecated
    public List<TaskAction> getAuditLogs(String taskId) {
        return this.handler.getLogs(taskId);
    }

    private Map<Long, TaskLock> getLocksWithIds(String taskid) {
        return this.handler.getLocks(taskid);
    }
}

