/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.google.common.base.Optional;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.indexer.TaskInfo;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.metadata.EntryExistsException;
import org.apache.druid.metadata.TaskLookup;

public interface TaskStorage {
    public void insert(Task var1, TaskStatus var2) throws EntryExistsException;

    public void setStatus(TaskStatus var1);

    public void addLock(String var1, TaskLock var2);

    public void replaceLock(String var1, TaskLock var2, TaskLock var3);

    public void removeLock(String var1, TaskLock var2);

    public void removeTasksOlderThan(long var1);

    public Optional<Task> getTask(String var1);

    public Optional<TaskStatus> getStatus(String var1);

    @Nullable
    public TaskInfo<Task, TaskStatus> getTaskInfo(String var1);

    @Deprecated
    public <T> void addAuditLog(Task var1, TaskAction<T> var2);

    @Deprecated
    public List<TaskAction> getAuditLogs(String var1);

    public List<Task> getActiveTasks();

    public List<Task> getActiveTasksByDatasource(String var1);

    public List<TaskInfo<Task, TaskStatus>> getTaskInfos(Map<TaskLookup.TaskLookupType, TaskLookup> var1, @Nullable String var2);

    default public List<TaskInfo<Task, TaskStatus>> getTaskInfos(TaskLookup taskLookup, @Nullable String datasource) {
        return this.getTaskInfos(Collections.singletonMap(taskLookup.getType(), taskLookup), datasource);
    }

    public List<TaskLock> getLocks(String var1);
}

