/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.sampler;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;

public class SamplerConfig {
    private static final int DEFAULT_NUM_ROWS = 200;
    private static final int MAX_NUM_ROWS = 5000;
    private static final int DEFAULT_TIMEOUT_MS = 10000;
    private final int numRows;
    private final int timeoutMs;

    @JsonCreator
    public SamplerConfig(@JsonProperty(value="numRows") Integer numRows, @JsonProperty(value="timeoutMs") Integer timeoutMs) {
        this.numRows = numRows != null ? numRows : 200;
        this.timeoutMs = timeoutMs != null ? timeoutMs : 10000;
        Preconditions.checkArgument((this.numRows <= 5000 ? 1 : 0) != 0, (String)"numRows must be <= %s", (Object[])new Object[]{5000});
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getTimeoutMs() {
        return this.timeoutMs;
    }

    public static SamplerConfig empty() {
        return new SamplerConfig(null, null);
    }
}

