/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.appenderator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.druid.indexing.appenderator.ActionBasedUsedSegmentChecker;
import org.apache.druid.indexing.common.actions.RetrieveUsedSegmentsAction;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.overlord.Segments;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class ActionBasedUsedSegmentCheckerTest {
    @Test
    public void testBasic() throws IOException {
        TaskActionClient taskActionClient = (TaskActionClient)EasyMock.createMock(TaskActionClient.class);
        EasyMock.expect((Object)taskActionClient.submit((TaskAction)new RetrieveUsedSegmentsAction("bar", Intervals.of((String)"2002/P1D"), null, Segments.ONLY_VISIBLE))).andReturn((Object)ImmutableList.of((Object)DataSegment.builder().dataSource("bar").interval(Intervals.of((String)"2002/P1D")).shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).version("b").size(0L).build(), (Object)DataSegment.builder().dataSource("bar").interval(Intervals.of((String)"2002/P1D")).shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(1))).version("b").size(0L).build()));
        EasyMock.expect((Object)taskActionClient.submit((TaskAction)new RetrieveUsedSegmentsAction("foo", null, (Collection)ImmutableList.of((Object)Intervals.of((String)"2000/P1D"), (Object)Intervals.of((String)"2001/P1D")), Segments.ONLY_VISIBLE))).andReturn((Object)ImmutableList.of((Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2000/P1D")).shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).version("a").size(0L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2000/P1D")).shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(1))).version("a").size(0L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2001/P1D")).shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(1))).version("b").size(0L).build(), (Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2002/P1D")).shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(1))).version("b").size(0L).build()));
        EasyMock.replay((Object[])new Object[]{taskActionClient});
        ActionBasedUsedSegmentChecker checker = new ActionBasedUsedSegmentChecker(taskActionClient);
        Set segments = checker.findUsedSegments((Set)ImmutableSet.of((Object)new SegmentIdWithShardSpec("foo", Intervals.of((String)"2000/P1D"), "a", (ShardSpec)new LinearShardSpec(Integer.valueOf(1))), (Object)new SegmentIdWithShardSpec("foo", Intervals.of((String)"2001/P1D"), "b", (ShardSpec)new LinearShardSpec(Integer.valueOf(0))), (Object)new SegmentIdWithShardSpec("bar", Intervals.of((String)"2002/P1D"), "b", (ShardSpec)new LinearShardSpec(Integer.valueOf(0)))));
        Assert.assertEquals((Object)ImmutableSet.of((Object)DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2000/P1D")).shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(1))).version("a").size(0L).build(), (Object)DataSegment.builder().dataSource("bar").interval(Intervals.of((String)"2002/P1D")).shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).version("b").size(0L).build()), (Object)segments);
        EasyMock.verify((Object[])new Object[]{taskActionClient});
    }
}

