/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.TimeChunkLock;
import org.apache.druid.indexing.common.actions.LockListAction;
import org.apache.druid.indexing.common.actions.RemoteTaskActionClient;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionHolder;
import org.apache.druid.indexing.common.task.NoopTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.http.client.response.BytesFullResponseHandler;
import org.apache.druid.java.util.http.client.response.BytesFullResponseHolder;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.apache.druid.rpc.HttpResponseException;
import org.apache.druid.rpc.RequestBuilder;
import org.apache.druid.rpc.ServiceClient;
import org.easymock.EasyMock;
import org.jboss.netty.buffer.BigEndianHeapChannelBuffer;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class RemoteTaskActionClientTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private ServiceClient directOverlordClient;
    private final ObjectMapper objectMapper = new DefaultObjectMapper();

    @Before
    public void setUp() {
        this.directOverlordClient = (ServiceClient)EasyMock.createMock(ServiceClient.class);
    }

    @Test
    public void testSubmitSimple() throws Exception {
        HashMap<String, List<TimeChunkLock>> expectedResponse = new HashMap<String, List<TimeChunkLock>>();
        List<TimeChunkLock> expectedLocks = Collections.singletonList(new TimeChunkLock(TaskLockType.SHARED, "groupId", "dataSource", Intervals.of((String)"2019/2020"), "version", 0));
        expectedResponse.put("result", expectedLocks);
        DefaultHttpResponse httpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        BytesFullResponseHolder responseHolder = new BytesFullResponseHolder((HttpResponse)httpResponse);
        responseHolder.addChunk(this.objectMapper.writeValueAsBytes(expectedResponse));
        NoopTask task = NoopTask.create((String)"id", (int)0);
        LockListAction action = new LockListAction();
        EasyMock.expect((Object)this.directOverlordClient.request((RequestBuilder)EasyMock.eq((Object)new RequestBuilder(HttpMethod.POST, "/druid/indexer/v1/action").jsonContent(this.objectMapper, (Object)new TaskActionHolder((Task)task, (TaskAction)action))), (HttpResponseHandler)EasyMock.anyObject(BytesFullResponseHandler.class))).andReturn((Object)responseHolder);
        EasyMock.replay((Object[])new Object[]{this.directOverlordClient});
        RemoteTaskActionClient client = new RemoteTaskActionClient((Task)task, this.directOverlordClient, this.objectMapper);
        List locks = (List)client.submit((TaskAction)action);
        Assert.assertEquals(expectedLocks, (Object)locks);
        EasyMock.verify((Object[])new Object[]{this.directOverlordClient});
    }

    @Test
    public void testSubmitWithIllegalStatusCode() throws Exception {
        HttpResponse response = (HttpResponse)EasyMock.createNiceMock(HttpResponse.class);
        EasyMock.expect((Object)response.getStatus()).andReturn((Object)HttpResponseStatus.BAD_REQUEST).anyTimes();
        EasyMock.expect((Object)response.getContent()).andReturn((Object)new BigEndianHeapChannelBuffer(0));
        EasyMock.replay((Object[])new Object[]{response});
        StringFullResponseHolder responseHolder = new StringFullResponseHolder(response, StandardCharsets.UTF_8).addChunk("testSubmitWithIllegalStatusCode");
        NoopTask task = NoopTask.create((String)"id", (int)0);
        LockListAction action = new LockListAction();
        EasyMock.expect((Object)this.directOverlordClient.request((RequestBuilder)EasyMock.eq((Object)new RequestBuilder(HttpMethod.POST, "/druid/indexer/v1/action").jsonContent(this.objectMapper, (Object)new TaskActionHolder((Task)task, (TaskAction)action))), (HttpResponseHandler)EasyMock.anyObject(BytesFullResponseHandler.class))).andThrow((Throwable)new ExecutionException((Throwable)new HttpResponseException(responseHolder)));
        EasyMock.replay((Object[])new Object[]{this.directOverlordClient});
        RemoteTaskActionClient client = new RemoteTaskActionClient((Task)task, this.directOverlordClient, this.objectMapper);
        this.expectedException.expect(IOException.class);
        this.expectedException.expectMessage("Error with status[400 Bad Request] and message[testSubmitWithIllegalStatusCode]. Check overlord logs for details.");
        client.submit((TaskAction)action);
        EasyMock.verify((Object[])new Object[]{this.directOverlordClient, response});
    }
}

