/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.SegmentLock;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.actions.SegmentAllocateAction;
import org.apache.druid.indexing.common.actions.TaskActionTestKit;
import org.apache.druid.indexing.common.task.NoopTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.HashBasedNumberedPartialShardSpec;
import org.apache.druid.timeline.partition.HashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.LinearPartialShardSpec;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.NumberedPartialShardSpec;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.PartialShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SegmentAllocateActionTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public TaskActionTestKit taskActionTestKit = new TaskActionTestKit();
    private static final String DATA_SOURCE = "none";
    private static final DateTime PARTY_TIME = DateTimes.of((String)"1999");
    private static final DateTime THE_DISTANT_FUTURE = DateTimes.of((String)"3000");
    private final LockGranularity lockGranularity;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{LockGranularity.SEGMENT}, (Object)new Object[]{LockGranularity.TIME_CHUNK});
    }

    public SegmentAllocateActionTest(LockGranularity lockGranularity) {
        this.lockGranularity = lockGranularity;
    }

    @Before
    public void setUp() {
        ServiceEmitter emitter = (ServiceEmitter)EasyMock.createMock(ServiceEmitter.class);
        EmittingLogger.registerEmitter((ServiceEmitter)emitter);
        EasyMock.replay((Object[])new Object[]{emitter});
    }

    @Test
    public void testManySegmentsSameInterval() {
        NoopTask task = NoopTask.create();
        this.taskActionTestKit.getTaskLockbox().add((Task)task);
        SegmentIdWithShardSpec id1 = this.allocate((Task)task, PARTY_TIME, Granularities.NONE, Granularities.HOUR, "s1", null);
        SegmentIdWithShardSpec id2 = this.allocate((Task)task, PARTY_TIME, Granularities.NONE, Granularities.HOUR, "s1", id1.toString());
        SegmentIdWithShardSpec id3 = this.allocate((Task)task, PARTY_TIME, Granularities.NONE, Granularities.HOUR, "s1", id2.toString());
        if (this.lockGranularity == LockGranularity.TIME_CHUNK) {
            TaskLock partyLock = (TaskLock)Iterables.getOnlyElement((Iterable)FluentIterable.from((Iterable)this.taskActionTestKit.getTaskLockbox().findLocksForTask((Task)task)).filter(input -> input.getInterval().contains((ReadableInstant)PARTY_TIME)));
            this.assertSameIdentifier(id1, new SegmentIdWithShardSpec(DATA_SOURCE, Granularities.HOUR.bucket(PARTY_TIME), partyLock.getVersion(), (ShardSpec)new NumberedShardSpec(0, 0)));
            this.assertSameIdentifier(id2, new SegmentIdWithShardSpec(DATA_SOURCE, Granularities.HOUR.bucket(PARTY_TIME), partyLock.getVersion(), (ShardSpec)new NumberedShardSpec(1, 0)));
            this.assertSameIdentifier(id3, new SegmentIdWithShardSpec(DATA_SOURCE, Granularities.HOUR.bucket(PARTY_TIME), partyLock.getVersion(), (ShardSpec)new NumberedShardSpec(2, 0)));
        } else {
            List partyTimeLocks = this.taskActionTestKit.getTaskLockbox().findLocksForTask((Task)task).stream().filter(input -> input.getInterval().contains((ReadableInstant)PARTY_TIME)).collect(Collectors.toList());
            Assert.assertEquals((long)3L, (long)partyTimeLocks.size());
            this.assertSameIdentifier(new SegmentIdWithShardSpec(DATA_SOURCE, Granularities.HOUR.bucket(PARTY_TIME), id1.getVersion(), (ShardSpec)new NumberedShardSpec(0, 0)), id1);
            this.assertSameIdentifier(new SegmentIdWithShardSpec(DATA_SOURCE, Granularities.HOUR.bucket(PARTY_TIME), id1.getVersion(), (ShardSpec)new NumberedShardSpec(1, 0)), id2);
            this.assertSameIdentifier(new SegmentIdWithShardSpec(DATA_SOURCE, Granularities.HOUR.bucket(PARTY_TIME), id1.getVersion(), (ShardSpec)new NumberedShardSpec(2, 0)), id3);
        }
    }

    @Test
    public void testResumeSequence() {
        NoopTask task = NoopTask.create();
        this.taskActionTestKit.getTaskLockbox().add((Task)task);
        HashMap<Integer, SegmentIdWithShardSpec> allocatedPartyTimeIds = new HashMap<Integer, SegmentIdWithShardSpec>();
        HashMap<Integer, SegmentIdWithShardSpec> allocatedFutureIds = new HashMap<Integer, SegmentIdWithShardSpec>();
        SegmentIdWithShardSpec id1 = this.allocate((Task)task, PARTY_TIME, Granularities.NONE, Granularities.HOUR, "s1", null);
        Assert.assertNotNull((Object)id1);
        allocatedPartyTimeIds.put(id1.getShardSpec().getPartitionNum(), id1);
        SegmentIdWithShardSpec id2 = this.allocate((Task)task, THE_DISTANT_FUTURE, Granularities.NONE, Granularities.HOUR, "s1", id1.toString());
        Assert.assertNotNull((Object)id2);
        allocatedFutureIds.put(id2.getShardSpec().getPartitionNum(), id2);
        SegmentIdWithShardSpec id3 = this.allocate((Task)task, PARTY_TIME, Granularities.NONE, Granularities.HOUR, "s1", id2.toString());
        Assert.assertNotNull((Object)id3);
        allocatedPartyTimeIds.put(id3.getShardSpec().getPartitionNum(), id3);
        SegmentIdWithShardSpec id4 = this.allocate((Task)task, PARTY_TIME, Granularities.NONE, Granularities.HOUR, "s1", id1.toString());
        Assert.assertNull((Object)id4);
        SegmentIdWithShardSpec id5 = this.allocate((Task)task, THE_DISTANT_FUTURE, Granularities.NONE, Granularities.HOUR, "s1", id1.toString());
        Assert.assertNotNull((Object)id5);
        allocatedFutureIds.put(id5.getShardSpec().getPartitionNum(), id5);
        SegmentIdWithShardSpec id6 = this.allocate((Task)task, THE_DISTANT_FUTURE, Granularities.NONE, Granularities.MINUTE, "s1", id1.toString());
        Assert.assertNull((Object)id6);
        SegmentIdWithShardSpec id7 = this.allocate((Task)task, THE_DISTANT_FUTURE, Granularities.NONE, Granularities.DAY, "s1", id1.toString());
        Assert.assertNotNull((Object)id7);
        allocatedFutureIds.put(id7.getShardSpec().getPartitionNum(), id7);
        if (this.lockGranularity == LockGranularity.TIME_CHUNK) {
            TaskLock partyLock = (TaskLock)Iterables.getOnlyElement((Iterable)FluentIterable.from((Iterable)this.taskActionTestKit.getTaskLockbox().findLocksForTask((Task)task)).filter((Predicate)new Predicate<TaskLock>(){

                public boolean apply(TaskLock input) {
                    return input.getInterval().contains((ReadableInstant)PARTY_TIME);
                }
            }));
            TaskLock futureLock = (TaskLock)Iterables.getOnlyElement((Iterable)FluentIterable.from((Iterable)this.taskActionTestKit.getTaskLockbox().findLocksForTask((Task)task)).filter((Predicate)new Predicate<TaskLock>(){

                public boolean apply(TaskLock input) {
                    return input.getInterval().contains((ReadableInstant)THE_DISTANT_FUTURE);
                }
            }));
            this.assertSameIdentifier(id1, new SegmentIdWithShardSpec(DATA_SOURCE, Granularities.HOUR.bucket(PARTY_TIME), partyLock.getVersion(), (ShardSpec)new NumberedShardSpec(0, 0)));
            this.assertSameIdentifier(id2, new SegmentIdWithShardSpec(DATA_SOURCE, Granularities.HOUR.bucket(THE_DISTANT_FUTURE), futureLock.getVersion(), (ShardSpec)new NumberedShardSpec(0, 0)));
            this.assertSameIdentifier(id3, new SegmentIdWithShardSpec(DATA_SOURCE, Granularities.HOUR.bucket(PARTY_TIME), partyLock.getVersion(), (ShardSpec)new NumberedShardSpec(1, 0)));
        } else {
            List<TaskLock> partyLocks = this.taskActionTestKit.getTaskLockbox().findLocksForTask((Task)task).stream().filter(input -> input.getInterval().contains((ReadableInstant)PARTY_TIME)).collect(Collectors.toList());
            Assert.assertEquals((long)2L, (long)partyLocks.size());
            HashMap partitionIdToLock = new HashMap();
            partyLocks.forEach(lock -> {
                Assert.assertEquals((Object)LockGranularity.SEGMENT, (Object)lock.getGranularity());
                SegmentLock segmentLock = (SegmentLock)lock;
                partitionIdToLock.put(segmentLock.getPartitionId(), segmentLock);
            });
            for (Map.Entry entry : partitionIdToLock.entrySet()) {
                this.assertSameIdentifier(new SegmentIdWithShardSpec(DATA_SOURCE, Granularities.HOUR.bucket(PARTY_TIME), ((SegmentIdWithShardSpec)allocatedPartyTimeIds.get(entry.getKey())).getVersion(), (ShardSpec)new NumberedShardSpec(((SegmentLock)entry.getValue()).getPartitionId(), 0)), (SegmentIdWithShardSpec)allocatedPartyTimeIds.get(entry.getKey()));
            }
            List<TaskLock> futureLocks = this.taskActionTestKit.getTaskLockbox().findLocksForTask((Task)task).stream().filter(input -> input.getInterval().contains((ReadableInstant)THE_DISTANT_FUTURE)).collect(Collectors.toList());
            Assert.assertEquals((long)1L, (long)futureLocks.size());
            partitionIdToLock.clear();
            futureLocks.forEach(lock -> {
                Assert.assertEquals((Object)LockGranularity.SEGMENT, (Object)lock.getGranularity());
                SegmentLock segmentLock = (SegmentLock)lock;
                partitionIdToLock.put(segmentLock.getPartitionId(), segmentLock);
            });
            for (Map.Entry entry : partitionIdToLock.entrySet()) {
                this.assertSameIdentifier(new SegmentIdWithShardSpec(DATA_SOURCE, Granularities.HOUR.bucket(THE_DISTANT_FUTURE), ((SegmentIdWithShardSpec)allocatedFutureIds.get(entry.getKey())).getVersion(), (ShardSpec)new NumberedShardSpec(((SegmentLock)entry.getValue()).getPartitionId(), 0)), (SegmentIdWithShardSpec)allocatedFutureIds.get(entry.getKey()));
            }
        }
        Assert.assertNull((Object)id4);
        this.assertSameIdentifier(id2, id5);
        Assert.assertNull((Object)id6);
        this.assertSameIdentifier(id2, id7);
    }

    @Test
    public void testMultipleSequences() {
        NoopTask task = NoopTask.create();
        this.taskActionTestKit.getTaskLockbox().add((Task)task);
        SegmentIdWithShardSpec id1 = this.allocate((Task)task, PARTY_TIME, Granularities.NONE, Granularities.HOUR, "s1", null);
        SegmentIdWithShardSpec id2 = this.allocate((Task)task, PARTY_TIME, Granularities.NONE, Granularities.HOUR, "s2", null);
        SegmentIdWithShardSpec id3 = this.allocate((Task)task, PARTY_TIME, Granularities.NONE, Granularities.HOUR, "s1", id1.toString());
        SegmentIdWithShardSpec id4 = this.allocate((Task)task, THE_DISTANT_FUTURE, Granularities.NONE, Granularities.HOUR, "s1", id3.toString());
        SegmentIdWithShardSpec id5 = this.allocate((Task)task, THE_DISTANT_FUTURE, Granularities.NONE, Granularities.HOUR, "s2", id2.toString());
        SegmentIdWithShardSpec id6 = this.allocate((Task)task, PARTY_TIME, Granularities.NONE, Granularities.HOUR, "s1", null);
        if (this.lockGranularity == LockGranularity.TIME_CHUNK) {
            TaskLock partyLock = (TaskLock)Iterables.getOnlyElement((Iterable)FluentIterable.from((Iterable)this.taskActionTestKit.getTaskLockbox().findLocksForTask((Task)task)).filter((Predicate)new Predicate<TaskLock>(){

                public boolean apply(TaskLock input) {
                    return input.getInterval().contains((ReadableInstant)PARTY_TIME);
                }
            }));
            TaskLock futureLock = (TaskLock)Iterables.getOnlyElement((Iterable)FluentIterable.from((Iterable)this.taskActionTestKit.getTaskLockbox().findLocksForTask((Task)task)).filter((Predicate)new Predicate<TaskLock>(){

                public boolean apply(TaskLock input) {
                    return input.getInterval().contains((ReadableInstant)THE_DISTANT_FUTURE);
                }
            }));
            this.assertSameIdentifier(id1, new SegmentIdWithShardSpec(DATA_SOURCE, Granularities.HOUR.bucket(PARTY_TIME), partyLock.getVersion(), (ShardSpec)new NumberedShardSpec(0, 0)));
            this.assertSameIdentifier(id2, new SegmentIdWithShardSpec(DATA_SOURCE, Granularities.HOUR.bucket(PARTY_TIME), partyLock.getVersion(), (ShardSpec)new NumberedShardSpec(1, 0)));
            this.assertSameIdentifier(id3, new SegmentIdWithShardSpec(DATA_SOURCE, Granularities.HOUR.bucket(PARTY_TIME), partyLock.getVersion(), (ShardSpec)new NumberedShardSpec(2, 0)));
            this.assertSameIdentifier(id4, new SegmentIdWithShardSpec(DATA_SOURCE, Granularities.HOUR.bucket(THE_DISTANT_FUTURE), futureLock.getVersion(), (ShardSpec)new NumberedShardSpec(0, 0)));
            this.assertSameIdentifier(id5, new SegmentIdWithShardSpec(DATA_SOURCE, Granularities.HOUR.bucket(THE_DISTANT_FUTURE), futureLock.getVersion(), (ShardSpec)new NumberedShardSpec(1, 0)));
        } else {
            List partyLocks = this.taskActionTestKit.getTaskLockbox().findLocksForTask((Task)task).stream().filter(input -> input.getInterval().contains((ReadableInstant)PARTY_TIME)).collect(Collectors.toList());
            Assert.assertEquals((long)3L, (long)partyLocks.size());
            this.assertSameIdentifier(new SegmentIdWithShardSpec(DATA_SOURCE, Granularities.HOUR.bucket(PARTY_TIME), ((TaskLock)partyLocks.get(0)).getVersion(), (ShardSpec)new NumberedShardSpec(0, 0)), id1);
            this.assertSameIdentifier(new SegmentIdWithShardSpec(DATA_SOURCE, Granularities.HOUR.bucket(PARTY_TIME), ((TaskLock)partyLocks.get(1)).getVersion(), (ShardSpec)new NumberedShardSpec(1, 0)), id2);
            this.assertSameIdentifier(new SegmentIdWithShardSpec(DATA_SOURCE, Granularities.HOUR.bucket(PARTY_TIME), ((TaskLock)partyLocks.get(2)).getVersion(), (ShardSpec)new NumberedShardSpec(2, 0)), id3);
            List futureLocks = this.taskActionTestKit.getTaskLockbox().findLocksForTask((Task)task).stream().filter(input -> input.getInterval().contains((ReadableInstant)THE_DISTANT_FUTURE)).collect(Collectors.toList());
            Assert.assertEquals((long)2L, (long)futureLocks.size());
            this.assertSameIdentifier(new SegmentIdWithShardSpec(DATA_SOURCE, Granularities.HOUR.bucket(THE_DISTANT_FUTURE), ((TaskLock)futureLocks.get(0)).getVersion(), (ShardSpec)new NumberedShardSpec(0, 0)), id4);
            this.assertSameIdentifier(new SegmentIdWithShardSpec(DATA_SOURCE, Granularities.HOUR.bucket(THE_DISTANT_FUTURE), ((TaskLock)futureLocks.get(1)).getVersion(), (ShardSpec)new NumberedShardSpec(1, 0)), id5);
        }
        this.assertSameIdentifier(id1, id6);
    }

    @Test
    public void testAddToExistingLinearShardSpecsSameGranularity() throws Exception {
        NoopTask task = NoopTask.create();
        this.taskActionTestKit.getMetadataStorageCoordinator().announceHistoricalSegments((Set)ImmutableSet.of((Object)DataSegment.builder().dataSource(DATA_SOURCE).interval(Granularities.HOUR.bucket(PARTY_TIME)).version(PARTY_TIME.toString()).shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build(), (Object)DataSegment.builder().dataSource(DATA_SOURCE).interval(Granularities.HOUR.bucket(PARTY_TIME)).version(PARTY_TIME.toString()).shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(1))).size(0L).build()));
        this.taskActionTestKit.getTaskLockbox().add((Task)task);
        SegmentIdWithShardSpec id1 = this.allocate((Task)task, PARTY_TIME, Granularities.NONE, Granularities.HOUR, "s1", null, (PartialShardSpec)LinearPartialShardSpec.instance());
        SegmentIdWithShardSpec id2 = this.allocate((Task)task, PARTY_TIME, Granularities.NONE, Granularities.HOUR, "s1", id1.toString(), (PartialShardSpec)LinearPartialShardSpec.instance());
        this.assertSameIdentifier(new SegmentIdWithShardSpec(DATA_SOURCE, Granularities.HOUR.bucket(PARTY_TIME), PARTY_TIME.toString(), (ShardSpec)new LinearShardSpec(Integer.valueOf(2))), id1);
        this.assertSameIdentifier(new SegmentIdWithShardSpec(DATA_SOURCE, Granularities.HOUR.bucket(PARTY_TIME), PARTY_TIME.toString(), (ShardSpec)new LinearShardSpec(Integer.valueOf(3))), id2);
    }

    @Test
    public void testAddToExistingNumberedShardSpecsSameGranularity() throws Exception {
        NoopTask task = NoopTask.create();
        this.taskActionTestKit.getMetadataStorageCoordinator().announceHistoricalSegments((Set)ImmutableSet.of((Object)DataSegment.builder().dataSource(DATA_SOURCE).interval(Granularities.HOUR.bucket(PARTY_TIME)).version(PARTY_TIME.toString()).shardSpec((ShardSpec)new NumberedShardSpec(0, 2)).size(0L).build(), (Object)DataSegment.builder().dataSource(DATA_SOURCE).interval(Granularities.HOUR.bucket(PARTY_TIME)).version(PARTY_TIME.toString()).shardSpec((ShardSpec)new NumberedShardSpec(1, 2)).size(0L).build()));
        this.taskActionTestKit.getTaskLockbox().add((Task)task);
        SegmentIdWithShardSpec id1 = this.allocate((Task)task, PARTY_TIME, Granularities.NONE, Granularities.HOUR, "s1", null);
        SegmentIdWithShardSpec id2 = this.allocate((Task)task, PARTY_TIME, Granularities.NONE, Granularities.HOUR, "s1", id1.toString());
        this.assertSameIdentifier(new SegmentIdWithShardSpec(DATA_SOURCE, Granularities.HOUR.bucket(PARTY_TIME), PARTY_TIME.toString(), (ShardSpec)new NumberedShardSpec(2, 2)), id1);
        this.assertSameIdentifier(new SegmentIdWithShardSpec(DATA_SOURCE, Granularities.HOUR.bucket(PARTY_TIME), PARTY_TIME.toString(), (ShardSpec)new NumberedShardSpec(3, 2)), id2);
    }

    @Test
    public void testAddToExistingNumberedShardSpecsCoarserPreferredGranularity() throws Exception {
        NoopTask task = NoopTask.create();
        this.taskActionTestKit.getMetadataStorageCoordinator().announceHistoricalSegments((Set)ImmutableSet.of((Object)DataSegment.builder().dataSource(DATA_SOURCE).interval(Granularities.HOUR.bucket(PARTY_TIME)).version(PARTY_TIME.toString()).shardSpec((ShardSpec)new NumberedShardSpec(0, 2)).size(0L).build(), (Object)DataSegment.builder().dataSource(DATA_SOURCE).interval(Granularities.HOUR.bucket(PARTY_TIME)).version(PARTY_TIME.toString()).shardSpec((ShardSpec)new NumberedShardSpec(1, 2)).size(0L).build()));
        this.taskActionTestKit.getTaskLockbox().add((Task)task);
        SegmentIdWithShardSpec id1 = this.allocate((Task)task, PARTY_TIME, Granularities.NONE, Granularities.DAY, "s1", null);
        this.assertSameIdentifier(new SegmentIdWithShardSpec(DATA_SOURCE, Granularities.HOUR.bucket(PARTY_TIME), PARTY_TIME.toString(), (ShardSpec)new NumberedShardSpec(2, 2)), id1);
    }

    @Test
    public void testAddToExistingNumberedShardSpecsFinerPreferredGranularity() throws Exception {
        NoopTask task = NoopTask.create();
        this.taskActionTestKit.getMetadataStorageCoordinator().announceHistoricalSegments((Set)ImmutableSet.of((Object)DataSegment.builder().dataSource(DATA_SOURCE).interval(Granularities.HOUR.bucket(PARTY_TIME)).version(PARTY_TIME.toString()).shardSpec((ShardSpec)new NumberedShardSpec(0, 2)).size(0L).build(), (Object)DataSegment.builder().dataSource(DATA_SOURCE).interval(Granularities.HOUR.bucket(PARTY_TIME)).version(PARTY_TIME.toString()).shardSpec((ShardSpec)new NumberedShardSpec(1, 2)).size(0L).build()));
        this.taskActionTestKit.getTaskLockbox().add((Task)task);
        SegmentIdWithShardSpec id1 = this.allocate((Task)task, PARTY_TIME, Granularities.NONE, Granularities.MINUTE, "s1", null);
        this.assertSameIdentifier(new SegmentIdWithShardSpec(DATA_SOURCE, Granularities.HOUR.bucket(PARTY_TIME), PARTY_TIME.toString(), (ShardSpec)new NumberedShardSpec(2, 2)), id1);
    }

    @Test
    public void testCannotAddToExistingNumberedShardSpecsWithCoarserQueryGranularity() throws Exception {
        NoopTask task = NoopTask.create();
        this.taskActionTestKit.getMetadataStorageCoordinator().announceHistoricalSegments((Set)ImmutableSet.of((Object)DataSegment.builder().dataSource(DATA_SOURCE).interval(Granularities.HOUR.bucket(PARTY_TIME)).version(PARTY_TIME.toString()).shardSpec((ShardSpec)new NumberedShardSpec(0, 2)).size(0L).build(), (Object)DataSegment.builder().dataSource(DATA_SOURCE).interval(Granularities.HOUR.bucket(PARTY_TIME)).version(PARTY_TIME.toString()).shardSpec((ShardSpec)new NumberedShardSpec(1, 2)).size(0L).build()));
        this.taskActionTestKit.getTaskLockbox().add((Task)task);
        SegmentIdWithShardSpec id1 = this.allocate((Task)task, PARTY_TIME, Granularities.DAY, Granularities.DAY, "s1", null);
        Assert.assertNull((Object)id1);
    }

    @Test
    public void testCannotDoAnythingWithSillyQueryGranularity() {
        NoopTask task = NoopTask.create();
        this.taskActionTestKit.getTaskLockbox().add((Task)task);
        SegmentIdWithShardSpec id1 = this.allocate((Task)task, PARTY_TIME, Granularities.DAY, Granularities.HOUR, "s1", null);
        Assert.assertNull((Object)id1);
    }

    @Test
    public void testWithPartialShardSpecAndOvershadowingSegments() throws IOException {
        NoopTask task = NoopTask.create();
        this.taskActionTestKit.getTaskLockbox().add((Task)task);
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        this.taskActionTestKit.getMetadataStorageCoordinator().announceHistoricalSegments((Set)ImmutableSet.of((Object)DataSegment.builder().dataSource(DATA_SOURCE).interval(Granularities.HOUR.bucket(PARTY_TIME)).version(PARTY_TIME.toString()).shardSpec((ShardSpec)new HashBasedNumberedShardSpec(0, 2, Integer.valueOf(0), Integer.valueOf(2), (List)ImmutableList.of((Object)"dim1"), null, (ObjectMapper)objectMapper)).size(0L).build(), (Object)DataSegment.builder().dataSource(DATA_SOURCE).interval(Granularities.HOUR.bucket(PARTY_TIME)).version(PARTY_TIME.toString()).shardSpec((ShardSpec)new HashBasedNumberedShardSpec(1, 2, Integer.valueOf(1), Integer.valueOf(2), (List)ImmutableList.of((Object)"dim1"), null, (ObjectMapper)objectMapper)).size(0L).build()));
        SegmentAllocateAction action = new SegmentAllocateAction(DATA_SOURCE, PARTY_TIME, Granularities.MINUTE, Granularities.HOUR, "seq", null, true, (PartialShardSpec)new HashBasedNumberedPartialShardSpec((List)ImmutableList.of((Object)"dim1"), 1, 2, null), this.lockGranularity, null);
        SegmentIdWithShardSpec segmentIdentifier = action.perform((Task)task, this.taskActionTestKit.getTaskActionToolbox());
        Assert.assertNotNull((Object)segmentIdentifier);
        ShardSpec shardSpec = segmentIdentifier.getShardSpec();
        Assert.assertEquals((long)2L, (long)shardSpec.getPartitionNum());
        Assert.assertTrue((boolean)(shardSpec instanceof HashBasedNumberedShardSpec));
        HashBasedNumberedShardSpec hashBasedNumberedShardSpec = (HashBasedNumberedShardSpec)shardSpec;
        Assert.assertEquals((long)2L, (long)hashBasedNumberedShardSpec.getNumCorePartitions());
        Assert.assertEquals((Object)ImmutableList.of((Object)"dim1"), (Object)hashBasedNumberedShardSpec.getPartitionDimensions());
    }

    @Test
    public void testSameIntervalWithSegmentGranularity() {
        NoopTask task = NoopTask.create();
        this.taskActionTestKit.getTaskLockbox().add((Task)task);
        PeriodGranularity segmentGranularity = new PeriodGranularity(Period.hours((int)1), null, DateTimes.inferTzFromString((String)"Asia/Shanghai"));
        SegmentIdWithShardSpec id1 = this.allocate((Task)task, PARTY_TIME, Granularities.MINUTE, (Granularity)segmentGranularity, "s1", null);
        SegmentIdWithShardSpec id2 = this.allocate((Task)task, PARTY_TIME, Granularities.MINUTE, (Granularity)segmentGranularity, "s2", null);
        Assert.assertNotNull((Object)id1);
        Assert.assertNotNull((Object)id2);
    }

    @Test
    public void testAllocateAllGranularity() {
        NoopTask task = NoopTask.create();
        this.taskActionTestKit.getTaskLockbox().add((Task)task);
        SegmentIdWithShardSpec id1 = this.allocate((Task)task, PARTY_TIME, Granularities.MINUTE, Granularities.ALL, "s1", null);
        SegmentIdWithShardSpec id2 = this.allocate((Task)task, PARTY_TIME, Granularities.MINUTE, Granularities.ALL, "s2", null);
        Assert.assertNotNull((Object)id1);
        Assert.assertNotNull((Object)id2);
        Assert.assertEquals((Object)Intervals.ETERNITY, (Object)id1.getInterval());
        Assert.assertEquals((Object)Intervals.ETERNITY, (Object)id2.getInterval());
    }

    private SegmentIdWithShardSpec allocate(Task task, DateTime timestamp, Granularity queryGranularity, Granularity preferredSegmentGranularity, String sequenceName, String sequencePreviousId) {
        return this.allocate(task, timestamp, queryGranularity, preferredSegmentGranularity, sequenceName, sequencePreviousId, (PartialShardSpec)NumberedPartialShardSpec.instance());
    }

    private SegmentIdWithShardSpec allocate(Task task, DateTime timestamp, Granularity queryGranularity, Granularity preferredSegmentGranularity, String sequenceName, String sequencePreviousId, PartialShardSpec partialShardSpec) {
        SegmentAllocateAction action = new SegmentAllocateAction(DATA_SOURCE, timestamp, queryGranularity, preferredSegmentGranularity, sequenceName, sequencePreviousId, false, partialShardSpec, this.lockGranularity, null);
        return action.perform(task, this.taskActionTestKit.getTaskActionToolbox());
    }

    private void assertSameIdentifier(SegmentIdWithShardSpec expected, SegmentIdWithShardSpec actual) {
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertEquals((long)expected.getShardSpec().getPartitionNum(), (long)actual.getShardSpec().getPartitionNum());
        Assert.assertEquals(expected.getShardSpec().getClass(), actual.getShardSpec().getClass());
        if (expected.getShardSpec().getClass() == NumberedShardSpec.class && actual.getShardSpec().getClass() == NumberedShardSpec.class) {
            Assert.assertEquals((long)expected.getShardSpec().getNumCorePartitions(), (long)actual.getShardSpec().getNumCorePartitions());
        } else if (expected.getShardSpec().getClass() != LinearShardSpec.class || actual.getShardSpec().getClass() == LinearShardSpec.class) {
            // empty if block
        }
    }
}

