/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Suppliers;
import org.apache.druid.indexing.common.TestUtils;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.config.TaskStorageConfig;
import org.apache.druid.indexing.overlord.HeapMemoryTaskStorage;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.TaskLockbox;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.indexing.overlord.supervisor.SupervisorManager;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.metadata.IndexerSQLMetadataStorageCoordinator;
import org.apache.druid.metadata.MetadataStorageConnectorConfig;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.metadata.SegmentsMetadataManagerConfig;
import org.apache.druid.metadata.SqlSegmentsMetadataManager;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.easymock.EasyMock;
import org.joda.time.Period;
import org.junit.rules.ExternalResource;

public class TaskActionTestKit
extends ExternalResource {
    private final MetadataStorageTablesConfig metadataStorageTablesConfig = MetadataStorageTablesConfig.fromBase((String)"druid");
    private TaskStorage taskStorage;
    private TaskLockbox taskLockbox;
    private TestDerbyConnector testDerbyConnector;
    private IndexerMetadataStorageCoordinator metadataStorageCoordinator;
    private SegmentsMetadataManager segmentsMetadataManager;
    private TaskActionToolbox taskActionToolbox;

    public TaskLockbox getTaskLockbox() {
        return this.taskLockbox;
    }

    public IndexerMetadataStorageCoordinator getMetadataStorageCoordinator() {
        return this.metadataStorageCoordinator;
    }

    public SegmentsMetadataManager getSegmentsMetadataManager() {
        return this.segmentsMetadataManager;
    }

    public TaskActionToolbox getTaskActionToolbox() {
        return this.taskActionToolbox;
    }

    public void before() {
        this.taskStorage = new HeapMemoryTaskStorage(new TaskStorageConfig(new Period((Object)"PT24H")));
        this.testDerbyConnector = new TestDerbyConnector(Suppliers.ofInstance((Object)new MetadataStorageConnectorConfig()), Suppliers.ofInstance((Object)this.metadataStorageTablesConfig));
        ObjectMapper objectMapper = new TestUtils().getTestObjectMapper();
        this.metadataStorageCoordinator = new IndexerSQLMetadataStorageCoordinator(objectMapper, this.metadataStorageTablesConfig, (SQLMetadataConnector)this.testDerbyConnector){

            public int getSqlMetadataMaxRetry() {
                return 2;
            }
        };
        this.taskLockbox = new TaskLockbox(this.taskStorage, this.metadataStorageCoordinator);
        this.segmentsMetadataManager = new SqlSegmentsMetadataManager(objectMapper, Suppliers.ofInstance((Object)new SegmentsMetadataManagerConfig()), Suppliers.ofInstance((Object)this.metadataStorageTablesConfig), (SQLMetadataConnector)this.testDerbyConnector);
        this.taskActionToolbox = new TaskActionToolbox(this.taskLockbox, this.taskStorage, this.metadataStorageCoordinator, (ServiceEmitter)new NoopServiceEmitter(), (SupervisorManager)EasyMock.createMock(SupervisorManager.class));
        this.testDerbyConnector.createDataSourceTable();
        this.testDerbyConnector.createPendingSegmentsTable();
        this.testDerbyConnector.createSegmentTable();
        this.testDerbyConnector.createRulesTable();
        this.testDerbyConnector.createConfigTable();
        this.testDerbyConnector.createTaskTables();
        this.testDerbyConnector.createAuditTable();
    }

    public void after() {
        this.testDerbyConnector.tearDown();
        this.taskStorage = null;
        this.taskLockbox = null;
        this.testDerbyConnector = null;
        this.metadataStorageCoordinator = null;
        this.segmentsMetadataManager = null;
        this.taskActionToolbox = null;
    }
}

