/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.data.input.FirehoseFactory;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.NoopFirehoseFactory;
import org.apache.druid.data.input.impl.NoopInputFormat;
import org.apache.druid.data.input.impl.NoopInputSource;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.indexing.common.task.IndexTask;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.granularity.ArbitraryGranularitySpec;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class IndexIngestionSpecTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testParserAndInputFormat() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Cannot use parser and inputSource together. Try using inputFormat instead of parser.");
        IndexTask.IndexIngestionSpec spec = new IndexTask.IndexIngestionSpec(new DataSchema("dataSource", (Map)ImmutableMap.of((Object)"fake", (Object)"parser map"), new AggregatorFactory[0], (GranularitySpec)new ArbitraryGranularitySpec(Granularities.NONE, null), null, null), new IndexTask.IndexIOConfig(null, (InputSource)new NoopInputSource(), (InputFormat)new NoopInputFormat(), null, null), null);
    }

    @Test
    public void testParserAndInputSource() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Cannot use parser and inputSource together.");
        IndexTask.IndexIngestionSpec spec = new IndexTask.IndexIngestionSpec(new DataSchema("dataSource", (Map)ImmutableMap.of((Object)"fake", (Object)"parser map"), new AggregatorFactory[0], (GranularitySpec)new ArbitraryGranularitySpec(Granularities.NONE, null), null, null), new IndexTask.IndexIOConfig(null, (InputSource)new NoopInputSource(), null, null, null), null);
    }

    @Test
    public void testFirehoseAndInputSource() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("At most one of [Property{name='firehose', value=NoopFirehoseFactory{}}, Property{name='inputSource'");
        IndexTask.IndexIngestionSpec spec = new IndexTask.IndexIngestionSpec(new DataSchema("dataSource", new TimestampSpec(null, null, null), DimensionsSpec.EMPTY, new AggregatorFactory[0], (GranularitySpec)new ArbitraryGranularitySpec(Granularities.NONE, null), null), new IndexTask.IndexIOConfig((FirehoseFactory)new NoopFirehoseFactory(), (InputSource)new NoopInputSource(), null, null, null), null);
    }

    @Test
    public void testFirehoseAndInputFormat() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Cannot use firehose and inputFormat together.");
        IndexTask.IndexIngestionSpec spec = new IndexTask.IndexIngestionSpec(new DataSchema("dataSource", new TimestampSpec(null, null, null), DimensionsSpec.EMPTY, new AggregatorFactory[0], (GranularitySpec)new ArbitraryGranularitySpec(Granularities.NONE, null), null), new IndexTask.IndexIOConfig((FirehoseFactory)new NoopFirehoseFactory(), null, (InputFormat)new NoopInputFormat(), null, null), null);
    }
}

