/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.StringTuple;
import org.apache.druid.indexer.partitions.DimensionRangePartitionsSpec;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.LockListAction;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.task.CachingLocalSegmentAllocator;
import org.apache.druid.indexing.common.task.SegmentAllocators;
import org.apache.druid.indexing.common.task.SequenceNameFunction;
import org.apache.druid.indexing.common.task.SupervisorTaskAccessWithNullClient;
import org.apache.druid.indexing.common.task.batch.parallel.SupervisorTaskAccess;
import org.apache.druid.indexing.common.task.batch.partition.CompletePartitionAnalysis;
import org.apache.druid.indexing.common.task.batch.partition.RangePartitionAnalysis;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.druid.segment.realtime.appenderator.SegmentAllocator;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.DimensionRangeBucketShardSpec;
import org.apache.druid.timeline.partition.PartitionBoundaries;
import org.easymock.EasyMock;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class RangePartitionCachingLocalSegmentAllocatorTest {
    private static final String DATASOURCE = "datasource";
    private static final String TASKID = "taskid";
    private static final String SUPERVISOR_TASKID = "supervisor-taskid";
    private static final String PARTITION_DIMENSION = "dimension";
    private static final List<String> PARTITION_DIMENSIONS = Collections.singletonList("dimension");
    private static final Interval INTERVAL_EMPTY = Intervals.utc((long)0L, (long)1000L);
    private static final Interval INTERVAL_SINGLETON = Intervals.utc((long)1000L, (long)2000L);
    private static final Interval INTERVAL_NORMAL = Intervals.utc((long)2000L, (long)3000L);
    private static final Map<Interval, String> INTERVAL_TO_VERSION = ImmutableMap.of((Object)INTERVAL_EMPTY, (Object)"version-empty", (Object)INTERVAL_SINGLETON, (Object)"version-singleton", (Object)INTERVAL_NORMAL, (Object)"version-normal");
    private static final StringTuple PARTITION0 = StringTuple.create((String[])new String[]{"0"});
    private static final StringTuple PARTITION5 = StringTuple.create((String[])new String[]{"5"});
    private static final StringTuple PARTITION9 = StringTuple.create((String[])new String[]{"9"});
    private static final PartitionBoundaries EMPTY_PARTITIONS = new PartitionBoundaries(new StringTuple[0]);
    private static final PartitionBoundaries SINGLETON_PARTITIONS = new PartitionBoundaries(new StringTuple[]{PARTITION0, PARTITION0});
    private static final PartitionBoundaries NORMAL_PARTITIONS = new PartitionBoundaries(new StringTuple[]{PARTITION0, PARTITION5, PARTITION9});
    private static final Map<Interval, PartitionBoundaries> INTERVAL_TO_PARTITIONS = ImmutableMap.of((Object)INTERVAL_EMPTY, (Object)EMPTY_PARTITIONS, (Object)INTERVAL_SINGLETON, (Object)SINGLETON_PARTITIONS, (Object)INTERVAL_NORMAL, (Object)NORMAL_PARTITIONS);
    private SegmentAllocator target;
    private SequenceNameFunction sequenceNameFunction;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setup() throws IOException {
        TaskToolbox toolbox = RangePartitionCachingLocalSegmentAllocatorTest.createToolbox(INTERVAL_TO_VERSION.keySet().stream().map(RangePartitionCachingLocalSegmentAllocatorTest::createTaskLock).collect(Collectors.toList()));
        RangePartitionAnalysis partitionAnalysis = new RangePartitionAnalysis(new DimensionRangePartitionsSpec(null, Integer.valueOf(1), PARTITION_DIMENSIONS, false));
        INTERVAL_TO_PARTITIONS.forEach((arg_0, arg_1) -> ((RangePartitionAnalysis)partitionAnalysis).updateBucket(arg_0, arg_1));
        this.target = SegmentAllocators.forNonLinearPartitioning((TaskToolbox)toolbox, (String)DATASOURCE, (String)TASKID, (GranularitySpec)new UniformGranularitySpec(Granularities.HOUR, Granularities.NONE, (List)ImmutableList.of()), (SupervisorTaskAccess)new SupervisorTaskAccessWithNullClient(SUPERVISOR_TASKID), (CompletePartitionAnalysis)partitionAnalysis);
        this.sequenceNameFunction = ((CachingLocalSegmentAllocator)this.target).getSequenceNameFunction();
    }

    @Test
    public void failsIfAllocateFromEmptyInterval() {
        Interval interval = INTERVAL_EMPTY;
        InputRow row = RangePartitionCachingLocalSegmentAllocatorTest.createInputRow(interval, PARTITION9);
        this.exception.expect(IllegalStateException.class);
        this.exception.expectMessage("Failed to get shardSpec");
        String sequenceName = this.sequenceNameFunction.getSequenceName(interval, row);
        this.allocate(row, sequenceName);
    }

    @Test
    public void allocatesCorrectShardSpecsForSingletonPartitions() {
        Interval interval = INTERVAL_SINGLETON;
        InputRow row = RangePartitionCachingLocalSegmentAllocatorTest.createInputRow(interval, PARTITION9);
        this.testAllocate(row, interval, 0, null);
    }

    @Test
    public void allocatesCorrectShardSpecsForFirstPartition() {
        Interval interval = INTERVAL_NORMAL;
        InputRow row = RangePartitionCachingLocalSegmentAllocatorTest.createInputRow(interval, PARTITION0);
        this.testAllocate(row, interval, 0);
    }

    @Test
    public void allocatesCorrectShardSpecsForLastPartition() {
        Interval interval = INTERVAL_NORMAL;
        InputRow row = RangePartitionCachingLocalSegmentAllocatorTest.createInputRow(interval, PARTITION9);
        int partitionNum = INTERVAL_TO_PARTITIONS.get(interval).size() - 2;
        this.testAllocate(row, interval, partitionNum, null);
    }

    @Test
    public void getSequenceName() {
        Interval interval = INTERVAL_NORMAL;
        InputRow row = RangePartitionCachingLocalSegmentAllocatorTest.createInputRow(interval, PARTITION9);
        String sequenceName = this.sequenceNameFunction.getSequenceName(interval, row);
        String expectedSequenceName = StringUtils.format((String)"%s_%s_%d", (Object[])new Object[]{TASKID, interval, 1});
        Assert.assertEquals((Object)expectedSequenceName, (Object)sequenceName);
    }

    private void testAllocate(InputRow row, Interval interval, int bucketId) {
        StringTuple partitionEnd = RangePartitionCachingLocalSegmentAllocatorTest.getPartitionEnd(interval, bucketId);
        this.testAllocate(row, interval, bucketId, partitionEnd);
    }

    @Nullable
    private static StringTuple getPartitionEnd(Interval interval, int bucketId) {
        PartitionBoundaries partitions = INTERVAL_TO_PARTITIONS.get(interval);
        boolean isLastPartition = bucketId + 1 == partitions.size();
        return isLastPartition ? null : (StringTuple)partitions.get(bucketId + 1);
    }

    private void testAllocate(InputRow row, Interval interval, int bucketId, @Nullable StringTuple partitionEnd) {
        StringTuple partitionStart = RangePartitionCachingLocalSegmentAllocatorTest.getPartitionStart(interval, bucketId);
        this.testAllocate(row, interval, bucketId, partitionStart, partitionEnd);
    }

    @Nullable
    private static StringTuple getPartitionStart(Interval interval, int bucketId) {
        boolean isFirstPartition = bucketId == 0;
        return isFirstPartition ? null : (StringTuple)INTERVAL_TO_PARTITIONS.get(interval).get(bucketId);
    }

    private void testAllocate(InputRow row, Interval interval, int bucketId, @Nullable StringTuple partitionStart, @Nullable StringTuple partitionEnd) {
        String sequenceName = this.sequenceNameFunction.getSequenceName(interval, row);
        SegmentIdWithShardSpec segmentIdWithShardSpec = this.allocate(row, sequenceName);
        Assert.assertEquals((Object)SegmentId.of((String)DATASOURCE, (Interval)interval, (String)INTERVAL_TO_VERSION.get(interval), (int)bucketId), (Object)segmentIdWithShardSpec.asSegmentId());
        DimensionRangeBucketShardSpec shardSpec = (DimensionRangeBucketShardSpec)segmentIdWithShardSpec.getShardSpec();
        Assert.assertEquals(PARTITION_DIMENSIONS, (Object)shardSpec.getDimensions());
        Assert.assertEquals((long)bucketId, (long)shardSpec.getBucketId());
        Assert.assertEquals((Object)partitionStart, (Object)shardSpec.getStart());
        Assert.assertEquals((Object)partitionEnd, (Object)shardSpec.getEnd());
    }

    private SegmentIdWithShardSpec allocate(InputRow row, String sequenceName) {
        try {
            return this.target.allocate(row, sequenceName, null, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static TaskToolbox createToolbox(List<TaskLock> taskLocks) {
        TaskToolbox toolbox = (TaskToolbox)EasyMock.mock(TaskToolbox.class);
        EasyMock.expect((Object)toolbox.getTaskActionClient()).andStubReturn((Object)RangePartitionCachingLocalSegmentAllocatorTest.createTaskActionClient(taskLocks));
        EasyMock.replay((Object[])new Object[]{toolbox});
        return toolbox;
    }

    private static TaskActionClient createTaskActionClient(List<TaskLock> taskLocks) {
        try {
            TaskActionClient taskActionClient = (TaskActionClient)EasyMock.mock(TaskActionClient.class);
            EasyMock.expect((Object)taskActionClient.submit((TaskAction)EasyMock.anyObject(LockListAction.class))).andStubReturn(taskLocks);
            EasyMock.replay((Object[])new Object[]{taskActionClient});
            return taskActionClient;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static TaskLock createTaskLock(Interval interval) {
        TaskLock taskLock = (TaskLock)EasyMock.mock(TaskLock.class);
        EasyMock.expect((Object)taskLock.getInterval()).andStubReturn((Object)interval);
        EasyMock.expect((Object)taskLock.getVersion()).andStubReturn((Object)INTERVAL_TO_VERSION.get(interval));
        EasyMock.replay((Object[])new Object[]{taskLock});
        return taskLock;
    }

    private static InputRow createInputRow(Interval interval, StringTuple dimensionValues) {
        long timestamp = interval.getStartMillis();
        InputRow inputRow = (InputRow)EasyMock.mock(InputRow.class);
        EasyMock.expect((Object)inputRow.getTimestamp()).andStubReturn((Object)DateTimes.utc((long)timestamp));
        EasyMock.expect((Object)inputRow.getTimestampFromEpoch()).andStubReturn((Object)timestamp);
        EasyMock.expect((Object)inputRow.getDimension(PARTITION_DIMENSION)).andStubReturn(Collections.singletonList(dimensionValues.get(0)));
        EasyMock.replay((Object[])new Object[]{inputRow});
        return inputRow;
    }
}

