/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.druid.indexing.common.task.Tasks;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Comparators;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;
import org.junit.Assert;
import org.junit.Test;

public class TasksTest {
    @Test
    public void testComputeCondensedIntervals() {
        TreeSet<Interval> inputIntervals = new TreeSet<Interval>(Comparators.intervalsByStartThenEnd());
        for (int m = 1; m < 13; ++m) {
            int d;
            for (d = 1; d < 10; ++d) {
                inputIntervals.add(TasksTest.getInterval(m, d, m, d + 1));
            }
            for (d = 12; d < 20; ++d) {
                inputIntervals.add(TasksTest.getInterval(m, d, m, d + 1));
            }
            inputIntervals.add(TasksTest.getInterval(m, 22, m, 23));
            for (d = 25; d < 28; ++d) {
                inputIntervals.add(TasksTest.getInterval(m, d, m, d + 1));
            }
            if (m != 1 && m != 3 && m != 5 && m != 7 && m != 8 && m != 10) continue;
            inputIntervals.add(TasksTest.getInterval(m, 31, m + 1, 1));
        }
        inputIntervals.add(Intervals.of((String)"2017-12-31/2018-01-01"));
        SortedSet condensedIntervals = Tasks.computeCondensedIntervals(inputIntervals);
        Iterator condensedIntervalIterator = condensedIntervals.iterator();
        Assert.assertTrue((boolean)condensedIntervalIterator.hasNext());
        Interval condensedInterval = (Interval)condensedIntervalIterator.next();
        TreeSet<Interval> checkedIntervals = new TreeSet<Interval>(Comparators.intervalsByStartThenEnd());
        for (Interval inputInterval : inputIntervals) {
            if (!condensedInterval.contains((ReadableInterval)inputInterval) && condensedIntervalIterator.hasNext()) {
                condensedInterval = (Interval)condensedIntervalIterator.next();
                Assert.assertTrue((boolean)condensedInterval.contains((ReadableInterval)inputInterval));
            }
            checkedIntervals.add(inputInterval);
        }
        Assert.assertFalse((boolean)condensedIntervalIterator.hasNext());
        Assert.assertEquals(inputIntervals, checkedIntervals);
    }

    private static Interval getInterval(int startMonth, int startDay, int endMonth, int endDay) {
        return Intervals.of((String)StringUtils.format((String)"2017-%02d-%02d/2017-%02d-%02d", (Object[])new Object[]{startMonth, startDay, endMonth, endDay}));
    }
}

