/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.indexing.common.task.batch.parallel.DeepStoragePartitionLocation;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTestingFactory;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.timeline.partition.BuildingShardSpec;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DeepStoragePartitionLocationTest {
    private static final ObjectMapper OBJECT_MAPPER = ParallelIndexTestingFactory.createObjectMapper();
    private DeepStoragePartitionLocation target;

    @Before
    public void setup() {
        this.target = new DeepStoragePartitionLocation("subtask-id", ParallelIndexTestingFactory.INTERVAL, (BuildingShardSpec)ParallelIndexTestingFactory.HASH_BASED_NUMBERED_SHARD_SPEC, (Map)ImmutableMap.of((Object)"path", (Object)"/test/path"));
    }

    @Test
    public void serializesDeserializes() {
        TestHelper.testSerializesDeserializes((ObjectMapper)OBJECT_MAPPER, (Object)this.target);
    }

    @Test
    public void hasPartitionIdThatMatchesShardSpec() {
        Assert.assertEquals((long)4L, (long)this.target.getBucketId());
    }

    @Test
    public void testEqualsAndHashCode() {
        EqualsVerifier.forClass(DeepStoragePartitionLocation.class).withNonnullFields(new String[]{"subTaskId", "interval", "shardSpec", "loadSpec"}).usingGetClass().verify();
    }
}

