/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.google.common.collect.ImmutableList;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.impl.CSVParseSpec;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexer.partitions.SingleDimensionPartitionsSpec;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.batch.parallel.AbstractMultiPhaseParallelIndexingTest;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTask;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.incremental.ParseExceptionReport;
import org.apache.druid.segment.incremental.RowIngestionMetersTotals;
import org.joda.time.Interval;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class MultiPhaseParallelIndexingRowStatsTest
extends AbstractMultiPhaseParallelIndexingTest {
    private static final String TIME = "ts";
    private static final String DIM1 = "dim1";
    private static final String DIM2 = "dim2";
    private static final TimestampSpec TIMESTAMP_SPEC = new TimestampSpec("ts", "auto", null);
    private static final DimensionsSpec DIMENSIONS_SPEC = new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Arrays.asList("ts", "dim1", "dim2")));
    private static final ParseSpec PARSE_SPEC = new CSVParseSpec(TIMESTAMP_SPEC, DIMENSIONS_SPEC, null, Arrays.asList("ts", "dim1", "dim2", "val"), false, 0);
    private static final Interval INTERVAL_TO_INDEX = Intervals.of((String)"2017-12/P1M");
    private File inputDir;

    public MultiPhaseParallelIndexingRowStatsTest() {
        super(LockGranularity.SEGMENT, false, 0.2, 0.2);
    }

    @Before
    public void setup() throws IOException {
        Throwable throwable;
        BufferedWriter writer;
        int i;
        this.inputDir = this.temporaryFolder.newFolder("data");
        for (i = 0; i < 10; ++i) {
            writer = Files.newBufferedWriter(new File(this.inputDir, "test_" + i).toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
            throwable = null;
            try {
                for (int j = 0; j < 10; ++j) {
                    writer.write(StringUtils.format((String)"2017-12-%d,%d,%d th test file\n", (Object[])new Object[]{j + 1, i + 10, i}));
                    writer.write(StringUtils.format((String)"2017-12-%d,%d,%d th test file\n", (Object[])new Object[]{j + 2, i + 11, i}));
                }
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (writer != null) {
                    if (throwable != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((Writer)writer).close();
                    }
                }
            }
        }
        for (i = 0; i < 5; ++i) {
            writer = Files.newBufferedWriter(new File(this.inputDir, "filtered_" + i).toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
            throwable = null;
            try {
                writer.write(StringUtils.format((String)"2017-12-%d,%d,%d th test file\n", (Object[])new Object[]{i + 1, i + 10, i}));
                continue;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (writer != null) {
                    if (throwable != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ((Writer)writer).close();
                    }
                }
            }
        }
    }

    @Test
    public void testHashPartitionRowStats() {
        this.testHashPartitionRowStats(2);
    }

    @Test
    @Ignore(value="assumes record rates, to be fixed PR #12852")
    public void testHashPartitionRowStats_concurrentSubTasks_1() {
        this.testHashPartitionRowStats(1);
    }

    private void testHashPartitionRowStats(int maxNumConcurrentSubTasks) {
        Integer numShards = 10;
        ParallelIndexSupervisorTask task = this.createTask(null, null, null, PARSE_SPEC, INTERVAL_TO_INDEX, this.inputDir, "test_*", (PartitionsSpec)new HashedPartitionsSpec(null, numShards, (List)ImmutableList.of((Object)DIM1, (Object)DIM2), null), maxNumConcurrentSubTasks, false, false);
        RowIngestionMetersTotals expectedTotals = new RowIngestionMetersTotals(200L, 0L, 0L, 0L);
        Map<String, Object> expectedReports = maxNumConcurrentSubTasks <= 1 ? this.buildExpectedTaskReportSequential(task.getId(), (List<ParseExceptionReport>)ImmutableList.of(), new RowIngestionMetersTotals(0L, 0L, 0L, 0L), expectedTotals) : this.buildExpectedTaskReportParallel(task.getId(), (List<ParseExceptionReport>)ImmutableList.of(), expectedTotals);
        Map<String, Object> actualReports = this.runTaskAndGetReports((Task)task, TaskState.SUCCESS);
        this.compareTaskReports(expectedReports, actualReports);
    }

    @Test
    public void testRangePartitionRowStats() {
        int targetRowsPerSegment = 20;
        ParallelIndexSupervisorTask task = this.createTask(null, null, null, PARSE_SPEC, INTERVAL_TO_INDEX, this.inputDir, "test_*", (PartitionsSpec)new SingleDimensionPartitionsSpec(Integer.valueOf(20), null, DIM1, false), 10, false, false);
        Map<String, Object> expectedReports = this.buildExpectedTaskReportParallel(task.getId(), (List<ParseExceptionReport>)ImmutableList.of(), new RowIngestionMetersTotals(200L, 0L, 0L, 0L));
        Map<String, Object> actualReports = this.runTaskAndGetReports((Task)task, TaskState.SUCCESS);
        this.compareTaskReports(expectedReports, actualReports);
    }
}

