/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.databind.jsontype.NamedType;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.task.IngestionTestBase;
import org.apache.druid.indexing.common.task.NoopTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.batch.parallel.AbstractParallelIndexSupervisorTaskTest;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexPhaseRunner;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.indexing.common.task.batch.parallel.SubTaskReport;
import org.apache.druid.indexing.common.task.batch.parallel.SubTaskSpec;
import org.apache.druid.java.util.common.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ParallelIndexPhaseRunnerTest
extends AbstractParallelIndexSupervisorTaskTest {
    private File inputDir;

    public ParallelIndexPhaseRunnerTest() {
        super(0.2, 0.2);
    }

    @Before
    public void setup() throws IOException {
        Throwable throwable;
        BufferedWriter writer;
        int i;
        this.inputDir = this.temporaryFolder.newFolder("data");
        for (i = 0; i < 5; ++i) {
            writer = Files.newBufferedWriter(new File(this.inputDir, "test_" + i).toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
            throwable = null;
            try {
                writer.write(StringUtils.format((String)"2017-12-%d,%d th test file\n", (Object[])new Object[]{24 + i, i}));
                writer.write(StringUtils.format((String)"2017-12-%d,%d th test file\n", (Object[])new Object[]{25 + i, i}));
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (writer != null) {
                    if (throwable != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((Writer)writer).close();
                    }
                }
            }
        }
        for (i = 0; i < 5; ++i) {
            writer = Files.newBufferedWriter(new File(this.inputDir, "filtered_" + i).toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
            throwable = null;
            try {
                writer.write(StringUtils.format((String)"2017-12-%d,%d th test file\n", (Object[])new Object[]{25 + i, i}));
                continue;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (writer != null) {
                    if (throwable != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ((Writer)writer).close();
                    }
                }
            }
        }
        this.getObjectMapper().registerSubtypes(new NamedType[]{new NamedType(ReportingNoopTask.class, "reporting_noop")});
    }

    @After
    public void tearDown() {
        this.temporaryFolder.delete();
    }

    @Test
    public void testLargeEstimatedNumSplits() throws Exception {
        NoopTask task = NoopTask.create();
        IngestionTestBase.TestLocalTaskActionClient actionClient = this.createActionClient((Task)task);
        TaskToolbox toolbox = this.createTaskToolbox((Task)task, actionClient);
        TestPhaseRunner runner = new TestPhaseRunner(toolbox, "supervisorTaskId", "groupId", AbstractParallelIndexSupervisorTaskTest.DEFAULT_TUNING_CONFIG_FOR_PARALLEL_INDEXING, 10, 12);
        Assert.assertEquals((Object)TaskState.SUCCESS, (Object)runner.run());
    }

    @Test
    public void testSmallEstimatedNumSplits() throws Exception {
        NoopTask task = NoopTask.create();
        IngestionTestBase.TestLocalTaskActionClient actionClient = this.createActionClient((Task)task);
        TaskToolbox toolbox = this.createTaskToolbox((Task)task, actionClient);
        TestPhaseRunner runner = new TestPhaseRunner(toolbox, "supervisorTaskId", "groupId", AbstractParallelIndexSupervisorTaskTest.DEFAULT_TUNING_CONFIG_FOR_PARALLEL_INDEXING, 10, 8);
        Assert.assertEquals((Object)TaskState.SUCCESS, (Object)runner.run());
    }

    private static class ReportingNoopTask
    extends NoopTask {
        private final TestPhaseRunner phaseRunner;

        private ReportingNoopTask(String groupId, TestPhaseRunner phaseRunner) {
            super(null, groupId, null, 10L, 0L, null, null, Collections.singletonMap("disableInject", true));
            this.phaseRunner = phaseRunner;
        }

        public TaskStatus run(TaskToolbox toolbox) throws Exception {
            TaskStatus result = super.run(toolbox);
            this.phaseRunner.collectReport(new EmptySubTaskReport(this.getId()));
            return result;
        }
    }

    private static class EmptySubTaskReport
    implements SubTaskReport {
        private final String taskId;

        private EmptySubTaskReport(String taskId) {
            this.taskId = taskId;
        }

        public String getTaskId() {
            return this.taskId;
        }
    }

    private static class TestSubTaskSpec
    extends SubTaskSpec<ReportingNoopTask> {
        private final TestPhaseRunner phaseRunner;

        private TestSubTaskSpec(String id, String groupId, String supervisorTaskId, Map<String, Object> context, InputSplit inputSplit, TestPhaseRunner phaseRunner) {
            super(id, groupId, supervisorTaskId, context, inputSplit);
            this.phaseRunner = phaseRunner;
        }

        public ReportingNoopTask newSubTask(int numAttempts) {
            return new ReportingNoopTask(this.getGroupId(), this.phaseRunner);
        }
    }

    private static class TestPhaseRunner
    extends ParallelIndexPhaseRunner<ReportingNoopTask, EmptySubTaskReport> {
        private final int actualNumSubTasks;
        private final int estimatedNumSubTasks;

        TestPhaseRunner(TaskToolbox toolbox, String supervisorTaskId, String groupId, ParallelIndexTuningConfig tuningConfig, int actualNumSubTasks, int estimatedNumSubTasks) {
            super(toolbox, supervisorTaskId, groupId, supervisorTaskId, tuningConfig, Collections.emptyMap());
            this.actualNumSubTasks = actualNumSubTasks;
            this.estimatedNumSubTasks = estimatedNumSubTasks;
        }

        Iterator<SubTaskSpec<ReportingNoopTask>> subTaskSpecIterator() {
            return new Iterator<SubTaskSpec<ReportingNoopTask>>(){
                int subTaskCount = 0;

                @Override
                public boolean hasNext() {
                    return this.subTaskCount < actualNumSubTasks;
                }

                @Override
                public SubTaskSpec<ReportingNoopTask> next() {
                    return new TestSubTaskSpec("specId_" + this.subTaskCount++, this.getGroupId(), this.getTaskId(), this.getContext(), new InputSplit(new Object()), this);
                }
            };
        }

        int estimateTotalNumSubTasks() {
            return this.estimatedNumSubTasks;
        }

        public String getName() {
            return "TestPhaseRunner";
        }
    }
}

