/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.tasklogs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.druid.indexing.common.tasklogs.ConsoleLoggingEnforcementConfigurationFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.junit.Assert;
import org.junit.Test;

public class ConsoleLoggingEnforcementTest {
    private static final String ROOT = "ROOT";

    @Test
    public void testConsoleConfiguration() throws IOException {
        String log4jConfiguration = "<Configuration status=\"WARN\">\n  <Appenders>\n    <Console name=\"Console\" target=\"SYSTEM_OUT\">\n      <PatternLayout pattern=\"%m\"/>\n    </Console>\n  </Appenders>\n  <Loggers>\n    <Root level=\"info\">\n      <AppenderRef ref=\"Console\"/>\n    </Root>\n    <Logger level=\"debug\" name=\"org.apache.druid\" additivity=\"false\">\n      <AppenderRef ref=\"Console\"/>\n    </Logger>\n  </Loggers>\n</Configuration>";
        LoggerContext context = this.enforceConsoleLogger(log4jConfiguration);
        this.assertHasOnlyOneConsoleAppender(this.getLogger(context, "name_not_in_config"), Level.INFO);
        this.assertHasOnlyOneConsoleAppender(this.getLogger(context, "org.apache.druid"), Level.DEBUG);
        this.assertHasOnlyOneConsoleAppender(this.getLogger(context, ROOT), Level.INFO);
        PatternLayout layout = (PatternLayout)((Appender)this.getLogger(context, "anything").getAppenders().values().stream().findFirst().get()).getLayout();
        Assert.assertEquals((Object)"%m", (Object)layout.getConversionPattern());
    }

    @Test
    public void testNoConsoleAppender() throws IOException {
        String log4jConfiguration = "<Configuration status=\"WARN\">\n  <Appenders>\n    <RollingRandomAccessFile name=\"FileAppender\" fileName=\"a.log\">\n      <PatternLayout pattern=\"%d{ISO8601} %p [%t] %c - %m%n\"/>\n    </RollingRandomAccessFile>\n  </Appenders>\n  <Loggers>\n    <Root level=\"info\">\n      <AppenderRef ref=\"FileAppender\"/>\n    </Root>\n  </Loggers>\n</Configuration>";
        LoggerContext context = this.enforceConsoleLogger(log4jConfiguration);
        this.assertHasOnlyOneConsoleAppender(this.getLogger(context, "name_not_in_config"), Level.INFO);
        this.assertHasOnlyOneConsoleAppender(this.getLogger(context, ROOT), Level.INFO);
        String defaultPattern = "%d{ISO8601} %p [%t] %c - %m%n";
        PatternLayout layout = (PatternLayout)((Appender)this.getLogger(context, "anything").getAppenders().values().stream().findFirst().get()).getLayout();
        Assert.assertEquals((Object)defaultPattern, (Object)layout.getConversionPattern());
    }

    @Test
    public void testHasConsoleAppenderButNotUsed() throws IOException {
        String log4jConfiguration = "<Configuration status=\"WARN\">\n  <Appenders>\n    <Console name=\"Console\" target=\"SYSTEM_OUT\">\n      <PatternLayout pattern=\"%m\"/>\n    </Console>\n    <RollingRandomAccessFile name=\"FileAppender\" fileName=\"a.log\">\n      <PatternLayout pattern=\"%d{ISO8601} %p [%t] %c - %m%n\"/>\n    </RollingRandomAccessFile>\n  </Appenders>\n  <Loggers>\n    <Root level=\"info\">\n      <AppenderRef ref=\"FileAppender\"/>\n    </Root>\n  </Loggers>\n</Configuration>";
        LoggerContext context = this.enforceConsoleLogger(log4jConfiguration);
        this.assertHasOnlyOneConsoleAppender(this.getLogger(context, "name_not_in_config"), Level.INFO);
        this.assertHasOnlyOneConsoleAppender(this.getLogger(context, ROOT), Level.INFO);
        PatternLayout layout = (PatternLayout)((Appender)this.getLogger(context, "anything").getAppenders().values().stream().findFirst().get()).getLayout();
        Assert.assertEquals((Object)"%m", (Object)layout.getConversionPattern());
    }

    @Test
    public void testMultipleAppender() throws IOException {
        String log4jConfiguration = "<Configuration status=\"WARN\">\n  <Appenders>\n    <Console name=\"Console\" target=\"SYSTEM_OUT\">\n      <PatternLayout pattern=\"%m\"/>\n    </Console>\n    <RollingRandomAccessFile name=\"FileAppender\" fileName=\"a.log\">\n      <PatternLayout pattern=\"%d{ISO8601} %p [%t] %c - %m%n\"/>\n    </RollingRandomAccessFile>\n  </Appenders>\n  <Loggers>\n    <Root level=\"info\">\n      <AppenderRef ref=\"FileAppender\"/>\n      <AppenderRef ref=\"Console\"/>\n    </Root>\n    <Logger level=\"debug\" name=\"org.apache.druid\" additivity=\"false\">\n      <AppenderRef ref=\"FileAppender\"/>\n      <AppenderRef ref=\"Console\"/>\n    </Logger>\n  </Loggers>\n</Configuration>";
        LoggerContext context = this.enforceConsoleLogger(log4jConfiguration);
        this.assertHasOnlyOneConsoleAppender(this.getLogger(context, "name_not_in_config"), Level.INFO);
        this.assertHasOnlyOneConsoleAppender(this.getLogger(context, "org.apache.druid"), Level.DEBUG);
        this.assertHasOnlyOneConsoleAppender(this.getLogger(context, ROOT), Level.INFO);
        PatternLayout layout = (PatternLayout)((Appender)this.getLogger(context, "anything").getAppenders().values().stream().findFirst().get()).getLayout();
        Assert.assertEquals((Object)"%m", (Object)layout.getConversionPattern());
    }

    @Test
    public void testEmptyAppender() throws IOException {
        String log4jConfiguration = "<Configuration status=\"WARN\">\n  <Appenders>\n    <Console name=\"Console\" target=\"SYSTEM_OUT\">\n      <PatternLayout pattern=\"%m\"/>\n    </Console>\n    <RollingRandomAccessFile name=\"FileAppender\" fileName=\"a.log\">\n      <PatternLayout pattern=\"%d{ISO8601} %p [%t] %c - %m%n\"/>\n    </RollingRandomAccessFile>\n  </Appenders>\n  <Loggers>\n    <Root level=\"info\">\n    </Root>\n    <Logger level=\"debug\" name=\"org.apache.druid\" additivity=\"false\">\n      <AppenderRef ref=\"FileAppender\"/>\n      <AppenderRef ref=\"Console\"/>\n    </Logger>\n  </Loggers>\n</Configuration>";
        LoggerContext context = this.enforceConsoleLogger(log4jConfiguration);
        this.assertHasOnlyOneConsoleAppender(this.getLogger(context, "name_not_in_config"), Level.INFO);
        this.assertHasOnlyOneConsoleAppender(this.getLogger(context, "org.apache.druid"), Level.DEBUG);
        this.assertHasOnlyOneConsoleAppender(this.getLogger(context, ROOT), Level.INFO);
        PatternLayout layout = (PatternLayout)((Appender)this.getLogger(context, "anything").getAppenders().values().stream().findFirst().get()).getLayout();
        Assert.assertEquals((Object)"%m", (Object)layout.getConversionPattern());
    }

    private LoggerContext enforceConsoleLogger(String configuration) throws IOException {
        LoggerContext context = new LoggerContext("test");
        ConfigurationSource source = new ConfigurationSource((InputStream)new ByteArrayInputStream(configuration.getBytes(StandardCharsets.UTF_8)));
        context.reconfigure(new ConsoleLoggingEnforcementConfigurationFactory().getConfiguration(context, source));
        return context;
    }

    private void assertHasOnlyOneConsoleAppender(Logger logger, Level level) {
        Assert.assertEquals((long)1L, (long)logger.getAppenders().size());
        Assert.assertEquals(ConsoleAppender.class, ((Appender)logger.getAppenders().values().stream().findFirst().get()).getClass());
        if (level != null) {
            Assert.assertEquals((Object)level, (Object)logger.getLevel());
        }
    }

    private Logger getLogger(LoggerContext context, String name) {
        String key = ROOT.equals(name) ? "" : name;
        return context.getLogger(key);
    }
}

