/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.input;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputSourceReader;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.indexing.input.GeneratorInputSource;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.generator.DataGenerator;
import org.apache.druid.segment.generator.GeneratorBasicSchemas;
import org.apache.druid.segment.generator.GeneratorColumnSchema;
import org.apache.druid.segment.generator.GeneratorSchemaInfo;
import org.junit.Assert;
import org.junit.Test;

public class GeneratorInputSourceTest {
    private static final ObjectMapper MAPPER = new DefaultObjectMapper();

    @Test
    public void testSerde() throws JsonProcessingException {
        GeneratorInputSource inputSource = new GeneratorInputSource("basic", null, Integer.valueOf(1000), Integer.valueOf(2), Long.valueOf(1024L), Long.valueOf(DateTimes.nowUtc().getMillis()), Integer.valueOf(1000), Double.valueOf(1.0));
        String serialized = MAPPER.writeValueAsString((Object)inputSource);
        GeneratorInputSource sauce = (GeneratorInputSource)MAPPER.readValue(serialized, GeneratorInputSource.class);
        Assert.assertEquals((Object)inputSource, (Object)sauce);
    }

    @Test
    public void testSerdeWithSchema() throws JsonProcessingException {
        GeneratorInputSource inputSource = new GeneratorInputSource(null, (List)ImmutableList.of((Object)GeneratorColumnSchema.makeLazyZipf((String)"test", (ValueType)ValueType.LONG, (boolean)false, (int)1, (Double)0.0, (int)0, (int)1000, (Double)1.3)), Integer.valueOf(1000), Integer.valueOf(2), Long.valueOf(1024L), Long.valueOf(DateTimes.nowUtc().getMillis()), Integer.valueOf(1000), Double.valueOf(1.0));
        String serialized = MAPPER.writeValueAsString((Object)inputSource);
        GeneratorInputSource sauce = (GeneratorInputSource)MAPPER.readValue(serialized, GeneratorInputSource.class);
        Assert.assertEquals((Object)inputSource, (Object)sauce);
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(GeneratorInputSource.class).usingGetClass().verify();
    }

    @Test
    public void testReader() throws IOException {
        long seed = 1024L;
        long millis = DateTimes.nowUtc().getMillis();
        int numConsecutiveTimestamps = 1000;
        double timestampIncrement = 1.0;
        int numRows = 1000;
        GeneratorInputSource inputSource = new GeneratorInputSource("basic", null, Integer.valueOf(1000), Integer.valueOf(2), Long.valueOf(1024L), Long.valueOf(millis), Integer.valueOf(1000), Double.valueOf(1.0));
        DataGenerator generator = new DataGenerator(((GeneratorSchemaInfo)GeneratorBasicSchemas.SCHEMA_MAP.get("basic")).getColumnSchemas(), 1024L, millis, 1000, Double.valueOf(1.0));
        InputSourceReader reader = inputSource.fixedFormatReader(null, null);
        CloseableIterator iterator = reader.read();
        InputRow first = (InputRow)iterator.next();
        InputRow generatorFirst = generator.nextRow();
        Assert.assertEquals((Object)generatorFirst, (Object)first);
        Assert.assertTrue((boolean)iterator.hasNext());
        int i = 1;
        while (iterator.hasNext()) {
            iterator.next();
            ++i;
        }
        Assert.assertEquals((long)1000L, (long)i);
    }

    @Test
    public void testSplits() {
        GeneratorInputSource inputSource = new GeneratorInputSource("basic", null, Integer.valueOf(1000), Integer.valueOf(2), Long.valueOf(1024L), Long.valueOf(DateTimes.nowUtc().getMillis()), Integer.valueOf(1000), Double.valueOf(1.0));
        Assert.assertEquals((long)2L, (long)inputSource.estimateNumSplits(null, null));
        Assert.assertEquals((Object)false, (Object)inputSource.needsFormat());
        Assert.assertEquals((long)2L, (long)inputSource.createSplits(null, null).count());
        Assert.assertEquals((Object)new Long(2048L), (Object)((GeneratorInputSource)inputSource.withSplit(new InputSplit((Object)2048L))).getSeed());
    }
}

