/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.apache.druid.indexing.common.task.IndexTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTask;
import org.apache.druid.indexing.overlord.ImmutableWorkerInfo;
import org.apache.druid.indexing.worker.Worker;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ImmutableWorkerInfoTest {
    @Test
    public void testSerde() throws Exception {
        ImmutableWorkerInfo workerInfo = new ImmutableWorkerInfo(new Worker("http", "testWorker", "192.0.0.1", 10, "v1", "_default_worker_category"), 2, (Set)ImmutableSet.of((Object)"grp1", (Object)"grp2"), (Collection)ImmutableSet.of((Object)"task1", (Object)"task2"), DateTimes.of((String)"2015-01-01T01:01:01Z"));
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        ImmutableWorkerInfo serde = (ImmutableWorkerInfo)mapper.readValue(mapper.writeValueAsString((Object)workerInfo), ImmutableWorkerInfo.class);
        Assert.assertEquals((Object)workerInfo, (Object)serde);
    }

    @Test
    public void testEqualsAndSerde() {
        this.assertEqualsAndHashCode(new ImmutableWorkerInfo(new Worker("http", "testWorker", "192.0.0.1", 10, "v1", "_default_worker_category"), 2, (Set)ImmutableSet.of((Object)"grp1", (Object)"grp2"), (Collection)ImmutableSet.of((Object)"task1", (Object)"task2"), DateTimes.of((String)"2015-01-01T01:01:01Z")), new ImmutableWorkerInfo(new Worker("http", "testWorker", "192.0.0.1", 10, "v1", "_default_worker_category"), 2, (Set)ImmutableSet.of((Object)"grp1", (Object)"grp2"), (Collection)ImmutableSet.of((Object)"task1", (Object)"task2"), DateTimes.of((String)"2015-01-01T01:01:01Z")), true);
        this.assertEqualsAndHashCode(new ImmutableWorkerInfo(new Worker("http", "testWorker", "192.0.0.1", 10, "v1", "c1"), 2, (Set)ImmutableSet.of((Object)"grp1", (Object)"grp2"), (Collection)ImmutableSet.of((Object)"task1", (Object)"task2"), DateTimes.of((String)"2015-01-01T01:01:01Z")), new ImmutableWorkerInfo(new Worker("http", "testWorker", "192.0.0.1", 10, "v1", "c2"), 2, (Set)ImmutableSet.of((Object)"grp1", (Object)"grp2"), (Collection)ImmutableSet.of((Object)"task1", (Object)"task2"), DateTimes.of((String)"2015-01-01T01:01:01Z")), false);
        this.assertEqualsAndHashCode(new ImmutableWorkerInfo(new Worker("http", "testWorker1", "192.0.0.1", 10, "v1", "_default_worker_category"), 2, (Set)ImmutableSet.of((Object)"grp1", (Object)"grp2"), (Collection)ImmutableSet.of((Object)"task1", (Object)"task2"), DateTimes.of((String)"2015-01-01T01:01:01Z")), new ImmutableWorkerInfo(new Worker("http", "testWorker2", "192.0.0.1", 10, "v1", "_default_worker_category"), 2, (Set)ImmutableSet.of((Object)"grp1", (Object)"grp2"), (Collection)ImmutableSet.of((Object)"task1", (Object)"task2"), DateTimes.of((String)"2015-01-01T01:01:01Z")), false);
        this.assertEqualsAndHashCode(new ImmutableWorkerInfo(new Worker("http", "testWorker", "192.0.0.1", 10, "v1", "_default_worker_category"), 2, (Set)ImmutableSet.of((Object)"grp3", (Object)"grp2"), (Collection)ImmutableSet.of((Object)"task1", (Object)"task2"), DateTimes.of((String)"2015-01-01T01:01:01Z")), new ImmutableWorkerInfo(new Worker("http", "testWorker", "192.0.0.1", 10, "v1", "_default_worker_category"), 2, (Set)ImmutableSet.of((Object)"grp1", (Object)"grp2"), (Collection)ImmutableSet.of((Object)"task1", (Object)"task2"), DateTimes.of((String)"2015-01-01T01:01:01Z")), false);
        this.assertEqualsAndHashCode(new ImmutableWorkerInfo(new Worker("http", "testWorker1", "192.0.0.1", 10, "v1", "_default_worker_category"), 2, (Set)ImmutableSet.of((Object)"grp1", (Object)"grp2"), (Collection)ImmutableSet.of((Object)"task1", (Object)"task2"), DateTimes.of((String)"2015-01-01T01:01:01Z")), new ImmutableWorkerInfo(new Worker("http", "testWorker2", "192.0.0.1", 10, "v1", "_default_worker_category"), 2, (Set)ImmutableSet.of((Object)"grp1", (Object)"grp2"), (Collection)ImmutableSet.of((Object)"task1", (Object)"task3"), DateTimes.of((String)"2015-01-01T01:01:01Z")), false);
        this.assertEqualsAndHashCode(new ImmutableWorkerInfo(new Worker("http", "testWorker1", "192.0.0.1", 10, "v1", "_default_worker_category"), 3, (Set)ImmutableSet.of((Object)"grp1", (Object)"grp2"), (Collection)ImmutableSet.of((Object)"task1", (Object)"task2"), DateTimes.of((String)"2015-01-01T01:01:01Z")), new ImmutableWorkerInfo(new Worker("http", "testWorker2", "192.0.0.1", 10, "v1", "_default_worker_category"), 2, (Set)ImmutableSet.of((Object)"grp1", (Object)"grp2"), (Collection)ImmutableSet.of((Object)"task1", (Object)"task2"), DateTimes.of((String)"2015-01-01T01:01:01Z")), false);
        this.assertEqualsAndHashCode(new ImmutableWorkerInfo(new Worker("http", "testWorker1", "192.0.0.1", 10, "v1", "_default_worker_category"), 3, (Set)ImmutableSet.of((Object)"grp1", (Object)"grp2"), (Collection)ImmutableSet.of((Object)"task1", (Object)"task2"), DateTimes.of((String)"2015-01-01T01:01:01Z")), new ImmutableWorkerInfo(new Worker("http", "testWorker2", "192.0.0.1", 10, "v1", "_default_worker_category"), 2, (Set)ImmutableSet.of((Object)"grp1", (Object)"grp2"), (Collection)ImmutableSet.of((Object)"task1", (Object)"task2"), DateTimes.of((String)"2015-01-01T01:01:02Z")), false);
        this.assertEqualsAndHashCode(new ImmutableWorkerInfo(new Worker("http", "testWorker1", "192.0.0.1", 10, "v1", "_default_worker_category"), 3, 0, (Set)ImmutableSet.of((Object)"grp1", (Object)"grp2"), (Collection)ImmutableSet.of((Object)"task1", (Object)"task2"), DateTimes.of((String)"2015-01-01T01:01:01Z"), DateTimes.of((String)"2017-07-30")), new ImmutableWorkerInfo(new Worker("http", "testWorker2", "192.0.0.1", 10, "v1", "_default_worker_category"), 2, 0, (Set)ImmutableSet.of((Object)"grp1", (Object)"grp2"), (Collection)ImmutableSet.of((Object)"task1", (Object)"task2"), DateTimes.of((String)"2015-01-01T01:01:02Z"), DateTimes.of((String)"2017-07-31")), false);
    }

    @Test
    public void test_canRunTask() {
        ImmutableWorkerInfo workerInfo = new ImmutableWorkerInfo(new Worker("http", "testWorker2", "192.0.0.1", 10, "v1", "_default_worker_category"), 6, 0, (Set)ImmutableSet.of((Object)"grp1", (Object)"grp2"), (Collection)ImmutableSet.of((Object)"task1", (Object)"task2"), DateTimes.of((String)"2015-01-01T01:01:02Z"));
        TaskResource taskResource0 = (TaskResource)Mockito.mock(TaskResource.class);
        Mockito.when((Object)taskResource0.getRequiredCapacity()).thenReturn((Object)3);
        Task parallelIndexTask = (Task)Mockito.mock(ParallelIndexSupervisorTask.class);
        Mockito.when((Object)parallelIndexTask.getType()).thenReturn((Object)"index_parallel");
        Mockito.when((Object)parallelIndexTask.getTaskResource()).thenReturn((Object)taskResource0);
        Assert.assertTrue((boolean)workerInfo.canRunTask(parallelIndexTask, 0.5));
        Assert.assertFalse((boolean)workerInfo.canRunTask(parallelIndexTask, 0.1));
        TaskResource taskResource1 = (TaskResource)Mockito.mock(TaskResource.class);
        Mockito.when((Object)taskResource1.getRequiredCapacity()).thenReturn((Object)5);
        Task anyOtherTask = (Task)Mockito.mock(IndexTask.class);
        Mockito.when((Object)anyOtherTask.getType()).thenReturn((Object)"index");
        Mockito.when((Object)anyOtherTask.getTaskResource()).thenReturn((Object)taskResource1);
        Assert.assertFalse((boolean)workerInfo.canRunTask(anyOtherTask, 0.5));
        TaskResource taskResource2 = (TaskResource)Mockito.mock(TaskResource.class);
        Mockito.when((Object)taskResource2.getRequiredCapacity()).thenReturn((Object)1);
        Mockito.when((Object)taskResource2.getAvailabilityGroup()).thenReturn((Object)"grp1");
        Task grp1Task = (Task)Mockito.mock(IndexTask.class);
        Mockito.when((Object)grp1Task.getType()).thenReturn((Object)"blah");
        Mockito.when((Object)grp1Task.getTaskResource()).thenReturn((Object)taskResource2);
        Assert.assertFalse((boolean)workerInfo.canRunTask(grp1Task, 0.3));
    }

    private void assertEqualsAndHashCode(ImmutableWorkerInfo o1, ImmutableWorkerInfo o2, boolean shouldMatch) {
        if (shouldMatch) {
            Assert.assertTrue((boolean)o1.equals((Object)o2));
            Assert.assertEquals((long)o1.hashCode(), (long)o2.hashCode());
        } else {
            Assert.assertFalse((boolean)o1.equals((Object)o2));
            Assert.assertNotEquals((long)o1.hashCode(), (long)o2.hashCode());
        }
    }
}

