/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.LockListAction;
import org.apache.druid.indexing.common.actions.LockReleaseAction;
import org.apache.druid.indexing.common.actions.SegmentInsertAction;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.actions.TimeChunkLockAcquireAction;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.AbstractTask;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;
import org.junit.Assert;

public class RealtimeishTask
extends AbstractTask {
    public RealtimeishTask() {
        super("rt1", "rt", new TaskResource("rt1", 1), "foo", null);
    }

    public String getType() {
        return "realtime_test";
    }

    public boolean isReady(TaskActionClient taskActionClient) {
        return true;
    }

    public void stopGracefully(TaskConfig taskConfig) {
    }

    public TaskStatus run(TaskToolbox toolbox) throws Exception {
        Interval interval1 = Intervals.of((String)"2010-01-01T00/PT1H");
        Interval interval2 = Intervals.of((String)"2010-01-01T01/PT1H");
        TaskLock lock1 = (TaskLock)toolbox.getTaskActionClient().submit((TaskAction)new TimeChunkLockAcquireAction(TaskLockType.EXCLUSIVE, interval1, 5000L));
        Assert.assertNotNull((Object)lock1);
        List locks1 = (List)toolbox.getTaskActionClient().submit((TaskAction)new LockListAction());
        Assert.assertEquals((String)"lock1 interval", (Object)interval1, (Object)lock1.getInterval());
        Assert.assertEquals((String)"locks1", (Object)ImmutableList.of((Object)lock1), (Object)locks1);
        TaskLock lock2 = (TaskLock)toolbox.getTaskActionClient().submit((TaskAction)new TimeChunkLockAcquireAction(TaskLockType.EXCLUSIVE, interval2, 5000L));
        Assert.assertNotNull((Object)lock2);
        List locks2 = (List)toolbox.getTaskActionClient().submit((TaskAction)new LockListAction());
        Assert.assertEquals((String)"lock2 interval", (Object)interval2, (Object)lock2.getInterval());
        Assert.assertEquals((String)"locks2", (Object)ImmutableList.of((Object)lock1, (Object)lock2), (Object)locks2);
        SegmentInsertAction firstSegmentInsertAction = new SegmentInsertAction((Set)ImmutableSet.of((Object)DataSegment.builder().dataSource("foo").interval(interval1).version(lock1.getVersion()).size(0L).build()));
        toolbox.getTaskActionClient().submit((TaskAction)firstSegmentInsertAction);
        toolbox.getTaskActionClient().submit((TaskAction)new LockReleaseAction(interval1));
        List locks3 = (List)toolbox.getTaskActionClient().submit((TaskAction)new LockListAction());
        Assert.assertEquals((String)"locks3", (Object)ImmutableList.of((Object)lock2), (Object)locks3);
        SegmentInsertAction secondSegmentInsertAction = new SegmentInsertAction((Set)ImmutableSet.of((Object)DataSegment.builder().dataSource("foo").interval(interval2).version(lock2.getVersion()).size(0L).build()));
        toolbox.getTaskActionClient().submit((TaskAction)secondSegmentInsertAction);
        toolbox.getTaskActionClient().submit((TaskAction)new LockReleaseAction(interval2));
        List locks4 = (List)toolbox.getTaskActionClient().submit((TaskAction)new LockListAction());
        Assert.assertEquals((String)"locks4", (Object)ImmutableList.of(), (Object)locks4);
        return TaskStatus.success((String)this.getId());
    }
}

