/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.client.indexing.NoopOverlordClient;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.SegmentCacheManagerFactory;
import org.apache.druid.indexing.common.SingleFileTaskReportFileWriter;
import org.apache.druid.indexing.common.TaskReportFileWriter;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.TaskToolboxFactory;
import org.apache.druid.indexing.common.TestUtils;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.actions.TaskActionClientFactory;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.AbstractTask;
import org.apache.druid.indexing.common.task.NoopTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.TestAppenderatorsManager;
import org.apache.druid.indexing.overlord.SingleTaskBackgroundRunner;
import org.apache.druid.indexing.overlord.TaskRunnerListener;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.Druids;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.NoopJoinableFactory;
import org.apache.druid.segment.loading.DataSegmentArchiver;
import org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.druid.segment.loading.DataSegmentMover;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.loading.NoopDataSegmentArchiver;
import org.apache.druid.segment.loading.NoopDataSegmentKiller;
import org.apache.druid.segment.loading.NoopDataSegmentMover;
import org.apache.druid.segment.loading.NoopDataSegmentPusher;
import org.apache.druid.segment.realtime.appenderator.AppenderatorsManager;
import org.apache.druid.segment.realtime.firehose.ChatHandlerProvider;
import org.apache.druid.segment.realtime.firehose.NoopChatHandlerProvider;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.SetAndVerifyContextQueryRunner;
import org.apache.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.druid.server.coordination.NoopDataSegmentAnnouncer;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.server.security.AuthTestUtils;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SingleTaskBackgroundRunnerTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private SingleTaskBackgroundRunner runner;

    @Before
    public void setup() throws IOException {
        TestUtils utils = new TestUtils();
        DruidNode node = new DruidNode("testServer", "testHost", false, Integer.valueOf(1000), null, true, false);
        TaskConfig taskConfig = new TaskConfig(this.temporaryFolder.newFile().toString(), null, null, Integer.valueOf(50000), null, true, null, null, null, false, false, TaskConfig.BATCH_PROCESSING_MODE_DEFAULT.name(), null);
        NoopServiceEmitter emitter = new NoopServiceEmitter();
        EmittingLogger.registerEmitter((ServiceEmitter)emitter);
        TaskToolboxFactory toolboxFactory = new TaskToolboxFactory(taskConfig, null, (TaskActionClientFactory)EasyMock.createMock(TaskActionClientFactory.class), (ServiceEmitter)emitter, (DataSegmentPusher)new NoopDataSegmentPusher(), (DataSegmentKiller)new NoopDataSegmentKiller(), (DataSegmentMover)new NoopDataSegmentMover(), (DataSegmentArchiver)new NoopDataSegmentArchiver(), (DataSegmentAnnouncer)new NoopDataSegmentAnnouncer(), null, null, null, null, (JoinableFactory)NoopJoinableFactory.INSTANCE, null, new SegmentCacheManagerFactory(utils.getTestObjectMapper()), utils.getTestObjectMapper(), utils.getTestIndexIO(), null, null, null, utils.getIndexMergerV9Factory(), null, node, null, null, (TaskReportFileWriter)new SingleFileTaskReportFileWriter(new File("fake")), null, AuthTestUtils.TEST_AUTHORIZER_MAPPER, (ChatHandlerProvider)new NoopChatHandlerProvider(), utils.getRowIngestionMetersFactory(), (AppenderatorsManager)new TestAppenderatorsManager(), (OverlordClient)new NoopOverlordClient(), null, null, null);
        this.runner = new SingleTaskBackgroundRunner(toolboxFactory, taskConfig, (ServiceEmitter)emitter, node, new ServerConfig());
    }

    @After
    public void teardown() {
        this.runner.stop();
    }

    @Test
    public void testRun() throws ExecutionException, InterruptedException {
        Assert.assertEquals((Object)TaskState.SUCCESS, (Object)((TaskStatus)this.runner.run((Task)new NoopTask(null, null, null, 500L, 0L, null, null, null)).get()).getStatusCode());
    }

    @Test
    public void testGetQueryRunner() throws ExecutionException, InterruptedException {
        ((TaskStatus)this.runner.run((Task)new NoopTask(null, null, "foo", 500L, 0L, null, null, null)).get()).getStatusCode();
        QueryRunner queryRunner = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Intervals.ONLY_ETERNITY)).build().getRunner((QuerySegmentWalker)this.runner);
        Assert.assertThat((Object)queryRunner, (Matcher)CoreMatchers.instanceOf(SetAndVerifyContextQueryRunner.class));
    }

    @Test
    public void testStop() throws ExecutionException, InterruptedException, TimeoutException {
        ListenableFuture future = this.runner.run((Task)new NoopTask(null, null, null, Long.MAX_VALUE, 0L, null, null, null));
        this.runner.stop();
        Assert.assertEquals((Object)TaskState.FAILED, (Object)((TaskStatus)future.get(1000L, TimeUnit.MILLISECONDS)).getStatusCode());
    }

    @Test
    public void testStopWithRestorableTask() throws InterruptedException, ExecutionException, TimeoutException {
        BooleanHolder holder = new BooleanHolder();
        ListenableFuture future = this.runner.run((Task)new RestorableTask(holder));
        this.runner.stop();
        Assert.assertEquals((Object)TaskState.SUCCESS, (Object)((TaskStatus)future.get(1000L, TimeUnit.MILLISECONDS)).getStatusCode());
        Assert.assertTrue((boolean)holder.get());
    }

    @Test
    public void testStopRestorableTaskExceptionAfterStop() {
        final AtomicReference statusHolder = new AtomicReference();
        this.runner.registerListener(new TaskRunnerListener(){

            public String getListenerId() {
                return "testStopRestorableTaskExceptionAfterStop";
            }

            public void locationChanged(String taskId, TaskLocation newLocation) {
            }

            public void statusChanged(String taskId, TaskStatus status) {
                statusHolder.set(status);
            }
        }, (Executor)Execs.directExecutor());
        this.runner.run((Task)new RestorableTask(new BooleanHolder()){

            @Override
            public TaskStatus run(TaskToolbox toolbox) {
                throw new Error("task failure test");
            }
        });
        this.runner.stop();
        Assert.assertEquals((Object)TaskState.FAILED, (Object)((TaskStatus)statusHolder.get()).getStatusCode());
        Assert.assertEquals((Object)"Failed to stop gracefully with exception. See task logs for more details.", (Object)((TaskStatus)statusHolder.get()).getErrorMsg());
    }

    @Test
    public void testStopNonRestorableTask() throws InterruptedException {
        final CountDownLatch runLatch = new CountDownLatch(1);
        final AtomicReference statusHolder = new AtomicReference();
        this.runner.registerListener(new TaskRunnerListener(){

            public String getListenerId() {
                return "testStopNonRestorableTask";
            }

            public void locationChanged(String taskId, TaskLocation newLocation) {
            }

            public void statusChanged(String taskId, TaskStatus status) {
                if (status.getStatusCode() == TaskState.RUNNING) {
                    runLatch.countDown();
                } else {
                    statusHolder.set(status);
                }
            }
        }, (Executor)Execs.directExecutor());
        this.runner.run((Task)new NoopTask(null, null, "datasource", 10000L, 0L, null, null, null));
        Assert.assertTrue((boolean)runLatch.await(1L, TimeUnit.SECONDS));
        this.runner.stop();
        Assert.assertEquals((Object)TaskState.FAILED, (Object)((TaskStatus)statusHolder.get()).getStatusCode());
        Assert.assertEquals((Object)"Canceled as task execution process stopped", (Object)((TaskStatus)statusHolder.get()).getErrorMsg());
    }

    private static class BooleanHolder {
        private boolean value;

        private BooleanHolder() {
        }

        void set() {
            this.value = true;
        }

        boolean get() {
            return this.value;
        }
    }

    private static class RestorableTask
    extends AbstractTask {
        private final BooleanHolder gracefullyStopped;

        RestorableTask(BooleanHolder gracefullyStopped) {
            super("testId", "testDataSource", Collections.emptyMap());
            this.gracefullyStopped = gracefullyStopped;
        }

        public String getType() {
            return "restorable";
        }

        public boolean isReady(TaskActionClient taskActionClient) {
            return true;
        }

        public TaskStatus run(TaskToolbox toolbox) {
            return TaskStatus.success((String)this.getId());
        }

        public boolean canRestore() {
            return true;
        }

        public void stopGracefully(TaskConfig taskConfig) {
            this.gracefullyStopped.set();
        }
    }
}

