/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.google.common.base.Optional;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.actions.LocalTaskActionClientFactory;
import org.apache.druid.indexing.common.actions.TaskActionClientFactory;
import org.apache.druid.indexing.common.config.TaskStorageConfig;
import org.apache.druid.indexing.common.task.NoopTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.HeapMemoryTaskStorage;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.RemoteTaskRunner;
import org.apache.druid.indexing.overlord.TaskLockbox;
import org.apache.druid.indexing.overlord.TaskQueue;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.indexing.overlord.config.DefaultTaskConfig;
import org.apache.druid.indexing.overlord.config.TaskLockConfig;
import org.apache.druid.indexing.overlord.config.TaskQueueConfig;
import org.apache.druid.indexing.test.TestIndexerMetadataStorageCoordinator;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.metadata.EntryExistsException;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TaskLockConfigTest {
    private TaskStorage taskStorage;

    @Before
    public void setup() {
        this.taskStorage = new HeapMemoryTaskStorage(new TaskStorageConfig(null));
    }

    @Test
    public void testDefault() throws EntryExistsException {
        TaskQueue taskQueue = this.createTaskQueue(null);
        taskQueue.start();
        NoopTask task = NoopTask.create();
        Assert.assertTrue((boolean)taskQueue.add((Task)task));
        taskQueue.stop();
        Optional optionalTask = this.taskStorage.getTask(task.getId());
        Assert.assertTrue((boolean)optionalTask.isPresent());
        Task fromTaskStorage = (Task)optionalTask.get();
        Assert.assertTrue((boolean)((Boolean)fromTaskStorage.getContextValue("forceTimeChunkLock")));
    }

    @Test
    public void testNotForceTimeChunkLock() throws EntryExistsException {
        TaskQueue taskQueue = this.createTaskQueue(false);
        taskQueue.start();
        NoopTask task = NoopTask.create();
        Assert.assertTrue((boolean)taskQueue.add((Task)task));
        taskQueue.stop();
        Optional optionalTask = this.taskStorage.getTask(task.getId());
        Assert.assertTrue((boolean)optionalTask.isPresent());
        Task fromTaskStorage = (Task)optionalTask.get();
        Assert.assertFalse((boolean)((Boolean)fromTaskStorage.getContextValue("forceTimeChunkLock")));
    }

    @Test
    public void testOverwriteDefault() throws EntryExistsException {
        TaskQueue taskQueue = this.createTaskQueue(null);
        taskQueue.start();
        NoopTask task = NoopTask.create();
        task.addToContext("forceTimeChunkLock", (Object)false);
        Assert.assertTrue((boolean)taskQueue.add((Task)task));
        taskQueue.stop();
        Optional optionalTask = this.taskStorage.getTask(task.getId());
        Assert.assertTrue((boolean)optionalTask.isPresent());
        Task fromTaskStorage = (Task)optionalTask.get();
        Assert.assertFalse((boolean)((Boolean)fromTaskStorage.getContextValue("forceTimeChunkLock")));
    }

    private TaskQueue createTaskQueue(final @Nullable Boolean forceTimeChunkLock) {
        TaskLockConfig lockConfig = forceTimeChunkLock != null ? new TaskLockConfig(){

            public boolean isForceTimeChunkLock() {
                return forceTimeChunkLock;
            }
        } : new TaskLockConfig();
        TaskQueueConfig queueConfig = new TaskQueueConfig(null, null, null, null);
        TaskRunner taskRunner = (TaskRunner)EasyMock.createNiceMock(RemoteTaskRunner.class);
        TaskActionClientFactory actionClientFactory = (TaskActionClientFactory)EasyMock.createNiceMock(LocalTaskActionClientFactory.class);
        TaskLockbox lockbox = new TaskLockbox(this.taskStorage, (IndexerMetadataStorageCoordinator)new TestIndexerMetadataStorageCoordinator());
        NoopServiceEmitter emitter = new NoopServiceEmitter();
        return new TaskQueue(lockConfig, queueConfig, new DefaultTaskConfig(), this.taskStorage, taskRunner, actionClientFactory, lockbox, (ServiceEmitter)emitter);
    }
}

