/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.autoscaling;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.common.guava.DSuppliers;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TestTasks;
import org.apache.druid.indexing.common.task.NoopTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.RemoteTaskRunner;
import org.apache.druid.indexing.overlord.RemoteTaskRunnerWorkItem;
import org.apache.druid.indexing.overlord.WorkerTaskRunner;
import org.apache.druid.indexing.overlord.ZkWorker;
import org.apache.druid.indexing.overlord.autoscaling.AutoScaler;
import org.apache.druid.indexing.overlord.autoscaling.AutoScalingData;
import org.apache.druid.indexing.overlord.autoscaling.Provisioner;
import org.apache.druid.indexing.overlord.autoscaling.ProvisioningSchedulerConfig;
import org.apache.druid.indexing.overlord.autoscaling.ScalingStats;
import org.apache.druid.indexing.overlord.autoscaling.SimpleWorkerProvisioningConfig;
import org.apache.druid.indexing.overlord.autoscaling.SimpleWorkerProvisioningStrategy;
import org.apache.druid.indexing.overlord.setup.DefaultWorkerBehaviorConfig;
import org.apache.druid.indexing.overlord.setup.WorkerBehaviorConfig;
import org.apache.druid.indexing.worker.TaskAnnouncement;
import org.apache.druid.indexing.worker.Worker;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.easymock.EasyMock;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SimpleProvisioningStrategyTest {
    private AutoScaler autoScaler;
    private Task testTask;
    private SimpleWorkerProvisioningStrategy strategy;
    private AtomicReference<WorkerBehaviorConfig> workerConfig;
    private ScheduledExecutorService executorService = Execs.scheduledSingleThreaded((String)"test service");

    @Before
    public void setUp() {
        this.autoScaler = (AutoScaler)EasyMock.createMock(AutoScaler.class);
        this.testTask = TestTasks.immediateSuccess("task1");
        SimpleWorkerProvisioningConfig simpleWorkerProvisioningConfig = new SimpleWorkerProvisioningConfig().setWorkerIdleTimeout(new Period(0L)).setMaxScalingDuration(new Period(1000L)).setNumEventsToTrack(1).setPendingTaskTimeout(new Period(0L)).setWorkerVersion("");
        ProvisioningSchedulerConfig schedulerConfig = new ProvisioningSchedulerConfig();
        this.workerConfig = new AtomicReference<DefaultWorkerBehaviorConfig>(new DefaultWorkerBehaviorConfig(null, this.autoScaler));
        this.strategy = new SimpleWorkerProvisioningStrategy(simpleWorkerProvisioningConfig, DSuppliers.of(this.workerConfig), schedulerConfig, (Supplier)new Supplier<ScheduledExecutorService>(){

            public ScheduledExecutorService get() {
                return SimpleProvisioningStrategyTest.this.executorService;
            }
        });
    }

    @After
    public void tearDown() {
        this.executorService.shutdownNow();
    }

    @Test
    public void testSuccessfulProvision() {
        EasyMock.expect((Object)this.autoScaler.getMinNumWorkers()).andReturn((Object)0);
        EasyMock.expect((Object)this.autoScaler.getMaxNumWorkers()).andReturn((Object)2);
        EasyMock.expect((Object)this.autoScaler.ipToIdLookup((List)EasyMock.anyObject())).andReturn(new ArrayList());
        EasyMock.expect((Object)this.autoScaler.provision()).andReturn((Object)new AutoScalingData(Collections.singletonList("aNode")));
        RemoteTaskRunner runner = (RemoteTaskRunner)EasyMock.createMock(RemoteTaskRunner.class);
        EasyMock.expect((Object)runner.getPendingTasks()).andReturn(Collections.singletonList(new RemoteTaskRunnerWorkItem(this.testTask.getId(), this.testTask.getType(), null, null, this.testTask.getDataSource()).withQueueInsertionTime(DateTimes.nowUtc())));
        EasyMock.expect((Object)runner.getWorkers()).andReturn(Collections.singletonList(new TestZkWorker(this.testTask).toImmutable()));
        EasyMock.replay((Object[])new Object[]{runner});
        EasyMock.replay((Object[])new Object[]{this.autoScaler});
        Provisioner provisioner = this.strategy.makeProvisioner((WorkerTaskRunner)runner);
        boolean provisionedSomething = provisioner.doProvision();
        Assert.assertTrue((boolean)provisionedSomething);
        Assert.assertTrue((provisioner.getStats().toList().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((ScalingStats.ScalingEvent)provisioner.getStats().toList().get(0)).getEvent() == ScalingStats.EVENT.PROVISION ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.autoScaler});
        EasyMock.verify((Object[])new Object[]{runner});
    }

    @Test
    public void testSomethingProvisioning() {
        EasyMock.expect((Object)this.autoScaler.getMinNumWorkers()).andReturn((Object)0).times(2);
        EasyMock.expect((Object)this.autoScaler.getMaxNumWorkers()).andReturn((Object)2).times(2);
        EasyMock.expect((Object)this.autoScaler.ipToIdLookup((List)EasyMock.anyObject())).andReturn(new ArrayList()).times(2);
        EasyMock.expect((Object)this.autoScaler.provision()).andReturn((Object)new AutoScalingData(Collections.singletonList("fake")));
        RemoteTaskRunner runner = (RemoteTaskRunner)EasyMock.createMock(RemoteTaskRunner.class);
        EasyMock.expect((Object)runner.getPendingTasks()).andReturn(Collections.singletonList(new RemoteTaskRunnerWorkItem(this.testTask.getId(), this.testTask.getType(), null, null, this.testTask.getDataSource()).withQueueInsertionTime(DateTimes.nowUtc()))).times(2);
        EasyMock.expect((Object)runner.getWorkers()).andReturn(Collections.singletonList(new TestZkWorker(this.testTask).toImmutable())).times(2);
        EasyMock.replay((Object[])new Object[]{runner});
        EasyMock.replay((Object[])new Object[]{this.autoScaler});
        Provisioner provisioner = this.strategy.makeProvisioner((WorkerTaskRunner)runner);
        boolean provisionedSomething = provisioner.doProvision();
        Assert.assertTrue((boolean)provisionedSomething);
        Assert.assertTrue((provisioner.getStats().toList().size() == 1 ? 1 : 0) != 0);
        DateTime createdTime = ((ScalingStats.ScalingEvent)provisioner.getStats().toList().get(0)).getTimestamp();
        Assert.assertTrue((((ScalingStats.ScalingEvent)provisioner.getStats().toList().get(0)).getEvent() == ScalingStats.EVENT.PROVISION ? 1 : 0) != 0);
        provisionedSomething = provisioner.doProvision();
        Assert.assertFalse((boolean)provisionedSomething);
        Assert.assertTrue((((ScalingStats.ScalingEvent)provisioner.getStats().toList().get(0)).getEvent() == ScalingStats.EVENT.PROVISION ? 1 : 0) != 0);
        DateTime anotherCreatedTime = ((ScalingStats.ScalingEvent)provisioner.getStats().toList().get(0)).getTimestamp();
        Assert.assertTrue((boolean)createdTime.equals((Object)anotherCreatedTime));
        EasyMock.verify((Object[])new Object[]{this.autoScaler});
        EasyMock.verify((Object[])new Object[]{runner});
    }

    @Test
    public void testProvisionAlert() throws Exception {
        ServiceEmitter emitter = (ServiceEmitter)EasyMock.createMock(ServiceEmitter.class);
        EmittingLogger.registerEmitter((ServiceEmitter)emitter);
        emitter.emit((ServiceEventBuilder)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        EasyMock.replay((Object[])new Object[]{emitter});
        EasyMock.expect((Object)this.autoScaler.getMinNumWorkers()).andReturn((Object)0).times(2);
        EasyMock.expect((Object)this.autoScaler.getMaxNumWorkers()).andReturn((Object)2).times(2);
        EasyMock.expect((Object)this.autoScaler.ipToIdLookup((List)EasyMock.anyObject())).andReturn(new ArrayList()).times(2);
        EasyMock.expect((Object)this.autoScaler.terminateWithIds((List)EasyMock.anyObject())).andReturn(null);
        EasyMock.expect((Object)this.autoScaler.provision()).andReturn((Object)new AutoScalingData(Collections.singletonList("fake")));
        EasyMock.replay((Object[])new Object[]{this.autoScaler});
        RemoteTaskRunner runner = (RemoteTaskRunner)EasyMock.createMock(RemoteTaskRunner.class);
        EasyMock.expect((Object)runner.getPendingTasks()).andReturn(Collections.singletonList(new RemoteTaskRunnerWorkItem(this.testTask.getId(), this.testTask.getType(), null, null, this.testTask.getDataSource()).withQueueInsertionTime(DateTimes.nowUtc()))).times(2);
        EasyMock.expect((Object)runner.getWorkers()).andReturn(Collections.singletonList(new TestZkWorker(this.testTask).toImmutable())).times(2);
        EasyMock.replay((Object[])new Object[]{runner});
        Provisioner provisioner = this.strategy.makeProvisioner((WorkerTaskRunner)runner);
        boolean provisionedSomething = provisioner.doProvision();
        Assert.assertTrue((boolean)provisionedSomething);
        Assert.assertTrue((provisioner.getStats().toList().size() == 1 ? 1 : 0) != 0);
        DateTime createdTime = ((ScalingStats.ScalingEvent)provisioner.getStats().toList().get(0)).getTimestamp();
        Assert.assertTrue((((ScalingStats.ScalingEvent)provisioner.getStats().toList().get(0)).getEvent() == ScalingStats.EVENT.PROVISION ? 1 : 0) != 0);
        Thread.sleep(2000L);
        provisionedSomething = provisioner.doProvision();
        Assert.assertFalse((boolean)provisionedSomething);
        Assert.assertTrue((((ScalingStats.ScalingEvent)provisioner.getStats().toList().get(0)).getEvent() == ScalingStats.EVENT.PROVISION ? 1 : 0) != 0);
        DateTime anotherCreatedTime = ((ScalingStats.ScalingEvent)provisioner.getStats().toList().get(0)).getTimestamp();
        Assert.assertTrue((boolean)createdTime.equals((Object)anotherCreatedTime));
        EasyMock.verify((Object[])new Object[]{this.autoScaler});
        EasyMock.verify((Object[])new Object[]{emitter});
        EasyMock.verify((Object[])new Object[]{runner});
    }

    @Test
    public void testDoSuccessfulTerminate() {
        EasyMock.expect((Object)this.autoScaler.getMinNumWorkers()).andReturn((Object)0);
        EasyMock.expect((Object)this.autoScaler.getMaxNumWorkers()).andReturn((Object)1);
        EasyMock.expect((Object)this.autoScaler.ipToIdLookup((List)EasyMock.anyObject())).andReturn(new ArrayList());
        EasyMock.expect((Object)this.autoScaler.terminate((List)EasyMock.anyObject())).andReturn((Object)new AutoScalingData(new ArrayList()));
        EasyMock.replay((Object[])new Object[]{this.autoScaler});
        RemoteTaskRunner runner = (RemoteTaskRunner)EasyMock.createMock(RemoteTaskRunner.class);
        EasyMock.expect((Object)runner.getPendingTasks()).andReturn(Collections.singletonList(new RemoteTaskRunnerWorkItem(this.testTask.getId(), this.testTask.getType(), null, null, this.testTask.getDataSource()).withQueueInsertionTime(DateTimes.nowUtc()))).times(2);
        EasyMock.expect((Object)runner.getWorkers()).andReturn(Collections.singletonList(new TestZkWorker(this.testTask).toImmutable())).times(2);
        EasyMock.expect((Object)runner.markWorkersLazy((Predicate)EasyMock.anyObject(), EasyMock.anyInt())).andReturn(Collections.singletonList(new TestZkWorker(this.testTask).getWorker()));
        EasyMock.expect((Object)runner.getLazyWorkers()).andReturn(new ArrayList());
        EasyMock.replay((Object[])new Object[]{runner});
        Provisioner provisioner = this.strategy.makeProvisioner((WorkerTaskRunner)runner);
        boolean terminatedSomething = provisioner.doTerminate();
        Assert.assertTrue((boolean)terminatedSomething);
        Assert.assertTrue((provisioner.getStats().toList().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((ScalingStats.ScalingEvent)provisioner.getStats().toList().get(0)).getEvent() == ScalingStats.EVENT.TERMINATE ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.autoScaler});
    }

    @Test
    public void testSomethingTerminating() {
        EasyMock.expect((Object)this.autoScaler.getMinNumWorkers()).andReturn((Object)0).times(2);
        EasyMock.expect((Object)this.autoScaler.getMaxNumWorkers()).andReturn((Object)1).times(2);
        EasyMock.expect((Object)this.autoScaler.ipToIdLookup((List)EasyMock.anyObject())).andReturn(Collections.singletonList("ip")).times(2);
        EasyMock.expect((Object)this.autoScaler.terminate((List)EasyMock.anyObject())).andReturn((Object)new AutoScalingData(Collections.singletonList("ip")));
        EasyMock.replay((Object[])new Object[]{this.autoScaler});
        RemoteTaskRunner runner = (RemoteTaskRunner)EasyMock.createMock(RemoteTaskRunner.class);
        EasyMock.expect((Object)runner.getPendingTasks()).andReturn(Collections.singletonList(new RemoteTaskRunnerWorkItem(this.testTask.getId(), this.testTask.getType(), null, null, this.testTask.getDataSource()).withQueueInsertionTime(DateTimes.nowUtc()))).times(2);
        EasyMock.expect((Object)runner.getWorkers()).andReturn(Collections.singletonList(new TestZkWorker(this.testTask).toImmutable())).times(2);
        EasyMock.expect((Object)runner.getLazyWorkers()).andReturn(new ArrayList()).times(2);
        EasyMock.expect((Object)runner.markWorkersLazy((Predicate)EasyMock.anyObject(), EasyMock.anyInt())).andReturn(Collections.singletonList(new TestZkWorker(this.testTask).getWorker()));
        EasyMock.replay((Object[])new Object[]{runner});
        Provisioner provisioner = this.strategy.makeProvisioner((WorkerTaskRunner)runner);
        boolean terminatedSomething = provisioner.doTerminate();
        Assert.assertTrue((boolean)terminatedSomething);
        Assert.assertTrue((provisioner.getStats().toList().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((ScalingStats.ScalingEvent)provisioner.getStats().toList().get(0)).getEvent() == ScalingStats.EVENT.TERMINATE ? 1 : 0) != 0);
        terminatedSomething = provisioner.doTerminate();
        Assert.assertFalse((boolean)terminatedSomething);
        Assert.assertTrue((provisioner.getStats().toList().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((ScalingStats.ScalingEvent)provisioner.getStats().toList().get(0)).getEvent() == ScalingStats.EVENT.TERMINATE ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.autoScaler});
        EasyMock.verify((Object[])new Object[]{runner});
    }

    @Test
    public void testNoActionNeeded() {
        EasyMock.reset((Object[])new Object[]{this.autoScaler});
        EasyMock.expect((Object)this.autoScaler.getMinNumWorkers()).andReturn((Object)0);
        EasyMock.expect((Object)this.autoScaler.getMaxNumWorkers()).andReturn((Object)2);
        EasyMock.expect((Object)this.autoScaler.ipToIdLookup((List)EasyMock.anyObject())).andReturn(Collections.singletonList("ip"));
        EasyMock.replay((Object[])new Object[]{this.autoScaler});
        RemoteTaskRunner runner = (RemoteTaskRunner)EasyMock.createMock(RemoteTaskRunner.class);
        EasyMock.expect((Object)runner.getPendingTasks()).andReturn(Collections.singletonList(new RemoteTaskRunnerWorkItem(this.testTask.getId(), this.testTask.getType(), null, null, this.testTask.getDataSource()).withQueueInsertionTime(DateTimes.nowUtc()))).times(2);
        EasyMock.expect((Object)runner.getWorkers()).andReturn(Arrays.asList(new TestZkWorker((Task)NoopTask.create()).toImmutable(), new TestZkWorker((Task)NoopTask.create()).toImmutable())).times(2);
        EasyMock.expect((Object)runner.getLazyWorkers()).andReturn(new ArrayList());
        EasyMock.expect((Object)runner.markWorkersLazy((Predicate)EasyMock.anyObject(), EasyMock.anyInt())).andReturn(Collections.emptyList());
        EasyMock.replay((Object[])new Object[]{runner});
        Provisioner provisioner = this.strategy.makeProvisioner((WorkerTaskRunner)runner);
        boolean terminatedSomething = provisioner.doTerminate();
        Assert.assertFalse((boolean)terminatedSomething);
        EasyMock.verify((Object[])new Object[]{this.autoScaler});
        EasyMock.reset((Object[])new Object[]{this.autoScaler});
        EasyMock.expect((Object)this.autoScaler.getMinNumWorkers()).andReturn((Object)0);
        EasyMock.expect((Object)this.autoScaler.getMaxNumWorkers()).andReturn((Object)2);
        EasyMock.expect((Object)this.autoScaler.ipToIdLookup((List)EasyMock.anyObject())).andReturn(Collections.singletonList("ip"));
        EasyMock.replay((Object[])new Object[]{this.autoScaler});
        boolean provisionedSomething = provisioner.doProvision();
        Assert.assertFalse((boolean)provisionedSomething);
        EasyMock.verify((Object[])new Object[]{this.autoScaler});
        EasyMock.verify((Object[])new Object[]{runner});
    }

    @Test
    public void testMinCountIncrease() {
        EasyMock.reset((Object[])new Object[]{this.autoScaler});
        EasyMock.expect((Object)this.autoScaler.getMinNumWorkers()).andReturn((Object)0);
        EasyMock.expect((Object)this.autoScaler.getMaxNumWorkers()).andReturn((Object)2);
        EasyMock.expect((Object)this.autoScaler.ipToIdLookup((List)EasyMock.anyObject())).andReturn(Collections.singletonList("ip"));
        EasyMock.replay((Object[])new Object[]{this.autoScaler});
        RemoteTaskRunner runner = (RemoteTaskRunner)EasyMock.createMock(RemoteTaskRunner.class);
        EasyMock.expect((Object)runner.getPendingTasks()).andReturn(Collections.emptyList()).times(3);
        EasyMock.expect((Object)runner.getWorkers()).andReturn(Collections.singletonList(new TestZkWorker((Task)NoopTask.create(), "http", "h1", "i1", "0").toImmutable())).times(3);
        EasyMock.expect((Object)runner.getLazyWorkers()).andReturn(new ArrayList());
        EasyMock.expect((Object)runner.markWorkersLazy((Predicate)EasyMock.anyObject(), EasyMock.anyInt())).andReturn(Collections.emptyList());
        EasyMock.replay((Object[])new Object[]{runner});
        Provisioner provisioner = this.strategy.makeProvisioner((WorkerTaskRunner)runner);
        boolean terminatedSomething = provisioner.doTerminate();
        Assert.assertFalse((boolean)terminatedSomething);
        EasyMock.verify((Object[])new Object[]{this.autoScaler});
        EasyMock.reset((Object[])new Object[]{this.autoScaler});
        EasyMock.expect((Object)this.autoScaler.getMinNumWorkers()).andReturn((Object)0);
        EasyMock.expect((Object)this.autoScaler.getMaxNumWorkers()).andReturn((Object)2);
        EasyMock.expect((Object)this.autoScaler.ipToIdLookup((List)EasyMock.anyObject())).andReturn(Collections.singletonList("ip"));
        EasyMock.replay((Object[])new Object[]{this.autoScaler});
        boolean provisionedSomething = provisioner.doProvision();
        Assert.assertFalse((boolean)provisionedSomething);
        EasyMock.verify((Object[])new Object[]{this.autoScaler});
        EasyMock.reset((Object[])new Object[]{this.autoScaler});
        EasyMock.expect((Object)this.autoScaler.getMinNumWorkers()).andReturn((Object)3);
        EasyMock.expect((Object)this.autoScaler.getMaxNumWorkers()).andReturn((Object)5);
        EasyMock.expect((Object)this.autoScaler.ipToIdLookup((List)EasyMock.anyObject())).andReturn(Collections.singletonList("ip"));
        EasyMock.expect((Object)this.autoScaler.provision()).andReturn((Object)new AutoScalingData(Collections.singletonList("h3")));
        EasyMock.expect((Object)this.autoScaler.provision()).andReturn((Object)new AutoScalingData(Collections.singletonList("h4")));
        EasyMock.replay((Object[])new Object[]{this.autoScaler});
        provisionedSomething = provisioner.doProvision();
        Assert.assertTrue((boolean)provisionedSomething);
        EasyMock.verify((Object[])new Object[]{this.autoScaler});
        EasyMock.verify((Object[])new Object[]{runner});
    }

    @Test
    public void testNullWorkerConfig() {
        this.workerConfig.set(null);
        EasyMock.replay((Object[])new Object[]{this.autoScaler});
        RemoteTaskRunner runner = (RemoteTaskRunner)EasyMock.createMock(RemoteTaskRunner.class);
        EasyMock.expect((Object)runner.getPendingTasks()).andReturn(Collections.singletonList(new RemoteTaskRunnerWorkItem(this.testTask.getId(), this.testTask.getType(), null, null, this.testTask.getDataSource()).withQueueInsertionTime(DateTimes.nowUtc()))).times(2);
        EasyMock.expect((Object)runner.getWorkers()).andReturn(Collections.singletonList(new TestZkWorker(null).toImmutable())).times(1);
        EasyMock.replay((Object[])new Object[]{runner});
        Provisioner provisioner = this.strategy.makeProvisioner((WorkerTaskRunner)runner);
        boolean terminatedSomething = provisioner.doTerminate();
        boolean provisionedSomething = provisioner.doProvision();
        Assert.assertFalse((boolean)terminatedSomething);
        Assert.assertFalse((boolean)provisionedSomething);
        EasyMock.verify((Object[])new Object[]{this.autoScaler});
        EasyMock.verify((Object[])new Object[]{runner});
    }

    private static class TestZkWorker
    extends ZkWorker {
        private final Task testTask;

        public TestZkWorker(Task testTask) {
            this(testTask, "http", "host", "ip", "0");
        }

        public TestZkWorker(Task testTask, String scheme, String host, String ip, String version) {
            super(new Worker(scheme, host, ip, 3, version, "_default_worker_category"), null, (ObjectMapper)new DefaultObjectMapper());
            this.testTask = testTask;
        }

        public Map<String, TaskAnnouncement> getRunningTasks() {
            if (this.testTask == null) {
                return new HashMap<String, TaskAnnouncement>();
            }
            return ImmutableMap.of((Object)this.testTask.getId(), (Object)TaskAnnouncement.create((Task)this.testTask, (TaskStatus)TaskStatus.running((String)this.testTask.getId()), (TaskLocation)TaskLocation.unknown()));
        }
    }
}

