/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.sampler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.druid.client.indexing.SamplerResponse;
import org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Test;

public class SamplerResponseTest {
    private static final ObjectMapper MAPPER = TestHelper.makeJsonMapper();

    @Test
    public void testSerde() throws IOException {
        ImmutableList data = ImmutableList.of((Object)new SamplerResponse.SamplerResponseRow((Map)ImmutableMap.of((Object)"row1", (Object)"val1"), (Map)ImmutableMap.of((Object)"t", (Object)123456, (Object)"dim1", (Object)"foo", (Object)"met1", (Object)6), null, null), (Object)new SamplerResponse.SamplerResponseRow((Map)ImmutableMap.of((Object)"row2", (Object)"val2"), (Map)ImmutableMap.of((Object)"t", (Object)123457, (Object)"dim1", (Object)"foo2", (Object)"met1", (Object)7), null, null), (Object)new SamplerResponse.SamplerResponseRow((Map)ImmutableMap.of((Object)"row3", (Object)"val3"), null, Boolean.valueOf(true), "Could not parse"));
        String out = MAPPER.writeValueAsString((Object)new SamplerResponse(1123, 1112, (List)data));
        String expected = "{\"numRowsRead\":1123,\"numRowsIndexed\":1112,\"data\":[{\"input\":{\"row1\":\"val1\"},\"parsed\":{\"t\":123456,\"dim1\":\"foo\",\"met1\":6}},{\"input\":{\"row2\":\"val2\"},\"parsed\":{\"t\":123457,\"dim1\":\"foo2\",\"met1\":7}},{\"input\":{\"row3\":\"val3\"},\"unparseable\":true,\"error\":\"Could not parse\"}]}";
        Assert.assertEquals((Object)expected, (Object)out);
    }
}

