/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.setup;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Map;
import org.apache.druid.indexing.common.task.NoopTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.ImmutableWorkerInfo;
import org.apache.druid.indexing.overlord.config.RemoteTaskRunnerConfig;
import org.apache.druid.indexing.overlord.config.WorkerTaskRunnerConfig;
import org.apache.druid.indexing.overlord.setup.AffinityConfig;
import org.apache.druid.indexing.overlord.setup.EqualDistributionWorkerSelectStrategy;
import org.apache.druid.indexing.worker.Worker;
import org.apache.druid.java.util.common.DateTimes;
import org.junit.Assert;
import org.junit.Test;

public class EqualDistributionWorkerSelectStrategyTest {
    private static final ImmutableMap<String, ImmutableWorkerInfo> WORKERS_FOR_AFFINITY_TESTS = ImmutableMap.of((Object)"localhost0", (Object)new ImmutableWorkerInfo(new Worker("http", "localhost0", "localhost0", 2, "v1", "_default_worker_category"), 0, new HashSet(), new HashSet(), DateTimes.nowUtc()), (Object)"localhost1", (Object)new ImmutableWorkerInfo(new Worker("http", "localhost1", "localhost1", 2, "v1", "_default_worker_category"), 0, new HashSet(), new HashSet(), DateTimes.nowUtc()), (Object)"localhost2", (Object)new ImmutableWorkerInfo(new Worker("http", "localhost2", "localhost2", 2, "v1", "_default_worker_category"), 1, new HashSet(), new HashSet(), DateTimes.nowUtc()), (Object)"localhost3", (Object)new ImmutableWorkerInfo(new Worker("http", "localhost3", "localhost3", 2, "v1", "_default_worker_category"), 1, new HashSet(), new HashSet(), DateTimes.nowUtc()));

    @Test
    public void testFindWorkerForTask() {
        EqualDistributionWorkerSelectStrategy strategy = new EqualDistributionWorkerSelectStrategy(null);
        ImmutableWorkerInfo worker = strategy.findWorkerForTask((WorkerTaskRunnerConfig)new RemoteTaskRunnerConfig(), ImmutableMap.of((Object)"lhost", (Object)new ImmutableWorkerInfo(new Worker("http", "lhost", "lhost", 1, "v1", "_default_worker_category"), 0, new HashSet(), new HashSet(), DateTimes.nowUtc()), (Object)"localhost", (Object)new ImmutableWorkerInfo(new Worker("http", "localhost", "localhost", 1, "v1", "_default_worker_category"), 1, new HashSet(), new HashSet(), DateTimes.nowUtc())), (Task)new NoopTask(null, null, null, 1L, 0L, null, null, null){

            public String getDataSource() {
                return "foo";
            }
        });
        Assert.assertEquals((Object)"lhost", (Object)worker.getWorker().getHost());
    }

    @Test
    public void testFindWorkerForTaskWhenSameCurrCapacityUsed() {
        EqualDistributionWorkerSelectStrategy strategy = new EqualDistributionWorkerSelectStrategy(null);
        ImmutableWorkerInfo worker = strategy.findWorkerForTask((WorkerTaskRunnerConfig)new RemoteTaskRunnerConfig(), ImmutableMap.of((Object)"lhost", (Object)new ImmutableWorkerInfo(new Worker("http", "lhost", "lhost", 5, "v1", "_default_worker_category"), 5, new HashSet(), new HashSet(), DateTimes.nowUtc()), (Object)"localhost", (Object)new ImmutableWorkerInfo(new Worker("http", "localhost", "localhost", 10, "v1", "_default_worker_category"), 5, new HashSet(), new HashSet(), DateTimes.nowUtc())), (Task)new NoopTask(null, null, null, 1L, 0L, null, null, null){

            public String getDataSource() {
                return "foo";
            }
        });
        Assert.assertEquals((Object)"localhost", (Object)worker.getWorker().getHost());
    }

    @Test
    public void testOneDisableWorkerDifferentUsedCapacity() {
        String disabledVersion = "";
        EqualDistributionWorkerSelectStrategy strategy = new EqualDistributionWorkerSelectStrategy(null);
        ImmutableWorkerInfo worker = strategy.findWorkerForTask((WorkerTaskRunnerConfig)new RemoteTaskRunnerConfig(), ImmutableMap.of((Object)"lhost", (Object)new ImmutableWorkerInfo(new Worker("http", "disableHost", "disableHost", 10, disabledVersion, "_default_worker_category"), 2, new HashSet(), new HashSet(), DateTimes.nowUtc()), (Object)"localhost", (Object)new ImmutableWorkerInfo(new Worker("http", "enableHost", "enableHost", 10, "v1", "_default_worker_category"), 5, new HashSet(), new HashSet(), DateTimes.nowUtc())), (Task)new NoopTask(null, null, null, 1L, 0L, null, null, null){

            public String getDataSource() {
                return "foo";
            }
        });
        Assert.assertEquals((Object)"enableHost", (Object)worker.getWorker().getHost());
    }

    @Test
    public void testOneDisableWorkerSameUsedCapacity() {
        String disabledVersion = "";
        EqualDistributionWorkerSelectStrategy strategy = new EqualDistributionWorkerSelectStrategy(null);
        ImmutableWorkerInfo worker = strategy.findWorkerForTask((WorkerTaskRunnerConfig)new RemoteTaskRunnerConfig(), ImmutableMap.of((Object)"lhost", (Object)new ImmutableWorkerInfo(new Worker("http", "disableHost", "disableHost", 10, disabledVersion, "_default_worker_category"), 5, new HashSet(), new HashSet(), DateTimes.nowUtc()), (Object)"localhost", (Object)new ImmutableWorkerInfo(new Worker("http", "enableHost", "enableHost", 10, "v1", "_default_worker_category"), 5, new HashSet(), new HashSet(), DateTimes.nowUtc())), (Task)new NoopTask(null, null, null, 1L, 0L, null, null, null){

            public String getDataSource() {
                return "foo";
            }
        });
        Assert.assertEquals((Object)"enableHost", (Object)worker.getWorker().getHost());
    }

    @Test
    public void testWeakAffinity() {
        EqualDistributionWorkerSelectStrategy strategy = new EqualDistributionWorkerSelectStrategy(new AffinityConfig((Map)ImmutableMap.of((Object)"foo", (Object)ImmutableSet.of((Object)"localhost1", (Object)"localhost2", (Object)"localhost3"), (Object)"bar", (Object)ImmutableSet.of((Object)"nonexistent-worker")), false));
        ImmutableWorkerInfo workerFoo = strategy.findWorkerForTask((WorkerTaskRunnerConfig)new RemoteTaskRunnerConfig(), WORKERS_FOR_AFFINITY_TESTS, (Task)EqualDistributionWorkerSelectStrategyTest.createDummyTask("foo"));
        Assert.assertEquals((Object)"localhost1", (Object)workerFoo.getWorker().getHost());
        ImmutableWorkerInfo workerBar = strategy.findWorkerForTask((WorkerTaskRunnerConfig)new RemoteTaskRunnerConfig(), WORKERS_FOR_AFFINITY_TESTS, (Task)EqualDistributionWorkerSelectStrategyTest.createDummyTask("bar"));
        Assert.assertEquals((Object)"localhost0", (Object)workerBar.getWorker().getHost());
        ImmutableWorkerInfo workerBaz = strategy.findWorkerForTask((WorkerTaskRunnerConfig)new RemoteTaskRunnerConfig(), WORKERS_FOR_AFFINITY_TESTS, (Task)EqualDistributionWorkerSelectStrategyTest.createDummyTask("baz"));
        Assert.assertEquals((Object)"localhost0", (Object)workerBaz.getWorker().getHost());
    }

    @Test
    public void testStrongAffinity() {
        EqualDistributionWorkerSelectStrategy strategy = new EqualDistributionWorkerSelectStrategy(new AffinityConfig((Map)ImmutableMap.of((Object)"foo", (Object)ImmutableSet.of((Object)"localhost1", (Object)"localhost2", (Object)"localhost3"), (Object)"bar", (Object)ImmutableSet.of((Object)"nonexistent-worker")), true));
        ImmutableWorkerInfo workerFoo = strategy.findWorkerForTask((WorkerTaskRunnerConfig)new RemoteTaskRunnerConfig(), WORKERS_FOR_AFFINITY_TESTS, (Task)EqualDistributionWorkerSelectStrategyTest.createDummyTask("foo"));
        Assert.assertEquals((Object)"localhost1", (Object)workerFoo.getWorker().getHost());
        ImmutableWorkerInfo workerBar = strategy.findWorkerForTask((WorkerTaskRunnerConfig)new RemoteTaskRunnerConfig(), WORKERS_FOR_AFFINITY_TESTS, (Task)EqualDistributionWorkerSelectStrategyTest.createDummyTask("bar"));
        Assert.assertNull((Object)workerBar);
        ImmutableWorkerInfo workerBaz = strategy.findWorkerForTask((WorkerTaskRunnerConfig)new RemoteTaskRunnerConfig(), WORKERS_FOR_AFFINITY_TESTS, (Task)EqualDistributionWorkerSelectStrategyTest.createDummyTask("baz"));
        Assert.assertEquals((Object)"localhost0", (Object)workerBaz.getWorker().getHost());
    }

    private static NoopTask createDummyTask(final String dataSource) {
        return new NoopTask(null, null, null, 1L, 0L, null, null, null){

            public String getDataSource() {
                return dataSource;
            }
        };
    }
}

