/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.supervisor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.druid.indexing.overlord.DataSourceMetadata;
import org.apache.druid.indexing.overlord.TaskMaster;
import org.apache.druid.indexing.overlord.supervisor.NoopSupervisorSpec;
import org.apache.druid.indexing.overlord.supervisor.Supervisor;
import org.apache.druid.indexing.overlord.supervisor.SupervisorManager;
import org.apache.druid.indexing.overlord.supervisor.SupervisorReport;
import org.apache.druid.indexing.overlord.supervisor.SupervisorResource;
import org.apache.druid.indexing.overlord.supervisor.SupervisorSpec;
import org.apache.druid.indexing.overlord.supervisor.SupervisorStateManager;
import org.apache.druid.indexing.overlord.supervisor.SupervisorStatus;
import org.apache.druid.indexing.overlord.supervisor.VersionedSupervisorSpec;
import org.apache.druid.indexing.overlord.supervisor.autoscaler.SupervisorTaskAutoScaler;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.Authorizer;
import org.apache.druid.server.security.AuthorizerMapper;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.EasyMockSupport;
import org.easymock.Mock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class SupervisorResourceTest
extends EasyMockSupport {
    private static final ObjectMapper OBJECT_MAPPER = TestHelper.makeJsonMapper();
    private static final TestSupervisorSpec SPEC1 = new TestSupervisorSpec("id1", null, Collections.singletonList("datasource1"));
    private static final TestSupervisorSpec SPEC2 = new TestSupervisorSpec("id2", null, Collections.singletonList("datasource2"));
    private static final Set<String> SUPERVISOR_IDS = ImmutableSet.of((Object)SPEC1.getId(), (Object)SPEC2.getId());
    @Mock
    private TaskMaster taskMaster;
    @Mock
    private SupervisorManager supervisorManager;
    @Mock
    private HttpServletRequest request;
    private SupervisorResource supervisorResource;

    @Before
    public void setUp() {
        this.supervisorResource = new SupervisorResource(this.taskMaster, new AuthorizerMapper(null){

            public Authorizer getAuthorizer(String name) {
                return (authenticationResult, resource, action) -> {
                    if (authenticationResult.getIdentity().equals("druid")) {
                        return Access.OK;
                    }
                    if (resource.getName().equals("datasource2")) {
                        return new Access(false, "not authorized.");
                    }
                    return Access.OK;
                };
            }
        }, OBJECT_MAPPER);
    }

    @Test
    public void testSpecPost() {
        TestSupervisorSpec spec = new TestSupervisorSpec("my-id", null, null){

            @Override
            public List<String> getDataSources() {
                return Collections.singletonList("datasource1");
            }
        };
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.of((Object)this.supervisorManager));
        EasyMock.expect((Object)this.supervisorManager.createOrUpdateAndStartSupervisor((SupervisorSpec)spec)).andReturn((Object)true);
        EasyMock.expect((Object)this.request.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authorization-Checked")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authentication-Result")).andReturn((Object)new AuthenticationResult("druid", "druid", null, null)).atLeastOnce();
        this.request.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().anyTimes();
        this.replayAll();
        Response response = this.supervisorResource.specPost((SupervisorSpec)spec, this.request);
        this.verifyAll();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"id", (Object)"my-id"), (Object)response.getEntity());
        this.resetAll();
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.absent());
        this.replayAll();
        response = this.supervisorResource.specPost((SupervisorSpec)spec, this.request);
        this.verifyAll();
        Assert.assertEquals((long)503L, (long)response.getStatus());
    }

    @Test
    public void testSpecGetAll() {
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.of((Object)this.supervisorManager));
        EasyMock.expect((Object)this.supervisorManager.getSupervisorIds()).andReturn(SUPERVISOR_IDS).atLeastOnce();
        EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec(SPEC1.getId())).andReturn((Object)Optional.of((Object)SPEC1));
        EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec(SPEC2.getId())).andReturn((Object)Optional.of((Object)SPEC2));
        EasyMock.expect((Object)this.request.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authorization-Checked")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authentication-Result")).andReturn((Object)new AuthenticationResult("druid", "druid", null, null)).atLeastOnce();
        this.request.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().anyTimes();
        this.replayAll();
        Response response = this.supervisorResource.specGetAll(null, null, null, this.request);
        this.verifyAll();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals(SUPERVISOR_IDS, (Object)response.getEntity());
        this.resetAll();
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.absent());
        this.replayAll();
        response = this.supervisorResource.specGetAll(null, null, null, this.request);
        this.verifyAll();
        Assert.assertEquals((long)503L, (long)response.getStatus());
    }

    @Test
    public void testSpecGetAllFull() {
        SupervisorStateManager.BasicState state1 = SupervisorStateManager.BasicState.RUNNING;
        SupervisorStateManager.BasicState state2 = SupervisorStateManager.BasicState.SUSPENDED;
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.of((Object)this.supervisorManager));
        EasyMock.expect((Object)this.supervisorManager.getSupervisorIds()).andReturn(SUPERVISOR_IDS).atLeastOnce();
        EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec("id1")).andReturn((Object)Optional.of((Object)SPEC1)).anyTimes();
        EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec("id2")).andReturn((Object)Optional.of((Object)SPEC2)).anyTimes();
        EasyMock.expect((Object)this.supervisorManager.getSupervisorState("id1")).andReturn((Object)Optional.of((Object)state1)).anyTimes();
        EasyMock.expect((Object)this.supervisorManager.getSupervisorState("id2")).andReturn((Object)Optional.of((Object)state2)).anyTimes();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authorization-Checked")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authentication-Result")).andReturn((Object)new AuthenticationResult("druid", "druid", null, null)).atLeastOnce();
        this.request.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().anyTimes();
        this.replayAll();
        Response response = this.supervisorResource.specGetAll("", null, null, this.request);
        this.verifyAll();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        List specs = (List)response.getEntity();
        Assert.assertTrue((boolean)specs.stream().allMatch(spec -> "id1".equals(spec.getId()) && SPEC1.equals(spec.getSpec()) || "id2".equals(spec.getId()) && SPEC2.equals(spec.getSpec())));
    }

    @Test
    public void testSpecGetAllSystem() {
        SupervisorStateManager.BasicState state1 = SupervisorStateManager.BasicState.RUNNING;
        SupervisorStateManager.BasicState state2 = SupervisorStateManager.BasicState.SUSPENDED;
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.of((Object)this.supervisorManager));
        EasyMock.expect((Object)this.supervisorManager.getSupervisorIds()).andReturn(SUPERVISOR_IDS).atLeastOnce();
        EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec("id1")).andReturn((Object)Optional.of((Object)SPEC1)).anyTimes();
        EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec("id2")).andReturn((Object)Optional.of((Object)SPEC2)).anyTimes();
        EasyMock.expect((Object)this.supervisorManager.getSupervisorState("id1")).andReturn((Object)Optional.of((Object)state1)).anyTimes();
        EasyMock.expect((Object)this.supervisorManager.getSupervisorState("id2")).andReturn((Object)Optional.of((Object)state2)).anyTimes();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authorization-Checked")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authentication-Result")).andReturn((Object)new AuthenticationResult("druid", "druid", null, null)).atLeastOnce();
        this.request.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().anyTimes();
        this.replayAll();
        Response response = this.supervisorResource.specGetAll(null, null, "", this.request);
        this.verifyAll();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        List specs = (List)response.getEntity();
        specs.sort(Comparator.comparing(SupervisorStatus::getId));
        Assert.assertEquals((long)2L, (long)specs.size());
        SupervisorStatus spec = (SupervisorStatus)specs.get(0);
        Assert.assertEquals((Object)"id1", (Object)spec.getId());
        Assert.assertEquals((Object)"RUNNING", (Object)spec.getState());
        Assert.assertEquals((Object)"RUNNING", (Object)spec.getDetailedState());
        Assert.assertEquals((Object)true, (Object)spec.isHealthy());
        Assert.assertEquals((Object)"{\"type\":\"SupervisorResourceTest$TestSupervisorSpec\"}", (Object)spec.getSpecString());
        Assert.assertEquals((Object)"test", (Object)spec.getType());
        Assert.assertEquals((Object)"dummy", (Object)spec.getSource());
        Assert.assertEquals((Object)false, (Object)spec.isSuspended());
    }

    @Test
    public void testSpecGetState() {
        SupervisorStateManager.BasicState state1 = SupervisorStateManager.BasicState.RUNNING;
        SupervisorStateManager.BasicState state2 = SupervisorStateManager.BasicState.SUSPENDED;
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.of((Object)this.supervisorManager));
        EasyMock.expect((Object)this.supervisorManager.getSupervisorIds()).andReturn(SUPERVISOR_IDS).atLeastOnce();
        EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec("id1")).andReturn((Object)Optional.of((Object)SPEC1)).times(1);
        EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec("id2")).andReturn((Object)Optional.of((Object)SPEC2)).times(1);
        EasyMock.expect((Object)this.supervisorManager.getSupervisorState("id1")).andReturn((Object)Optional.of((Object)state1)).times(1);
        EasyMock.expect((Object)this.supervisorManager.getSupervisorState("id2")).andReturn((Object)Optional.of((Object)state2)).times(1);
        EasyMock.expect((Object)this.request.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authorization-Checked")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authentication-Result")).andReturn((Object)new AuthenticationResult("druid", "druid", null, null)).atLeastOnce();
        this.request.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().anyTimes();
        this.replayAll();
        Response response = this.supervisorResource.specGetAll(null, Boolean.valueOf(true), null, this.request);
        this.verifyAll();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        List states = (List)response.getEntity();
        Assert.assertTrue((boolean)states.stream().allMatch(arg_0 -> SupervisorResourceTest.lambda$testSpecGetState$1((SupervisorStateManager.State)state1, (SupervisorStateManager.State)state2, arg_0)));
    }

    @Test
    public void testSpecGet() {
        TestSupervisorSpec spec = new TestSupervisorSpec("my-id", null, null);
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.of((Object)this.supervisorManager)).times(2);
        EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec("my-id")).andReturn((Object)Optional.of((Object)spec));
        EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec("my-id-2")).andReturn((Object)Optional.absent());
        this.replayAll();
        Response response = this.supervisorResource.specGet("my-id");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)spec, (Object)response.getEntity());
        response = this.supervisorResource.specGet("my-id-2");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        this.verifyAll();
        this.resetAll();
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.absent());
        this.replayAll();
        response = this.supervisorResource.specGet("my-id");
        this.verifyAll();
        Assert.assertEquals((long)503L, (long)response.getStatus());
    }

    @Test
    public void testSpecGetStatus() {
        SupervisorReport report = new SupervisorReport("id", DateTimes.nowUtc(), null);
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.of((Object)this.supervisorManager)).times(2);
        EasyMock.expect((Object)this.supervisorManager.getSupervisorStatus("my-id")).andReturn((Object)Optional.of((Object)report));
        EasyMock.expect((Object)this.supervisorManager.getSupervisorStatus("my-id-2")).andReturn((Object)Optional.absent());
        this.replayAll();
        Response response = this.supervisorResource.specGetStatus("my-id");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)report, (Object)response.getEntity());
        response = this.supervisorResource.specGetStatus("my-id-2");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        this.verifyAll();
        this.resetAll();
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.absent());
        this.replayAll();
        response = this.supervisorResource.specGetStatus("my-id");
        this.verifyAll();
        Assert.assertEquals((long)503L, (long)response.getStatus());
    }

    @Test
    public void testSpecGetHealth() {
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.of((Object)this.supervisorManager)).times(3);
        EasyMock.expect((Object)this.supervisorManager.isSupervisorHealthy("my-id")).andReturn((Object)Optional.of((Object)true));
        EasyMock.expect((Object)this.supervisorManager.isSupervisorHealthy("my-id-2")).andReturn((Object)Optional.of((Object)false));
        EasyMock.expect((Object)this.supervisorManager.isSupervisorHealthy("my-id-3")).andReturn((Object)Optional.absent());
        this.replayAll();
        Response response = this.supervisorResource.specGetHealth("my-id");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"healthy", (Object)true), (Object)response.getEntity());
        response = this.supervisorResource.specGetHealth("my-id-2");
        Assert.assertEquals((long)503L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"healthy", (Object)false), (Object)response.getEntity());
        response = this.supervisorResource.specGetHealth("my-id-3");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"error", (Object)"[my-id-3] does not exist or health check not implemented"), (Object)response.getEntity());
        this.verifyAll();
    }

    @Test
    public void testSpecSuspend() {
        TestSupervisorSpec suspended = new TestSupervisorSpec("my-id", null, null, true){

            @Override
            public List<String> getDataSources() {
                return Collections.singletonList("datasource1");
            }
        };
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.of((Object)this.supervisorManager));
        EasyMock.expect((Object)this.supervisorManager.suspendOrResumeSupervisor("my-id", true)).andReturn((Object)true);
        EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec("my-id")).andReturn((Object)Optional.of((Object)suspended));
        this.replayAll();
        Response response = this.supervisorResource.specSuspend("my-id");
        this.verifyAll();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        TestSupervisorSpec responseSpec = (TestSupervisorSpec)response.getEntity();
        Assert.assertEquals((Object)suspended.id, (Object)responseSpec.id);
        Assert.assertEquals((Object)suspended.suspended, (Object)responseSpec.suspended);
        this.resetAll();
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.of((Object)this.supervisorManager));
        EasyMock.expect((Object)this.supervisorManager.suspendOrResumeSupervisor("my-id", true)).andReturn((Object)false);
        EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec("my-id")).andReturn((Object)Optional.of((Object)suspended));
        this.replayAll();
        response = this.supervisorResource.specSuspend("my-id");
        this.verifyAll();
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"error", (Object)"[my-id] is already suspended"), (Object)response.getEntity());
    }

    @Test
    public void testSpecResume() {
        TestSupervisorSpec running = new TestSupervisorSpec("my-id", null, null, false){

            @Override
            public List<String> getDataSources() {
                return Collections.singletonList("datasource1");
            }
        };
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.of((Object)this.supervisorManager));
        EasyMock.expect((Object)this.supervisorManager.suspendOrResumeSupervisor("my-id", false)).andReturn((Object)true);
        EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec("my-id")).andReturn((Object)Optional.of((Object)running));
        this.replayAll();
        Response response = this.supervisorResource.specResume("my-id");
        this.verifyAll();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        TestSupervisorSpec responseSpec = (TestSupervisorSpec)response.getEntity();
        Assert.assertEquals((Object)running.id, (Object)responseSpec.id);
        Assert.assertEquals((Object)running.suspended, (Object)responseSpec.suspended);
        this.resetAll();
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.of((Object)this.supervisorManager));
        EasyMock.expect((Object)this.supervisorManager.suspendOrResumeSupervisor("my-id", false)).andReturn((Object)false);
        EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec("my-id")).andReturn((Object)Optional.of((Object)running));
        this.replayAll();
        response = this.supervisorResource.specResume("my-id");
        this.verifyAll();
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"error", (Object)"[my-id] is already running"), (Object)response.getEntity());
    }

    @Test
    public void testTerminate() {
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.of((Object)this.supervisorManager)).times(2);
        EasyMock.expect((Object)this.supervisorManager.stopAndRemoveSupervisor("my-id")).andReturn((Object)true);
        EasyMock.expect((Object)this.supervisorManager.stopAndRemoveSupervisor("my-id-2")).andReturn((Object)false);
        this.replayAll();
        Response response = this.supervisorResource.terminate("my-id");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"id", (Object)"my-id"), (Object)response.getEntity());
        response = this.supervisorResource.terminate("my-id-2");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        this.verifyAll();
        this.resetAll();
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.absent());
        this.replayAll();
        response = this.supervisorResource.terminate("my-id");
        this.verifyAll();
        Assert.assertEquals((long)503L, (long)response.getStatus());
    }

    @Test
    public void testSuspendAll() {
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.of((Object)this.supervisorManager));
        EasyMock.expect((Object)this.supervisorManager.getSupervisorIds()).andReturn(SUPERVISOR_IDS).atLeastOnce();
        EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec(SPEC1.getId())).andReturn((Object)Optional.of((Object)SPEC1));
        EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec(SPEC2.getId())).andReturn((Object)Optional.of((Object)SPEC2));
        EasyMock.expect((Object)this.supervisorManager.suspendOrResumeSupervisor(SPEC1.getId(), true)).andReturn((Object)true);
        EasyMock.expect((Object)this.supervisorManager.suspendOrResumeSupervisor(SPEC2.getId(), true)).andReturn((Object)true);
        EasyMock.expect((Object)this.request.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authorization-Checked")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authentication-Result")).andReturn((Object)new AuthenticationResult("druid", "druid", null, null)).atLeastOnce();
        this.request.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().anyTimes();
        this.replayAll();
        Response response = this.supervisorResource.suspendAll(this.request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"status", (Object)"success"), (Object)response.getEntity());
        this.verifyAll();
    }

    @Test
    public void testSuspendAllWithPartialAuthorization() {
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.of((Object)this.supervisorManager));
        EasyMock.expect((Object)this.supervisorManager.getSupervisorIds()).andReturn(SUPERVISOR_IDS).atLeastOnce();
        EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec(SPEC1.getId())).andReturn((Object)Optional.of((Object)SPEC1));
        EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec(SPEC2.getId())).andReturn((Object)Optional.of((Object)SPEC2));
        EasyMock.expect((Object)this.supervisorManager.suspendOrResumeSupervisor(SPEC1.getId(), true)).andReturn((Object)true);
        EasyMock.expect((Object)this.request.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authorization-Checked")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authentication-Result")).andReturn((Object)new AuthenticationResult("notDruid", "druid", null, null)).atLeastOnce();
        this.request.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().anyTimes();
        this.replayAll();
        Response response = this.supervisorResource.suspendAll(this.request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"status", (Object)"success"), (Object)response.getEntity());
        this.verifyAll();
    }

    @Test
    public void testResumeAll() {
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.of((Object)this.supervisorManager));
        EasyMock.expect((Object)this.supervisorManager.getSupervisorIds()).andReturn(SUPERVISOR_IDS).atLeastOnce();
        EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec(SPEC1.getId())).andReturn((Object)Optional.of((Object)SPEC1));
        EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec(SPEC2.getId())).andReturn((Object)Optional.of((Object)SPEC2));
        EasyMock.expect((Object)this.supervisorManager.suspendOrResumeSupervisor(SPEC1.getId(), false)).andReturn((Object)true);
        EasyMock.expect((Object)this.supervisorManager.suspendOrResumeSupervisor(SPEC2.getId(), false)).andReturn((Object)true);
        EasyMock.expect((Object)this.request.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authorization-Checked")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authentication-Result")).andReturn((Object)new AuthenticationResult("druid", "druid", null, null)).atLeastOnce();
        this.request.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().anyTimes();
        this.replayAll();
        Response response = this.supervisorResource.resumeAll(this.request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"status", (Object)"success"), (Object)response.getEntity());
        this.verifyAll();
    }

    @Test
    public void testResumeAllWithPartialAuthorization() {
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.of((Object)this.supervisorManager));
        EasyMock.expect((Object)this.supervisorManager.getSupervisorIds()).andReturn(SUPERVISOR_IDS).atLeastOnce();
        EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec(SPEC1.getId())).andReturn((Object)Optional.of((Object)SPEC1));
        EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec(SPEC2.getId())).andReturn((Object)Optional.of((Object)SPEC2));
        EasyMock.expect((Object)this.supervisorManager.suspendOrResumeSupervisor(SPEC1.getId(), false)).andReturn((Object)true);
        EasyMock.expect((Object)this.request.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authorization-Checked")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authentication-Result")).andReturn((Object)new AuthenticationResult("notDruid", "druid", null, null)).atLeastOnce();
        this.request.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().anyTimes();
        this.replayAll();
        Response response = this.supervisorResource.resumeAll(this.request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"status", (Object)"success"), (Object)response.getEntity());
        this.verifyAll();
    }

    @Test
    public void testTerminateAll() {
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.of((Object)this.supervisorManager));
        EasyMock.expect((Object)this.supervisorManager.getSupervisorIds()).andReturn(SUPERVISOR_IDS).atLeastOnce();
        EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec(SPEC1.getId())).andReturn((Object)Optional.of((Object)SPEC1));
        EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec(SPEC2.getId())).andReturn((Object)Optional.of((Object)SPEC2));
        EasyMock.expect((Object)this.supervisorManager.stopAndRemoveSupervisor(SPEC1.getId())).andReturn((Object)true);
        EasyMock.expect((Object)this.supervisorManager.stopAndRemoveSupervisor(SPEC2.getId())).andReturn((Object)true);
        EasyMock.expect((Object)this.request.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authorization-Checked")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authentication-Result")).andReturn((Object)new AuthenticationResult("druid", "druid", null, null)).atLeastOnce();
        this.request.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().anyTimes();
        this.replayAll();
        Response response = this.supervisorResource.terminateAll(this.request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"status", (Object)"success"), (Object)response.getEntity());
        this.verifyAll();
    }

    @Test
    public void testTerminateAllWithPartialAuthorization() {
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.of((Object)this.supervisorManager));
        EasyMock.expect((Object)this.supervisorManager.getSupervisorIds()).andReturn(SUPERVISOR_IDS).atLeastOnce();
        EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec(SPEC1.getId())).andReturn((Object)Optional.of((Object)SPEC1));
        EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec(SPEC2.getId())).andReturn((Object)Optional.of((Object)SPEC2));
        EasyMock.expect((Object)this.supervisorManager.stopAndRemoveSupervisor(SPEC1.getId())).andReturn((Object)true);
        EasyMock.expect((Object)this.request.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authorization-Checked")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authentication-Result")).andReturn((Object)new AuthenticationResult("notDruid", "druid", null, null)).atLeastOnce();
        this.request.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().anyTimes();
        this.replayAll();
        Response response = this.supervisorResource.terminateAll(this.request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"status", (Object)"success"), (Object)response.getEntity());
        this.verifyAll();
    }

    @Test
    public void testSpecGetAllHistory() {
        ImmutableList versions1 = ImmutableList.of((Object)new VersionedSupervisorSpec((SupervisorSpec)new TestSupervisorSpec("id1", null, Collections.singletonList("datasource1")), "v1"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new TestSupervisorSpec("id1", null, Collections.singletonList("datasource1")), "v2"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new NoopSupervisorSpec(null, Collections.singletonList("datasource1")), "tombstone"));
        ImmutableList versions2 = ImmutableList.of((Object)new VersionedSupervisorSpec((SupervisorSpec)new TestSupervisorSpec("id2", null, Collections.singletonList("datasource2")), "v1"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new TestSupervisorSpec("id2", null, Collections.singletonList("datasource2")), "v2"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new NoopSupervisorSpec(null, Collections.singletonList("datasource2")), "tombstone"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new TestSupervisorSpec("id2", null, Collections.singletonList("datasource2")), "v3"));
        ImmutableList versions3 = ImmutableList.of((Object)new VersionedSupervisorSpec((SupervisorSpec)new TestSupervisorSpec("id2", null, Collections.singletonList("datasource3")), "v1"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new NoopSupervisorSpec(null, null), "tombstone"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new TestSupervisorSpec("id2", null, Collections.singletonList("datasource3")), "v2"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new NoopSupervisorSpec(null, null), "tombstone"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new TestSupervisorSpec("id2", null, Collections.singletonList("datasource3")), "v3"));
        HashMap<String, ImmutableList> history = new HashMap<String, ImmutableList>();
        history.put("id1", versions1);
        history.put("id2", versions2);
        history.put("id3", versions3);
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.of((Object)this.supervisorManager)).times(2);
        EasyMock.expect((Object)this.supervisorManager.getSupervisorHistory()).andReturn(history);
        EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec("id1")).andReturn((Object)Optional.of((Object)SPEC1)).atLeastOnce();
        EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec("id2")).andReturn((Object)Optional.of((Object)SPEC2)).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authorization-Checked")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authentication-Result")).andReturn((Object)new AuthenticationResult("druid", "druid", null, null)).atLeastOnce();
        this.request.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().anyTimes();
        this.replayAll();
        Response response = this.supervisorResource.specGetAllHistory(this.request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals(history, (Object)response.getEntity());
        this.resetAll();
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.absent());
        this.replayAll();
        response = this.supervisorResource.specGetAllHistory(this.request);
        this.verifyAll();
        Assert.assertEquals((long)503L, (long)response.getStatus());
    }

    @Test
    public void testSpecGetAllHistoryWithPartialAuthorization() {
        ImmutableList versions1 = ImmutableList.of((Object)new VersionedSupervisorSpec((SupervisorSpec)new TestSupervisorSpec("id1", null, Collections.singletonList("datasource1")), "v1"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new TestSupervisorSpec("id1", null, Collections.singletonList("datasource1")), "v2"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new NoopSupervisorSpec(null, Collections.singletonList("datasource1")), "tombstone"));
        ImmutableList versions2 = ImmutableList.of((Object)new VersionedSupervisorSpec((SupervisorSpec)new TestSupervisorSpec("id2", null, Collections.singletonList("datasource2")), "v1"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new TestSupervisorSpec("id2", null, Collections.singletonList("datasource2")), "v2"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new NoopSupervisorSpec(null, Collections.singletonList("datasource2")), "tombstone"));
        ImmutableList versions3 = ImmutableList.of((Object)new VersionedSupervisorSpec((SupervisorSpec)new TestSupervisorSpec("id2", null, Collections.singletonList("datasource2")), "v1"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new TestSupervisorSpec("id2", null, Collections.singletonList("datasource2")), "v2"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new NoopSupervisorSpec(null, Collections.singletonList("datasource2")), "tombstone"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new TestSupervisorSpec("id3", null, Collections.singletonList("datasource3")), "v1"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new NoopSupervisorSpec(null, Collections.singletonList("datasource3")), "tombstone"));
        ImmutableList versions4 = ImmutableList.of((Object)new VersionedSupervisorSpec((SupervisorSpec)new TestSupervisorSpec("id2", null, Collections.singletonList("datasource2")), "v1"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new NoopSupervisorSpec(null, null), "tombstone"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new TestSupervisorSpec("id2", null, Collections.singletonList("datasource2")), "v2"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new NoopSupervisorSpec(null, null), "tombstone"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new TestSupervisorSpec("id2", null, Collections.singletonList("datasource2")), "v3"));
        HashMap<String, ImmutableList> history = new HashMap<String, ImmutableList>();
        history.put("id1", versions1);
        history.put("id2", versions2);
        history.put("id3", versions3);
        history.put("id4", versions4);
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.of((Object)this.supervisorManager)).times(2);
        EasyMock.expect((Object)this.supervisorManager.getSupervisorHistory()).andReturn(history);
        EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec("id1")).andReturn((Object)Optional.of((Object)SPEC1)).atLeastOnce();
        EasyMock.expect((Object)this.supervisorManager.getSupervisorSpec("id2")).andReturn((Object)Optional.of((Object)SPEC2)).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authorization-Checked")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authentication-Result")).andReturn((Object)new AuthenticationResult("wronguser", "druid", null, null)).atLeastOnce();
        this.request.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().anyTimes();
        this.replayAll();
        Response response = this.supervisorResource.specGetAllHistory(this.request);
        HashMap<String, ImmutableList> filteredHistory = new HashMap<String, ImmutableList>();
        filteredHistory.put("id1", versions1);
        filteredHistory.put("id3", ImmutableList.of((Object)new VersionedSupervisorSpec((SupervisorSpec)new TestSupervisorSpec("id3", null, Collections.singletonList("datasource3")), "v1"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new NoopSupervisorSpec(null, Collections.singletonList("datasource3")), "tombstone")));
        filteredHistory.put("id4", ImmutableList.of((Object)new VersionedSupervisorSpec((SupervisorSpec)new NoopSupervisorSpec(null, null), "tombstone"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new NoopSupervisorSpec(null, null), "tombstone")));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals(filteredHistory, (Object)response.getEntity());
        this.resetAll();
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.absent());
        this.replayAll();
        response = this.supervisorResource.specGetAllHistory(this.request);
        this.verifyAll();
        Assert.assertEquals((long)503L, (long)response.getStatus());
    }

    @Test
    public void testSpecGetHistory() {
        ImmutableList versions1 = ImmutableList.of((Object)new VersionedSupervisorSpec((SupervisorSpec)new TestSupervisorSpec("id1", null, Collections.singletonList("datasource1")), "v1"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new NoopSupervisorSpec(null, Collections.singletonList("datasource1")), "tombstone"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new TestSupervisorSpec("id1", null, Collections.singletonList("datasource1")), "v2"));
        ImmutableList versions2 = ImmutableList.of((Object)new VersionedSupervisorSpec((SupervisorSpec)new TestSupervisorSpec("id2", null, Collections.singletonList("datasource2")), "v1"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new NoopSupervisorSpec(null, Collections.singletonList("datasource2")), "tombstone"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new TestSupervisorSpec("id2", null, Collections.singletonList("datasource2")), "v2"));
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.of((Object)this.supervisorManager)).times(3);
        EasyMock.expect((Object)this.supervisorManager.getSupervisorHistoryForId("id1")).andReturn((Object)versions1).times(1);
        EasyMock.expect((Object)this.supervisorManager.getSupervisorHistoryForId("id2")).andReturn((Object)versions2).times(1);
        EasyMock.expect((Object)this.supervisorManager.getSupervisorHistoryForId("id3")).andReturn(Collections.emptyList()).times(1);
        EasyMock.expect((Object)this.request.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authorization-Checked")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authentication-Result")).andReturn((Object)new AuthenticationResult("druid", "druid", null, null)).atLeastOnce();
        this.request.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().anyTimes();
        this.replayAll();
        Response response = this.supervisorResource.specGetHistory(this.request, "id1");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)versions1, (Object)response.getEntity());
        response = this.supervisorResource.specGetHistory(this.request, "id2");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)versions2, (Object)response.getEntity());
        response = this.supervisorResource.specGetHistory(this.request, "id3");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        this.resetAll();
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.absent());
        this.replayAll();
        response = this.supervisorResource.specGetHistory(this.request, "id1");
        this.verifyAll();
        Assert.assertEquals((long)503L, (long)response.getStatus());
    }

    @Test
    public void testSpecGetHistoryWithAuthFailure() {
        ImmutableList versions1 = ImmutableList.of((Object)new VersionedSupervisorSpec((SupervisorSpec)new TestSupervisorSpec("id1", null, Collections.singletonList("datasource1")), "v1"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new NoopSupervisorSpec(null, Collections.singletonList("datasource3")), "tombstone"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new TestSupervisorSpec("id1", null, Collections.singletonList("datasource1")), "v2"));
        ImmutableList versions2 = ImmutableList.of((Object)new VersionedSupervisorSpec((SupervisorSpec)new TestSupervisorSpec("id2", null, Collections.singletonList("datasource2")), "v1"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new NoopSupervisorSpec(null, Collections.singletonList("datasource2")), "tombstone"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new TestSupervisorSpec("id2", null, Collections.singletonList("datasource2")), "v2"));
        ImmutableList versions3 = ImmutableList.of((Object)new VersionedSupervisorSpec((SupervisorSpec)new TestSupervisorSpec("id3", null, Collections.singletonList("datasource3")), "v1"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new NoopSupervisorSpec(null, null), "tombstone"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new TestSupervisorSpec("id3", null, Collections.singletonList("datasource2")), "v2"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new NoopSupervisorSpec(null, null), "tombstone"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new TestSupervisorSpec("id3", null, Collections.singletonList("datasource3")), "v2"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new NoopSupervisorSpec(null, Collections.singletonList("datasource3")), "tombstone"));
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.of((Object)this.supervisorManager)).times(4);
        EasyMock.expect((Object)this.supervisorManager.getSupervisorHistoryForId("id1")).andReturn((Object)versions1).times(1);
        EasyMock.expect((Object)this.supervisorManager.getSupervisorHistoryForId("id2")).andReturn((Object)versions2).times(1);
        EasyMock.expect((Object)this.supervisorManager.getSupervisorHistoryForId("id3")).andReturn((Object)versions3).times(1);
        EasyMock.expect((Object)this.supervisorManager.getSupervisorHistoryForId("id4")).andReturn(Collections.emptyList()).times(1);
        EasyMock.expect((Object)this.request.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authorization-Checked")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authentication-Result")).andReturn((Object)new AuthenticationResult("notdruid", "druid", null, null)).atLeastOnce();
        this.request.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().anyTimes();
        this.replayAll();
        Response response = this.supervisorResource.specGetHistory(this.request, "id1");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)versions1, (Object)response.getEntity());
        response = this.supervisorResource.specGetHistory(this.request, "id2");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        response = this.supervisorResource.specGetHistory(this.request, "id3");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableList.of((Object)new VersionedSupervisorSpec((SupervisorSpec)new TestSupervisorSpec("id3", null, Collections.singletonList("datasource3")), "v1"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new NoopSupervisorSpec(null, null), "tombstone"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new NoopSupervisorSpec(null, null), "tombstone"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new TestSupervisorSpec("id3", null, Collections.singletonList("datasource3")), "v2"), (Object)new VersionedSupervisorSpec((SupervisorSpec)new NoopSupervisorSpec(null, Collections.singletonList("datasource3")), "tombstone")), (Object)response.getEntity());
        response = this.supervisorResource.specGetHistory(this.request, "id4");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        this.resetAll();
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.absent());
        this.replayAll();
        response = this.supervisorResource.specGetHistory(this.request, "id1");
        this.verifyAll();
        Assert.assertEquals((long)503L, (long)response.getStatus());
    }

    @Test
    public void testReset() {
        Capture id1 = Capture.newInstance();
        Capture id2 = Capture.newInstance();
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.of((Object)this.supervisorManager)).times(2);
        EasyMock.expect((Object)this.supervisorManager.resetSupervisor((String)EasyMock.capture((Capture)id1), (DataSourceMetadata)EasyMock.anyObject(DataSourceMetadata.class))).andReturn((Object)true);
        EasyMock.expect((Object)this.supervisorManager.resetSupervisor((String)EasyMock.capture((Capture)id2), (DataSourceMetadata)EasyMock.anyObject(DataSourceMetadata.class))).andReturn((Object)false);
        this.replayAll();
        Response response = this.supervisorResource.reset("my-id");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"id", (Object)"my-id"), (Object)response.getEntity());
        response = this.supervisorResource.reset("my-id-2");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertEquals((Object)"my-id", (Object)id1.getValue());
        Assert.assertEquals((Object)"my-id-2", (Object)id2.getValue());
        this.verifyAll();
        this.resetAll();
        EasyMock.expect((Object)this.taskMaster.getSupervisorManager()).andReturn((Object)Optional.absent());
        this.replayAll();
        response = this.supervisorResource.terminate("my-id");
        Assert.assertEquals((long)503L, (long)response.getStatus());
        this.verifyAll();
    }

    @Test
    public void testNoopSupervisorSpecSerde() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String oldSpec = "{\"type\":\"NoopSupervisorSpec\",\"id\":null,\"dataSources\":null}";
        NoopSupervisorSpec expectedSpec = new NoopSupervisorSpec(null, null);
        NoopSupervisorSpec deserializedSpec = (NoopSupervisorSpec)mapper.readValue(oldSpec, NoopSupervisorSpec.class);
        Assert.assertEquals((Object)expectedSpec, (Object)deserializedSpec);
        NoopSupervisorSpec spec = new NoopSupervisorSpec("abcd", Collections.singletonList("defg"));
        NoopSupervisorSpec specRoundTrip = (NoopSupervisorSpec)mapper.readValue(mapper.writeValueAsBytes((Object)spec), NoopSupervisorSpec.class);
        Assert.assertEquals((Object)spec, (Object)specRoundTrip);
    }

    private static /* synthetic */ boolean lambda$testSpecGetState$1(SupervisorStateManager.State state1, SupervisorStateManager.State state2, SupervisorStatus state) {
        String id = state.getId();
        if ("id1".equals(id)) {
            return state1.toString().equals(state.getState()) && state1.toString().equals(state.getDetailedState()) && Boolean.valueOf(state.isHealthy()).booleanValue() == state1.isHealthy();
        }
        if ("id2".equals(id)) {
            return state2.toString().equals(state.getState()) && state2.toString().equals(state.getDetailedState()) && Boolean.valueOf(state.isHealthy()).booleanValue() == state2.isHealthy();
        }
        return false;
    }

    private static class TestSupervisorSpec
    implements SupervisorSpec {
        protected final String id;
        protected final Supervisor supervisor;
        protected final List<String> datasources;
        boolean suspended;

        public TestSupervisorSpec(String id, Supervisor supervisor, List<String> datasources) {
            this.id = id;
            this.supervisor = supervisor;
            this.datasources = datasources;
        }

        public TestSupervisorSpec(String id, Supervisor supervisor, List<String> datasources, boolean suspended) {
            this(id, supervisor, datasources);
            this.suspended = suspended;
        }

        public String getId() {
            return this.id;
        }

        public Supervisor createSupervisor() {
            return this.supervisor;
        }

        public SupervisorTaskAutoScaler createAutoscaler(Supervisor supervisor) {
            return null;
        }

        public List<String> getDataSources() {
            return this.datasources;
        }

        public SupervisorSpec createSuspendedSpec() {
            return new TestSupervisorSpec(this.id, this.supervisor, this.datasources, true);
        }

        public SupervisorSpec createRunningSpec() {
            return new TestSupervisorSpec(this.id, this.supervisor, this.datasources, false);
        }

        public boolean isSuspended() {
            return this.suspended;
        }

        public String getType() {
            return "test";
        }

        public String getSource() {
            return "dummy";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestSupervisorSpec that = (TestSupervisorSpec)o;
            if (this.getId() != null ? !this.getId().equals(that.getId()) : that.getId() != null) {
                return false;
            }
            if (this.supervisor != null ? !this.supervisor.equals(that.supervisor) : that.supervisor != null) {
                return false;
            }
            if (this.datasources != null ? !this.datasources.equals(that.datasources) : that.datasources != null) {
                return false;
            }
            return this.isSuspended() == that.isSuspended();
        }

        public int hashCode() {
            int result = this.getId() != null ? this.getId().hashCode() : 0;
            result = 31 * result + (this.supervisor != null ? this.supervisor.hashCode() : 0);
            result = 31 * result + (this.datasources != null ? this.datasources.hashCode() : 0);
            return result;
        }
    }
}

