/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.initialization;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.JsonConfigurator;
import org.apache.druid.initialization.Initialization;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.server.initialization.IndexerZkConfig;
import org.apache.druid.server.initialization.ZkPathsConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class IndexerZkConfigTest {
    private static final String INDEXER_PROPERTY_STRING = "test.druid.zk.paths.indexer";
    private static final String ZK_SERVICE_CONFIG_STRING = "test.druid.zk.paths";
    private static final Collection<String> CLOBBERABLE_PROPERTIES = new HashSet<String>();
    private static final Module SIMPLE_ZK_CONFIG_MODULE = new Module(){

        public void configure(Binder binder) {
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/test");
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(0);
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(-1);
            JsonConfigProvider.bind((Binder)binder, (String)IndexerZkConfigTest.INDEXER_PROPERTY_STRING, IndexerZkConfig.class);
            JsonConfigProvider.bind((Binder)binder, (String)IndexerZkConfigTest.ZK_SERVICE_CONFIG_STRING, ZkPathsConfig.class);
        }
    };
    private Properties propertyValues = new Properties();
    private int assertions = 0;

    @BeforeClass
    public static void setup() {
        for (Field field : IndexerZkConfig.class.getDeclaredFields()) {
            if (null == field.getAnnotation(JsonProperty.class)) continue;
            CLOBBERABLE_PROPERTIES.add(StringUtils.format((String)"%s.%s", (Object[])new Object[]{INDEXER_PROPERTY_STRING, field.getName()}));
        }
        for (Field field : ZkPathsConfig.class.getDeclaredFields()) {
            if (null == field.getAnnotation(JsonProperty.class)) continue;
            CLOBBERABLE_PROPERTIES.add(StringUtils.format((String)"%s.%s", (Object[])new Object[]{ZK_SERVICE_CONFIG_STRING, field.getName()}));
        }
    }

    @Before
    public void setupTest() {
        for (String property : CLOBBERABLE_PROPERTIES) {
            this.propertyValues.put(property, UUID.randomUUID().toString());
        }
        this.assertions = 0;
    }

    private void validateEntries(ZkPathsConfig zkPathsConfig) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        for (Field field : ZkPathsConfig.class.getDeclaredFields()) {
            if (null == field.getAnnotation(JsonProperty.class)) continue;
            String property = StringUtils.format((String)"%s.%s", (Object[])new Object[]{ZK_SERVICE_CONFIG_STRING, field.getName()});
            String getter = StringUtils.format((String)"get%s%s", (Object[])new Object[]{StringUtils.toUpperCase((String)field.getName().substring(0, 1)), field.getName().substring(1)});
            Method method = ZkPathsConfig.class.getDeclaredMethod(getter, new Class[0]);
            Assert.assertEquals((Object)this.propertyValues.get(property), (Object)method.invoke((Object)zkPathsConfig, new Object[0]));
            ++this.assertions;
        }
    }

    private void validateEntries(IndexerZkConfig indexerZkConfig) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        for (Field field : IndexerZkConfig.class.getDeclaredFields()) {
            if (null == field.getAnnotation(JsonProperty.class)) continue;
            String property = StringUtils.format((String)"%s.%s", (Object[])new Object[]{INDEXER_PROPERTY_STRING, field.getName()});
            String getter = StringUtils.format((String)"get%s%s", (Object[])new Object[]{StringUtils.toUpperCase((String)field.getName().substring(0, 1)), field.getName().substring(1)});
            Method method = IndexerZkConfig.class.getDeclaredMethod(getter, new Class[0]);
            Assert.assertEquals((Object)this.propertyValues.get(property), (Object)method.invoke((Object)indexerZkConfig, new Object[0]));
            ++this.assertions;
        }
    }

    @Test
    public void testNullConfig() {
        this.propertyValues.clear();
        Injector injector = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of((Object)SIMPLE_ZK_CONFIG_MODULE));
        JsonConfigurator configurator = (JsonConfigurator)injector.getBinding(JsonConfigurator.class).getProvider().get();
        JsonConfigProvider zkPathsConfig = JsonConfigProvider.of((String)ZK_SERVICE_CONFIG_STRING, ZkPathsConfig.class);
        zkPathsConfig.inject(this.propertyValues, configurator);
        JsonConfigProvider indexerZkConfig = JsonConfigProvider.of((String)INDEXER_PROPERTY_STRING, IndexerZkConfig.class);
        indexerZkConfig.inject(this.propertyValues, configurator);
        Assert.assertEquals((Object)"/druid/indexer/tasks", (Object)((IndexerZkConfig)indexerZkConfig.get().get()).getTasksPath());
    }

    @Test
    public void testSimpleConfig() throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Injector injector = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of((Object)SIMPLE_ZK_CONFIG_MODULE));
        JsonConfigurator configurator = (JsonConfigurator)injector.getBinding(JsonConfigurator.class).getProvider().get();
        JsonConfigProvider zkPathsConfig = JsonConfigProvider.of((String)ZK_SERVICE_CONFIG_STRING, ZkPathsConfig.class);
        zkPathsConfig.inject(this.propertyValues, configurator);
        JsonConfigProvider indexerZkConfig = JsonConfigProvider.of((String)INDEXER_PROPERTY_STRING, IndexerZkConfig.class);
        indexerZkConfig.inject(this.propertyValues, configurator);
        IndexerZkConfig zkConfig = (IndexerZkConfig)indexerZkConfig.get().get();
        ZkPathsConfig zkPathsConfig1 = (ZkPathsConfig)zkPathsConfig.get().get();
        this.validateEntries(zkConfig);
        this.validateEntries(zkPathsConfig1);
        Assert.assertEquals((long)CLOBBERABLE_PROPERTIES.size(), (long)this.assertions);
    }

    @Test
    public void testIndexerBaseOverride() {
        String overrideValue = "/foo/bar/baz";
        String indexerPropertyKey = "test.druid.zk.paths.indexer.base";
        String priorValue = System.getProperty("test.druid.zk.paths.indexer.base");
        System.setProperty("test.druid.zk.paths.indexer.base", "/foo/bar/baz");
        Injector injector = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of((Object)SIMPLE_ZK_CONFIG_MODULE));
        this.propertyValues.clear();
        this.propertyValues.setProperty("test.druid.zk.paths.indexer.base", "/foo/bar/baz");
        JsonConfigurator configurator = (JsonConfigurator)injector.getBinding(JsonConfigurator.class).getProvider().get();
        JsonConfigProvider indexerPathsConfig = JsonConfigProvider.of((String)INDEXER_PROPERTY_STRING, IndexerZkConfig.class);
        indexerPathsConfig.inject(this.propertyValues, configurator);
        IndexerZkConfig indexerZkConfig = (IndexerZkConfig)indexerPathsConfig.get().get();
        if (priorValue == null) {
            System.clearProperty("test.druid.zk.paths.indexer.base");
        } else {
            System.setProperty("test.druid.zk.paths.indexer.base", priorValue);
        }
        Assert.assertEquals((Object)"/foo/bar/baz", (Object)indexerZkConfig.getBase());
        Assert.assertEquals((Object)"/foo/bar/baz/announcements", (Object)indexerZkConfig.getAnnouncementsPath());
    }

    @Test
    public void testExactConfig() {
        Injector injector = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of((Object)SIMPLE_ZK_CONFIG_MODULE));
        this.propertyValues.setProperty("test.druid.zk.paths.base", "/druid/metrics");
        JsonConfigurator configurator = (JsonConfigurator)injector.getBinding(JsonConfigurator.class).getProvider().get();
        JsonConfigProvider zkPathsConfig = JsonConfigProvider.of((String)ZK_SERVICE_CONFIG_STRING, ZkPathsConfig.class);
        zkPathsConfig.inject(this.propertyValues, configurator);
        ZkPathsConfig zkPathsConfig1 = (ZkPathsConfig)zkPathsConfig.get().get();
        IndexerZkConfig indexerZkConfig = new IndexerZkConfig(zkPathsConfig1, null, null, null, null);
        Assert.assertEquals((Object)"/druid/metrics/indexer", (Object)indexerZkConfig.getBase());
        Assert.assertEquals((Object)"/druid/metrics/indexer/announcements", (Object)indexerZkConfig.getAnnouncementsPath());
    }

    @Test
    public void testFullOverride() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        ZkPathsConfig zkPathsConfig = new ZkPathsConfig();
        IndexerZkConfig indexerZkConfig = new IndexerZkConfig(zkPathsConfig, "/druid/prod", "/druid/prod/a", "/druid/prod/t", "/druid/prod/s");
        Map value = (Map)mapper.readValue(mapper.writeValueAsString((Object)indexerZkConfig), JacksonUtils.TYPE_REFERENCE_MAP_STRING_STRING);
        IndexerZkConfig newConfig = new IndexerZkConfig(zkPathsConfig, (String)value.get("base"), (String)value.get("announcementsPath"), (String)value.get("tasksPath"), (String)value.get("statusPath"));
        Assert.assertEquals((Object)indexerZkConfig, (Object)newConfig);
    }
}

