/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.apache.druid.client.indexing.IndexingService;
import org.apache.druid.curator.discovery.ServiceAnnouncer;
import org.apache.druid.discovery.DruidLeaderSelector;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.actions.TaskActionClientFactory;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.TaskLockbox;
import org.apache.druid.indexing.overlord.TaskQueue;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.apache.druid.indexing.overlord.TaskRunnerFactory;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.indexing.overlord.autoscaling.ScalingStats;
import org.apache.druid.indexing.overlord.config.DefaultTaskConfig;
import org.apache.druid.indexing.overlord.config.TaskLockConfig;
import org.apache.druid.indexing.overlord.config.TaskQueueConfig;
import org.apache.druid.indexing.overlord.helpers.OverlordHelperManager;
import org.apache.druid.indexing.overlord.supervisor.SupervisorManager;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.coordinator.CoordinatorOverlordServiceConfig;
import org.apache.druid.server.metrics.TaskCountStatsProvider;
import org.apache.druid.server.metrics.TaskSlotCountStatsProvider;

public class TaskMaster
implements TaskCountStatsProvider,
TaskSlotCountStatsProvider {
    private static final EmittingLogger log = new EmittingLogger(TaskMaster.class);
    private final DruidLeaderSelector overlordLeaderSelector;
    private final DruidLeaderSelector.Listener leadershipListener;
    private final ReentrantLock giant = new ReentrantLock(true);
    private final TaskActionClientFactory taskActionClientFactory;
    private final SupervisorManager supervisorManager;
    private final AtomicReference<Lifecycle> leaderLifecycleRef = new AtomicReference<Object>(null);
    private volatile TaskRunner taskRunner;
    private volatile TaskQueue taskQueue;
    private volatile boolean initialized;

    @Inject
    public TaskMaster(final TaskLockConfig taskLockConfig, final TaskQueueConfig taskQueueConfig, final DefaultTaskConfig defaultTaskConfig, final TaskLockbox taskLockbox, final TaskStorage taskStorage, final TaskActionClientFactory taskActionClientFactory, @Self DruidNode selfNode, final TaskRunnerFactory runnerFactory, final ServiceAnnouncer serviceAnnouncer, CoordinatorOverlordServiceConfig coordinatorOverlordServiceConfig, final ServiceEmitter emitter, final SupervisorManager supervisorManager, final OverlordHelperManager overlordHelperManager, @IndexingService DruidLeaderSelector overlordLeaderSelector) {
        this.supervisorManager = supervisorManager;
        this.taskActionClientFactory = taskActionClientFactory;
        this.overlordLeaderSelector = overlordLeaderSelector;
        final DruidNode node = coordinatorOverlordServiceConfig.getOverlordService() == null ? selfNode : selfNode.withService(coordinatorOverlordServiceConfig.getOverlordService());
        this.leadershipListener = new DruidLeaderSelector.Listener(){

            public void becomeLeader() {
                TaskMaster.this.giant.lock();
                log.info("By the power of Grayskull, I have the power!", new Object[0]);
                try {
                    taskLockbox.syncFromStorage();
                    TaskMaster.this.taskRunner = runnerFactory.build();
                    TaskMaster.this.taskQueue = new TaskQueue(taskLockConfig, taskQueueConfig, defaultTaskConfig, taskStorage, TaskMaster.this.taskRunner, taskActionClientFactory, taskLockbox, emitter);
                    Lifecycle leaderLifecycle = new Lifecycle("task-master");
                    if (TaskMaster.this.leaderLifecycleRef.getAndSet(leaderLifecycle) != null) {
                        log.makeAlert("TaskMaster set a new Lifecycle without the old one being cleared!  Race condition", new Object[0]).emit();
                    }
                    leaderLifecycle.addManagedInstance((Object)TaskMaster.this.taskRunner);
                    leaderLifecycle.addManagedInstance((Object)TaskMaster.this.taskQueue);
                    leaderLifecycle.addManagedInstance((Object)supervisorManager);
                    leaderLifecycle.addManagedInstance((Object)overlordHelperManager);
                    leaderLifecycle.addHandler(new Lifecycle.Handler(){

                        public void start() {
                            TaskMaster.this.initialized = true;
                            serviceAnnouncer.announce(node);
                        }

                        public void stop() {
                            serviceAnnouncer.unannounce(node);
                        }
                    });
                    leaderLifecycle.start();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    TaskMaster.this.giant.unlock();
                }
            }

            public void stopBeingLeader() {
                TaskMaster.this.giant.lock();
                try {
                    TaskMaster.this.initialized = false;
                    Lifecycle leaderLifecycle = TaskMaster.this.leaderLifecycleRef.getAndSet(null);
                    if (leaderLifecycle != null) {
                        leaderLifecycle.stop();
                    }
                }
                finally {
                    TaskMaster.this.giant.unlock();
                }
            }
        };
    }

    @LifecycleStart
    public void start() {
        this.giant.lock();
        try {
            this.overlordLeaderSelector.registerListener(this.leadershipListener);
        }
        finally {
            this.giant.unlock();
        }
    }

    @LifecycleStop
    public void stop() {
        this.giant.lock();
        try {
            this.gracefulStopLeaderLifecycle();
            this.overlordLeaderSelector.unregisterListener();
        }
        finally {
            this.giant.unlock();
        }
    }

    public boolean isLeader() {
        return this.overlordLeaderSelector.isLeader() && this.initialized;
    }

    public String getCurrentLeader() {
        return this.overlordLeaderSelector.getCurrentLeader();
    }

    public Optional<String> getRedirectLocation() {
        String leader = this.overlordLeaderSelector.getCurrentLeader();
        if (leader == null || leader.isEmpty() || this.overlordLeaderSelector.isLeader()) {
            return Optional.absent();
        }
        return Optional.of((Object)leader);
    }

    public Optional<TaskRunner> getTaskRunner() {
        if (this.isLeader()) {
            return Optional.of((Object)this.taskRunner);
        }
        return Optional.absent();
    }

    public Optional<TaskQueue> getTaskQueue() {
        if (this.isLeader()) {
            return Optional.of((Object)this.taskQueue);
        }
        return Optional.absent();
    }

    public Optional<TaskActionClient> getTaskActionClient(Task task) {
        if (this.isLeader()) {
            return Optional.of((Object)this.taskActionClientFactory.create(task));
        }
        return Optional.absent();
    }

    public Optional<ScalingStats> getScalingStats() {
        if (this.isLeader()) {
            return this.taskRunner.getScalingStats();
        }
        return Optional.absent();
    }

    public Optional<SupervisorManager> getSupervisorManager() {
        if (this.isLeader()) {
            return Optional.of((Object)this.supervisorManager);
        }
        return Optional.absent();
    }

    public Map<String, Long> getSuccessfulTaskCount() {
        Optional<TaskQueue> taskQueue = this.getTaskQueue();
        if (taskQueue.isPresent()) {
            return ((TaskQueue)taskQueue.get()).getSuccessfulTaskCount();
        }
        return null;
    }

    public Map<String, Long> getFailedTaskCount() {
        Optional<TaskQueue> taskQueue = this.getTaskQueue();
        if (taskQueue.isPresent()) {
            return ((TaskQueue)taskQueue.get()).getFailedTaskCount();
        }
        return null;
    }

    public Map<String, Long> getRunningTaskCount() {
        Optional<TaskQueue> taskQueue = this.getTaskQueue();
        if (taskQueue.isPresent()) {
            return ((TaskQueue)taskQueue.get()).getRunningTaskCount();
        }
        return null;
    }

    public Map<String, Long> getPendingTaskCount() {
        Optional<TaskQueue> taskQueue = this.getTaskQueue();
        if (taskQueue.isPresent()) {
            return ((TaskQueue)taskQueue.get()).getPendingTaskCount();
        }
        return null;
    }

    public Map<String, Long> getWaitingTaskCount() {
        Optional<TaskQueue> taskQueue = this.getTaskQueue();
        if (taskQueue.isPresent()) {
            return ((TaskQueue)taskQueue.get()).getWaitingTaskCount();
        }
        return null;
    }

    private void gracefulStopLeaderLifecycle() {
        try {
            if (this.isLeader()) {
                this.leadershipListener.stopBeingLeader();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    public Map<String, Long> getTotalTaskSlotCount() {
        Optional<TaskRunner> taskRunner = this.getTaskRunner();
        if (taskRunner.isPresent()) {
            return ((TaskRunner)taskRunner.get()).getTotalTaskSlotCount();
        }
        return null;
    }

    @Nullable
    public Map<String, Long> getIdleTaskSlotCount() {
        Optional<TaskRunner> taskRunner = this.getTaskRunner();
        if (taskRunner.isPresent()) {
            return ((TaskRunner)taskRunner.get()).getIdleTaskSlotCount();
        }
        return null;
    }

    @Nullable
    public Map<String, Long> getUsedTaskSlotCount() {
        Optional<TaskRunner> taskRunner = this.getTaskRunner();
        if (taskRunner.isPresent()) {
            return ((TaskRunner)taskRunner.get()).getUsedTaskSlotCount();
        }
        return null;
    }

    @Nullable
    public Map<String, Long> getLazyTaskSlotCount() {
        Optional<TaskRunner> taskRunner = this.getTaskRunner();
        if (taskRunner.isPresent()) {
            return ((TaskRunner)taskRunner.get()).getLazyTaskSlotCount();
        }
        return null;
    }

    @Nullable
    public Map<String, Long> getBlacklistedTaskSlotCount() {
        Optional<TaskRunner> taskRunner = this.getTaskRunner();
        if (taskRunner.isPresent()) {
            return ((TaskRunner)taskRunner.get()).getBlacklistedTaskSlotCount();
        }
        return null;
    }
}

