/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.autoscaling;

import com.google.common.base.Supplier;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.druid.indexing.overlord.WorkerTaskRunner;
import org.apache.druid.indexing.overlord.autoscaling.Provisioner;
import org.apache.druid.indexing.overlord.autoscaling.ProvisioningSchedulerConfig;
import org.apache.druid.indexing.overlord.autoscaling.ProvisioningService;
import org.apache.druid.indexing.overlord.autoscaling.ProvisioningStrategy;
import org.apache.druid.indexing.overlord.autoscaling.ScalingStats;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.joda.time.Duration;
import org.joda.time.Period;

public abstract class AbstractWorkerProvisioningStrategy
implements ProvisioningStrategy<WorkerTaskRunner> {
    private static final EmittingLogger log = new EmittingLogger(AbstractWorkerProvisioningStrategy.class);
    private final ProvisioningSchedulerConfig provisioningSchedulerConfig;
    private final Supplier<ScheduledExecutorService> execFactory;

    AbstractWorkerProvisioningStrategy(ProvisioningSchedulerConfig provisioningSchedulerConfig, Supplier<ScheduledExecutorService> execFactory) {
        this.provisioningSchedulerConfig = provisioningSchedulerConfig;
        this.execFactory = execFactory;
    }

    @Override
    public ProvisioningService makeProvisioningService(WorkerTaskRunner runner) {
        return new WorkerProvisioningService(this.makeProvisioner(runner));
    }

    protected abstract Provisioner makeProvisioner(WorkerTaskRunner var1);

    final class WorkerProvisioningService
    implements ProvisioningService {
        private final ScheduledExecutorService exec;
        private final Provisioner provisioner;

        WorkerProvisioningService(final Provisioner provisioner) {
            this.exec = (ScheduledExecutorService)AbstractWorkerProvisioningStrategy.this.execFactory.get();
            log.info("Started Resource Management Scheduler", new Object[0]);
            this.provisioner = provisioner;
            long rate = AbstractWorkerProvisioningStrategy.this.provisioningSchedulerConfig.getProvisionPeriod().toStandardDuration().getMillis();
            this.exec.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        provisioner.doProvision();
                    }
                    catch (Exception e) {
                        log.error((Throwable)e, "Uncaught exception.", new Object[0]);
                    }
                }
            }, rate, rate, TimeUnit.MILLISECONDS);
            Period period = AbstractWorkerProvisioningStrategy.this.provisioningSchedulerConfig.getTerminatePeriod();
            PeriodGranularity granularity = new PeriodGranularity(period, AbstractWorkerProvisioningStrategy.this.provisioningSchedulerConfig.getOriginTime(), null);
            long startTime = granularity.bucketEnd(DateTimes.nowUtc()).getMillis();
            this.exec.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        provisioner.doTerminate();
                    }
                    catch (Exception e) {
                        log.error((Throwable)e, "Uncaught exception.", new Object[0]);
                    }
                }
            }, new Duration(System.currentTimeMillis(), startTime).getMillis(), AbstractWorkerProvisioningStrategy.this.provisioningSchedulerConfig.getTerminatePeriod().toStandardDuration().getMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public ScalingStats getStats() {
            return this.provisioner.getStats();
        }

        @Override
        public void close() {
            log.info("Stopping Resource Management Scheduler", new Object[0]);
            this.exec.shutdown();
        }
    }
}

