/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.Duration;
import org.joda.time.Period;

public class TaskQueueConfig {
    @JsonProperty
    private int maxSize;
    @JsonProperty
    private Duration startDelay;
    @JsonProperty
    private Duration restartDelay;
    @JsonProperty
    private Duration storageSyncRate;

    @JsonCreator
    public TaskQueueConfig(@JsonProperty(value="maxSize") Integer maxSize, @JsonProperty(value="startDelay") Period startDelay, @JsonProperty(value="restartDelay") Period restartDelay, @JsonProperty(value="storageSyncRate") Period storageSyncRate) {
        this.maxSize = maxSize == null ? Integer.MAX_VALUE : maxSize;
        this.startDelay = TaskQueueConfig.defaultDuration(startDelay, "PT1M");
        this.restartDelay = TaskQueueConfig.defaultDuration(restartDelay, "PT30S");
        this.storageSyncRate = TaskQueueConfig.defaultDuration(storageSyncRate, "PT1M");
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public Duration getStartDelay() {
        return this.startDelay;
    }

    public Duration getRestartDelay() {
        return this.restartDelay;
    }

    public Duration getStorageSyncRate() {
        return this.storageSyncRate;
    }

    private static Duration defaultDuration(Period period, String theDefault) {
        return (period == null ? new Period((Object)theDefault) : period).toStandardDuration();
    }
}

