/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.druid.client.indexing.SamplerResponse;
import org.apache.druid.client.indexing.SamplerSpec;
import org.apache.druid.data.input.ByteBufferInputRowParser;
import org.apache.druid.data.input.FiniteFirehoseFactory;
import org.apache.druid.data.input.Firehose;
import org.apache.druid.data.input.FirehoseFactoryToInputSourceAdaptor;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowListPlusRawValues;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.data.input.impl.ByteEntity;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.druid.indexing.overlord.sampler.InputSourceSampler;
import org.apache.druid.indexing.overlord.sampler.SamplerConfig;
import org.apache.druid.indexing.overlord.sampler.SamplerException;
import org.apache.druid.indexing.seekablestream.RecordSupplierInputSource;
import org.apache.druid.indexing.seekablestream.common.RecordSupplier;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisorIOConfig;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisorSpec;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisorTuningConfig;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.segment.indexing.DataSchema;

public abstract class SeekableStreamSamplerSpec<PartitionIdType, SequenceOffsetType, RecordType extends ByteEntity>
implements SamplerSpec {
    static final long POLL_TIMEOUT_MS = 100L;
    @Nullable
    private final DataSchema dataSchema;
    private final InputSourceSampler inputSourceSampler;
    protected final SeekableStreamSupervisorIOConfig ioConfig;
    @Nullable
    protected final SeekableStreamSupervisorTuningConfig tuningConfig;
    protected final SamplerConfig samplerConfig;

    public SeekableStreamSamplerSpec(SeekableStreamSupervisorSpec ingestionSpec, @Nullable SamplerConfig samplerConfig, InputSourceSampler inputSourceSampler) {
        this.dataSchema = ((SeekableStreamSupervisorSpec)Preconditions.checkNotNull((Object)ingestionSpec, (Object)"[spec] is required")).getDataSchema();
        this.ioConfig = (SeekableStreamSupervisorIOConfig)Preconditions.checkNotNull((Object)ingestionSpec.getIoConfig(), (Object)"[spec.ioConfig] is required");
        this.tuningConfig = ingestionSpec.getTuningConfig();
        this.samplerConfig = samplerConfig == null ? SamplerConfig.empty() : samplerConfig;
        this.inputSourceSampler = inputSourceSampler;
    }

    public SamplerResponse sample() {
        InputFormat inputFormat;
        Object inputSource;
        if (this.dataSchema.getParser() != null) {
            inputSource = new FirehoseFactoryToInputSourceAdaptor((FiniteFirehoseFactory)new SeekableStreamSamplerFirehoseFactory(), this.dataSchema.getParser());
            inputFormat = null;
        } else {
            RecordSupplier<PartitionIdType, SequenceOffsetType, RecordType> recordSupplier;
            try {
                recordSupplier = this.createRecordSupplier();
            }
            catch (Exception e) {
                throw new SamplerException(e, "Unable to create RecordSupplier: %s", Throwables.getRootCause((Throwable)e).getMessage());
            }
            inputSource = new RecordSupplierInputSource<PartitionIdType, SequenceOffsetType, RecordType>(this.ioConfig.getStream(), recordSupplier, this.ioConfig.isUseEarliestSequenceNumber());
            inputFormat = (InputFormat)Preconditions.checkNotNull((Object)this.ioConfig.getInputFormat(), (Object)"[spec.ioConfig.inputFormat] is required");
        }
        return this.inputSourceSampler.sample((InputSource)inputSource, inputFormat, this.dataSchema, this.samplerConfig);
    }

    protected abstract RecordSupplier<PartitionIdType, SequenceOffsetType, RecordType> createRecordSupplier();

    private class SeekableStreamSamplerFirehose
    implements Firehose {
        private final InputRowParser parser;
        private final CloseableIterator<InputEntity> entityIterator;

        protected SeekableStreamSamplerFirehose(InputRowParser parser) {
            this.parser = parser;
            if (parser instanceof StringInputRowParser) {
                ((StringInputRowParser)parser).startFileFromBeginning();
            }
            RecordSupplierInputSource inputSource = new RecordSupplierInputSource(SeekableStreamSamplerSpec.this.ioConfig.getStream(), SeekableStreamSamplerSpec.this.createRecordSupplier(), SeekableStreamSamplerSpec.this.ioConfig.isUseEarliestSequenceNumber());
            this.entityIterator = inputSource.createEntityIterator();
        }

        public boolean hasMore() {
            return this.entityIterator.hasNext();
        }

        public InputRow nextRow() {
            throw new UnsupportedOperationException();
        }

        public InputRowListPlusRawValues nextRowWithRaw() {
            Map rawColumns;
            ByteBuffer bb = ((ByteEntity)this.entityIterator.next()).getBuffer();
            try {
                rawColumns = this.parser instanceof StringInputRowParser ? ((StringInputRowParser)this.parser).buildStringKeyMap(bb) : null;
            }
            catch (ParseException e) {
                return InputRowListPlusRawValues.of(null, (ParseException)e);
            }
            try {
                List rows = this.parser.parseBatch((Object)bb);
                return InputRowListPlusRawValues.of((List)(rows.isEmpty() ? null : rows), (Map)rawColumns);
            }
            catch (ParseException e) {
                return InputRowListPlusRawValues.of((Map)rawColumns, (ParseException)e);
            }
        }

        public void close() throws IOException {
            this.entityIterator.close();
        }
    }

    private class SeekableStreamSamplerFirehoseFactory
    implements FiniteFirehoseFactory<ByteBufferInputRowParser, Object> {
        private SeekableStreamSamplerFirehoseFactory() {
        }

        public Firehose connect(ByteBufferInputRowParser parser, @Nullable File temporaryDirectory) {
            throw new UnsupportedOperationException();
        }

        public Firehose connectForSampler(ByteBufferInputRowParser parser, @Nullable File temporaryDirectory) {
            return new SeekableStreamSamplerFirehose((InputRowParser)parser);
        }

        public boolean isSplittable() {
            return false;
        }

        public Stream<InputSplit<Object>> getSplits(@Nullable SplitHintSpec splitHintSpec) {
            throw new UnsupportedOperationException();
        }

        public int getNumSplits(@Nullable SplitHintSpec splitHintSpec) {
            throw new UnsupportedOperationException();
        }

        public FiniteFirehoseFactory withSplit(InputSplit split) {
            throw new UnsupportedOperationException();
        }
    }
}

