/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.AbstractTask;
import org.apache.druid.indexing.common.task.Task;

public class TestTasks {
    private static final String DATASOURCE = "dummyDs";

    public static void registerSubtypes(ObjectMapper mapper) {
        mapper.registerSubtypes(new Class[]{ImmediateSuccessTask.class, UnendingTask.class});
    }

    public static Task immediateSuccess(String id) {
        return new ImmediateSuccessTask(id);
    }

    public static Task unending(String id) {
        return new UnendingTask(id);
    }

    @JsonTypeName(value="unending")
    public static class UnendingTask
    extends AbstractTask {
        @JsonCreator
        public UnendingTask(@JsonProperty(value="id") String id) {
            super(id, TestTasks.DATASOURCE, null);
        }

        public String getType() {
            return "unending";
        }

        public boolean isReady(TaskActionClient taskActionClient) {
            return true;
        }

        public void stopGracefully(TaskConfig taskConfig) {
        }

        public TaskStatus run(TaskToolbox toolbox) throws Exception {
            while (!Thread.currentThread().isInterrupted()) {
                Thread.sleep(1000L);
            }
            return TaskStatus.failure((String)this.getId(), (String)"Dummy task status failure for testing");
        }
    }

    @JsonTypeName(value="immediateSuccess")
    public static class ImmediateSuccessTask
    extends AbstractTask {
        @JsonCreator
        public ImmediateSuccessTask(@JsonProperty(value="id") String id) {
            super(id, TestTasks.DATASOURCE, null);
        }

        public String getType() {
            return "immediateSuccess";
        }

        public boolean isReady(TaskActionClient taskActionClient) {
            return true;
        }

        public void stopGracefully(TaskConfig taskConfig) {
        }

        public TaskStatus run(TaskToolbox toolbox) {
            return TaskStatus.success((String)this.getId());
        }
    }
}

