/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.druid.client.indexing.NoopOverlordClient;
import org.apache.druid.data.input.impl.NoopInputFormat;
import org.apache.druid.data.input.impl.NoopInputSource;
import org.apache.druid.guice.DruidSecondaryModule;
import org.apache.druid.guice.FirehoseModule;
import org.apache.druid.indexing.common.IndexingServiceCondition;
import org.apache.druid.indexing.common.stats.DropwizardRowIngestionMetersFactory;
import org.apache.druid.indexing.common.task.IndexTaskClientFactory;
import org.apache.druid.indexing.common.task.TestAppenderatorsManager;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTaskClientProvider;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.expression.LookupEnabledTestExprMacroTable;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.IndexMergerV9Factory;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.incremental.RowIngestionMetersFactory;
import org.apache.druid.segment.loading.LocalDataSegmentPuller;
import org.apache.druid.segment.loading.LocalLoadSpec;
import org.apache.druid.segment.realtime.appenderator.AppenderatorsManager;
import org.apache.druid.segment.realtime.firehose.ChatHandlerProvider;
import org.apache.druid.segment.realtime.firehose.NoopChatHandlerProvider;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.timeline.DataSegment;

public class TestUtils {
    public static final OverlordClient OVERLORD_SERVICE_CLIENT = new NoopOverlordClient();
    public static final ParallelIndexSupervisorTaskClientProvider TASK_CLIENT_PROVIDER = (supervisorTaskId, httpTimeout, numRetries) -> {
        throw new UnsupportedOperationException();
    };
    public static final AppenderatorsManager APPENDERATORS_MANAGER = new TestAppenderatorsManager();
    private static final Logger log = new Logger(TestUtils.class);
    private final ObjectMapper jsonMapper = new DefaultObjectMapper();
    private final IndexMergerV9Factory indexMergerV9Factory;
    private final IndexIO indexIO = new IndexIO(this.jsonMapper, () -> 0);
    private final RowIngestionMetersFactory rowIngestionMetersFactory;

    public TestUtils() {
        this.indexMergerV9Factory = new IndexMergerV9Factory(this.jsonMapper, this.indexIO, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance());
        this.rowIngestionMetersFactory = new DropwizardRowIngestionMetersFactory();
        this.jsonMapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ExprMacroTable.class, (Object)LookupEnabledTestExprMacroTable.INSTANCE).addValue(IndexIO.class, (Object)this.indexIO).addValue(ObjectMapper.class, (Object)this.jsonMapper).addValue(ChatHandlerProvider.class, (Object)new NoopChatHandlerProvider()).addValue(AuthConfig.class, (Object)new AuthConfig()).addValue(AuthorizerMapper.class, null).addValue(RowIngestionMetersFactory.class, (Object)this.rowIngestionMetersFactory).addValue(DataSegment.PruneSpecsHolder.class, (Object)DataSegment.PruneSpecsHolder.DEFAULT).addValue(IndexingServiceClient.class, (Object)OVERLORD_SERVICE_CLIENT).addValue(AuthorizerMapper.class, (Object)new AuthorizerMapper((Map)ImmutableMap.of())).addValue(AppenderatorsManager.class, (Object)APPENDERATORS_MANAGER).addValue(LocalDataSegmentPuller.class, (Object)new LocalDataSegmentPuller()).addValue(IndexTaskClientFactory.class, (Object)TASK_CLIENT_PROVIDER));
        this.jsonMapper.registerModule((Module)new SimpleModule(){

            public void setupModule(Module.SetupContext context) {
                context.registerSubtypes(new NamedType[]{new NamedType(LocalLoadSpec.class, "local"), new NamedType(NoopInputSource.class, "noop"), new NamedType(NoopInputFormat.class, "noop")});
            }
        });
        DruidSecondaryModule.setupAnnotationIntrospector((ObjectMapper)this.jsonMapper, (AnnotationIntrospector)TestHelper.makeAnnotationIntrospector());
        List firehoseModules = new FirehoseModule().getJacksonModules();
        firehoseModules.forEach(arg_0 -> ((ObjectMapper)this.jsonMapper).registerModule(arg_0));
    }

    public ObjectMapper getTestObjectMapper() {
        return this.jsonMapper;
    }

    public IndexMergerV9 getTestIndexMergerV9() {
        return this.indexMergerV9Factory.create(true);
    }

    public IndexMergerV9Factory getIndexMergerV9Factory() {
        return this.indexMergerV9Factory;
    }

    public IndexIO getTestIndexIO() {
        return this.indexIO;
    }

    public RowIngestionMetersFactory getRowIngestionMetersFactory() {
        return this.rowIngestionMetersFactory;
    }

    public static boolean conditionValid(IndexingServiceCondition condition) {
        return TestUtils.conditionValid(condition, 1000L);
    }

    public static boolean conditionValid(IndexingServiceCondition condition, long timeout) {
        try {
            Stopwatch stopwatch = Stopwatch.createUnstarted();
            stopwatch.start();
            while (!condition.isValid()) {
                Thread.sleep(100L);
                if (stopwatch.elapsed(TimeUnit.MILLISECONDS) <= timeout) continue;
                throw new ISE("Condition[%s] not met", new Object[]{condition});
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Condition[%s] not met within timeout[%,d]", new Object[]{condition, timeout});
            return false;
        }
        return true;
    }
}

