/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.druid.indexing.common.actions.RetrieveUnusedSegmentsAction;
import org.apache.druid.indexing.common.actions.RetrieveUsedSegmentsAction;
import org.apache.druid.indexing.common.actions.TaskActionTestKit;
import org.apache.druid.indexing.common.task.NoopTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.Segments;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class RetrieveSegmentsActionsTest {
    private static final Interval INTERVAL = Intervals.of((String)"2017-10-01/2017-10-15");
    @Rule
    public TaskActionTestKit actionTestKit = new TaskActionTestKit();
    private Task task;
    private Set<DataSegment> expectedUnusedSegments;
    private Set<DataSegment> expectedUsedSegments;

    @Before
    public void setup() throws IOException {
        this.task = NoopTask.create();
        this.actionTestKit.getTaskLockbox().add(this.task);
        this.expectedUnusedSegments = new HashSet<DataSegment>();
        this.expectedUnusedSegments.add(this.createSegment(Intervals.of((String)"2017-10-05/2017-10-06"), "1"));
        this.expectedUnusedSegments.add(this.createSegment(Intervals.of((String)"2017-10-06/2017-10-07"), "1"));
        this.expectedUnusedSegments.add(this.createSegment(Intervals.of((String)"2017-10-07/2017-10-08"), "1"));
        this.actionTestKit.getMetadataStorageCoordinator().announceHistoricalSegments(this.expectedUnusedSegments);
        this.expectedUnusedSegments.forEach(s -> this.actionTestKit.getTaskLockbox().unlock(this.task, s.getInterval()));
        this.expectedUsedSegments = new HashSet<DataSegment>();
        this.expectedUsedSegments.add(this.createSegment(Intervals.of((String)"2017-10-05/2017-10-06"), "2"));
        this.expectedUsedSegments.add(this.createSegment(Intervals.of((String)"2017-10-06/2017-10-07"), "2"));
        this.expectedUsedSegments.add(this.createSegment(Intervals.of((String)"2017-10-07/2017-10-08"), "2"));
        this.actionTestKit.getMetadataStorageCoordinator().announceHistoricalSegments(this.expectedUsedSegments);
        this.expectedUsedSegments.forEach(s -> this.actionTestKit.getTaskLockbox().unlock(this.task, s.getInterval()));
        this.expectedUnusedSegments.forEach(s -> this.actionTestKit.getSegmentsMetadataManager().markSegmentAsUnused(s.getId()));
    }

    private DataSegment createSegment(Interval interval, String version) {
        return new DataSegment(this.task.getDataSource(), interval, version, null, (List)ImmutableList.of((Object)"dim1", (Object)"dim2"), (List)ImmutableList.of((Object)"met1", (Object)"met2"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(version), 1L);
    }

    @Test
    public void testRetrieveUsedSegmentsAction() {
        RetrieveUsedSegmentsAction action = new RetrieveUsedSegmentsAction(this.task.getDataSource(), INTERVAL, null, Segments.ONLY_VISIBLE);
        HashSet resultSegments = new HashSet(action.perform(this.task, this.actionTestKit.getTaskActionToolbox()));
        Assert.assertEquals(this.expectedUsedSegments, resultSegments);
    }

    @Test
    public void testRetrieveUnusedSegmentsAction() {
        RetrieveUnusedSegmentsAction action = new RetrieveUnusedSegmentsAction(this.task.getDataSource(), INTERVAL);
        HashSet resultSegments = new HashSet(action.perform(this.task, this.actionTestKit.getTaskActionToolbox()));
        Assert.assertEquals(this.expectedUnusedSegments, resultSegments);
    }
}

