/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.stats;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.indexing.common.stats.TaskRealtimeMetricsMonitor;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.segment.incremental.NoopRowIngestionMeters;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.realtime.FireDepartment;
import org.apache.druid.segment.realtime.FireDepartmentMetrics;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TaskRealtimeMetricsMonitorTest {
    private ServiceEmitter emitter;
    private FireDepartment fireDepartment;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setup() {
        this.emitter = (ServiceEmitter)EasyMock.mock(ServiceEmitter.class);
        this.fireDepartment = (FireDepartment)EasyMock.mock(FireDepartment.class);
    }

    @Test
    public void testLastRoundMetricsEmission() {
        FireDepartmentMetrics metrics = new FireDepartmentMetrics();
        NoopRowIngestionMeters rowIngestionMeters = new NoopRowIngestionMeters();
        DataSchema schema = new DataSchema("dataSource", null, null, null, null, null, null, null);
        EasyMock.expect((Object)this.fireDepartment.getMetrics()).andReturn((Object)metrics);
        EasyMock.expectLastCall().times(2);
        EasyMock.expect((Object)this.fireDepartment.getDataSchema()).andReturn((Object)schema);
        EasyMock.expectLastCall().times(2);
        EasyMock.replay((Object[])new Object[]{this.fireDepartment});
        TaskRealtimeMetricsMonitor monitor = new TaskRealtimeMetricsMonitor(this.fireDepartment, (RowIngestionMeters)rowIngestionMeters, (Map)ImmutableMap.of());
        Assert.assertFalse((boolean)monitor.isStarted());
        boolean zerothRound = monitor.monitor(this.emitter);
        monitor.start();
        Assert.assertTrue((boolean)monitor.isStarted());
        boolean firstRound = monitor.monitor(this.emitter);
        monitor.stop();
        Assert.assertFalse((boolean)monitor.isStarted());
        boolean secondRound = monitor.monitor(this.emitter);
        boolean thirdRound = monitor.monitor(this.emitter);
        Assert.assertFalse((boolean)zerothRound);
        Assert.assertTrue((firstRound && secondRound ? 1 : 0) != 0);
        Assert.assertFalse((boolean)thirdRound);
        EasyMock.verify((Object[])new Object[]{this.fireDepartment});
    }
}

