/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.client.indexing.ClientCompactionTaskGranularitySpec;
import org.apache.druid.client.indexing.ClientCompactionTaskTransformSpec;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.SegmentsSplitHintSpec;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.data.input.impl.CsvInputFormat;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.LocalInputSource;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.partitions.DimensionRangePartitionsSpec;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexer.partitions.SingleDimensionPartitionsSpec;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.RetryPolicyConfig;
import org.apache.druid.indexing.common.RetryPolicyFactory;
import org.apache.druid.indexing.common.task.CompactionInputSpec;
import org.apache.druid.indexing.common.task.CompactionIntervalSpec;
import org.apache.druid.indexing.common.task.CompactionTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.batch.parallel.AbstractParallelIndexSupervisorTaskTest;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIOConfig;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTask;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.indexing.firehose.WindowedSegmentId;
import org.apache.druid.indexing.input.DruidInputSource;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.TuningConfig;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.druid.timeline.CompactionState;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.DimensionRangeShardSpec;
import org.apache.druid.timeline.partition.HashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.NumberedOverwriteShardSpec;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.SingleDimensionShardSpec;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CompactionTaskParallelRunTest
extends AbstractParallelIndexSupervisorTaskTest {
    private static final String DATA_SOURCE = "test";
    private static final RetryPolicyFactory RETRY_POLICY_FACTORY = new RetryPolicyFactory(new RetryPolicyConfig());
    private static final Interval INTERVAL_TO_INDEX = Intervals.of((String)"2014-01-01/2014-01-02");
    private final LockGranularity lockGranularity;
    private File inputDir;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{LockGranularity.TIME_CHUNK}, (Object)new Object[]{LockGranularity.SEGMENT});
    }

    public CompactionTaskParallelRunTest(LockGranularity lockGranularity) {
        super(0.2, 0.2);
        this.lockGranularity = lockGranularity;
    }

    @Before
    public void setup() throws IOException {
        this.getObjectMapper().registerSubtypes(new Class[]{ParallelIndexTuningConfig.class, DruidInputSource.class});
        this.getObjectMapper().registerSubtypes(new Class[]{CompactionTask.CompactionTuningConfig.class, DruidInputSource.class});
        this.inputDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("druid", "index", this.inputDir);
        try (BufferedWriter writer = Files.newWriter((File)tmpFile, (Charset)StandardCharsets.UTF_8);){
            writer.write("2014-01-01T00:00:10Z,a,1\n");
            writer.write("2014-01-01T00:00:10Z,b,2\n");
            writer.write("2014-01-01T00:00:10Z,c,3\n");
            writer.write("2014-01-01T01:00:20Z,a,1\n");
            writer.write("2014-01-01T01:00:20Z,b,2\n");
            writer.write("2014-01-01T01:00:20Z,c,3\n");
            writer.write("2014-01-01T02:00:30Z,a,1\n");
            writer.write("2014-01-01T02:00:30Z,b,2\n");
            writer.write("2014-01-01T02:00:30Z,c,3\n");
        }
    }

    @Test
    public void testRunParallelWithDynamicPartitioningMatchCompactionState() throws Exception {
        this.runIndexTask(null, true);
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.getSegmentCacheManagerFactory(), RETRY_POLICY_FACTORY);
        CompactionTask compactionTask = builder.inputSpec((CompactionInputSpec)new CompactionIntervalSpec(INTERVAL_TO_INDEX, null)).tuningConfig((TuningConfig)AbstractParallelIndexSupervisorTaskTest.DEFAULT_TUNING_CONFIG_FOR_PARALLEL_INDEXING).build();
        Set<DataSegment> compactedSegments = this.runTask((Task)compactionTask);
        for (DataSegment segment : compactedSegments) {
            Assert.assertSame(this.lockGranularity == LockGranularity.TIME_CHUNK ? NumberedShardSpec.class : NumberedOverwriteShardSpec.class, segment.getShardSpec().getClass());
            HashMap<String, String> expectedLongSumMetric = new HashMap<String, String>();
            expectedLongSumMetric.put("type", "longSum");
            expectedLongSumMetric.put("name", "val");
            expectedLongSumMetric.put("fieldName", "val");
            CompactionState expectedState = new CompactionState((PartitionsSpec)new DynamicPartitionsSpec(null, Long.valueOf(Long.MAX_VALUE)), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"ts", (Object)"dim"))), (List)ImmutableList.of(expectedLongSumMetric), null, compactionTask.getTuningConfig().getIndexSpec().asMap(this.getObjectMapper()), (Map)this.getObjectMapper().readValue(this.getObjectMapper().writeValueAsString((Object)new UniformGranularitySpec(Granularities.HOUR, Granularities.MINUTE, Boolean.valueOf(true), (List)ImmutableList.of((Object)segment.getInterval()))), Map.class));
            Assert.assertEquals((Object)expectedState, (Object)segment.getLastCompactionState());
        }
    }

    @Test
    public void testRunParallelWithHashPartitioningMatchCompactionState() throws Exception {
        Assume.assumeFalse((this.lockGranularity == LockGranularity.SEGMENT ? 1 : 0) != 0);
        this.runIndexTask(null, true);
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.getSegmentCacheManagerFactory(), RETRY_POLICY_FACTORY);
        CompactionTask compactionTask = builder.inputSpec((CompactionInputSpec)new CompactionIntervalSpec(INTERVAL_TO_INDEX, null)).tuningConfig((TuningConfig)this.newTuningConfig((PartitionsSpec)new HashedPartitionsSpec(null, Integer.valueOf(3), null), 2, true)).build();
        Set<DataSegment> compactedSegments = this.runTask((Task)compactionTask);
        for (DataSegment segment : compactedSegments) {
            HashMap<String, String> expectedLongSumMetric = new HashMap<String, String>();
            expectedLongSumMetric.put("type", "longSum");
            expectedLongSumMetric.put("name", "val");
            expectedLongSumMetric.put("fieldName", "val");
            Assert.assertSame(HashBasedNumberedShardSpec.class, segment.getShardSpec().getClass());
            CompactionState expectedState = new CompactionState((PartitionsSpec)new HashedPartitionsSpec(null, Integer.valueOf(3), null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"ts", (Object)"dim"))), (List)ImmutableList.of(expectedLongSumMetric), null, compactionTask.getTuningConfig().getIndexSpec().asMap(this.getObjectMapper()), (Map)this.getObjectMapper().readValue(this.getObjectMapper().writeValueAsString((Object)new UniformGranularitySpec(Granularities.HOUR, Granularities.MINUTE, Boolean.valueOf(true), (List)ImmutableList.of((Object)segment.getInterval()))), Map.class));
            Assert.assertEquals((Object)expectedState, (Object)segment.getLastCompactionState());
        }
    }

    @Test
    public void testRunParallelWithRangePartitioning() throws Exception {
        Assume.assumeFalse((this.lockGranularity == LockGranularity.SEGMENT ? 1 : 0) != 0);
        this.runIndexTask(null, true);
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.getSegmentCacheManagerFactory(), RETRY_POLICY_FACTORY);
        CompactionTask compactionTask = builder.inputSpec((CompactionInputSpec)new CompactionIntervalSpec(INTERVAL_TO_INDEX, null)).tuningConfig((TuningConfig)this.newTuningConfig((PartitionsSpec)new SingleDimensionPartitionsSpec(Integer.valueOf(7), null, "dim", false), 2, true)).build();
        Set<DataSegment> compactedSegments = this.runTask((Task)compactionTask);
        for (DataSegment segment : compactedSegments) {
            HashMap<String, String> expectedLongSumMetric = new HashMap<String, String>();
            expectedLongSumMetric.put("type", "longSum");
            expectedLongSumMetric.put("name", "val");
            expectedLongSumMetric.put("fieldName", "val");
            Assert.assertSame(SingleDimensionShardSpec.class, segment.getShardSpec().getClass());
            CompactionState expectedState = new CompactionState((PartitionsSpec)new SingleDimensionPartitionsSpec(Integer.valueOf(7), null, "dim", false), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"ts", (Object)"dim"))), (List)ImmutableList.of(expectedLongSumMetric), null, compactionTask.getTuningConfig().getIndexSpec().asMap(this.getObjectMapper()), (Map)this.getObjectMapper().readValue(this.getObjectMapper().writeValueAsString((Object)new UniformGranularitySpec(Granularities.HOUR, Granularities.MINUTE, Boolean.valueOf(true), (List)ImmutableList.of((Object)segment.getInterval()))), Map.class));
            Assert.assertEquals((Object)expectedState, (Object)segment.getLastCompactionState());
        }
    }

    @Test
    public void testRunParallelWithMultiDimensionRangePartitioning() throws Exception {
        Assume.assumeFalse((this.lockGranularity == LockGranularity.SEGMENT ? 1 : 0) != 0);
        this.runIndexTask(null, true);
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.getSegmentCacheManagerFactory(), RETRY_POLICY_FACTORY);
        CompactionTask compactionTask = builder.inputSpec((CompactionInputSpec)new CompactionIntervalSpec(INTERVAL_TO_INDEX, null)).tuningConfig((TuningConfig)this.newTuningConfig((PartitionsSpec)new DimensionRangePartitionsSpec(Integer.valueOf(7), null, Arrays.asList("dim1", "dim2"), false), 2, true)).build();
        Set<DataSegment> compactedSegments = this.runTask((Task)compactionTask);
        for (DataSegment segment : compactedSegments) {
            HashMap<String, String> expectedLongSumMetric = new HashMap<String, String>();
            expectedLongSumMetric.put("type", "longSum");
            expectedLongSumMetric.put("name", "val");
            expectedLongSumMetric.put("fieldName", "val");
            Assert.assertSame(DimensionRangeShardSpec.class, segment.getShardSpec().getClass());
            CompactionState expectedState = new CompactionState((PartitionsSpec)new DimensionRangePartitionsSpec(Integer.valueOf(7), null, Arrays.asList("dim1", "dim2"), false), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"ts", (Object)"dim"))), (List)ImmutableList.of(expectedLongSumMetric), null, compactionTask.getTuningConfig().getIndexSpec().asMap(this.getObjectMapper()), (Map)this.getObjectMapper().readValue(this.getObjectMapper().writeValueAsString((Object)new UniformGranularitySpec(Granularities.HOUR, Granularities.MINUTE, Boolean.valueOf(true), (List)ImmutableList.of((Object)segment.getInterval()))), Map.class));
            Assert.assertEquals((Object)expectedState, (Object)segment.getLastCompactionState());
        }
    }

    @Test
    public void testRunParallelWithRangePartitioningWithSingleTask() throws Exception {
        Assume.assumeFalse((this.lockGranularity == LockGranularity.SEGMENT ? 1 : 0) != 0);
        this.runIndexTask(null, true);
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.getSegmentCacheManagerFactory(), RETRY_POLICY_FACTORY);
        CompactionTask compactionTask = builder.inputSpec((CompactionInputSpec)new CompactionIntervalSpec(INTERVAL_TO_INDEX, null)).tuningConfig((TuningConfig)this.newTuningConfig((PartitionsSpec)new SingleDimensionPartitionsSpec(Integer.valueOf(7), null, "dim", false), 1, true)).build();
        Set<DataSegment> compactedSegments = this.runTask((Task)compactionTask);
        for (DataSegment segment : compactedSegments) {
            HashMap<String, String> expectedLongSumMetric = new HashMap<String, String>();
            expectedLongSumMetric.put("type", "longSum");
            expectedLongSumMetric.put("name", "val");
            expectedLongSumMetric.put("fieldName", "val");
            Assert.assertSame(SingleDimensionShardSpec.class, segment.getShardSpec().getClass());
            CompactionState expectedState = new CompactionState((PartitionsSpec)new SingleDimensionPartitionsSpec(Integer.valueOf(7), null, "dim", false), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"ts", (Object)"dim"))), (List)ImmutableList.of(expectedLongSumMetric), null, compactionTask.getTuningConfig().getIndexSpec().asMap(this.getObjectMapper()), (Map)this.getObjectMapper().readValue(this.getObjectMapper().writeValueAsString((Object)new UniformGranularitySpec(Granularities.HOUR, Granularities.MINUTE, Boolean.valueOf(true), (List)ImmutableList.of((Object)segment.getInterval()))), Map.class));
            Assert.assertEquals((Object)expectedState, (Object)segment.getLastCompactionState());
        }
    }

    @Test
    public void testRunParallelWithMultiDimensionRangePartitioningWithSingleTask() throws Exception {
        Assume.assumeFalse((this.lockGranularity == LockGranularity.SEGMENT ? 1 : 0) != 0);
        this.runIndexTask(null, true);
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.getSegmentCacheManagerFactory(), RETRY_POLICY_FACTORY);
        CompactionTask compactionTask = builder.inputSpec((CompactionInputSpec)new CompactionIntervalSpec(INTERVAL_TO_INDEX, null)).tuningConfig((TuningConfig)this.newTuningConfig((PartitionsSpec)new DimensionRangePartitionsSpec(Integer.valueOf(7), null, Arrays.asList("dim1", "dim2"), false), 1, true)).build();
        Set<DataSegment> compactedSegments = this.runTask((Task)compactionTask);
        for (DataSegment segment : compactedSegments) {
            HashMap<String, String> expectedLongSumMetric = new HashMap<String, String>();
            expectedLongSumMetric.put("type", "longSum");
            expectedLongSumMetric.put("name", "val");
            expectedLongSumMetric.put("fieldName", "val");
            Assert.assertSame(DimensionRangeShardSpec.class, segment.getShardSpec().getClass());
            CompactionState expectedState = new CompactionState((PartitionsSpec)new DimensionRangePartitionsSpec(Integer.valueOf(7), null, Arrays.asList("dim1", "dim2"), false), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"ts", (Object)"dim"))), (List)ImmutableList.of(expectedLongSumMetric), null, compactionTask.getTuningConfig().getIndexSpec().asMap(this.getObjectMapper()), (Map)this.getObjectMapper().readValue(this.getObjectMapper().writeValueAsString((Object)new UniformGranularitySpec(Granularities.HOUR, Granularities.MINUTE, Boolean.valueOf(true), (List)ImmutableList.of((Object)segment.getInterval()))), Map.class));
            Assert.assertEquals((Object)expectedState, (Object)segment.getLastCompactionState());
        }
    }

    @Test
    public void testRunCompactionStateNotStoreIfContextSetToFalse() {
        this.runIndexTask(null, true);
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.getSegmentCacheManagerFactory(), RETRY_POLICY_FACTORY);
        CompactionTask compactionTask = builder.inputSpec((CompactionInputSpec)new CompactionIntervalSpec(INTERVAL_TO_INDEX, null)).tuningConfig((TuningConfig)AbstractParallelIndexSupervisorTaskTest.DEFAULT_TUNING_CONFIG_FOR_PARALLEL_INDEXING).context((Map)ImmutableMap.of((Object)"storeCompactionState", (Object)false)).build();
        Set<DataSegment> compactedSegments = this.runTask((Task)compactionTask);
        for (DataSegment segment : compactedSegments) {
            Assert.assertSame(this.lockGranularity == LockGranularity.TIME_CHUNK ? NumberedShardSpec.class : NumberedOverwriteShardSpec.class, segment.getShardSpec().getClass());
            Assert.assertEquals(null, (Object)segment.getLastCompactionState());
        }
    }

    @Test
    public void testRunCompactionWithFilterShouldStoreInState() throws Exception {
        this.runIndexTask(null, true);
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.getSegmentCacheManagerFactory(), RETRY_POLICY_FACTORY);
        CompactionTask compactionTask = builder.inputSpec((CompactionInputSpec)new CompactionIntervalSpec(INTERVAL_TO_INDEX, null)).tuningConfig((TuningConfig)AbstractParallelIndexSupervisorTaskTest.DEFAULT_TUNING_CONFIG_FOR_PARALLEL_INDEXING).transformSpec(new ClientCompactionTaskTransformSpec((DimFilter)new SelectorDimFilter("dim", "a", null))).build();
        Set<DataSegment> compactedSegments = this.runTask((Task)compactionTask);
        Assert.assertEquals((long)3L, (long)compactedSegments.size());
        for (DataSegment segment : compactedSegments) {
            Assert.assertSame(this.lockGranularity == LockGranularity.TIME_CHUNK ? NumberedShardSpec.class : NumberedOverwriteShardSpec.class, segment.getShardSpec().getClass());
            HashMap<String, String> expectedLongSumMetric = new HashMap<String, String>();
            expectedLongSumMetric.put("type", "longSum");
            expectedLongSumMetric.put("name", "val");
            expectedLongSumMetric.put("fieldName", "val");
            CompactionState expectedState = new CompactionState((PartitionsSpec)new DynamicPartitionsSpec(null, Long.valueOf(Long.MAX_VALUE)), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"ts", (Object)"dim"))), (List)ImmutableList.of(expectedLongSumMetric), (Map)this.getObjectMapper().readValue(this.getObjectMapper().writeValueAsString((Object)compactionTask.getTransformSpec()), Map.class), compactionTask.getTuningConfig().getIndexSpec().asMap(this.getObjectMapper()), (Map)this.getObjectMapper().readValue(this.getObjectMapper().writeValueAsString((Object)new UniformGranularitySpec(Granularities.HOUR, Granularities.MINUTE, Boolean.valueOf(true), (List)ImmutableList.of((Object)segment.getInterval()))), Map.class));
            Assert.assertEquals((Object)expectedState, (Object)segment.getLastCompactionState());
        }
    }

    @Test
    public void testRunCompactionWithNewMetricsShouldStoreInState() throws Exception {
        this.runIndexTask(null, true);
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.getSegmentCacheManagerFactory(), RETRY_POLICY_FACTORY);
        CompactionTask compactionTask = builder.inputSpec((CompactionInputSpec)new CompactionIntervalSpec(INTERVAL_TO_INDEX, null)).tuningConfig((TuningConfig)AbstractParallelIndexSupervisorTaskTest.DEFAULT_TUNING_CONFIG_FOR_PARALLEL_INDEXING).metricsSpec(new AggregatorFactory[]{new CountAggregatorFactory("cnt"), new LongSumAggregatorFactory("val", "val")}).build();
        Set<DataSegment> compactedSegments = this.runTask((Task)compactionTask);
        Assert.assertEquals((long)3L, (long)compactedSegments.size());
        for (DataSegment segment : compactedSegments) {
            Assert.assertSame(this.lockGranularity == LockGranularity.TIME_CHUNK ? NumberedShardSpec.class : NumberedOverwriteShardSpec.class, segment.getShardSpec().getClass());
            HashMap<String, String> expectedCountMetric = new HashMap<String, String>();
            expectedCountMetric.put("type", "count");
            expectedCountMetric.put("name", "cnt");
            HashMap<String, String> expectedLongSumMetric = new HashMap<String, String>();
            expectedLongSumMetric.put("type", "longSum");
            expectedLongSumMetric.put("name", "val");
            expectedLongSumMetric.put("fieldName", "val");
            CompactionState expectedState = new CompactionState((PartitionsSpec)new DynamicPartitionsSpec(null, Long.valueOf(Long.MAX_VALUE)), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"ts", (Object)"dim"))), (List)ImmutableList.of(expectedCountMetric, expectedLongSumMetric), (Map)this.getObjectMapper().readValue(this.getObjectMapper().writeValueAsString((Object)compactionTask.getTransformSpec()), Map.class), compactionTask.getTuningConfig().getIndexSpec().asMap(this.getObjectMapper()), (Map)this.getObjectMapper().readValue(this.getObjectMapper().writeValueAsString((Object)new UniformGranularitySpec(Granularities.HOUR, Granularities.MINUTE, Boolean.valueOf(true), (List)ImmutableList.of((Object)segment.getInterval()))), Map.class));
            Assert.assertEquals((Object)expectedState, (Object)segment.getLastCompactionState());
        }
    }

    @Test
    public void testCompactHashAndDynamicPartitionedSegments() {
        this.runIndexTask((PartitionsSpec)new HashedPartitionsSpec(null, Integer.valueOf(2), null), false);
        this.runIndexTask(null, true);
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.getSegmentCacheManagerFactory(), RETRY_POLICY_FACTORY);
        CompactionTask compactionTask = builder.inputSpec((CompactionInputSpec)new CompactionIntervalSpec(INTERVAL_TO_INDEX, null)).tuningConfig((TuningConfig)AbstractParallelIndexSupervisorTaskTest.DEFAULT_TUNING_CONFIG_FOR_PARALLEL_INDEXING).build();
        Map intervalToSegments = SegmentUtils.groupSegmentsByInterval(this.runTask((Task)compactionTask));
        Assert.assertEquals((long)3L, (long)intervalToSegments.size());
        Assert.assertEquals((Object)ImmutableSet.of((Object)Intervals.of((String)"2014-01-01T00/PT1H"), (Object)Intervals.of((String)"2014-01-01T01/PT1H"), (Object)Intervals.of((String)"2014-01-01T02/PT1H")), intervalToSegments.keySet());
        for (Map.Entry entry : intervalToSegments.entrySet()) {
            NumberedShardSpec numberedShardSpec;
            List segmentsInInterval = (List)entry.getValue();
            Assert.assertEquals((long)1L, (long)segmentsInInterval.size());
            ShardSpec shardSpec = ((DataSegment)segmentsInInterval.get(0)).getShardSpec();
            if (this.lockGranularity == LockGranularity.TIME_CHUNK) {
                Assert.assertSame(NumberedShardSpec.class, shardSpec.getClass());
                numberedShardSpec = (NumberedShardSpec)shardSpec;
                Assert.assertEquals((long)0L, (long)numberedShardSpec.getPartitionNum());
                Assert.assertEquals((long)1L, (long)numberedShardSpec.getNumCorePartitions());
                continue;
            }
            Assert.assertSame(NumberedOverwriteShardSpec.class, shardSpec.getClass());
            numberedShardSpec = (NumberedOverwriteShardSpec)shardSpec;
            Assert.assertEquals((long)32768L, (long)numberedShardSpec.getPartitionNum());
            Assert.assertEquals((long)1L, (long)numberedShardSpec.getAtomicUpdateGroupSize());
        }
    }

    @Test
    public void testCompactRangeAndDynamicPartitionedSegments() {
        this.runIndexTask((PartitionsSpec)new SingleDimensionPartitionsSpec(Integer.valueOf(2), null, "dim", false), false);
        this.runIndexTask(null, true);
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.getSegmentCacheManagerFactory(), RETRY_POLICY_FACTORY);
        CompactionTask compactionTask = builder.inputSpec((CompactionInputSpec)new CompactionIntervalSpec(INTERVAL_TO_INDEX, null)).tuningConfig((TuningConfig)AbstractParallelIndexSupervisorTaskTest.DEFAULT_TUNING_CONFIG_FOR_PARALLEL_INDEXING).build();
        Map intervalToSegments = SegmentUtils.groupSegmentsByInterval(this.runTask((Task)compactionTask));
        Assert.assertEquals((long)3L, (long)intervalToSegments.size());
        Assert.assertEquals((Object)ImmutableSet.of((Object)Intervals.of((String)"2014-01-01T00/PT1H"), (Object)Intervals.of((String)"2014-01-01T01/PT1H"), (Object)Intervals.of((String)"2014-01-01T02/PT1H")), intervalToSegments.keySet());
        for (Map.Entry entry : intervalToSegments.entrySet()) {
            NumberedShardSpec numberedShardSpec;
            List segmentsInInterval = (List)entry.getValue();
            Assert.assertEquals((long)1L, (long)segmentsInInterval.size());
            ShardSpec shardSpec = ((DataSegment)segmentsInInterval.get(0)).getShardSpec();
            if (this.lockGranularity == LockGranularity.TIME_CHUNK) {
                Assert.assertSame(NumberedShardSpec.class, shardSpec.getClass());
                numberedShardSpec = (NumberedShardSpec)shardSpec;
                Assert.assertEquals((long)0L, (long)numberedShardSpec.getPartitionNum());
                Assert.assertEquals((long)1L, (long)numberedShardSpec.getNumCorePartitions());
                continue;
            }
            Assert.assertSame(NumberedOverwriteShardSpec.class, shardSpec.getClass());
            numberedShardSpec = (NumberedOverwriteShardSpec)shardSpec;
            Assert.assertEquals((long)32768L, (long)numberedShardSpec.getPartitionNum());
            Assert.assertEquals((long)1L, (long)numberedShardSpec.getAtomicUpdateGroupSize());
        }
    }

    @Test
    public void testDruidInputSourceCreateSplitsWithIndividualSplits() {
        this.runIndexTask(null, true);
        ArrayList splits = Lists.newArrayList((Iterator)DruidInputSource.createSplits((CoordinatorClient)this.getCoordinatorClient(), (RetryPolicyFactory)RETRY_POLICY_FACTORY, (String)DATA_SOURCE, (Interval)INTERVAL_TO_INDEX, (SplitHintSpec)new SegmentsSplitHintSpec(null, Integer.valueOf(1))));
        ArrayList segments = new ArrayList(this.getCoordinatorClient().fetchUsedSegmentsInDataSourceForIntervals(DATA_SOURCE, (List)ImmutableList.of((Object)INTERVAL_TO_INDEX)));
        HashSet<String> segmentIdsFromSplits = new HashSet<String>();
        HashSet<String> segmentIdsFromCoordinator = new HashSet<String>();
        Assert.assertEquals((long)segments.size(), (long)splits.size());
        for (int i = 0; i < segments.size(); ++i) {
            segmentIdsFromCoordinator.add(((DataSegment)segments.get(i)).getId().toString());
            segmentIdsFromSplits.add(((WindowedSegmentId)((List)((InputSplit)splits.get(i)).get()).get(0)).getSegmentId());
        }
        Assert.assertEquals(segmentIdsFromCoordinator, segmentIdsFromSplits);
    }

    @Test
    public void testCompactionDropSegmentsOfInputIntervalIfDropFlagIsSet() {
        this.runIndexTask(null, true);
        Collection usedSegments = this.getCoordinatorClient().fetchUsedSegmentsInDataSourceForIntervals(DATA_SOURCE, (List)ImmutableList.of((Object)INTERVAL_TO_INDEX));
        Assert.assertEquals((long)3L, (long)usedSegments.size());
        for (DataSegment segment : usedSegments) {
            Assert.assertTrue((boolean)Granularities.HOUR.isAligned(segment.getInterval()));
        }
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.getSegmentCacheManagerFactory(), RETRY_POLICY_FACTORY);
        CompactionTask compactionTask = builder.inputSpec((CompactionInputSpec)new CompactionIntervalSpec(INTERVAL_TO_INDEX, null), Boolean.valueOf(true)).tuningConfig((TuningConfig)AbstractParallelIndexSupervisorTaskTest.DEFAULT_TUNING_CONFIG_FOR_PARALLEL_INDEXING).granularitySpec(new ClientCompactionTaskGranularitySpec(Granularities.MINUTE, null, null)).build();
        Set<DataSegment> compactedSegments = this.runTask((Task)compactionTask);
        usedSegments = this.getCoordinatorClient().fetchUsedSegmentsInDataSourceForIntervals(DATA_SOURCE, (List)ImmutableList.of((Object)INTERVAL_TO_INDEX));
        Assert.assertEquals((long)180L, (long)usedSegments.size());
        int tombstonesCount = 0;
        for (DataSegment segment : usedSegments) {
            Assert.assertTrue((boolean)Granularities.MINUTE.isAligned(segment.getInterval()));
            if (!segment.isTombstone()) continue;
            ++tombstonesCount;
        }
        Assert.assertEquals((long)177L, (long)tombstonesCount);
    }

    @Test
    public void testCompactionDoesNotDropSegmentsIfDropFlagNotSet() {
        this.runIndexTask(null, true);
        Collection usedSegments = this.getCoordinatorClient().fetchUsedSegmentsInDataSourceForIntervals(DATA_SOURCE, (List)ImmutableList.of((Object)INTERVAL_TO_INDEX));
        Assert.assertEquals((long)3L, (long)usedSegments.size());
        for (DataSegment segment : usedSegments) {
            Assert.assertTrue((boolean)Granularities.HOUR.isAligned(segment.getInterval()));
        }
        CompactionTask.Builder builder = new CompactionTask.Builder(DATA_SOURCE, this.getSegmentCacheManagerFactory(), RETRY_POLICY_FACTORY);
        CompactionTask compactionTask = builder.inputSpec((CompactionInputSpec)new CompactionIntervalSpec(INTERVAL_TO_INDEX, null)).tuningConfig((TuningConfig)AbstractParallelIndexSupervisorTaskTest.DEFAULT_TUNING_CONFIG_FOR_PARALLEL_INDEXING).granularitySpec(new ClientCompactionTaskGranularitySpec(Granularities.MINUTE, null, null)).build();
        Set<DataSegment> compactedSegments = this.runTask((Task)compactionTask);
        usedSegments = this.getCoordinatorClient().fetchUsedSegmentsInDataSourceForIntervals(DATA_SOURCE, (List)ImmutableList.of((Object)INTERVAL_TO_INDEX));
        Assert.assertEquals((long)6L, (long)usedSegments.size());
        int hourSegmentCount = 0;
        int minuteSegmentCount = 0;
        for (DataSegment segment : usedSegments) {
            if (Granularities.MINUTE.isAligned(segment.getInterval())) {
                ++minuteSegmentCount;
            }
            if (!Granularities.MINUTE.isAligned(segment.getInterval())) continue;
            ++hourSegmentCount;
        }
        Assert.assertEquals((long)3L, (long)hourSegmentCount);
        Assert.assertEquals((long)3L, (long)minuteSegmentCount);
    }

    private void runIndexTask(@Nullable PartitionsSpec partitionsSpec, boolean appendToExisting) {
        ParallelIndexIOConfig ioConfig = new ParallelIndexIOConfig(null, (InputSource)new LocalInputSource(this.inputDir, "druid*"), (InputFormat)new CsvInputFormat(Arrays.asList("ts", "dim", "val"), "|", null, Boolean.valueOf(false), 0), Boolean.valueOf(appendToExisting), null);
        ParallelIndexTuningConfig tuningConfig = this.newTuningConfig(partitionsSpec, 2, !appendToExisting);
        ParallelIndexSupervisorTask indexTask = new ParallelIndexSupervisorTask(null, null, null, new ParallelIndexIngestionSpec(new DataSchema(DATA_SOURCE, new TimestampSpec("ts", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Arrays.asList("ts", "dim"))), new AggregatorFactory[]{new LongSumAggregatorFactory("val", "val")}, (GranularitySpec)new UniformGranularitySpec(Granularities.HOUR, Granularities.MINUTE, (List)ImmutableList.of((Object)INTERVAL_TO_INDEX)), null), ioConfig, tuningConfig), null);
        this.runTask((Task)indexTask);
    }

    private Set<DataSegment> runTask(Task task) {
        task.addToContext("forceTimeChunkLock", (Object)(this.lockGranularity == LockGranularity.TIME_CHUNK ? 1 : 0));
        TaskStatus status = this.getIndexingServiceClient().runAndWait(task);
        Assert.assertEquals((String)status.toString(), (Object)TaskState.SUCCESS, (Object)status.getStatusCode());
        return this.getIndexingServiceClient().getPublishedSegments(task);
    }
}

