/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import java.io.IOException;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexing.common.task.CompactionTask;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.RoaringBitmapSerdeFactory;
import org.apache.druid.segment.indexing.TuningConfig;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class CompactionTuningConfigTest {
    private final ObjectMapper mapper = new DefaultObjectMapper();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setup() {
        this.mapper.registerSubtypes(new NamedType[]{new NamedType(CompactionTask.CompactionTuningConfig.class, "compcation")});
    }

    @Test
    public void testSerdeDefault() throws IOException {
        CompactionTask.CompactionTuningConfig tuningConfig = CompactionTask.CompactionTuningConfig.defaultConfig();
        byte[] json = this.mapper.writeValueAsBytes((Object)tuningConfig);
        CompactionTask.CompactionTuningConfig fromJson = (CompactionTask.CompactionTuningConfig)this.mapper.readValue(json, TuningConfig.class);
        Assert.assertEquals((Object)fromJson, (Object)tuningConfig);
    }

    @Test
    public void testSerdeWithNonZeroAwaitSegmentAvailabilityTimeoutMillis() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("awaitSegmentAvailabilityTimeoutMillis is not supported for Compcation Task");
        CompactionTask.CompactionTuningConfig tuningConfig = new CompactionTask.CompactionTuningConfig(null, null, null, Integer.valueOf(10), Long.valueOf(1000L), null, null, null, null, (PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(100), Long.valueOf(100L)), new IndexSpec((BitmapSerdeFactory)new RoaringBitmapSerdeFactory(Boolean.valueOf(true)), CompressionStrategy.UNCOMPRESSED, CompressionStrategy.LZF, CompressionFactory.LongEncodingStrategy.LONGS), new IndexSpec(), Integer.valueOf(1), Boolean.valueOf(false), Boolean.valueOf(true), Long.valueOf(10000L), (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance(), null, Integer.valueOf(250), Integer.valueOf(100), Long.valueOf(20L), new Duration(3600L), Integer.valueOf(128), null, null, Boolean.valueOf(false), null, null, null, Long.valueOf(5L));
    }

    @Test
    public void testSerdeWithZeroAwaitSegmentAvailabilityTimeoutMillis() {
        CompactionTask.CompactionTuningConfig tuningConfig = new CompactionTask.CompactionTuningConfig(null, null, null, Integer.valueOf(10), Long.valueOf(1000L), null, null, null, null, (PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(100), Long.valueOf(100L)), new IndexSpec((BitmapSerdeFactory)new RoaringBitmapSerdeFactory(Boolean.valueOf(true)), CompressionStrategy.UNCOMPRESSED, CompressionStrategy.LZF, CompressionFactory.LongEncodingStrategy.LONGS), new IndexSpec(), Integer.valueOf(1), Boolean.valueOf(false), Boolean.valueOf(true), Long.valueOf(10000L), (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance(), null, Integer.valueOf(250), Integer.valueOf(100), Long.valueOf(20L), new Duration(3600L), Integer.valueOf(128), null, null, Boolean.valueOf(false), null, null, null, Long.valueOf(0L));
        Assert.assertEquals((long)0L, (long)tuningConfig.getAwaitSegmentAvailabilityTimeoutMillis());
    }

    @Test
    public void testSerdeWithNullAwaitSegmentAvailabilityTimeoutMillis() {
        CompactionTask.CompactionTuningConfig tuningConfig = new CompactionTask.CompactionTuningConfig(null, null, null, Integer.valueOf(10), Long.valueOf(1000L), null, null, null, null, (PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(100), Long.valueOf(100L)), new IndexSpec((BitmapSerdeFactory)new RoaringBitmapSerdeFactory(Boolean.valueOf(true)), CompressionStrategy.UNCOMPRESSED, CompressionStrategy.LZF, CompressionFactory.LongEncodingStrategy.LONGS), new IndexSpec(), Integer.valueOf(1), Boolean.valueOf(false), Boolean.valueOf(true), Long.valueOf(10000L), (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance(), null, Integer.valueOf(250), Integer.valueOf(100), Long.valueOf(20L), new Duration(3600L), Integer.valueOf(128), null, null, Boolean.valueOf(false), null, null, null, null);
        Assert.assertEquals((long)0L, (long)tuningConfig.getAwaitSegmentAvailabilityTimeoutMillis());
    }

    @Test
    public void testEqualsAndHashCode() {
        EqualsVerifier.forClass(CompactionTask.CompactionTuningConfig.class).usingGetClass().verify();
    }
}

