/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.SegmentCacheManagerFactory;
import org.apache.druid.indexing.common.SingleFileTaskReportFileWriter;
import org.apache.druid.indexing.common.TaskReportFileWriter;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.TestUtils;
import org.apache.druid.indexing.common.actions.SegmentInsertAction;
import org.apache.druid.indexing.common.actions.SegmentTransactionalInsertAction;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.actions.TaskActionClientFactory;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.config.TaskStorageConfig;
import org.apache.druid.indexing.common.task.CountingLocalTaskActionClientForTest;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.TestAppenderatorsManager;
import org.apache.druid.indexing.overlord.HeapMemoryTaskStorage;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.TaskLockbox;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.apache.druid.indexing.overlord.TaskRunnerListener;
import org.apache.druid.indexing.overlord.TaskRunnerWorkItem;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.indexing.overlord.autoscaling.ScalingStats;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.metadata.EntryExistsException;
import org.apache.druid.metadata.IndexerSQLMetadataStorageCoordinator;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.metadata.SegmentsMetadataManagerConfig;
import org.apache.druid.metadata.SqlSegmentsMetadataManager;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMergerV9Factory;
import org.apache.druid.segment.incremental.RowIngestionMetersFactory;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.NoopJoinableFactory;
import org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.loading.LocalDataSegmentPusher;
import org.apache.druid.segment.loading.LocalDataSegmentPusherConfig;
import org.apache.druid.segment.loading.NoopDataSegmentKiller;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.realtime.appenderator.AppenderatorsManager;
import org.apache.druid.segment.realtime.firehose.ChatHandlerProvider;
import org.apache.druid.segment.realtime.firehose.NoopChatHandlerProvider;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.server.security.AuthTestUtils;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.DataSegment;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;

public abstract class IngestionTestBase
extends InitializedNullHandlingTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    private final TestUtils testUtils = new TestUtils();
    private final ObjectMapper objectMapper = this.testUtils.getTestObjectMapper();
    private SegmentCacheManagerFactory segmentCacheManagerFactory;
    private TaskStorage taskStorage;
    private IndexerSQLMetadataStorageCoordinator storageCoordinator;
    private SegmentsMetadataManager segmentsMetadataManager;
    private TaskLockbox lockbox;

    @Before
    public void setUpIngestionTestBase() throws IOException {
        EmittingLogger.registerEmitter((ServiceEmitter)new NoopServiceEmitter());
        this.temporaryFolder.create();
        TestDerbyConnector connector = this.derbyConnectorRule.getConnector();
        connector.createTaskTables();
        connector.createSegmentTable();
        this.taskStorage = new HeapMemoryTaskStorage(new TaskStorageConfig(null));
        this.storageCoordinator = new IndexerSQLMetadataStorageCoordinator(this.objectMapper, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), (SQLMetadataConnector)this.derbyConnectorRule.getConnector());
        this.segmentsMetadataManager = new SqlSegmentsMetadataManager(this.objectMapper, SegmentsMetadataManagerConfig::new, this.derbyConnectorRule.metadataTablesConfigSupplier(), (SQLMetadataConnector)this.derbyConnectorRule.getConnector());
        this.lockbox = new TaskLockbox(this.taskStorage, (IndexerMetadataStorageCoordinator)this.storageCoordinator);
        this.segmentCacheManagerFactory = new SegmentCacheManagerFactory(this.getObjectMapper());
    }

    @After
    public void tearDownIngestionTestBase() {
        this.temporaryFolder.delete();
    }

    public TestLocalTaskActionClientFactory createActionClientFactory() {
        return new TestLocalTaskActionClientFactory();
    }

    public TestLocalTaskActionClient createActionClient(Task task) {
        return new TestLocalTaskActionClient(task);
    }

    public void prepareTaskForLocking(Task task) throws EntryExistsException {
        this.lockbox.add(task);
        this.taskStorage.insert(task, TaskStatus.running((String)task.getId()));
    }

    public void shutdownTask(Task task) {
        this.lockbox.remove(task);
    }

    public SegmentCacheManager newSegmentLoader(File storageDir) {
        return this.segmentCacheManagerFactory.manufacturate(storageDir);
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public TaskStorage getTaskStorage() {
        return this.taskStorage;
    }

    public SegmentCacheManagerFactory getSegmentCacheManagerFactory() {
        return this.segmentCacheManagerFactory;
    }

    public IndexerMetadataStorageCoordinator getMetadataStorageCoordinator() {
        return this.storageCoordinator;
    }

    public SegmentsMetadataManager getSegmentsMetadataManager() {
        return this.segmentsMetadataManager;
    }

    public TaskLockbox getLockbox() {
        return this.lockbox;
    }

    public IndexerSQLMetadataStorageCoordinator getStorageCoordinator() {
        return this.storageCoordinator;
    }

    public RowIngestionMetersFactory getRowIngestionMetersFactory() {
        return this.testUtils.getRowIngestionMetersFactory();
    }

    public TaskActionToolbox createTaskActionToolbox() {
        this.storageCoordinator.start();
        return new TaskActionToolbox(this.lockbox, this.taskStorage, (IndexerMetadataStorageCoordinator)this.storageCoordinator, (ServiceEmitter)new NoopServiceEmitter(), null);
    }

    public IndexIO getIndexIO() {
        return this.testUtils.getTestIndexIO();
    }

    public IndexMergerV9Factory getIndexMergerV9Factory() {
        return this.testUtils.getIndexMergerV9Factory();
    }

    public class TestTaskRunner
    implements TaskRunner {
        private TestLocalTaskActionClient taskActionClient;
        private File taskReportsFile;

        public List<Pair<Task, ListenableFuture<TaskStatus>>> restore() {
            throw new UnsupportedOperationException();
        }

        public void start() {
            throw new UnsupportedOperationException();
        }

        public void registerListener(TaskRunnerListener listener, Executor executor) {
            throw new UnsupportedOperationException();
        }

        public void unregisterListener(String listenerId) {
            throw new UnsupportedOperationException();
        }

        public TestLocalTaskActionClient getTaskActionClient() {
            return this.taskActionClient;
        }

        public File getTaskReportsFile() {
            return this.taskReportsFile;
        }

        public List<DataSegment> getPublishedSegments() {
            ArrayList<DataSegment> segments = new ArrayList<DataSegment>(this.taskActionClient.getPublishedSegments());
            Collections.sort(segments);
            return segments;
        }

        public ListenableFuture<TaskStatus> run(Task task) {
            try {
                IngestionTestBase.this.lockbox.add(task);
                IngestionTestBase.this.taskStorage.insert(task, TaskStatus.running((String)task.getId()));
                this.taskActionClient = IngestionTestBase.this.createActionClient(task);
                this.taskReportsFile = IngestionTestBase.this.temporaryFolder.newFile(StringUtils.format((String)"ingestionTestBase-%s.json", (Object[])new Object[]{System.currentTimeMillis()}));
                TaskToolbox box = new TaskToolbox.Builder().config(new TaskConfig(null, null, null, null, null, false, null, null, null, false, false, TaskConfig.BATCH_PROCESSING_MODE_DEFAULT.name(), null)).taskExecutorNode(new DruidNode("druid/middlemanager", "localhost", false, Integer.valueOf(8091), null, true, false)).taskActionClient((TaskActionClient)this.taskActionClient).segmentPusher((DataSegmentPusher)new LocalDataSegmentPusher(new LocalDataSegmentPusherConfig())).dataSegmentKiller((DataSegmentKiller)new NoopDataSegmentKiller()).joinableFactory((JoinableFactory)NoopJoinableFactory.INSTANCE).jsonMapper(IngestionTestBase.this.objectMapper).taskWorkDir(IngestionTestBase.this.temporaryFolder.newFolder()).indexIO(IngestionTestBase.this.getIndexIO()).indexMergerV9(IngestionTestBase.this.testUtils.getIndexMergerV9Factory().create(((Boolean)task.getContextValue("storeEmptyColumns", (Object)true)).booleanValue())).taskReportFileWriter((TaskReportFileWriter)new SingleFileTaskReportFileWriter(this.taskReportsFile)).authorizerMapper(AuthTestUtils.TEST_AUTHORIZER_MAPPER).chatHandlerProvider((ChatHandlerProvider)new NoopChatHandlerProvider()).rowIngestionMetersFactory(IngestionTestBase.this.testUtils.getRowIngestionMetersFactory()).appenderatorsManager((AppenderatorsManager)new TestAppenderatorsManager()).build();
                if (task.isReady(box.getTaskActionClient())) {
                    ListenableFuture listenableFuture = Futures.immediateFuture((Object)task.run(box));
                    return listenableFuture;
                }
                try {
                    throw new ISE("task is not ready", new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                IngestionTestBase.this.lockbox.remove(task);
            }
        }

        public void shutdown(String taskid, String reason) {
            throw new UnsupportedOperationException();
        }

        public void stop() {
            throw new UnsupportedOperationException();
        }

        public Collection<? extends TaskRunnerWorkItem> getRunningTasks() {
            throw new UnsupportedOperationException();
        }

        public Collection<? extends TaskRunnerWorkItem> getPendingTasks() {
            throw new UnsupportedOperationException();
        }

        public Collection<? extends TaskRunnerWorkItem> getKnownTasks() {
            throw new UnsupportedOperationException();
        }

        public Optional<ScalingStats> getScalingStats() {
            throw new UnsupportedOperationException();
        }

        public Map<String, Long> getTotalTaskSlotCount() {
            throw new UnsupportedOperationException();
        }

        public Map<String, Long> getIdleTaskSlotCount() {
            throw new UnsupportedOperationException();
        }

        public Map<String, Long> getUsedTaskSlotCount() {
            throw new UnsupportedOperationException();
        }

        public Map<String, Long> getLazyTaskSlotCount() {
            throw new UnsupportedOperationException();
        }

        public Map<String, Long> getBlacklistedTaskSlotCount() {
            throw new UnsupportedOperationException();
        }
    }

    public class TestLocalTaskActionClient
    extends CountingLocalTaskActionClientForTest {
        private final Set<DataSegment> publishedSegments;

        private TestLocalTaskActionClient(Task task) {
            super(task, IngestionTestBase.this.taskStorage, IngestionTestBase.this.createTaskActionToolbox());
            this.publishedSegments = new HashSet<DataSegment>();
        }

        @Override
        public <RetType> RetType submit(TaskAction<RetType> taskAction) {
            RetType result = super.submit(taskAction);
            if (taskAction instanceof SegmentTransactionalInsertAction) {
                this.publishedSegments.addAll(((SegmentTransactionalInsertAction)taskAction).getSegments());
            } else if (taskAction instanceof SegmentInsertAction) {
                this.publishedSegments.addAll(((SegmentInsertAction)taskAction).getSegments());
            }
            return result;
        }

        public Set<DataSegment> getPublishedSegments() {
            return this.publishedSegments;
        }
    }

    public class TestLocalTaskActionClientFactory
    implements TaskActionClientFactory {
        public TaskActionClient create(Task task) {
            return new TestLocalTaskActionClient(task);
        }
    }
}

