/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.druid.guice.ExtensionsConfig;
import org.apache.druid.indexing.common.task.Initialization;
import org.apache.druid.java.util.common.ISE;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class InitializationTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test(expected=ISE.class)
    public void testGetHadoopDependencyFilesToLoad_wrong_type_root_hadoop_depenencies_dir() throws IOException {
        final File rootHadoopDependenciesDir = this.temporaryFolder.newFile();
        ExtensionsConfig config = new ExtensionsConfig(){

            public String getHadoopDependenciesDir() {
                return rootHadoopDependenciesDir.getAbsolutePath();
            }
        };
        Initialization.getHadoopDependencyFilesToLoad((List)ImmutableList.of(), (ExtensionsConfig)config);
    }

    @Test(expected=ISE.class)
    public void testGetHadoopDependencyFilesToLoad_non_exist_version_dir() throws IOException {
        final File rootHadoopDependenciesDir = this.temporaryFolder.newFolder();
        ExtensionsConfig config = new ExtensionsConfig(){

            public String getHadoopDependenciesDir() {
                return rootHadoopDependenciesDir.getAbsolutePath();
            }
        };
        File hadoopClient = new File(rootHadoopDependenciesDir, "hadoop-client");
        hadoopClient.mkdir();
        Initialization.getHadoopDependencyFilesToLoad((List)ImmutableList.of((Object)"org.apache.hadoop:hadoop-client:2.3.0"), (ExtensionsConfig)config);
    }

    @Test
    public void testGetHadoopDependencyFilesToLoad_with_hadoop_coordinates() throws IOException {
        final File rootHadoopDependenciesDir = this.temporaryFolder.newFolder();
        ExtensionsConfig config = new ExtensionsConfig(){

            public String getHadoopDependenciesDir() {
                return rootHadoopDependenciesDir.getAbsolutePath();
            }
        };
        File hadoopClient = new File(rootHadoopDependenciesDir, "hadoop-client");
        File versionDir = new File(hadoopClient, "2.3.0");
        hadoopClient.mkdir();
        versionDir.mkdir();
        Object[] expectedFileList = new File[]{versionDir};
        Object[] actualFileList = Initialization.getHadoopDependencyFilesToLoad((List)ImmutableList.of((Object)"org.apache.hadoop:hadoop-client:2.3.0"), (ExtensionsConfig)config);
        Assert.assertArrayEquals((Object[])expectedFileList, (Object[])actualFileList);
    }
}

