/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.FirehoseFactory;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.LocalInputSource;
import org.apache.druid.data.input.impl.NoopInputFormat;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.guice.FirehoseModule;
import org.apache.druid.indexer.HadoopIOConfig;
import org.apache.druid.indexer.HadoopIngestionSpec;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexing.common.TestUtils;
import org.apache.druid.indexing.common.task.ArchiveTask;
import org.apache.druid.indexing.common.task.HadoopIndexTask;
import org.apache.druid.indexing.common.task.IndexTask;
import org.apache.druid.indexing.common.task.MoveTask;
import org.apache.druid.indexing.common.task.RealtimeIndexTask;
import org.apache.druid.indexing.common.task.RestoreTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.incremental.RowIngestionMetersFactory;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.RealtimeIOConfig;
import org.apache.druid.segment.indexing.RealtimeTuningConfig;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.druid.segment.realtime.FireDepartment;
import org.apache.druid.segment.realtime.firehose.LocalFirehoseFactory;
import org.apache.druid.server.security.AuthTestUtils;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.hamcrest.CoreMatchers;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TaskSerdeTest {
    private final ObjectMapper jsonMapper;
    private final RowIngestionMetersFactory rowIngestionMetersFactory;
    private final IndexSpec indexSpec = new IndexSpec();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    public TaskSerdeTest() {
        TestUtils testUtils = new TestUtils();
        this.jsonMapper = testUtils.getTestObjectMapper();
        this.rowIngestionMetersFactory = testUtils.getRowIngestionMetersFactory();
        for (Module jacksonModule : new FirehoseModule().getJacksonModules()) {
            this.jsonMapper.registerModule(jacksonModule);
        }
        this.jsonMapper.registerSubtypes(new NamedType[]{new NamedType(ParallelIndexTuningConfig.class, "index_parallel"), new NamedType(IndexTask.IndexTuningConfig.class, "index")});
    }

    @Test
    public void testIndexTaskIOConfigDefaults() throws Exception {
        IndexTask.IndexIOConfig ioConfig = (IndexTask.IndexIOConfig)this.jsonMapper.readValue("{\"type\":\"index\",\"inputSource\":{\"type\":\"noop\"},\"inputFormat\":{\"type\":\"noop\"}}", IndexTask.IndexIOConfig.class);
        Assert.assertEquals((Object)false, (Object)ioConfig.isAppendToExisting());
        Assert.assertEquals((Object)false, (Object)ioConfig.isDropExisting());
    }

    @Test
    public void testIndexTaskTuningConfigDefaults() throws Exception {
        IndexTask.IndexTuningConfig tuningConfig = (IndexTask.IndexTuningConfig)this.jsonMapper.readValue("{\"type\":\"index\"}", IndexTask.IndexTuningConfig.class);
        Assert.assertFalse((boolean)tuningConfig.isReportParseExceptions());
        Assert.assertEquals((Object)new IndexSpec(), (Object)tuningConfig.getIndexSpec());
        Assert.assertEquals((Object)new Period(Integer.MAX_VALUE), (Object)tuningConfig.getIntermediatePersistPeriod());
        Assert.assertEquals((long)0L, (long)tuningConfig.getMaxPendingPersists());
        Assert.assertEquals((long)1000000L, (long)tuningConfig.getMaxRowsInMemory());
        Assert.assertNull((Object)tuningConfig.getNumShards());
        Assert.assertNull((Object)tuningConfig.getMaxRowsPerSegment());
    }

    @Test
    public void testIndexTaskTuningConfigTargetPartitionSizeOrNumShards() throws Exception {
        IndexTask.IndexTuningConfig tuningConfig = (IndexTask.IndexTuningConfig)this.jsonMapper.readValue("{\"type\":\"index\", \"targetPartitionSize\":10}", IndexTask.IndexTuningConfig.class);
        Assert.assertEquals((long)10L, (long)tuningConfig.getMaxRowsPerSegment().intValue());
        Assert.assertNull((Object)tuningConfig.getNumShards());
        tuningConfig = (IndexTask.IndexTuningConfig)this.jsonMapper.readValue("{\"type\":\"index\"}", IndexTask.IndexTuningConfig.class);
        Assert.assertNull((Object)tuningConfig.getMaxRowsPerSegment());
        tuningConfig = (IndexTask.IndexTuningConfig)this.jsonMapper.readValue("{\"type\":\"index\", \"maxRowsPerSegment\":10}", IndexTask.IndexTuningConfig.class);
        Assert.assertEquals((long)10L, (long)tuningConfig.getMaxRowsPerSegment().intValue());
        Assert.assertNull((Object)tuningConfig.getNumShards());
        tuningConfig = (IndexTask.IndexTuningConfig)this.jsonMapper.readValue("{\"type\":\"index\", \"numShards\":10, \"forceGuaranteedRollup\": true}", IndexTask.IndexTuningConfig.class);
        Assert.assertNull((Object)tuningConfig.getMaxRowsPerSegment());
        Assert.assertEquals((long)10L, (long)tuningConfig.getNumShards().intValue());
        tuningConfig = (IndexTask.IndexTuningConfig)this.jsonMapper.readValue("{\"type\":\"index\", \"targetPartitionSize\":-1, \"numShards\":10, \"forceGuaranteedRollup\": true}", IndexTask.IndexTuningConfig.class);
        Assert.assertNull((Object)tuningConfig.getMaxRowsPerSegment());
        Assert.assertEquals((long)10L, (long)tuningConfig.getNumShards().intValue());
        tuningConfig = (IndexTask.IndexTuningConfig)this.jsonMapper.readValue("{\"type\":\"index\", \"targetPartitionSize\":10, \"numShards\":-1}", IndexTask.IndexTuningConfig.class);
        Assert.assertNull((Object)tuningConfig.getNumShards());
        Assert.assertEquals((long)10L, (long)tuningConfig.getMaxRowsPerSegment().intValue());
        tuningConfig = (IndexTask.IndexTuningConfig)this.jsonMapper.readValue("{\"type\":\"index\", \"targetPartitionSize\":-1, \"numShards\":-1, \"forceGuaranteedRollup\": true}", IndexTask.IndexTuningConfig.class);
        Assert.assertNull((Object)tuningConfig.getNumShards());
        Assert.assertNotNull((Object)tuningConfig.getMaxRowsPerSegment());
        Assert.assertEquals((long)5000000L, (long)tuningConfig.getMaxRowsPerSegment().intValue());
    }

    @Test
    public void testIndexTaskTuningConfigTargetPartitionSizeAndNumShards() throws Exception {
        this.thrown.expectCause(CoreMatchers.isA(IllegalArgumentException.class));
        this.jsonMapper.readValue("{\"type\":\"index\", \"targetPartitionSize\":10, \"numShards\":10, \"forceGuaranteedRollup\": true}", IndexTask.IndexTuningConfig.class);
    }

    @Test
    public void testTaskResourceValid() throws Exception {
        TaskResource actual = (TaskResource)this.jsonMapper.readValue("{\"availabilityGroup\":\"index_xxx_mmm\", \"requiredCapacity\":1}", TaskResource.class);
        Assert.assertNotNull((Object)actual);
        Assert.assertNotNull((Object)actual.getAvailabilityGroup());
        Assert.assertTrue((actual.getRequiredCapacity() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTaskResourceWithNullAvailabilityGroupShouldFail() throws Exception {
        this.thrown.expectCause(CoreMatchers.isA(NullPointerException.class));
        this.jsonMapper.readValue("{\"availabilityGroup\":null, \"requiredCapacity\":10}", TaskResource.class);
    }

    @Test
    public void testTaskResourceWithZeroRequiredCapacityShouldFail() throws Exception {
        this.thrown.expectCause(CoreMatchers.isA(NullPointerException.class));
        this.jsonMapper.readValue("{\"availabilityGroup\":null, \"requiredCapacity\":0}", TaskResource.class);
    }

    @Test
    public void testTaskResourceWithNegativeRequiredCapacityShouldFail() throws Exception {
        this.thrown.expectCause(CoreMatchers.isA(NullPointerException.class));
        this.jsonMapper.readValue("{\"availabilityGroup\":null, \"requiredCapacity\":-1}", TaskResource.class);
    }

    @Test
    public void testIndexTaskSerde() throws Exception {
        IndexTask task = new IndexTask(null, null, new IndexTask.IndexIngestionSpec(new DataSchema("foo", new TimestampSpec(null, null, null), DimensionsSpec.EMPTY, new AggregatorFactory[]{new DoubleSumAggregatorFactory("met", "met")}, (GranularitySpec)new UniformGranularitySpec(Granularities.DAY, null, (List)ImmutableList.of((Object)Intervals.of((String)"2010-01-01/P2D"))), null), new IndexTask.IndexIOConfig(null, (InputSource)new LocalInputSource(new File("lol"), "rofl"), (InputFormat)new NoopInputFormat(), Boolean.valueOf(true), Boolean.valueOf(false)), new IndexTask.IndexTuningConfig(null, null, null, Integer.valueOf(10), null, null, null, Integer.valueOf(9999), null, null, (PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(10000), null), this.indexSpec, null, Integer.valueOf(3), Boolean.valueOf(false), null, null, null, null, null, null, null, null, Long.valueOf(1L))), null);
        String json = this.jsonMapper.writeValueAsString((Object)task);
        Thread.sleep(100L);
        IndexTask task2 = (IndexTask)this.jsonMapper.readValue(json, Task.class);
        Assert.assertEquals((Object)"foo", (Object)task.getDataSource());
        Assert.assertEquals((Object)task.getId(), (Object)task2.getId());
        Assert.assertEquals((Object)task.getGroupId(), (Object)task2.getGroupId());
        Assert.assertEquals((Object)task.getDataSource(), (Object)task2.getDataSource());
        IndexTask.IndexIOConfig taskIoConfig = task.getIngestionSchema().getIOConfig();
        IndexTask.IndexIOConfig task2IoConfig = task2.getIngestionSchema().getIOConfig();
        Assert.assertTrue((boolean)(taskIoConfig.getInputSource() instanceof LocalInputSource));
        Assert.assertTrue((boolean)(task2IoConfig.getInputSource() instanceof LocalInputSource));
        Assert.assertEquals((Object)taskIoConfig.isAppendToExisting(), (Object)task2IoConfig.isAppendToExisting());
        Assert.assertEquals((Object)taskIoConfig.isDropExisting(), (Object)task2IoConfig.isDropExisting());
        IndexTask.IndexTuningConfig taskTuningConfig = task.getIngestionSchema().getTuningConfig();
        IndexTask.IndexTuningConfig task2TuningConfig = task2.getIngestionSchema().getTuningConfig();
        Assert.assertEquals((Object)taskTuningConfig.getBasePersistDirectory(), (Object)task2TuningConfig.getBasePersistDirectory());
        Assert.assertEquals((Object)taskTuningConfig.getIndexSpec(), (Object)task2TuningConfig.getIndexSpec());
        Assert.assertEquals((Object)taskTuningConfig.getIntermediatePersistPeriod(), (Object)task2TuningConfig.getIntermediatePersistPeriod());
        Assert.assertEquals((long)taskTuningConfig.getMaxPendingPersists(), (long)task2TuningConfig.getMaxPendingPersists());
        Assert.assertEquals((long)taskTuningConfig.getMaxRowsInMemory(), (long)task2TuningConfig.getMaxRowsInMemory());
        Assert.assertEquals((Object)taskTuningConfig.getNumShards(), (Object)task2TuningConfig.getNumShards());
        Assert.assertEquals((Object)taskTuningConfig.getMaxRowsPerSegment(), (Object)task2TuningConfig.getMaxRowsPerSegment());
        Assert.assertEquals((Object)taskTuningConfig.isReportParseExceptions(), (Object)task2TuningConfig.isReportParseExceptions());
        Assert.assertEquals((long)taskTuningConfig.getAwaitSegmentAvailabilityTimeoutMillis(), (long)task2TuningConfig.getAwaitSegmentAvailabilityTimeoutMillis());
    }

    @Test
    public void testIndexTaskwithResourceSerde() throws Exception {
        IndexTask task = new IndexTask(null, new TaskResource("rofl", 2), new IndexTask.IndexIngestionSpec(new DataSchema("foo", new TimestampSpec(null, null, null), DimensionsSpec.EMPTY, new AggregatorFactory[]{new DoubleSumAggregatorFactory("met", "met")}, (GranularitySpec)new UniformGranularitySpec(Granularities.DAY, null, (List)ImmutableList.of((Object)Intervals.of((String)"2010-01-01/P2D"))), null), new IndexTask.IndexIOConfig(null, (InputSource)new LocalInputSource(new File("lol"), "rofl"), (InputFormat)new NoopInputFormat(), Boolean.valueOf(true), Boolean.valueOf(false)), new IndexTask.IndexTuningConfig(null, null, null, Integer.valueOf(10), null, null, null, null, null, null, (PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(10000), null), this.indexSpec, null, Integer.valueOf(3), Boolean.valueOf(false), null, null, null, null, null, null, null, null, null)), null);
        for (Module jacksonModule : new FirehoseModule().getJacksonModules()) {
            this.jsonMapper.registerModule(jacksonModule);
        }
        String json = this.jsonMapper.writeValueAsString((Object)task);
        Thread.sleep(100L);
        IndexTask task2 = (IndexTask)this.jsonMapper.readValue(json, Task.class);
        Assert.assertEquals((Object)"foo", (Object)task.getDataSource());
        Assert.assertEquals((Object)task.getId(), (Object)task2.getId());
        Assert.assertEquals((long)2L, (long)task.getTaskResource().getRequiredCapacity());
        Assert.assertEquals((Object)"rofl", (Object)task.getTaskResource().getAvailabilityGroup());
        Assert.assertEquals((long)task.getTaskResource().getRequiredCapacity(), (long)task2.getTaskResource().getRequiredCapacity());
        Assert.assertEquals((Object)task.getTaskResource().getAvailabilityGroup(), (Object)task2.getTaskResource().getAvailabilityGroup());
        Assert.assertEquals((Object)task.getGroupId(), (Object)task2.getGroupId());
        Assert.assertEquals((Object)task.getDataSource(), (Object)task2.getDataSource());
        Assert.assertTrue((boolean)(task.getIngestionSchema().getIOConfig().getInputSource() instanceof LocalInputSource));
        Assert.assertTrue((boolean)(task2.getIngestionSchema().getIOConfig().getInputSource() instanceof LocalInputSource));
    }

    @Test
    public void testRealtimeIndexTaskSerde() throws Exception {
        RealtimeIndexTask task = new RealtimeIndexTask(null, new TaskResource("rofl", 2), new FireDepartment(new DataSchema("foo", null, new AggregatorFactory[0], (GranularitySpec)new UniformGranularitySpec(Granularities.HOUR, Granularities.NONE, null), null, this.jsonMapper), new RealtimeIOConfig((FirehoseFactory)new LocalFirehoseFactory(new File("lol"), "rofl", null), (schema, config, metrics) -> null), new RealtimeTuningConfig(null, Integer.valueOf(1), Long.valueOf(10L), null, new Period((Object)"PT10M"), null, null, null, null, Integer.valueOf(1), (ShardSpec)NoneShardSpec.instance(), this.indexSpec, null, 0, 0, Boolean.valueOf(true), null, null, null, null)), null);
        String json = this.jsonMapper.writeValueAsString((Object)task);
        Thread.sleep(100L);
        RealtimeIndexTask task2 = (RealtimeIndexTask)this.jsonMapper.readValue(json, Task.class);
        Assert.assertEquals((Object)"foo", (Object)task.getDataSource());
        Assert.assertEquals((long)2L, (long)task.getTaskResource().getRequiredCapacity());
        Assert.assertEquals((Object)"rofl", (Object)task.getTaskResource().getAvailabilityGroup());
        Assert.assertEquals((Object)new Period((Object)"PT10M"), (Object)task.getRealtimeIngestionSchema().getTuningConfig().getWindowPeriod());
        Assert.assertEquals((Object)Granularities.HOUR, (Object)task.getRealtimeIngestionSchema().getDataSchema().getGranularitySpec().getSegmentGranularity());
        Assert.assertTrue((boolean)task.getRealtimeIngestionSchema().getTuningConfig().isReportParseExceptions());
        Assert.assertEquals((Object)task.getId(), (Object)task2.getId());
        Assert.assertEquals((Object)task.getGroupId(), (Object)task2.getGroupId());
        Assert.assertEquals((Object)task.getDataSource(), (Object)task2.getDataSource());
        Assert.assertEquals((long)task.getTaskResource().getRequiredCapacity(), (long)task2.getTaskResource().getRequiredCapacity());
        Assert.assertEquals((Object)task.getTaskResource().getAvailabilityGroup(), (Object)task2.getTaskResource().getAvailabilityGroup());
        Assert.assertEquals((Object)task.getRealtimeIngestionSchema().getTuningConfig().getWindowPeriod(), (Object)task2.getRealtimeIngestionSchema().getTuningConfig().getWindowPeriod());
        Assert.assertEquals((long)task.getRealtimeIngestionSchema().getTuningConfig().getMaxBytesInMemory(), (long)task2.getRealtimeIngestionSchema().getTuningConfig().getMaxBytesInMemory());
        Assert.assertEquals((Object)task.getRealtimeIngestionSchema().getDataSchema().getGranularitySpec().getSegmentGranularity(), (Object)task2.getRealtimeIngestionSchema().getDataSchema().getGranularitySpec().getSegmentGranularity());
    }

    @Test
    public void testArchiveTaskSerde() throws Exception {
        ArchiveTask task = new ArchiveTask(null, "foo", Intervals.of((String)"2010-01-01/P1D"), null);
        String json = this.jsonMapper.writeValueAsString((Object)task);
        Thread.sleep(100L);
        ArchiveTask task2 = (ArchiveTask)this.jsonMapper.readValue(json, Task.class);
        Assert.assertEquals((Object)"foo", (Object)task.getDataSource());
        Assert.assertEquals((Object)Intervals.of((String)"2010-01-01/P1D"), (Object)task.getInterval());
        Assert.assertEquals((Object)task.getId(), (Object)task2.getId());
        Assert.assertEquals((Object)task.getGroupId(), (Object)task2.getGroupId());
        Assert.assertEquals((Object)task.getDataSource(), (Object)task2.getDataSource());
        Assert.assertEquals((Object)task.getInterval(), (Object)task2.getInterval());
    }

    @Test
    public void testRestoreTaskSerde() throws Exception {
        RestoreTask task = new RestoreTask(null, "foo", Intervals.of((String)"2010-01-01/P1D"), null);
        String json = this.jsonMapper.writeValueAsString((Object)task);
        Thread.sleep(100L);
        RestoreTask task2 = (RestoreTask)this.jsonMapper.readValue(json, Task.class);
        Assert.assertEquals((Object)"foo", (Object)task.getDataSource());
        Assert.assertEquals((Object)Intervals.of((String)"2010-01-01/P1D"), (Object)task.getInterval());
        Assert.assertEquals((Object)task.getId(), (Object)task2.getId());
        Assert.assertEquals((Object)task.getGroupId(), (Object)task2.getGroupId());
        Assert.assertEquals((Object)task.getDataSource(), (Object)task2.getDataSource());
        Assert.assertEquals((Object)task.getInterval(), (Object)task2.getInterval());
    }

    @Test
    public void testMoveTaskSerde() throws Exception {
        MoveTask task = new MoveTask(null, "foo", Intervals.of((String)"2010-01-01/P1D"), (Map)ImmutableMap.of((Object)"bucket", (Object)"hey", (Object)"baseKey", (Object)"what"), null, null);
        String json = this.jsonMapper.writeValueAsString((Object)task);
        Thread.sleep(100L);
        MoveTask task2 = (MoveTask)this.jsonMapper.readValue(json, Task.class);
        Assert.assertEquals((Object)"foo", (Object)task.getDataSource());
        Assert.assertEquals((Object)Intervals.of((String)"2010-01-01/P1D"), (Object)task.getInterval());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"bucket", (Object)"hey", (Object)"baseKey", (Object)"what"), (Object)task.getTargetLoadSpec());
        Assert.assertEquals((Object)task.getId(), (Object)task2.getId());
        Assert.assertEquals((Object)task.getGroupId(), (Object)task2.getGroupId());
        Assert.assertEquals((Object)task.getDataSource(), (Object)task2.getDataSource());
        Assert.assertEquals((Object)task.getInterval(), (Object)task2.getInterval());
        Assert.assertEquals((Object)task.getTargetLoadSpec(), (Object)task2.getTargetLoadSpec());
    }

    @Test
    public void testHadoopIndexTaskSerde() throws Exception {
        HadoopIndexTask task = new HadoopIndexTask(null, new HadoopIngestionSpec(new DataSchema("foo", null, new AggregatorFactory[0], (GranularitySpec)new UniformGranularitySpec(Granularities.DAY, null, (List)ImmutableList.of((Object)Intervals.of((String)"2010-01-01/P1D"))), null, this.jsonMapper), new HadoopIOConfig((Map)ImmutableMap.of((Object)"paths", (Object)"bar"), null, null), null), null, null, "blah", this.jsonMapper, null, AuthTestUtils.TEST_AUTHORIZER_MAPPER, null);
        String json = this.jsonMapper.writeValueAsString((Object)task);
        HadoopIndexTask task2 = (HadoopIndexTask)this.jsonMapper.readValue(json, Task.class);
        Assert.assertEquals((Object)"foo", (Object)task.getDataSource());
        Assert.assertEquals((Object)task.getId(), (Object)task2.getId());
        Assert.assertEquals((Object)task.getGroupId(), (Object)task2.getGroupId());
        Assert.assertEquals((Object)task.getDataSource(), (Object)task2.getDataSource());
        Assert.assertEquals((Object)task.getSpec().getTuningConfig().getJobProperties(), (Object)task2.getSpec().getTuningConfig().getJobProperties());
        Assert.assertEquals((Object)"blah", (Object)task.getClasspathPrefix());
        Assert.assertEquals((Object)"blah", (Object)task2.getClasspathPrefix());
    }
}

