/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Injector;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import org.apache.druid.guice.GuiceAnnotationIntrospector;
import org.apache.druid.guice.GuiceInjectableValues;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.indexing.common.task.batch.parallel.DeepStoragePartitionLocation;
import org.apache.druid.indexing.common.task.batch.parallel.DeepStorageShuffleClient;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.loading.LocalDataSegmentPuller;
import org.apache.druid.segment.loading.LocalLoadSpec;
import org.apache.druid.utils.CompressionUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class DeepStorageShuffleClientTest {
    private DeepStorageShuffleClient deepStorageShuffleClient;
    private ObjectMapper mapper;
    private File segmentFile;
    private String segmentFileName;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Before
    public void setUp() throws Exception {
        Injector injector = GuiceInjectors.makeStartupInjectorWithModules((Iterable)ImmutableList.of(binder -> binder.bind(LocalDataSegmentPuller.class)));
        this.mapper = new DefaultObjectMapper();
        this.mapper.registerModule((Module)new SimpleModule("loadSpecTest").registerSubtypes(new Class[]{LocalLoadSpec.class}));
        this.mapper.setInjectableValues((InjectableValues)new GuiceInjectableValues(injector));
        GuiceAnnotationIntrospector guiceIntrospector = new GuiceAnnotationIntrospector();
        this.mapper.setAnnotationIntrospectors((AnnotationIntrospector)new AnnotationIntrospectorPair((AnnotationIntrospector)guiceIntrospector, this.mapper.getSerializationConfig().getAnnotationIntrospector()), (AnnotationIntrospector)new AnnotationIntrospectorPair((AnnotationIntrospector)guiceIntrospector, this.mapper.getDeserializationConfig().getAnnotationIntrospector()));
        this.deepStorageShuffleClient = new DeepStorageShuffleClient(this.mapper);
        File temp = this.temporaryFolder.newFile();
        this.segmentFileName = temp.getName();
        try (BufferedWriter writer = Files.newBufferedWriter(temp.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            for (int j = 0; j < 10; ++j) {
                writer.write(StringUtils.format((String)"let's write some data.\n", (Object[])new Object[0]));
            }
        }
        this.segmentFile = new File(temp.getAbsolutePath() + ".zip");
        CompressionUtils.zip((File)this.segmentFile.getParentFile(), (File)this.segmentFile);
    }

    @Test
    public void fetchSegmentFile() throws IOException {
        File partitionDir = this.temporaryFolder.newFolder();
        String subTaskId = "subTask";
        File unzippedDir = this.deepStorageShuffleClient.fetchSegmentFile(partitionDir, "testSupervisor", new DeepStoragePartitionLocation(subTaskId, Intervals.of((String)"2000/2099"), null, (Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)this.segmentFile.getAbsolutePath())));
        Assert.assertEquals((Object)StringUtils.format((String)"%s/unzipped_%s", (Object[])new Object[]{partitionDir.getAbsolutePath(), subTaskId}), (Object)unzippedDir.getAbsolutePath());
        File fetchedSegmentFile = unzippedDir.listFiles((dir, name) -> name.endsWith(".tmp"))[0];
        Assert.assertEquals((Object)this.segmentFileName, (Object)fetchedSegmentFile.getName());
        Assert.assertTrue((fetchedSegmentFile.length() > 0L ? 1 : 0) != 0);
    }
}

