/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.StringTuple;
import org.apache.druid.data.input.impl.InlineInputSource;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexing.common.task.batch.parallel.AbstractParallelIndexSupervisorTaskTest;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTestingFactory;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.indexing.common.task.batch.parallel.PartialRangeSegmentGenerateTask;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.timeline.partition.PartitionBoundaries;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class PartialRangeSegmentGenerateTaskTest
extends AbstractParallelIndexSupervisorTaskTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    public PartialRangeSegmentGenerateTaskTest() {
        super(0.0, 0.0);
    }

    @Test
    public void requiresForceGuaranteedRollup() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("range or single_dim partitionsSpec required");
        ParallelIndexTuningConfig tuningConfig = new ParallelIndexTestingFactory.TuningConfigBuilder().forceGuaranteedRollup(false).partitionsSpec((PartitionsSpec)new DynamicPartitionsSpec(null, null)).build();
        new PartialRangeSegmentGenerateTaskBuilder().tuningConfig(tuningConfig).build();
    }

    @Test
    public void requiresMultiDimensionPartitions() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("range or single_dim partitionsSpec required");
        HashedPartitionsSpec partitionsSpec = new HashedPartitionsSpec(null, Integer.valueOf(1), null);
        ParallelIndexTuningConfig tuningConfig = new ParallelIndexTestingFactory.TuningConfigBuilder().partitionsSpec((PartitionsSpec)partitionsSpec).build();
        new PartialRangeSegmentGenerateTaskBuilder().tuningConfig(tuningConfig).build();
    }

    @Test
    public void requiresGranularitySpecInputIntervals() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Missing intervals in granularitySpec");
        DataSchema dataSchema = ParallelIndexTestingFactory.createDataSchema(Collections.emptyList());
        new PartialRangeSegmentGenerateTaskBuilder().dataSchema(dataSchema).build();
    }

    @Test
    public void serializesDeserializes() {
        PartialRangeSegmentGenerateTask task = new PartialRangeSegmentGenerateTaskBuilder().build();
        TestHelper.testSerializesDeserializes((ObjectMapper)this.getObjectMapper(), (Object)task);
    }

    @Test
    public void hasCorrectPrefixForAutomaticId() {
        PartialRangeSegmentGenerateTask task = new PartialRangeSegmentGenerateTaskBuilder().build();
        Assert.assertThat((Object)task.getId(), (Matcher)Matchers.startsWith((String)"partial_range_index_generate"));
    }

    private static class PartialRangeSegmentGenerateTaskBuilder {
        private static final InputSource INPUT_SOURCE = new InlineInputSource("data");
        private static final InputFormat INPUT_FORMAT = ParallelIndexTestingFactory.getInputFormat();
        private ParallelIndexTuningConfig tuningConfig = new ParallelIndexTestingFactory.TuningConfigBuilder().partitionsSpec((PartitionsSpec)new ParallelIndexTestingFactory.SingleDimensionPartitionsSpecBuilder().build()).build();
        private DataSchema dataSchema = ParallelIndexTestingFactory.createDataSchema(ParallelIndexTestingFactory.INPUT_INTERVALS);

        private PartialRangeSegmentGenerateTaskBuilder() {
        }

        PartialRangeSegmentGenerateTaskBuilder tuningConfig(ParallelIndexTuningConfig tuningConfig) {
            this.tuningConfig = tuningConfig;
            return this;
        }

        PartialRangeSegmentGenerateTaskBuilder dataSchema(DataSchema dataSchema) {
            this.dataSchema = dataSchema;
            return this;
        }

        PartialRangeSegmentGenerateTask build() {
            ParallelIndexIngestionSpec ingestionSpec = ParallelIndexTestingFactory.createIngestionSpec(INPUT_SOURCE, INPUT_FORMAT, this.tuningConfig, this.dataSchema);
            return new PartialRangeSegmentGenerateTask(ParallelIndexTestingFactory.AUTOMATIC_ID, "group-id", ParallelIndexTestingFactory.TASK_RESOURCE, "supervisor-task-id", "subtask-spec-id", 1, ingestionSpec, ParallelIndexTestingFactory.CONTEXT, (Map)ImmutableMap.of((Object)Intervals.ETERNITY, (Object)new PartitionBoundaries(new StringTuple[]{StringTuple.create((String[])new String[]{"a"})})));
        }
    }
}

