/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.task.batch.parallel.TombstoneHelper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.TombstoneShardSpec;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TombstoneHelperTest {
    private final TaskActionClient taskActionClient = (TaskActionClient)Mockito.mock(TaskActionClient.class);

    @Test
    public void noTombstonesWhenNoDataInInputIntervalAndNoExistingSegments() throws Exception {
        Interval interval = Intervals.of((String)"2020-04-01/2020-04-04");
        UniformGranularitySpec granularitySpec = new UniformGranularitySpec(Granularities.DAY, null, Boolean.valueOf(false), Collections.singletonList(interval));
        DataSchema dataSchema = new DataSchema("test", null, null, null, (GranularitySpec)granularitySpec, null);
        List pushedSegments = Collections.emptyList();
        Mockito.when((Object)this.taskActionClient.submit((TaskAction)ArgumentMatchers.any(TaskAction.class))).thenReturn(Collections.emptyList());
        TombstoneHelper tombstoneHelper = new TombstoneHelper(pushedSegments, dataSchema, this.taskActionClient);
        List tombstoneIntervals = tombstoneHelper.computeTombstoneIntervals();
        Assert.assertTrue((boolean)tombstoneIntervals.isEmpty());
        Map intervalToLockVersion = Collections.emptyMap();
        Set tombstones = tombstoneHelper.computeTombstones(intervalToLockVersion);
        Assert.assertEquals((long)0L, (long)tombstones.size());
    }

    @Test
    public void tombstonesCreatedWhenNoDataInInputIntervalAndExistingSegments() throws Exception {
        Interval interval = Intervals.of((String)"2020-04-01/2020-04-04");
        UniformGranularitySpec granularitySpec = new UniformGranularitySpec(Granularities.DAY, null, Boolean.valueOf(false), Collections.singletonList(interval));
        DataSchema dataSchema = new DataSchema("test", null, null, null, (GranularitySpec)granularitySpec, null);
        List pushedSegments = Collections.emptyList();
        DataSegment existingUsedSegment = DataSegment.builder().dataSource("test").interval(interval).version("oldVersion").size(100L).build();
        Assert.assertFalse((boolean)existingUsedSegment.isTombstone());
        Mockito.when((Object)this.taskActionClient.submit((TaskAction)ArgumentMatchers.any(TaskAction.class))).thenReturn(Collections.singletonList(existingUsedSegment));
        TombstoneHelper tombstoneHelper = new TombstoneHelper(pushedSegments, dataSchema, this.taskActionClient);
        List tombstoneIntervals = tombstoneHelper.computeTombstoneIntervals();
        Assert.assertEquals((long)3L, (long)tombstoneIntervals.size());
        HashMap<Interval, SegmentIdWithShardSpec> intervalToVersion = new HashMap<Interval, SegmentIdWithShardSpec>();
        for (Interval ti : tombstoneIntervals) {
            intervalToVersion.put(ti, new SegmentIdWithShardSpec("test", ti, "newVersion", (ShardSpec)new TombstoneShardSpec()));
        }
        Set tombstones = tombstoneHelper.computeTombstones(intervalToVersion);
        Assert.assertEquals((long)3L, (long)tombstones.size());
        tombstones.forEach(ts -> Assert.assertTrue((boolean)ts.isTombstone()));
    }
}

